/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbEntityDAO {

    // singleton쐬
    private static final XbEntityDAO instance = new XbEntityDAO();
    private Connection conn = null;

    // RXgN^
    private XbEntityDAO() {
    }

    // CX^X擾
    protected static synchronized XbEntityDAO getInstance(Connection connection) {
        // CX^X𐶐
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected ArrayList<XbEntityObj> getEntity(long entityId) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            strb_sql.append("select ");
            strb_sql.append("ide.identifier_id as identifier_id, ");
            strb_sql.append("ide.schema as schema, ");
            strb_sql.append("ide.value as value ");
            strb_sql.append("from ");
            strb_sql.append("xb_entity_identifier ent, ");
            strb_sql.append("xb_identifier ide ");
            strb_sql.append("where ");
            strb_sql.append("ent.identifier_id = ide.identifier_id ");
            strb_sql.append("and ent.entity_id = ? ");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            stmt.setLong(1, entityId);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbEntityObj> relist = new ArrayList<XbEntityObj>();
            while (rs.next()) {
                XbEntityObj obj = new XbEntityObj();
                obj.setIdentifierId(rs.getLong("identifier_id"));
                obj.setSchemaUri(rs.getString("schema"));
                obj.setValue(rs.getString("value"));
                relist.add(obj);
            }

            rs.close();

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}