/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.io.File;
import java.sql.Connection;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import jp.co.going.xbrl.common.XbConstants;
import jp.co.going.xbrl.common.XbContextIdList;
import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.common.XbRefList;

import org.w3c.dom.Document;

/**
 * waqkCX^X𐶐NX
 * 
 * @author Going Dot Com Inc.
 */
public class XbCreator {

    private XbInstance instance;
    private Connection conn;
    private Document doc;

    /**
     * RXgN^
     * 
     * @param conn
     *            SQLRlNV
     */
    public XbCreator(Connection conn) throws XbException {
        this.conn = conn;
    }

    /**
     * waqkCX^X𐶐
     * 
     * @param taxGroupId
     *            ^N\m~[O[vID
     * @param contextIdList
     *            ReLXgIDXg
     * @param refList
     *            Qƃ^OIDXg
     * @param version
     *            CX^Xo[W
     * @throws XbException
     */
    public void createInstance(long taxGroupId, XbContextIdList contextIdList, XbRefList refList, String version) throws XbException {
        // version
        if (version.equals(XbConstants.SPECIFICATION_NO_20)) { // 2.0
            instance = new XbInstance20(this.conn);
        } else if (version.equals(XbConstants.SPECIFICATION_NO_21)) { // 2.1
            instance = new XbInstance21(this.conn);
        }
        // instance쐬
        doc = instance.createInstance(taxGroupId, contextIdList, refList);
    }

    /**
     * 쐬CX^XDocumentƂĎ擾
     * 
     * @return XBRLCX^XhLg
     * @throws XbException
     */
    public Document getXbrlDocument() throws XbException {
        return doc;
    }

    /**
     * 쐬CX^XXBRLt@CƂĐ
     * 
     * @param fileName
     *            CX^Xo̓t@C
     * @throws XbException
     */
    public void createXbrlFile(String fileName) throws XbException {
        try {
            // t@Co
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty(XbConstants.INDENT_VALUE, XbConstants.YES_VALUE);
            File outfile = new File(fileName);

            transformer.transform(new DOMSource(doc), new StreamResult(outfile.toString()));
        } catch (TransformerException e) {
            throw new XbException(e);
        }
    }
}