/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbContextUnitDAO {
    // singleton쐬
    private static final XbContextUnitDAO instance = new XbContextUnitDAO();
    private Connection conn = null;

    // RXgN^
    private XbContextUnitDAO() {
    }

    // CX^X擾
    protected static synchronized XbContextUnitDAO getInstance(Connection connection) {
        // CX^X𐶐
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected XbContextUnitObj getUnitInfo(long contextId) throws XbException {
        PreparedStatement stmt = null;
        try {
            StringBuffer strb_sql = new StringBuffer();
            strb_sql.append("select cu.unit_id as unit_id , u.name as name ");
            strb_sql.append("from xb_context_unit cu , xb_unit u ");
            strb_sql.append("where cu.context_id = ? and cu.unit_id = u.unit_id");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            stmt.setLong(1, contextId);

            ResultSet rs = stmt.executeQuery();

            XbContextUnitObj obj = null;
            if (rs.next()) {
                obj = new XbContextUnitObj();
                obj.setUnitId(rs.getLong("unit_id"));
                obj.setName(rs.getString("name"));
            }

            rs.close();

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}