/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbContextDAO {

    // singleton쐬
    private static final XbContextDAO instance = new XbContextDAO();
    private Connection conn = null;

    // RXgN^
    private XbContextDAO() {
    }

    // CX^X擾
    protected static synchronized XbContextDAO getInstance(Connection connection) {
        try {
            if (instance.conn == null || instance.conn.isClosed()) {
                instance.conn = connection;
            }
        } catch (SQLException e) {
            e.printStackTrace();
        }

        return instance;
    }

    protected XbContextObj getContext(long contextid) throws XbException {
        final String query = "select context_id, context_type, name, entity_id, period_start_date, period_end_date, item_precision, item_cwa, unit_flag from xb_context where context_id = ? ";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement(query);
            stmt.setLong(1, contextid);

            ResultSet rs = stmt.executeQuery();

            XbContextObj obj = new XbContextObj();
            if (rs.next()) {
                obj.setContextId(rs.getLong("context_id"));
                obj.setContextType(rs.getString("context_type"));
                obj.setName(rs.getString("name"));
                obj.setEntityId(rs.getLong("entity_id"));
                obj.setPeriodStartDate(rs.getString("period_start_date"));
                obj.setPeriodEndDate(rs.getString("period_end_date"));
                obj.setPrecision(rs.getInt("item_precision"));
                obj.setCwa(rs.getInt("item_cwa"));
                obj.setUnitFlag(rs.getInt("unit_flag") == 1);
            }

            rs.close();

            return obj;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        } finally {
            if (stmt != null) {
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
        }
    }
}