/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.base;

import java.io.File;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;

import jp.co.going.xbrl.common.XbConstants;
import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.common.parse.XbPAOImpl;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * {XL[}caɊi[NX
 * 
 * @author Going Dot Com Inc.
 */
public class XbBaseschema {
    // dlԍmAgpϐ
    private String specification_no;
    // VXet
    private Date system_date;

    private XbBaseSchemaDAO dbaBaseSchemaDAO;
    private XbItemTypeDAO dbaItemtypeDAO;

    /**
     * RXgN^
     * 
     * @param conn
     *            SQLRlNV
     * @throws XbException
     */
    public XbBaseschema(Connection conn) throws XbException {
        // DateNXCX^X
        system_date = new Date();
        // {XL[}ANZXNX
        dbaBaseSchemaDAO = XbBaseSchemaDAO.getInstance(conn);
        // ڌ^ANZXNX
        dbaItemtypeDAO = XbItemTypeDAO.getInstance(conn);
    }

    /**
     * {XL[}̎捞݂s܂
     * 
     * @param dirPath
     *            {XL[}i[tH_
     * @param ver
     *            XBRLo[W
     * @throws Exception
     */
    public void registerBaseSchema(String dirPath, String ver) throws XbException {

        // ǂݍ݃t@C擾
        File existsFile;
        try {
            existsFile = new File(new URI(dirPath));
        } catch (Exception e) {
            existsFile = new File(dirPath);
        }
        File[] existsFileList = existsFile.listFiles();

        if (existsFileList.length == 0) {
            throw new XbException("t@C݂܂B");
        }

        // dlԍ擾
        if (ver.equals(XbConstants.SPECIFICATION_NO_20)) {
            specification_no = XbConstants.SPECIFICATION_NO_20;
        } else {
            specification_no = XbConstants.SPECIFICATION_NO_21;
        }

        // {XL[}ݒ肷
        this.setBaseSchema(dirPath, existsFileList);
    }

    /**
     * {XL[}e[uɐݒ肷
     * 
     * @param String
     *            t@CpX
     * @throws SQLException
     * @throws ClassNotFoundException
     * @throws Exception
     * @see Ȃ
     * @return Ȃ
     */
    private void setBaseSchema(String path, File existsFileList[]) throws XbException {
        int cnt = 0;
        for (int i = 0; i < existsFileList.length; i++) {
            String str_Extension = this.getExtension(existsFileList[i]);
            // t@Cgq`FbN@.xsdΏۂƂ
            if (str_Extension.equals(XbConstants.FILE_EXTENSION)) {
                if ((XbConstants.SPECIFICATION_NO_20.equals(specification_no) && existsFileList[i].getName().equals("xbrl-instance-2003-12-31.xsd"))
                        || (XbConstants.SPECIFICATION_NO_21.equals(specification_no) && existsFileList[i].getName().equals("xbrl-instance.xsd"))) {
                    throw new XbException("Io[Wƒ`t@C̃o[Wv܂B");
                }

                cnt++;
                // finame
                String fileName = path + "/" + existsFileList[i].getName();
                // p[T̐
                XbPAOImpl parser = new XbPAOImpl();
                // XMLt@C̃p[X
                parser.parse(fileName);
                // DOCUMENTm[h̎擾
                Document document = parser.getDocument();

                // ****  ****
                this.getSchemaName(document);
                // xbrl-instancet@C
                if (existsFileList[i].getName().indexOf(XbConstants.FILENAME_XBRL_INSTANCE) != -1) {
                    this.getItemType(document);
                }
            }
        }
        if (cnt == 0) {
            throw new XbException("`t@C݂܂B");
        }
    }

    /**
     * {XL[}e[uXV
     */
    private void getSchemaName(Document document) throws XbException {

        String strUrl = "";
        int cnt;
        XbBaseSchemaObj baseSchemaObj;

        // --------------------------------------------------------------------
        // {XL[}e[uXV
        // --------------------------------------------------------------------
        NodeList lst = document.getElementsByTagNameNS("*", XbConstants.TAG_SCHEMA);
        for (int i = 0; i < lst.getLength(); i++) {
            Node child = lst.item(i);
            NamedNodeMap attrs = child.getAttributes();
            for (int j = 0; j < attrs.getLength(); j++) {
                if (XbConstants.TARGET_NAMESPACE.equals(attrs.item(j).getNodeName())) {
                    // targetNamespaceŎw肳ĂURLێ
                    strUrl = attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue();
                } else if (strUrl.equals(attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue())) {
                    // targetNamespace̎ʎqƓʎqOԂ̏ꍇADBɍXV
                    // selects(L[)
                    cnt = dbaBaseSchemaDAO.select(attrs.item(j).getNodeName(), specification_no);
                    // ȂΒǉXV
                    if (cnt == 0) {
                        baseSchemaObj = new XbBaseSchemaObj();
                        // OԐݒ
                        baseSchemaObj.setNamespace(attrs.item(j).getNodeName());
                        // OURL
                        baseSchemaObj.setNamespace_url(strUrl);
                        // dlԍ
                        baseSchemaObj.setSpecification_no(specification_no);
                        // t
                        baseSchemaObj.setCreation_date(system_date);

                        // Inserts
                        dbaBaseSchemaDAO.insert(baseSchemaObj);
                    }
                }
            }
        }
    }

    /**
     * ڌ^e[uXV
     */
    private void getItemType(Document document) throws XbException {
        String strTypeName = "";
        String strAttributeName = "";
        String strAttributeNameValue = "";
        XbItemTypeObj itemTypeObj;
        int cnt;

        NodeList lst = document.getElementsByTagNameNS("*", XbConstants.TAG_COMPLEX_TYPE);

        // --------------------------------------------------------------------
        // ^e[uXV
        // --------------------------------------------------------------------

        for (int i = 0; i < lst.getLength(); i++) {
            Node child = lst.item(i);
            // l擾
            NamedNodeMap attrs = child.getAttributes();
            strTypeName = "";
            if (attrs.getLength() != 0) {
                strTypeName = attrs.getNamedItem("name").getNodeValue();
                strAttributeName = "";
                strAttributeName = this.getAttributeName(child, strAttributeName);
            }

            strAttributeNameValue = "";
            // o[Wɕʂ "numeric" or "nonnumeric" ^𔻒肷
            if ((specification_no.equals(XbConstants.SPECIFICATION_NO_20) && strAttributeName.equals("numericContext"))
                    || (specification_no.equals(XbConstants.SPECIFICATION_NO_21) && strAttributeName.equals("xbrli:numericItemAttrs") || strAttributeName
                            .equals("xbrli:essentialNumericItemAttrs"))) {
                strAttributeNameValue = XbConstants.ATTRIBUTE_NUMERIC;
            } else if ((specification_no.equals(XbConstants.SPECIFICATION_NO_20) && strAttributeName.equals("nonNumericContext"))
                    || (specification_no.equals(XbConstants.SPECIFICATION_NO_21) && strAttributeName.equals("xbrli:nonNumericItemAttrs"))) {
                strAttributeNameValue = XbConstants.ATTRIBUTE_NO_NUMERIC;
            }

            if (strTypeName != "" && strAttributeNameValue != "") {
                // selects(L[)
                cnt = dbaItemtypeDAO.select(strTypeName, specification_no);
                if (cnt == 0) {
                    // ȂΒǉXV
                    itemTypeObj = new XbItemTypeObj();
                    // _
                    itemTypeObj.setType_name(strTypeName);
                    // ^
                    itemTypeObj.setAttribute_name(strAttributeNameValue);
                    // dlԍ
                    itemTypeObj.setSpecification_no(specification_no);
                    // t
                    itemTypeObj.setCreation_date(system_date);

                    // Inserts
                    dbaItemtypeDAO.insert(itemTypeObj);
                }
            }
        }
    }

    /**
     * ̂擾
     */
    private String getAttributeName(Node node, String strAttributeName) throws XbException {
        if (node.getNodeType() == Node.ELEMENT_NODE) {
            for (Node childnode = node.getFirstChild(); childnode != null; childnode = childnode.getNextSibling()) {
                if (childnode.getNodeType() == Node.ELEMENT_NODE) {
                    // COMPLEXTYPE_ATTRIBUTE_GROUP
                    if (specification_no.equals(XbConstants.SPECIFICATION_NO_20) && XbConstants.COMPLEXTYPE_ATTRIBUTE.equals(childnode.getNodeName())) {
                        // l擾
                        NamedNodeMap attrs = childnode.getAttributes();
                        if (attrs.getLength() != 0) {
                            // dlԍ@2.0̏ꍇ
                            strAttributeName = attrs.getNamedItem("name").getNodeValue();
                            break;
                        }
                    }
                    if (specification_no.equals(XbConstants.SPECIFICATION_NO_21) && XbConstants.COMPLEXTYPE_ATTRIBUTE_GROUP.equals(childnode.getNodeName())) {
                        // l擾
                        NamedNodeMap attrs = childnode.getAttributes();
                        if (attrs.getLength() != 0) {
                            // dlԍ@2.1̏ꍇ
                            strAttributeName = attrs.getNamedItem("ref").getNodeValue();
                            break;
                        }
                    }
                    strAttributeName = this.getAttributeName(childnode, strAttributeName);
                }
            }
        }
        return strAttributeName;
    }

    /**
     * t@C̊gq擾
     */
    private String getExtension(File file) {
        String fileName = file.getName();
        int index = fileName.lastIndexOf('.');
        if (index != -1) {
            return fileName.substring(index + 1, fileName.length());
        }
        return "";
    }
}