/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbTaxonomyItemDAO {

    // singleton쐬
    private static XbTaxonomyItemDAO taxItem = null;
    // Connectionϐ
    private static Connection conn = null;

    // RXgN^
    private XbTaxonomyItemDAO() {
    }

    // CX^X擾
    public static XbTaxonomyItemDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (taxItem == null) {
            conn = connection;
            taxItem = new XbTaxonomyItemDAO();
        }

        return taxItem;
    }

    protected int insert(XbTaxonomyItemObj obj)
        throws XbException {

        try {
            // Xe[gg쐬
            PreparedStatement stmt;

    		StringBuffer  strb_sql = new StringBuffer();
    	    // ⍇̎s
        	strb_sql.append("insert into ");
        	strb_sql.append("xb_taxonomy_item ");
        	strb_sql.append("values ");
        	strb_sql.append("(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    		// SQLݒ
    		stmt = conn.prepareStatement(strb_sql.toString());

    		int index = 1;
    		stmt.setLong(index++, obj.getTaxonomyItemId());
    		stmt.setLong(index++, obj.getTaxonomyId());
    		stmt.setLong(index++, obj.getTaxonomyGroupId());
    		stmt.setString(index++, obj.getItemId());
    		stmt.setString(index++, obj.getItemName());
    		stmt.setString(index++, obj.getItemType());
    		stmt.setString(index++, obj.getItemSubstitutiongroup());
    		stmt.setString(index++, obj.getItemBalance());
    		stmt.setInt(index++, obj.getItemNillable());
    		stmt.setString(index++, obj.getItemPeriodType());
    		stmt.setInt(index++, obj.getAbstractFlg());
    		stmt.setString(index++, obj.getDocumentation());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreationDate().getTime()));

    	   	// SQL@s
    	   	int count =stmt.executeUpdate();

    	    // Xe[ggN[Y
    	    stmt.close();

    	    return count;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
	}	
}