/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.common.XbConstants;
import jp.co.going.xbrl.common.parse.XbPAOImpl;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * ^N\m~[caɊi[NX
 * 
 * @author Going Dot Com Inc.
 */
abstract public class XbTaxonomyImpl implements XbTaxonomy {

	// VXet
	private Date system_date;
	// RlNV
    private Connection conn;
    // DAO
    private XbTaxonomyGroupDAO dbaTaxonomyGroupDAO;
    private XbTaxonomyDAO      dbaTaxonomyDAO;
    private XbTaxonomyItemDAO  dbaTaxonomyItemDAO;
    private XbLinkbaseRefDAO   dbaLinkbaseRefDAO;
    private XbItemTypeDAO    dbaItemtypeDAO;
    private XbNextIdDAO    taxGroupIdDAO;
    private XbNextIdDAO    taxIdDAO;
    private XbNextIdDAO    taxItemIdDAO;
    private XbNextIdDAO    linkRefIdDAO;
    private XbItemWorkDAO     itemWorkDAO;
    private XbItemLabelDAO     itemLabelDAO;
    private XbItemTopDAO       itemTopDAO;
    private XbItemOrderDAO     itemOrderDAO;

    private String spec;

    protected ArrayList<String> schemaList = new ArrayList<String>();

    /**
     * RXgN^
     * @param conn SQLRlNV
     * @throws XbException
     */
	protected XbTaxonomyImpl(Connection conn, String spec) throws XbException {
        this.conn = conn;
        this.spec = spec;
		// ^N\m~[O[vANZXNX
        dbaTaxonomyGroupDAO = XbTaxonomyGroupDAO.getInstance(conn);
		// ^N\m~[ANZXNX
        dbaTaxonomyDAO = XbTaxonomyDAO.getInstance(conn);
		// ^N\m~[ȖڃANZXNX
        dbaTaxonomyItemDAO = XbTaxonomyItemDAO.getInstance(conn);
		// Nx[XANZXNX
        dbaLinkbaseRefDAO = XbLinkbaseRefDAO.getInstance(conn);
        // ACe^CvZXNX
        dbaItemtypeDAO = XbItemTypeDAO.getInstance(conn);
		// O[vID擾
        taxGroupIdDAO = XbTaxGroupNextIdDAO.getInstance(conn);
        // ^N\m~[ID擾
        taxIdDAO = XbTaxNextIdDAO.getInstance(conn);
        // ACeID擾
        taxItemIdDAO = XbTaxItemNextIdDAO.getInstance(conn);
        // Nx[XID擾
        linkRefIdDAO = XbLinkRefNextIdDAO.getInstance(conn);
        // eq֌Wo^
        if (spec.equals(XbConstants.SPECIFICATION_NO_20)) {
            itemWorkDAO =  XbItemWork20DAO.getInstance(conn);
        } else if (spec.equals(XbConstants.SPECIFICATION_NO_21)) {
            itemWorkDAO =  XbItemWork21DAO.getInstance(conn);
        }
        // \o^
        if (spec.equals(XbConstants.SPECIFICATION_NO_20)) {
            itemLabelDAO = XbItemLabel20DAO.getInstance(conn);
        } else if (spec.equals(XbConstants.SPECIFICATION_NO_21)) {
            itemLabelDAO = XbItemLabel21DAO.getInstance(conn);
        }
        // TOPvfo^
        itemTopDAO = XbItemTopDAO.getInstance(conn);
        // яo^
        itemOrderDAO = XbItemOrderDAO.getInstance(conn);
        // DateNXCX^X
        system_date = new Date();
    }

    /**
     * ^N\m~[O[vݒ肷
     * @param       String                  [
     * @param       String                  l
     * @throws      XbException
     * @return      XbTaxonomyGroupObj      ^N\m~[O[vIuWFNg
     */
    private XbTaxonomyGroupObj setTaxonomyGroup(String grpName, String note) throws XbException {

        XbTaxonomyGroupObj taxGroupObj = new XbTaxonomyGroupObj();

        // ^N\m~[O[vID
        taxGroupObj.setTaxonomyGroupId(taxGroupIdDAO.getNextValue());
        // ^N\m~[O[v
        taxGroupObj.setTaxonomyGroupName(grpName);
        // dlԍ
        taxGroupObj.setSpecificationNo(this.spec);
        // l
        taxGroupObj.setNote(note);
        // t
        taxGroupObj.setCreationDate(system_date);
        // Inserts
        dbaTaxonomyGroupDAO.insert(taxGroupObj);

        return taxGroupObj;
    }


    /**
     * 擾XMLt@CparseDOMIuWFNg쐬
     * @param fileName t@C
     * @return DOMIuWFNg
     * @throws XbException
     */
	private Document getDocument(String fileName) throws XbException {
        // p[T̐
        XbPAOImpl parser = new XbPAOImpl();
        // XMLt@C̃p[X
        parser.parse(fileName);
        // DOCUMENTm[h̎擾
        return  parser.getDocument();
    }

    /**
     * eDBɓo^
     * @param       XbTaxonomyGroupObj          ^N\m~[O[vIuWFNg
     * @param       XbTaxonomyPramObjList       ^N\m~[t@CIuWFNgXg
     * @throws      SQLException
     * @throws      ClassNotFoundException
     * @throws      Exception
     * @see         Ȃ
     */
    private void registTaxonomyObj(Document doc, XbTaxonomyGroupObj taxGroupObj, String pathName, String fileName, int flg) throws XbException {

        String path = "";
        // ^hݒ肷
        this.setDerivation(doc);
        // ^N\m~[ݒ肷
        XbTaxonomyObj taxObj = this.setTaxonomy(doc, taxGroupObj, fileName, flg);
        // LinkBaseRefݒ肷
        XbLinkBaseObj linkPram = this.setLinkbaseref(doc, pathName, taxObj);
        // LinkBaseݒ肷
        XbLinkBase linkBase = new XbLinkBase(this.conn);
        linkBase.setLinkBase(linkPram);
        // ^N\m~[Ȗڐݒ
        setTaxonomyItem(doc, taxObj);
        // C|[gt@C
        NodeList lst = doc.getElementsByTagNameNS("*", XbConstants.TAG_IMPORT);
        // ċAs
        ArrayList<String> impList = getImportList(lst);
        for ( int i = 0; i < impList.size();i ++) {
            // t@CDOMIuWFNg쐬
            String file = pathName + "/" + impList.get(i);
            Document document = getDocument(file);
            path = file.substring(0, file.lastIndexOf("/"));
            this.registTaxonomyObj(document, taxGroupObj, path, impList.get(i), 0);
        }
        // CN[ht@C
        NodeList list = doc.getElementsByTagNameNS("*", XbConstants.TAG_INCLUDE);
        // ċAs
        ArrayList<String> imcList = getImportList(list);
        for ( int i = 0; i < imcList.size();i ++) {
            // t@CDOMIuWFNg쐬
            String file = pathName + "/" + imcList.get(i);
            Document document = getDocument(file);
            path = file.substring(0, file.lastIndexOf("/"));
            this.registTaxonomyObj(document, taxGroupObj, path, imcList.get(i), 0);
        }
    }

    /**
     * ^N\m~[ݒ肷
     * @param       Document                DOCUMENTm[h
     * @param       XbTaxonomyPramObj               ^N\m~[IuWFNgXg
     * @param       XbTaxonomyGroupObj      ^N\m~[O[vIuWFNg
     * @throws      Exception
     * @see         Ȃ
     * @return      XbTaxonomyObj           ^N\m~[IuWFNg
     */
    private XbTaxonomyObj setTaxonomy(Document doc, XbTaxonomyGroupObj taxGroupobj, String fileName, int flg) throws XbException {

        XbTaxonomyObj taxObj = new XbTaxonomyObj();

        // ^N\m~[ID
        taxObj.setTaxonomyId(taxIdDAO.getNextValue());
        // ^N\m~[O[vID
        taxObj.setTaxonomyGroupId(taxGroupobj.getTaxonomyGroupId());
        // ^N\m~[
        taxObj.setTaxonomyName(taxGroupobj.getTaxonomyGroupName());
        // ^N\m~[t@C
        taxObj.setTaxonomyFile(fileName.substring(fileName.lastIndexOf("/") + 1));
        // OԂݒ肷
        this.setNamespase(doc, taxObj);
        // I[tO
        taxObj.setTerminatedFlag(flg);
        // t
        taxObj.setCreationDate(system_date);
        // Inserts
        dbaTaxonomyDAO.insert(taxObj);

        return taxObj;
    }

    /**
     * OԂݒ肷
     * @param       Document            DOCUMENTm[h
     * @param       XbTaxonomyObj       IuWFNg
     * @throws      Exception
     * @see         Ȃ
     * @return      Ȃ
     */
    private void setNamespase(Document document, XbTaxonomyObj taxObj) {

        String str_url = "";

        NodeList lst = document.getElementsByTagNameNS("*", XbConstants.TAG_SCHEMA);

        // --------------------------------------------------------------------
        // targetNamespace擾
        // --------------------------------------------------------------------
        for (int i = 0;i < lst.getLength();i ++) {
            Node child = lst.item(i);
            NamedNodeMap attrs = child.getAttributes();

            for (int j = 0;j < attrs.getLength();j ++) {
                String node  = attrs.item(j).getNodeName();
                String value = attrs.getNamedItem(node).getNodeValue();

                if(XbConstants.TARGET_NAMESPACE.equals(node)){
                    // targetNamespaceŎw肳ĂURLێ
                    str_url = value;
                }
                else if (str_url.equals(value)) {
                    String strwk = null;
                    String sp[] = node.split(":");
                    if (sp.length >= 2) {
                        // O
                        strwk = sp[1];
                    }
                    // O
                    taxObj.setNamespace(strwk);
                    // OURL
                    taxObj.setNamespaceUrl(value);
                }
            }
        }
    }

    /**
     * LinkBaseݒ肷
     * @param       Document            DOCUMENTm[h
     * @param       XbTaxonomyObj       IuWFNg
     * @throws      Exception
     * @see         Ȃ
     * @return      ArrayList           XbLinkbaserefObjIuWFNgXg
     */
    private XbLinkBaseObj setLinkbaseref(Document document, String pathName, XbTaxonomyObj taxObj) throws XbException {
        // Linkbaseref^O擾
        NodeList lst_link = document.getElementsByTagNameNS("*", XbConstants.TAG_LINKBASE);
        // Nx[X捞IuWFNg쐬
        XbLinkBaseObj linkParam = new XbLinkBaseObj();
        // ^N\m~[IDݒ
        linkParam.setTaxonomyId(String.valueOf(taxObj.getTaxonomyId()));

        // --------------------------------------------------------------------
        // LinkBaseRef擾
        // --------------------------------------------------------------------
        for (int i = 0;i < lst_link.getLength();i ++) {
            Node child = lst_link.item(i);
            NamedNodeMap attrs = child.getAttributes();
            XbLinkbaserefObj linkobj = new XbLinkbaserefObj();

            // LinkBaseref ID
            linkobj.setLinkbaserefId(linkRefIdDAO.getNextValue());
            // ^N\m~[ID
            linkobj.setTaxonomyId(taxObj.getTaxonomyId());
            // ^N\m~[O[vID
            linkobj.setTaxonomyGroupId(taxObj.getTaxonomyGroupId());

            for (int j = 0;j < attrs.getLength();j ++) {
                String node  = attrs.item(j).getNodeName();
                String value = attrs.item(j).getNodeValue();

                if (XbConstants.ATTRIBUTE_XLINK_ROLE.equals(node)) {
                    linkobj.setLinkbaseRole(value);
                    // JeS[ݒ
                    String category = value.substring(value.lastIndexOf("/") + 1);
                    linkobj.setCategory(category);
                }
                if (XbConstants.ATTRIBUTE_XLINK_HREF.equals(node)) {
                    linkobj.setLinkbaseHref(value);
                }
            }
            // t
            linkobj.setCreationDate(system_date);
            // Inserts
            dbaLinkbaseRefDAO.insert(linkobj);
            // Nx[Xt@Cݒ
            setLinkBaseFile(linkParam, pathName, linkobj);
        }
        return linkParam;
    }

    /**
     * ^N\m~[Ȗڂݒ肷
     * @param       Document            DOCUMENTm[h
     * @param       XbTaxonomyObj       IuWFNg
     * @throws      Exception
     * @see         Ȃ
     * @return      Ȃ
     */
    private void setTaxonomyItem(Document document, XbTaxonomyObj taxobj) throws XbException {
        // Element^O擾
        NodeList lst = document.getElementsByTagNameNS("*", XbConstants.TAG_ELEMENT);

        // --------------------------------------------------------------------
        // ^e[uXV
        // --------------------------------------------------------------------
        for (int i = 0;i < lst.getLength();i ++) {
            Node child = lst.item(i);
            XbTaxonomyItemObj taxItemObj = new XbTaxonomyItemObj();
            NamedNodeMap attrs = child.getAttributes();

            // l擾
            for (int j = 0;j < attrs.getLength();j ++) {
                String node  = attrs.item(j).getNodeName();
                String value = attrs.getNamedItem(node).getNodeValue();

                if (XbConstants.ATTRIBUTE_ID.equals(node)) {
                    // id (element tag attrubute)
                    taxItemObj.setItemId(value);
                }
                if (XbConstants.ATTRIBUTE_NAME.equals(node)) {
                    // name (element tag attrubute)
                    taxItemObj.setItemName(value);
                }
                if (XbConstants.ATTRIBUTE_TYPE.equals(node)) {
                    // type (element tag attrubute)
                    taxItemObj.setItemType(this.getSplitAtem(value));
                }
                if (XbConstants.ATTRIBUTE_SUBSTITUTION_GROUP.equals(node)) {
                    // substitutiongroup (element tag attrubute)
                    taxItemObj.setItemSubstitutiongroup(this.getSplitAtem(value));
                }
                if (XbConstants.ATTRIBUTE_BALANCE.equals(node)) {
                    // ݕ(credit)/ؕ(Debit)
                    taxItemObj.setItemBalance(value);
                }
                if (XbConstants.ATTRIBUTE_NILLABLE.equals(node)) {
                    if (value.equals("true")) {
                        // NULLltO(0:false, 1:true)
                        taxItemObj.setItemNillable(1);
                    }else{
                        // NULLltO(0:false, 1:true)
                        taxItemObj.setItemNillable(0);
                    }
                }
                if (XbConstants.ATTRIBUTE_ABSTRACT.equals(node)) {
                    if (value.equals("true")) {
                        // tO(0:false, 1:true)
                        taxItemObj.setAbstractFlg(1);
                    } else {
                        // tO(0:false, 1:true)
                        taxItemObj.setAbstractFlg(0);
                    }
                }
                if (XbConstants.ATTRIBUTE_PERIOD_TYPE.equals(node)) {
                    // vԑ
                    taxItemObj.setItemPeriodType(value);
                }
            }

            // substitutionGroupe "link:part" ȊȌꍇA
            // ^N\m~[ȖڃR[h쐬
            if (!XbConstants.SUBSTITUTION_GROUP_VALUE.equals(taxItemObj.getItemSubstitutiongroup()) && taxItemObj.getItemId() != null) {
                // ^N\m~[ACeID
                taxItemObj.setTaxonomyItemId(taxItemIdDAO.getNextValue());
                // ^N\m~[ID
                taxItemObj.setTaxonomyId(taxobj.getTaxonomyId());
                // ^N\m~[O[vID
                taxItemObj.setTaxonomyGroupId(taxobj.getTaxonomyGroupId());
                // hLg(Ql)
                taxItemObj.setDocumentation(this.getAttributeName(child));
                // t
                taxItemObj.setCreationDate(system_date);
                // Inserts
                dbaTaxonomyItemDAO.insert(taxItemObj);
            }
        }
    }

    /**
     * documentation"ja"Valuel擾
     * @param       Node        m[h
     * @throws      Ȃ
     * @see         Ȃ
     * @return      String      Valuel
     */
    private String getAttributeName(Node root) {
        Node childnode = root.getFirstChild();
        if (childnode == null) {
            return null;
        }

        // documentation^O
        ArrayList<Node> ls  = getNode(childnode, XbConstants.TAG_DOCUMENTATION);
        for (int i=0;i < ls.size();i ++) {
            Node nowork = ls.get(i);
            // l擾
            NamedNodeMap attrs = nowork.getAttributes();
            if (attrs.getLength() != 0) {
                for (int j = 0;j < attrs.getLength();j ++) {
                    // xml:lang"ja"Valuel擾
                    if (attrs.getNamedItem(attrs.item(j).getNodeName()).getNodeValue().equals("ja")) {
                        String str = getNodeVal(nowork);
                        return str;
                    }
                }
            }
        }
        return null;
    }

    /**
     * w肵^Om[hXg擾
     * @param       Node            m[h
     * @param       String          ^O
     * @throws      Ȃ
     * @see         Ȃ
     * @return      ArrayList       m[hXg
     */
    private ArrayList<Node> getNode(Node node, String nodeName) {
        ArrayList<Node> lst = new ArrayList<Node>();
        if ((node == null) || (nodeName == null) ) {
            return null;
        }

        NodeList ls = node.getChildNodes();
        Node child = null;
        for (int i = 0;i < ls.getLength();i ++) {
            child = ls.item(i);
            if (nodeName.equals(child.getNodeName())) {
                lst.add(child);
            }
        }
        return lst;
    }

    /**
     * w肵m[hValue擾
     * @param       Node        m[h
     * @throws      Ȃ
     * @see         Ȃ
     * @return      String      Valuel
     */
    private String getNodeVal(Node node) {
        if (node == null) {
            return null;
        }

        NodeList ls = node.getChildNodes();
        Node child = null;
        for (int i = 0;i < ls.getLength();i ++) {
            child = ls.item(i);
            if (child.getNodeType() == Node.TEXT_NODE) {
                return child.getNodeValue();
            }
        }
        return null;
    }

    /**
     * ":"̑񕶎ԋp
     * @param       String      Ώƕ
     * @throws      Ȃ
     * @see         Ȃ
     * @return      String      Valuel
     */
    private String getSplitAtem(String str) {
        if (str == null) {
            return null;
        }

        String sp[] = str.split(":");
        if (sp.length >= 2) {
            // 񕶎
            return sp[1];
        }
        return str;
    }

    /**
     * Ȗڂ̏Ԃ\o^
     * @param grpId ^N\m~[O[vID
     * @throws XbException
     */
    private void setItemInsert(long grpId) throws XbException {
        // [Ne[uɐeq֌Wo^
        itemWorkDAO.insert(grpId);
        // xo^
        itemLabelDAO.setItemLabel(grpId);
        // snovfo^
        ArrayList<XbItemTopObj> itemTop = itemTopDAO.setItemTop(grpId);
        // яo^
        itemOrderDAO.setItemOrder(itemTop);
    }

    /**
     * hACeo^
     * @param doc hLg
     * @throws XbException
     */
    private void setDerivation(Document doc) throws XbException {
        // ^O擾
        NodeList restLst = doc.getElementsByTagNameNS("*", XbConstants.TAG_COMPLEX_TYPE);
        for (int i = 0;i < restLst.getLength();i ++) {
            Node node = restLst.item(i);
            NamedNodeMap attrs = node.getAttributes();
            // name̒l擾
            if (attrs.getLength() != 0) {
                String item = attrs.getNamedItem("name").getNodeValue();
                Node child = node.getFirstChild();
                // itemǉ
                this.addItemType(child, item);
            }
        }
    }

    /**
     * ACě^o^
     * @param item ǉACe
     * @throws XbException
     */
    private void addItemType(Node node, String item) throws XbException {
        while (node != null) {
            // simpleContent
            if (node.getNodeType() == Node.ELEMENT_NODE &&
                    XbConstants.TAG_SIMPLECONTENT.equals(this.getSplitAtem(node.getNodeName()))) {
                Node child = node.getFirstChild();
                this.addItemType(child, item);
            }
            // restriction or extension
            if (node.getNodeType() == Node.ELEMENT_NODE &&
                    (XbConstants.TAG_RESTRICTION.equals(this.getSplitAtem(node.getNodeName())) ||
                            XbConstants.TAG_EXTENSION.equals(this.getSplitAtem(node.getNodeName())))) {
                // l擾
                NamedNodeMap attrs = node.getAttributes();
                // ȟ^擾
                String itemName = this.getSplitAtem(attrs.getNamedItem("base").getNodeValue());
                // insert
                dbaItemtypeDAO.insert(item, itemName, this.spec, system_date);
            }
            node = node.getNextSibling();
        }
    }

    /**
     *  importĂXL[}擾邩肷
     * @param value importXL[}
     * @param version o[W
     * @return true : XL[}擾 false : 擾Ȃ
	 */
    protected boolean isAddFlg(String value, String version) {
        String instance = "";
        String linkbase = "";

        if (version.equals(XbConstants.SPECIFICATION_NO_20)) {
            instance = XbConstants.INSTANCE_NAME20;
            linkbase = XbConstants.LINKBASE_NAME20;
        } else if (version.equals(XbConstants.SPECIFICATION_NO_21)) {
            instance = XbConstants.INSTANCE_NAME21;
            linkbase = XbConstants.LINKBASE_NAME21;
        }

        if (value.equals(instance) || value.equals(linkbase)) {
            return false;
        }

        for (int i = 0;i < this.schemaList.size();i ++) {
            if (value.equals(schemaList.get(i))) {
                return false;
            }
        }

        return true;
    }

    /**
     * ^N\m~[̎捞݂s
     * @param       grpName         [
     * @param       note            l
     * @param       fileName        [^N\m~[t@C
     * @throws      XbException
     */
	public final void registerTaxonomy(String grpName, String note, String fileName) throws XbException {
		// ^N\m~[O[vݒ肷
		XbTaxonomyGroupObj taxGroupObj = this.setTaxonomyGroup(grpName, note);
        // pathfile擾
        File name = new File(fileName);
        String pathName = name.getParent();
        String fName = name.getName();
        // t@CǂݍDOM쐬
        Document doc = this.getDocument(fileName);
        // ^N\m~[IuWFNgeDBɐݒ肷
		this.registTaxonomyObj(doc, taxGroupObj, pathName, fName, 1);
		// ACeo^
        this.setItemInsert(taxGroupObj.getTaxonomyGroupId());
    }

	abstract protected void setLinkBaseFile(XbLinkBaseObj linkObj, String pathName, XbLinkbaserefObj linkobj) throws XbException;

    abstract protected ArrayList<String> getImportList(NodeList importList);
}