/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.common.XbConstants;

/**
 * ^N\m~[荞ނ߂
 * IuWFNg擾NX
 * 
 * @author Going Dot Com Inc.
 */
public class XbTaxonomyFactory {

    /**
     * w肵XybÑ^N\m~[
     * 荞݃CX^X𐶐
     * 
     * @param conn caRlNV
     * @param spec XybNi2.0 or 2.1j
     * @return XbTaxonomyIuWFNg
     * @throws XbException
     */
    public static XbTaxonomy createTaxonomy(Connection conn, String spec) throws XbException {
        XbTaxonomy taxonomy = null;

        if (XbConstants.SPECIFICATION_NO_20.equals(spec)) {
            taxonomy = new XbTaxonomy20(conn, spec);
        } else {
            taxonomy = new XbTaxonomy21(conn, spec);
        }
        return taxonomy;
    }
}