/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbTaxonomyDAO {

    // singleton쐬
    private static XbTaxonomyDAO tax = null;
    // Connectionϐ
    private static Connection conn = null;

    // RXgN^
    private XbTaxonomyDAO() {
    }

    // CX^X擾
    public static XbTaxonomyDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (tax == null) {
            conn = connection;
            tax = new XbTaxonomyDAO();
        }

        return tax;
    }

    protected void insert(XbTaxonomyObj obj)
        throws XbException {

        try {
            // Xe[gg쐬
            PreparedStatement stmt;

    		StringBuffer  strb_sql = new StringBuffer();
    	    // ⍇̎s
        	strb_sql.append("insert into ");
        	strb_sql.append("xb_taxonomy ");
        	strb_sql.append("values ");
        	strb_sql.append("(?, ?, ?, ?, ?, ?, ?, ?)");

    		// SQLݒ
    		stmt = conn.prepareStatement(strb_sql.toString());

    		int index = 1;
    		stmt.setLong(index++, obj.getTaxonomyId());
    		stmt.setLong(index++, obj.getTaxonomyGroupId());
    		stmt.setString(index++, obj.getTaxonomyName());
    		stmt.setString(index++, obj.getTaxonomyFile());
    		stmt.setString(index++, obj.getNamespace());
    		stmt.setString(index++, obj.getNamespaceUrl());
    		stmt.setInt(index++, obj.getTerminatedFlag());
            stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreationDate().getTime()));

    	   	// SQL@s
    	   	stmt.executeUpdate();

    	    // Xe[ggN[Y
    	    stmt.close();
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
	}
}