/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.common.XbConstants;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * o[W2.1̃^N\m~[caɊi[NX
 * 
 * @author Going Dot Com Inc.
 */
public class XbTaxonomy21 extends XbTaxonomyImpl {

    /**
     * RXgN^
     * @param           conn DBRlNV
     * @throws      XbException
     */
	public XbTaxonomy21(Connection conn, String spec) throws XbException {
	    super(conn, spec);
    }

    /**
     *  Nx[Xo^p[^ݒ肷
     * @param linkObj   Nx[Xp[^
     * @param linkobj   XL[}link
     */
    protected void setLinkBaseFile(XbLinkBaseObj linkObj, String pathName, XbLinkbaserefObj linkobj) throws XbException {
        try {
            String str = linkobj.getCategory().substring(0, linkobj.getCategory().indexOf(XbConstants.ROLE_URL_LINKBASEREF));

            // Calculation
            if (XbConstants.ROLE_URL_CALCULATION.equals(str)) {
                linkObj.setCalculationFileName(pathName + "/" + linkobj.getLinkbaseHref());
            // Definition
            } else if (XbConstants.ROLE_URL_DEFINITION.equals(str)) {
                linkObj.setDefinitionFileName(pathName + "/" + linkobj.getLinkbaseHref());
            // Label
            } else if (XbConstants.ROLE_URL_LABEL.equals(str)) {
                linkObj.setLabelFileName(pathName + "/" + linkobj.getLinkbaseHref());
            // Presentation
            } else if (XbConstants.ROLE_URL_PRESENTATION.equals(str)) {
                linkObj.setPresentationFileName(pathName + "/" + linkobj.getLinkbaseHref());
            // Reference
            } else if (XbConstants.ROLE_URL_REFERENCE.equals(str)) {
                linkObj.setReferenceFileName(pathName + "/" + linkobj.getLinkbaseHref());
            }
        } catch (IndexOutOfBoundsException e) {
            throw new XbException("ǂݍ񂾃^N\m~̃o[WႢ܂B");
        }
    }

    /**
     * importĂXL[}擾
     * @param importList import^OXg
     * @return importt@CXg
     */
    protected ArrayList<String> getImportList(NodeList importList) {
        ArrayList<String> list = new ArrayList<String>();

        // Xg񐔃[v
        for (int i = 0;i < importList.getLength();i ++) {
            // vf擾
            Node child = importList.item(i);
            // 擾
            NamedNodeMap attrs = child.getAttributes();

            String strValue = attrs.getNamedItem(XbConstants.TAG_IMPORT_SCHEMALOCATION).getNodeValue();

            // t@C؂o
            String schemaFile = this.getFileName(strValue);

            if (super.isAddFlg(schemaFile, XbConstants.SPECIFICATION_NO_21)) {
                super.schemaList.add(schemaFile);
                // Xgɒǉ
                list.add(schemaFile);
            }
        }

        return list;
    }

    private String getFileName(String name) {
        String fileName = "";

        if ("../".equals(name.substring(0, 3))) {
            fileName = name;
        } else {
            fileName = name.substring(name.lastIndexOf("/") + 1);
        }

        return fileName;
    }
}