/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbResourceItemDAO {

    // singleton쐬
    private static XbResourceItemDAO singleton = null;
    // Connectionϐ
    private static Connection conn = null;
    // Xe[gg쐬
    private PreparedStatement stmt = null;

    // RXgN^
    private XbResourceItemDAO() {
    }

    // CX^X擾
    public static XbResourceItemDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (singleton == null) {
            conn = connection;
            singleton = new XbResourceItemDAO();
        }

        return singleton;
    }

    protected int insert(XbResourceItemObj obj)
        throws XbException {

        try {
            StringBuffer  strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("insert into ");
            strb_sql.append("xb_resource_item ");
            strb_sql.append("values ");
            strb_sql.append("(?, ?, ?, ?, ?, ?)");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, obj.getResource_item_id());
            stmt.setLong(index++, obj.getResource_id());
            stmt.setString(index++, obj.getNamespace());
            stmt.setString(index++, obj.getNamespace_url());
            stmt.setString(index++, obj.getItem_name());
            stmt.setString(index++, obj.getItem_value());

            // SQL@s
            int count =stmt.executeUpdate();

            // Xe[ggN[Y
            stmt.close();

            return count;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }
}
