/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.taxonomy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
public class XbLinkbaseLocatorDAO {

    // singleton쐬
    private static XbLinkbaseLocatorDAO singleton = null;
    // Connectionϐ
    private static Connection conn = null;
    // Xe[gg쐬
    private PreparedStatement stmt = null;

     // RXgN^
    public XbLinkbaseLocatorDAO(){
    }

    // CX^X擾
    public static XbLinkbaseLocatorDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (singleton == null) {
            conn = connection;
            singleton = new XbLinkbaseLocatorDAO();
        }

        return singleton;
    }

    protected int insert(XbLinkbaseLocatorObj obj)
        throws XbException {

        try {
            StringBuffer  strb_sql = new StringBuffer();
            // ⍇̎s
            strb_sql.append("insert into ");
            strb_sql.append("xb_linkbase_locator ");
            strb_sql.append("values ");
            strb_sql.append("(?, ?, ?, ?, ?, ?, ?)");

            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());

            int index = 1;
            stmt.setLong(index++, obj.getLocator_id());
            stmt.setLong(index++, obj.getLinkbaseref_id());
            stmt.setString(index++, obj.getLoc_href());
            stmt.setString(index++, obj.getLoc_identifier());
            stmt.setString(index++, obj.getLoc_label());
            stmt.setString(index++, obj.getLoc_title());
            stmt.setString(index++, obj.getLoc_role());

            // SQL@s
            int count =stmt.executeUpdate();

            // Xe[ggN[Y
            stmt.close();

            return count;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }
}