/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbRefObj;

/**
 * @author Masako Okayasu
 */
public class XbRefDao {

	// singleton쐬
    private static XbRefDao ref = null;
    // Connectionϐ
    private static Connection conn = null;
	// Xe[gg쐬
    private PreparedStatement stmt;

    // RXgN^
    public XbRefDao(){
    }

    // CX^X擾
    public static synchronized XbRefDao getInstance(Connection connection){
    	// CX^X𐶐
        if(ref == null) {
            conn = connection;
            ref = new XbRefDao();
        }

        return ref;
    }

	public void insert(XbRefObj obj) throws XbException{

		try {
			StringBuffer strb_sql = new StringBuffer();
		    // ⍇̎s
	    	strb_sql.append("insert into ");
	    	strb_sql.append("xb_ref ");
	    	strb_sql.append("values ");
	    	strb_sql.append("(?,?,?,?)");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setInt(index++, obj.getRef_type());
			stmt.setLong(index++, obj.getRef_id());
			stmt.setString(index++, obj.getRef_name());
	        stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

		   	// SQL@s
		   	stmt.executeUpdate();

		    // Xe[ggN[Y
		    stmt.close(); 

		} catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        }
	}

	public ArrayList<XbRefObj> selectAll() throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("ref_type, ");
			strb_sql.append("ref_id, ");
			strb_sql.append("ref_name, ");
			strb_sql.append("creation_date ");
			strb_sql.append("from xb_ref ");
			strb_sql.append("order by ref_type, ref_id ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			ResultSet rs = stmt.executeQuery();
			ArrayList<XbRefObj> relist = new ArrayList<XbRefObj>();
			while(rs.next()) {
				XbRefObj obj = new XbRefObj();
				obj.setRef_type(rs.getInt("ref_type"));
				obj.setRef_id(rs.getLong("ref_id"));
				obj.setRef_name(rs.getString("ref_name"));
				obj.setCreation_date(rs.getDate("creation_date"));
				relist.add(obj);
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return relist;
		} catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        }
	}

	public ArrayList<XbRefObj> selectAllByType(int ref_type) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("ref_type, ");
			strb_sql.append("ref_id, ");
			strb_sql.append("ref_name, ");
			strb_sql.append("creation_date ");
			strb_sql.append("from xb_ref ");
			strb_sql.append("where ref_type=? ");
			strb_sql.append("order by ref_id ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setInt(index++, ref_type);

			ResultSet rs = stmt.executeQuery();
			ArrayList<XbRefObj> relist = new ArrayList<XbRefObj>();
			while(rs.next()) {
				XbRefObj obj = new XbRefObj();
				obj.setRef_type(rs.getInt("ref_type"));
				obj.setRef_id(rs.getLong("ref_id"));
				obj.setRef_name(rs.getString("ref_name"));
				obj.setCreation_date(rs.getDate("creation_date"));
				relist.add(obj);
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return relist;
		} catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        }
	}

	public XbRefObj select(int ref_type, long ref_id) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("ref_type, ");
			strb_sql.append("ref_id, ");
			strb_sql.append("ref_name, ");
			strb_sql.append("creation_date ");
			strb_sql.append("from xb_ref ");
			strb_sql.append("where ref_type=? and ref_id=? ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setInt(index++, ref_type);
			stmt.setLong(index++, ref_id);

			ResultSet rs = stmt.executeQuery();
			XbRefObj obj = null;
			while(rs.next()) {
				obj = new XbRefObj();
				obj.setRef_type(rs.getInt("ref_type"));
				obj.setRef_id(rs.getLong("ref_id"));
				obj.setRef_name(rs.getString("ref_name"));
				obj.setCreation_date(rs.getDate("creation_date"));
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return obj;
		} catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        }
	}

	public long getNextId(int ref_type) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("max(ref_id)+1 as max ");
			strb_sql.append("from xb_ref ");
			strb_sql.append("where ref_type=? ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setInt(index++, ref_type);

			ResultSet rs = stmt.executeQuery();
			rs.next();

			return (rs.getLong("max")==0 ? 1 : rs.getLong("max"));
		} catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        }
	}
}