/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbRefAttributesObj;

/**
 * @author Masako Okayasu
 */
public class XbRefAttributesDao {

	// singleton쐬
    private static XbRefAttributesDao refAttr = null;
    // Connectionϐ
    private static Connection conn = null;
	// Xe[gg쐬
    private PreparedStatement stmt;

    // RXgN^
    public XbRefAttributesDao(){
    }

    public static synchronized XbRefAttributesDao getInstance(Connection connection){
    	// CX^X𐶐
        if(refAttr == null) {
            conn = connection;
            refAttr = new XbRefAttributesDao();
        }

        return refAttr;
    }

	public void insert(XbRefAttributesObj obj) throws XbException{

		try {
			StringBuffer strb_sql = new StringBuffer();
		    // ⍇̎s
	    	strb_sql.append("insert into ");
	    	strb_sql.append("xb_ref_attributes ");
	    	strb_sql.append("values ");
	    	strb_sql.append("(?,?,?,?,?)");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setInt(index++, obj.getRef_type());
			stmt.setLong(index++, obj.getRef_id());
			stmt.setString(index++, obj.getName());
			stmt.setString(index++, obj.getValue());
	        stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

		   	// SQL@s
		   	stmt.executeUpdate();

		    // Xe[ggN[Y
		    stmt.close(); 

		} catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        }
	}

	public ArrayList<XbRefAttributesObj> selectAll(	int ref_type, long ref_id) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("ref_type, ");
			strb_sql.append("ref_id, ");
			strb_sql.append("name, ");
			strb_sql.append("value, ");
			strb_sql.append("creation_date ");
			strb_sql.append("from xb_ref_attributes ");
			strb_sql.append("where ref_type=? and ref_id=? ");
			strb_sql.append("order by name ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setInt(index++, ref_type);
			stmt.setLong(index++, ref_id);

			ResultSet rs = stmt.executeQuery();
			ArrayList<XbRefAttributesObj> relist = new ArrayList<XbRefAttributesObj>();
			while(rs.next()) {
				XbRefAttributesObj obj = new XbRefAttributesObj();
				obj.setRef_type(rs.getInt("ref_type"));
				obj.setRef_id(rs.getLong("ref_id"));
				obj.setName(rs.getString("name"));
				obj.setValue(rs.getString("value"));
				obj.setCreation_date(rs.getDate("creation_date"));
				relist.add(obj);
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return relist;
		} catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        }
	}

	public XbRefAttributesObj select(int ref_type, long ref_id, String name) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("ref_type, ");
			strb_sql.append("ref_id, ");
			strb_sql.append("name, ");
			strb_sql.append("value, ");
			strb_sql.append("creation_date ");
			strb_sql.append("from xb_ref_attributes ");
			strb_sql.append("where ref_type=? and ref_id=? and name=? ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setInt(index++, ref_type);
			stmt.setLong(index++, ref_id);
			stmt.setString(index++, name);

			ResultSet rs = stmt.executeQuery();
			XbRefAttributesObj obj = null;
			while(rs.next()) {
				obj = new XbRefAttributesObj();
				obj.setRef_type(rs.getInt("ref_type"));
				obj.setRef_id(rs.getLong("ref_id"));
				obj.setName(rs.getString("name"));
				obj.setValue(rs.getString("value"));
				obj.setCreation_date(rs.getDate("creation_date"));
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return obj;
		} catch (SQLException e) {
            throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
        }
	}
}