/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.sample.dao.obj.XbContextUnitObj;

/**
 * @author Masako Okayasu
 */
public class XbContextUnitDao {

	// singleton쐬
    private static XbContextUnitDao contextUnit = null;
    // Connectionϐ
    private static Connection conn = null;
	// Xe[gg쐬
    private PreparedStatement stmt;

    // e[u
	private String table1 = "xb_context_unit";
	private String table2 = "xb_unit";

    // RXgN^
    public XbContextUnitDao(){
    }

    // CX^X擾
    public static synchronized XbContextUnitDao getInstance(Connection connection){
    	//  CX^X𐶐
    	if(contextUnit == null) {
    		conn = connection;
    		contextUnit = new XbContextUnitDao();
    	}

    	return contextUnit;
    }

	public void insert(XbContextUnitObj obj) throws XbException{

		try {
			StringBuffer strb_sql = new StringBuffer();
		    // ⍇̎s
	    	strb_sql.append("insert into ");
	    	strb_sql.append(table1 + " ");
	    	strb_sql.append("values ");
	    	strb_sql.append("(?,?,?,?)");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, obj.getContext_id());
			stmt.setLong(index++, obj.getUnit_id());
			stmt.setLong(index++, obj.getPresentation_order());
	        stmt.setTimestamp(index++, new java.sql.Timestamp(obj.getCreation_date().getTime()));

		   	// SQL@s
		   	stmt.executeUpdate();

		    // Xe[ggN[Y
		    stmt.close(); 

		} catch (SQLException e) {
	        throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
	    }
	}

	public ArrayList<XbContextUnitObj> selectAll(long context_id) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("context_id, ");
			strb_sql.append(table1 + ".unit_id, ");
			strb_sql.append("unit_name, ");
			strb_sql.append("name, ");
			strb_sql.append(table1 + ".presentation_order, ");
			strb_sql.append(table1 + ".creation_date ");
			strb_sql.append("from " + table1 + ", " + table2 + " ");
			strb_sql.append("where context_id=? ");
			strb_sql.append("and " + table1 + ".unit_id=" + table2 + ".unit_id ");
			strb_sql.append("order by presentation_order, " + table1 + ".unit_id ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, context_id);

			ResultSet rs = stmt.executeQuery();
			ArrayList<XbContextUnitObj> relist = new ArrayList<XbContextUnitObj>();
			while(rs.next()) {
				XbContextUnitObj obj = new XbContextUnitObj();
				obj.setContext_id(rs.getLong("context_id"));
				obj.setUnit_id(rs.getLong("unit_id"));
				obj.setUnit_name(rs.getString("unit_name"));
				obj.setName(rs.getString("name"));
				obj.setPresentation_order(rs.getLong("presentation_order"));
				obj.setCreation_date(rs.getDate("creation_date"));
				relist.add(obj);
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return relist;
		} catch (SQLException e) {
	        throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
	    }
	}

	public XbContextUnitObj select(long context_id, long unit_id) throws XbException{

		try {
			StringBuffer  strb_sql = new StringBuffer();
		    // ⍇̎s
			strb_sql.append("select ");
			strb_sql.append("context_id, ");
			strb_sql.append(table1 + ".unit_id, ");
			strb_sql.append("unit_name, ");
			strb_sql.append("name, ");
			strb_sql.append(table1 + ".presentation_order, ");
			strb_sql.append(table1 + ".creation_date ");
			strb_sql.append("from " + table1 + ", " + table2 + " ");
			strb_sql.append("where context_id=? ");
			strb_sql.append("and " + table1 + ".unit_id=? ");
			strb_sql.append("and " + table1 + ".unit_id=" + table2 + ".unit_id ");

			// SQLݒ
			stmt = conn.prepareStatement(strb_sql.toString());

			int index = 1;
			stmt.setLong(index++, context_id);
			stmt.setLong(index++, unit_id);

			ResultSet rs = stmt.executeQuery();
			XbContextUnitObj obj = null;
			while(rs.next()) {
				obj = new XbContextUnitObj();
				obj.setContext_id(rs.getLong("context_id"));
				obj.setUnit_id(rs.getLong("unit_id"));
				obj.setUnit_name(rs.getString("unit_name"));
				obj.setName(rs.getString("name"));
				obj.setPresentation_order(rs.getLong("presentation_order"));
				obj.setCreation_date(rs.getDate("creation_date"));
			}

		    // ʃZbgN[Y
		    rs.close();

		    // Xe[ggN[Y
		    stmt.close();

		    return obj;
		} catch (SQLException e) {
	        throw new XbException(e, "SQLݒG[: SQLError : " + e.getMessage());
	    }
	}
}