/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.sample;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.table.DefaultTableModel;

/**
 * @author Masako Okayasu
 */
@SuppressWarnings("serial")
public class XbFormParamInput extends XbCommon implements ActionListener {

	private JTable table = null;
	private DefaultTableModel tableModel = null;

	private JLabel[] title = null;
	private JTextField[] text = null;
	private JPanel[] valuePanel = null;

	/**
	 * RXgN^
	 */
	public XbFormParamInput(String param, JTable table) {
		this.table = table;

		setTitle("XBRL Toolkit : Input " + param);
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			e.printStackTrace();
		}

		Container container = getContentPane();
		container.setLayout(new BorderLayout());

		JPanel HeaderPanel = new JPanel();
		HeaderPanel.setLayout(new BorderLayout());
		HeaderPanel.setPreferredSize(new Dimension(200, 23));
		HeaderPanel.add(new JLabel("@y " + nameList.get(param) + " <" + param + "> z"), BorderLayout.WEST);

		JPanel FormPanel = FormPanel();
		if(param.equals(MEASURE)) {
			MeasureFunc();
		}
		JPanel SubmitPanel = SubmitPanel();

		submitButton.addActionListener(this);
		submitButton.setEnabled(false);
		closeButton.addActionListener(this);

		container.add(HeaderPanel, BorderLayout.NORTH);
		container.add(FormPanel, BorderLayout.CENTER);
		container.add(SubmitPanel, BorderLayout.SOUTH);

		pack();
	}

	/**
	 * measure͗̐
	 */
	private void MeasureFunc() {
		unitCombo.setPreferredSize(new Dimension(85, 20));
		unitCombo.addActionListener(this);
		unitCombo.setSelectedIndex(0);

		valuePanel[1].removeAll();
		valuePanel[1].add(unitCombo, BorderLayout.WEST);
		text[1].setText(unitCombo.getSelectedItem().toString());
	}

	/**
	 * ̓tH[̐
	 */
	private JPanel FormPanel() {
		GridBagLayout layout = new GridBagLayout();
		GridBagConstraints gbc = new GridBagConstraints();

		JPanel FormPanel = new JPanel();
		FormPanel.setLayout(layout);

		int count = table.getColumnCount() - 1;
		title = new JLabel[count];
		text = new JTextField[count];
		valuePanel = new JPanel[count];

		for(int i=0; i<count; i++) {
			title[i] = new JLabel(table.getColumnName(i+1));
			layout.setConstraints(title[i], setGrid(0, i, gbc));
			FormPanel.add(title[i]);

			text[i] = setField(200);
			if(title[i].toString().indexOf("*") != -1) {
				text[i].addCaretListener(new CaretListener() {
					public void caretUpdate(CaretEvent e) {
						if(e.getDot() > 0) {
							submitButton.setEnabled(true);
				}	}	});
			}
			valuePanel[i] = setPanel(text[i]);

			layout.setConstraints(valuePanel[i], setGrid(1, i, gbc));
			FormPanel.add(valuePanel[i]);
		}

		return FormPanel;
	}

	/**
	 * Button ̃Cxg擾
	 */
	public void actionPerformed(ActionEvent e) {
		Object source = e.getSource();

		if(source == unitCombo) {
			text[1].setText(unitCombo.getSelectedItem().toString());
		}
		else if(source == submitButton) {
			String[] data = new String[text.length + 1];
			data[0] = "(̔)";

			boolean rc = true;
			for(int i=0; i<text.length; i++) {
				if(title[i].toString().indexOf("*") != -1 && text[i].getText().equals(""))  rc = false;
				data[i+1] = text[i].getText();
			}

			if(rc==true) {
				tableModel = (DefaultTableModel)table.getModel();
				tableModel.insertRow(table.getRowCount(), data);
				table.scrollRectToVisible(table.getCellRect(tableModel.getRowCount()-1, 0, true));
				table.repaint();
			}

			this.setVisible(false);
		}
		else if(source == closeButton){
			this.setVisible(false);
		}
	}
}