/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.common.XbConstants;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Going Dot Com Inc.
 */
class XbScenario extends XbContext {

    private Document doc;

    protected XbScenario(Connection conn, Document doc) throws XbException {
        this.doc = doc;

        etcDAO = XbScenarioDAO.getInstance(conn);
    }

    /**
     * Scenario쐬
     * @param entityId contextID
     * @return scenarioTag
     * @throws XbException
     */
    protected Element createScenario(String contextId, Element rootInstance) throws XbException {

        // scenario(root)擾
        ArrayList<XbEtcObj> scenarioList = etcDAO.getEtc(contextId, "0");
        Element scenario = null;

        for (int i = 0;i < scenarioList.size();i ++) {
            XbEtcObj obj = scenarioList.get(i);
            // scenarioTag
            scenario = super.createElement(this.doc, XbConstants.TAG_SCENARIO);
            // rootOԐݒ
            super.setAttribute(rootInstance, XbConstants.NAMESPACE_XMLNS + obj.getPrefix(), obj.getUri());
            // ċA
            Element scenarioItem = super.createEtc(this.doc, contextId, obj, obj.getPrefix());
            // scenarioɐݒ
            super.appendChild(scenario, scenarioItem);
        }

        return scenario;
    }
}