/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.common.XbConstants;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Going Dot Com Inc.
 */
class XbItem20 extends XbItem {

    protected XbItem20(Connection conn, Document doc) throws XbException {
        super(conn, doc);
    }

    protected void createItem() throws XbException {
        XbInterfaceObj old = null;
        String itemValue = "";

        for (int i = 0;i < interfaceList.size();i ++) {
            XbInterfaceObj obj = interfaceList.get(i);

            if (i == 0) {
                old = obj;
                itemValue = obj.getItemValue();
            }
            else if (obj.getTaxonomyItemId().equals(old.getTaxonomyItemId()) &&
                                obj.getTaxonomyItemSeq().equals(old.getTaxonomyItemSeq()) &&
                                XbConstants.ATTRIBUTE_NUMERIC.equals(obj.getContextType()) &&
                                obj.getContextName().equals(old.getContextName())) {
                itemValue = String.valueOf(Long.parseLong(itemValue) + Long.parseLong(obj.getItemValue()));
            } else {
                // ċA
                Element itemChild = this.createElementChild(old, itemValue);
                // itemݒ
                super.appendChild(super.root, itemChild);
                // lZbg
                old = obj;
                itemValue = obj.getItemValue();
            }
        }
        // ċA
        Element itemChild = this.createElementChild(old, itemValue);
        // itemݒ
        super.appendChild(super.root, itemChild);
    }

    protected Element createElementChild(XbInterfaceObj obj, String itemValue) throws XbException {
        // qvf擾
        ArrayList<XbInterfaceObj> itemChildList = interfaceDAO.select(obj.getTaxonomyItemId(), obj.getTaxonomyItemSeq());
        Element item = super.createElement(obj);

        if (itemChildList.size() == 0) {
            // ǉ
            this.setAttribute(item, obj);
            super.setAttribute(item, obj.getFootnoteValue());
            super.appendChild(item, itemValue);
        } else {
            XbInterfaceObj old = null;
            String value = "";

            for (int i = 0;i < itemChildList.size();i ++) {
                XbInterfaceObj itemChildObj = itemChildList.get(i);

                if (i == 0) {
                    old = itemChildObj;
                    value = itemChildObj.getItemValue();
                }
                else if (itemChildObj.getTaxonomyItemId().equals(old.getTaxonomyItemId()) &&
                                    itemChildObj.getTaxonomyItemSeq().equals(old.getTaxonomyItemSeq()) &&
                                    XbConstants.ATTRIBUTE_NUMERIC.equals(itemChildObj.getContextType()) &&
                                    itemChildObj.getContextName().equals(old.getContextName())) {
                    value = String.valueOf(Long.parseLong(value) + Long.parseLong(itemChildObj.getItemValue()));
                } else {
                    // ċA
                    Element itemChild = this.createElementChild(old, value);
                    // itemݒ
                    super.appendChild(item, itemChild);
                    // lZbg
                    old = itemChildObj;
                    value = itemChildObj.getItemValue();
                }
            }
            // ċA
            Element itemChild = this.createElementChild(old, value);
            // itemݒ
            super.appendChild(item, itemChild);
        }
        return item;
    }

    private void setAttribute(Element element, XbInterfaceObj obj) {
        if (XbConstants.ATTRIBUTE_NUMERIC.equals(obj.getContextType())) {
            element.setAttribute(XbConstants.ATTRIBUTE_NC, obj.getContextName());
        } else {
            element.setAttribute(XbConstants.ATTRIBUTE_NNC, obj.getContextName());
        }
    }
}