/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.common.XbConstants;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Going Dot Com Inc.
 */
class XbInstanceRef extends XbContext {

    private Document doc;

    private XbInstanceRefAttrDAO instanceRefAttrDAO;

    protected XbInstanceRef(Connection conn, Document doc) throws XbException {
        this.doc = doc;

        instanceRefAttrDAO = XbInstanceRefAttrDAO.getInstance(conn);
    }

    /**
     * InstanceRef쐬
     * @param entityId entityID
     * @return entityTag
     * @throws XbException
     */
    protected Element createInstanceRef(String refType, String refId) throws XbException {

        Element ref = null;
        // ref_typeō쐬Ggς
        if (refType.equals(XbConstants.ONE_VALUE)) {  // schemaref
            ref = super.createElement(this.doc, XbConstants.TAG_SCHEMAREF);
        } else if (refType.equals(XbConstants.TWO_VALUE)) {  // linkbaseref
            ref = super.createElement(this.doc, XbConstants.TAG_LINKBASEREF);
        } else if (refType.equals(XbConstants.THREE_VALUE)) {  // roleref
            ref = super.createElement(this.doc, XbConstants.TAG_ROLEREF);
        } else if (refType.equals(XbConstants.FOUR_VALUE)) {  // arcroleref
            ref = super.createElement(this.doc, XbConstants.TAG_ARCROLEREF);
        }

        // refAttr擾
        ArrayList<XbInstanceRefAttrObj> refAttrList = instanceRefAttrDAO.getInstanceRefAttr(refType, refId);

        for (int i = 0;i < refAttrList.size();i ++) {
            XbInstanceRefAttrObj obj = refAttrList.get(i);
            // ǉ
            super.setAttribute(ref, XbConstants.NAMESPACE_XLINLK + obj.getName(), obj.getValue());
        }

        return ref;
    }
}