/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbContextIdList;
import jp.co.going.xbrl.common.XbRef;
import jp.co.going.xbrl.common.XbRefList;
import jp.co.going.xbrl.common.XbException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Going Dot Com Inc.
 */
class XbInstance21 extends XbInstance {

    private XbRootElement root;
    private XbInstanceRef ref;
    private XbItem item;
    private XbContext21 context;
    private XbUnit unit;

    protected XbInstance21(Connection conn) throws XbException {
        super(conn);
        root = new XbRootElement21();
        ref = new XbInstanceRef(conn, super.doc);
        item = new XbItem21(conn, super.doc);
        context = new XbContext21(conn, super.doc);
        unit = new XbUnit21(conn, super.doc);

        mappingDAO = XbMappingDAO21.getInstance(conn);
    }

    /**
     * CX^X쐬
     * @param taxGroupId
     * @param contextIdList
     * @param refList
     * @return
     * @throws XbException
     */
    protected Document createInstance(String taxGroupId, XbContextIdList contextIdList, XbRefList refList) throws XbException {

        //interfacee[uNA
        super.clearInterface();
        // contextList
        ArrayList<Element> contextList = new ArrayList<Element>();
        // unitList
        ArrayList<Element> unitList = new ArrayList<Element>();
        // root쐬
        Element rootElement = root.createRootElement(super.conn, super.doc);
        // ref쐬
        for (int i = 0;i < refList.size();i ++) {
            XbRef obj = refList.get(i);
            rootElement.appendChild(ref.createInstanceRef(obj.getRefType(), obj.getRefId()));
        }
        // itemEcontext쐬
        for (int i = 0;i < contextIdList.size();i ++) {
            // context擾
            XbContextObj obj = contextDAO.getContext(contextIdList.get(i));
            // mappingInfo
            // mappingInfo
            super.getSearchInfo(obj);
            // item擾
            mappongList = mappingDAO.getMappingInfo(obj, taxGroupId, super.entity, super.unit.getUnitName());
            // context쐬
            if (mappongList.size() != 0) {
                // insrtItem
                super.setContextItem(mappongList, obj);
                // tupleData擾
                super.getTupleData(taxGroupId, obj);

                // footnoteIdList쐬
                super.addFootNoteId();
                // context쐬
                Element contextTag = context.createContext(obj, rootElement);
                // unit쐬
                Element unitTag = unit.createUnit(obj.getContextId(), rootElement);
                // contextzi[
                contextList.add(contextTag);
                // unitzi[
                unitList.add(unitTag);
            }
        }

        // ACe쐬(בւ)
        item.createItem(rootElement);

        // contextǉ
        for (int i = 0;i < contextList.size();i ++) {
            if (contextList.get(i) != null) {
                rootElement.appendChild(contextList.get(i));
            }
        }
        // unitǉ
        for (int i = 0;i < unitList.size();i ++) {
            if (unitList.get(i) != null) {
                rootElement.appendChild(unitList.get(i));
            }
        }
        // footnote쐬
        super.createFootNote(taxGroupId, rootElement);

        super.doc.appendChild(rootElement);
        return super.doc;
    }
}