/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbContextIdList;
import jp.co.going.xbrl.common.XbRef;
import jp.co.going.xbrl.common.XbRefList;
import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.common.XbConstants;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author Going Dot Com Inc.
 */
class XbInstance20 extends XbInstance {

    private XbRootElement root;
    private XbInstanceRef ref;
    private XbItem item;
    private XbContext20 context;

    protected XbInstance20(Connection conn) throws XbException {
        super(conn);
        root = new XbRootElement20();
        ref = new XbInstanceRef(conn, super.doc);
        item = new XbItem20(conn, super.doc);
        context = new XbContext20(conn, super.doc);

        mappingDAO = XbMappingDAO20.getInstance(conn);
    }

    /**
     * CX^X쐬
     * @param taxGroupId
     * @param contextIdList
     * @param refList
     * @return
     * @throws XbException
     */
    protected Document createInstance(String taxGroupId, XbContextIdList contextIdList, XbRefList refList) throws XbException {

        //interfacee[uNA
        super.clearInterface();

        // contextList
        ArrayList<Element> contextList = new ArrayList<Element>();
        // root쐬
        Element rootElement = root.createRootElement(super.conn, super.doc);
        // itemEcontext쐬
        for (int i = 0;i < contextIdList.size();i ++) {
            // context擾
            XbContextObj obj = contextDAO.getContext(contextIdList.get(i));
            // mappingInfo
            super.getSearchInfo(obj);
            // item擾
            mappongList = mappingDAO.getMappingInfo(obj, taxGroupId, super.entity, super.unit.getUnitName());
            // context쐬
            if (mappongList.size() != 0) {
                // insrtItem
                super.setContextItem(mappongList, obj);
                // tupleData擾
                super.getTupleData(taxGroupId, obj);

                // footnoteIdList쐬
                super.addFootNoteId();
                // context쐬
                Element contextTag = context.createContext(obj, rootElement);
                // contextzi[
                contextList.add(contextTag);
            }
        }

        // ACe쐬(בւ)
        item.createItem(rootElement);

        // contextǉ
        for (int i = 0;i < contextList.size();i ++) {
            if (contextList.get(i) != null) {
                rootElement.appendChild(contextList.get(i));
            }
        }

        // linkbaseRef쐬
        for (int i = 0;i < refList.size();i ++) {
            XbRef obj = refList.get(i);
            if (XbConstants.TWO_VALUE.equals(obj.getRefType())) { // 2.0linkbasê
                rootElement.appendChild(ref.createInstanceRef(obj.getRefType(), obj.getRefId()));
            }
        }
        // footnote쐬
        super.createFootNote(taxGroupId, rootElement);

        super.doc.appendChild(rootElement);

        return super.doc;
    }
}