/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;

/**
 * @author Going Dot Com Inc.
 */
class XbEntityDAO {

    // singleton쐬
    private static XbEntityDAO instance = null;
    private static Connection conn = null;

    // RXgN^
    private XbEntityDAO() {
    }

    // CX^X擾
    protected static synchronized XbEntityDAO getInstance(Connection connection) {
        // CX^X𐶐
        if (instance == null) {
            conn = connection;
            instance = new XbEntityDAO();
        }

        return instance;
    }

    protected ArrayList<XbEntityObj> getEntity(String entityId) throws XbException {
        try {
            // Xe[gg쐬
            PreparedStatement stmt;
            StringBuffer  strb_sql = new StringBuffer();

            // CXg
            strb_sql.append("select ");
            strb_sql.append("ide.identifier_id as identifier_id, ");
            strb_sql.append("ide.schema as schema, ");
            strb_sql.append("ide.value as value ");
            strb_sql.append("from ");
            strb_sql.append("xb_entity_identifier ent, ");
            strb_sql.append("xb_identifier ide ");
            strb_sql.append("where ");
            strb_sql.append("ent.identifier_id = ide.identifier_id ");
            strb_sql.append("and ent.entity_id = ? ");
            // SQLݒ
            stmt = conn.prepareStatement(strb_sql.toString());
            int index = 1;

            stmt.setString(index++, entityId);

            ResultSet rs = stmt.executeQuery();

            ArrayList<XbEntityObj> relist = new ArrayList<XbEntityObj>();
            while(rs.next()) {
                // TuXg
                XbEntityObj obj = new XbEntityObj();
                obj.setIdentifierId(rs.getString("identifier_id"));
                obj.setSchemaUri(rs.getString("schema"));
                obj.setValue(rs.getString("value"));
                relist.add(obj);
            }
            // ʃZbgN[Y
            rs.close(); 
            // Xe[ggN[Y
            stmt.close(); 

            return relist;
        } catch (SQLException e) {
            throw new XbException(e, "SQLError : " + e.getMessage());
        }
    }
}