/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.instance;

import java.util.ArrayList;

import jp.co.going.xbrl.common.XbException;
import jp.co.going.xbrl.common.XbConstants;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * @author Going Dot Com Inc.
 */
class XbContext {

    protected XbContextObj contextObj;

    protected XbEtcDAO etcDAO;

    /**
     * ^O쐬
     * @param doc hLg
     * @param name ^O
     * @return ^O
     */
    protected Element createElement(Document doc, String name) {
        return doc.createElement(name);
    }

    /**
     * ݒ肷
     * @param element vf
     * @param list Xg
     */
    private void setAttribute(Element element, ArrayList<XbEtcAttrObj> list) {
        for (int i = 0;i < list.size();i ++) {
            XbEtcAttrObj obj = list.get(i);
            this.setAttribute(element, obj.getEtcAttrName(), obj.getEtcAttrValue());
        }
    }

    /**
     * ݒ肷
     * @param element ^O
     * @param name 
     * @param value l
     */
    protected void setAttribute(Element element, String name, String value) {
        element.setAttribute(name, value);
    }

    /**
     * eLXgm[hݒ肷
     * @param element ^O
     * @param doc hLg
     * @param value eLXgm[h
     */
    protected void appendChild(Element element, Document doc, String value) {
        if (value != null && !"".equals(value)) {
            element.appendChild(doc.createTextNode(value));
        }
    }

    /**
     * e^OɎqm[hǉ
     * @param element e^O
     * @param node qm[h
     */
    protected void appendChild(Element element, Node node) {
        if (node != null) {
            element.appendChild(node);
        }
    }

    /**
     * ړt̗vf쐬
     * @param prefix ړ
     * @param name O
     * @return ^O
     */
    protected String addEtcStr(String prefix, String name) {
        StringBuffer str = new StringBuffer();
        str.append(prefix);
        str.append(XbConstants.COLON_TYPE);
        str.append(name);

        return str.toString();
    }

    /**
     * evf쐬
     * @param doc hLg
     * @param mainId eID
     * @param obj IuWFNg
     * @param prefix ړ
     * @param name O
     * @return vf
     * @throws XbException
     */
    protected Element createEtc(Document doc, String mainId, XbEtcObj obj, String prefix) throws XbException {
        // qvf擾
        ArrayList<XbEtcObj> etcList = etcDAO.getEtc(mainId, obj.getEtcId());
        Element etcItem = this.createElement(doc, this.addEtcStr(prefix, obj.getName()));

        if (etcList.size() == 0) {
            this.setAttribute(etcItem, obj.getAttrList());
            this.appendChild(etcItem, doc, obj.getValue());
        } else {
            this.setAttribute(etcItem, obj.getAttrList());

            for (int i = 0;i < etcList.size();i ++) {
                XbEtcObj etcObj = etcList.get(i);
                Element item = this.createEtc(doc, mainId, etcObj, prefix);
                this.appendChild(etcItem, item);
            }
        }

        return etcItem;
    }

    protected void createContext() throws XbException {}
}