/*
 * Copyright (c) 2007, Going Dot Com Inc. All rights reserved.
 */

package jp.co.going.xbrl.common.parse;

import java.io.IOException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import jp.co.going.xbrl.common.XbException;

import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/**
 * wlkt@Cp[X邽߂̃NXł
 * @author Masako Okayasu
 */
public class XbPAOImpl implements XbPAO {

    // hLg쐬
    private DOMParser parser;  // XMLp[T̃CX^X

    /**
     * RXgN^
     * @throws		XbException
     */
    public XbPAOImpl() throws XbException {
    	// p[T̐
        parser = new DOMParser();

        // G[Enh̓o^
        parser.setErrorHandler(new XbPAOError());
    }

    /**
     * parse
     * @param fileName
     * @throws XbException
     */
    public void parse(String fileName) throws XbException {
        try {
            // XMLt@C̃p[X
            parser.parse(fileName);
        }
        catch (IOException e) {
            throw new XbException(e, e.getMessage());
        }
        catch (SAXException e) {
            throw new XbException(e);
        }
    }

    /**
     * Document擾
     * @return Document
     * @throws XbException
     */
    public Document getDocument() {
        return  parser.getDocument();
    }

    /**
     * DocumentBuilder쐬
     * @return			DocumentBuilder
     */
	public DocumentBuilder getDocumentBuilder() throws XbException {

		DocumentBuilder docbuilder = null;
		try {
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
			docbuilder = dbfactory.newDocumentBuilder();
		}
		catch (ParserConfigurationException e) {
            throw new XbException(e);
		}
		return docbuilder;
	}
}