--==============================================================
--  Database name:  XBRL TOOL SCHEMAS
--  DBMS name:      ORACLE Version 10g
--  Created on:     2007-05-16 XX:XX:XX
--  Description:    XBRL Reportp̃e[u쐬܂
--==============================================================

----------------------------------------------------------------
--- <e[uꗗ>
---   xb_base_schema                {XL[}e[u
---   xb_item_type                  ڌ^e[u
---   xb_taxonomy_group             ^N\m~[O[ve[u
---   xb_taxonomy                   ^N\m~[e[u
---   xb_linkbaseref                QƃNx[Xe[u
---   xb_linkbase_arc               A[Ne[u
---   xb_linkbase_locator           P[^e[u
---   xb_linkbase_resource          Nx[X\[Xe[u
---   xb_resource_item              \[XACee[u
---   xb_resource_item_attr         \[XACee[u
---   xb_taxonomy_item              ^N\m~[Ȗڃe[u
---   xb_item_label                 ACexe[u
---   xb_item_work                  ACeI[_[[Ne[u
---   xb_item_top                   ACe[ge[u
---   xb_item                       ACeI[_[e[u
---   xb_interface                  C^[tF[Xe[u
---   xb_item_interface             ACeC^[tF[Xe[u
----------------------------------------------------------------

--------------------------------------------------
--- Taxonomy n
--------------------------------------------------

--- <<{XL[}e[u>>
---   {XL[}̖Oԋyюʎq(OURL)Ǘ
create table xb_base_schema
(
  namespace             varchar2(256) not null,   --- O(PK)
  namespace_url         varchar2(512) not null,   --- OURL
  specification_no      varchar2(3) not null      --- dlԍ (2.0 or 2.1)(PK)
                        check(specification_no = any('2.0','2.1')),
  creation_date         date not null,            --- 쐬
  constraint  pk_xb_base_schema primary key (namespace, specification_no)
)
/

--- <<ڌ^e[u>>
---   XBRLŎgp^̈ꗗǗ
---   XBRLł͐l͔񐔒lǂ炩̒lŉ^p
create table xb_item_type
(
  type_name             varchar2(50) not null,    --- ^(PK)
  attribute_name        varchar2(15) not null     ---  (numeric or nonnumeric)
                        check(attribute_name = any('numeric','nonnumeric')),
  specification_no      varchar2(3) not null      --- dlԍ (2.0 or 2.1)(PK)
                        check(specification_no = any('2.0','2.1')),
  creation_date         date not null,            --- 쐬
  constraint  pk_xb_item_type primary key (type_name, specification_no)
)
/

--- <<^N\m~[O[ve[u>>
---   ^N\m~[O[vۂ̊ǗPʃe[u
create table xb_taxonomy_group
(
  taxonomy_group_id     number(28) not null,      --- ^N\m~[O[vID(PK)
  taxonomy_group_name   varchar2(32) not null,    --- ^N\m~[O[v
  specification_no      varchar2(3) not null      --- dlԍ (2.0 or 2.1)
                        check(specification_no = any('2.0','2.1')),
  note                  varchar2(256),            --- l
  creation_date         date not null,            --- 쐬
  constraint pk_xb_taxonomy_group primary key (taxonomy_group_id)
)
/

--- <<^N\m~[e[u>>
---   ^N\m~[t@Citem(Ȗ)ȊȌ
create table xb_taxonomy
(
  taxonomy_id           number(28) not null,      --- ^N\m~[ID(PK)
  taxonomy_group_id     number(28) not null,      --- ^N\m~[O[vID(FK)
  taxonomy_name         varchar2(128),            --- ^N\m~[
  taxonomy_file         varchar2(128) not null,   --- ^N\m~[t@C
  namespace             varchar2(256) not null,   --- O
  namespace_url         varchar2(512) not null,   --- OURL
  terminated_flag       number(1),                --- I[tO(0:OFF, 1:ON)
                        check(terminated_flag = any(0,1)),
  creation_date         date not null,            --- 쐬
  constraint pk_xb_taxonomy primary key (taxonomy_id),
  constraint fk_xb_taxonomy foreign key (taxonomy_group_id)
    references xb_taxonomy_group (taxonomy_group_id)
)
/

--- <<QƃNx[Xe[u>>
---   linkbaseRef^Ȍi[
create table xb_linkbaseref
(
  linkbaseref_id        number(28) not null,      --- QƃNx[XID(PK)
  linkbase_role         varchar2(128) not null,   --- role
  linkbase_href         varchar2(256),            --- href
  taxonomy_id           number(28) not null,      --- ^N\m~[ID(FK)
  taxonomy_group_id     number(28) not null,      --- ^N\m~[O[vID(FK)
  category              varchar(64),              --- Nx[X
  creation_date         date not null,            --- 쐬
  constraint pk_xb_linkbaseref primary key (linkbaseref_id),
  constraint fk_xb_tax_linkbaseref foreign key (taxonomy_id)
    references xb_taxonomy (taxonomy_id),
  constraint fk_xb_tax_group_linkbaseref foreign key (taxonomy_group_id)
    references xb_taxonomy_group (taxonomy_group_id)
)
/

--- <<A[Ne[u>>
---   eNx[X̃A[Ni[
create table xb_linkbase_arc
(
  arc_id                        number(28) not null,  --- A[NID(PK)
  linkbaseref_id                number(28) not null,  --- QƃNx[XID(FK)
  arc_show                      varchar2(10),         --- show
  arc_title                     varchar2(512),        --- title
  arc_from                      varchar2(256),        --- from
  arc_to                        varchar2(256),        --- to
  arc_arcrole                   varchar2(256),        --- arcrole
  arc_use                       varchar2(20),         --- use
  arc_priority                  number(28),           --- priority
  calculation_weight            number(10,4),         --- weigh(calculation link̂)
  presentation_order            number(10,4),         --- order(݂ꍇZbg)
  constraint pk_xb_linkbase_arc primary key (arc_id),
  constraint fk_xb_arc_linkbase_ref foreign key (linkbaseref_id)
    references xb_linkbaseref (linkbaseref_id)
)
/

--- <<P[^e[u>>
---   eNx[X̃P[^i[
create table xb_linkbase_locator
(
  locator_id                    number(28) not null,    --- P[^ID(PK)
  linkbaseref_id                number(28) not null,    --- QƃNx[XID(FK)
  loc_href                      varchar2(256) not null, --- href
  loc_identifier                varchar2(256) not null, --- hrefʎq
  loc_label                     varchar2(256),          --- label
  loc_title                     varchar2(512),          --- title
  loc_role                      varchar2(256),          --- role
  constraint pk_xb_linkbase_loc primary key (locator_id),
  constraint fk_xb_loc_linkbase_ref foreign key (linkbaseref_id)
    references xb_linkbaseref (linkbaseref_id)
)
/

--- <<\[Xe[u>>
---   eNx[X̃\[Xi[
---   ɃxNƃt@XNY
create table xb_linkbase_resource
(
  resource_id                   number(28) not null,  --- \[XID(PK)
  linkbaseref_id                number(28) not null,  --- QƃNx[XID(FK)
  resource_label                varchar2(256),        --- label
  resource_title                varchar2(512),        --- title
  label_role                    varchar2(256),        --- role
  label_lang                    varchar2(8),          --- lang
  resource_value                long,                 --- l
  constraint pk_xb_linkbase_resource primary key (resource_id),
  constraint fk_xb_resource_linkbase_ref foreign key (linkbaseref_id)
    references xb_linkbaseref (linkbaseref_id)
)
/

--- <<\[XACee[u>>
---   \[X̒l^Ovf̏ꍇÃe[uɏi[
create table xb_resource_item
(
  resource_item_id              number(28) not null,  --- \[XACeID(PK)
  resource_id                   number(28) not null,  --- \[XID(FK)
  namespace                     varchar2(256),        --- O
  namespace_url                 varchar2(512),        --- OURL
  item_name                     varchar2(512),        --- ACe
  item_value                    long,                 --- ACel
  constraint pk_xb_resource_item primary key (resource_item_id),
  constraint fk_xb_resource_item foreign key (resource_id)
    references xb_linkbase_resource (resource_id)
)
/

--- <<\[XACee[u>>
---   \[X̒l^Ovf̏ꍇÃe[uɏi[()
create table xb_resource_item_attr
(
  resource_item_attr_id         number(28) not null,  --- \[XACeID(PK)
  resource_item_id              number(28) not null,  --- \[XACeID(PK)
  attribute_name                varchar2(512),        --- 
  attribute_value               varchar2(512),        --- l
  constraint pk_xb_resource_item_attr primary key (resource_item_attr_id),
  constraint fk_xb_resource_item_attr foreign key (resource_item_id)
    references xb_resource_item (resource_item_id)
)
/

--- <<^N\m~[Ȗڃe[u>>
---   XBRL̊ȖڌQ
create table xb_taxonomy_item
(
  taxonomy_item_id        number(28) not null,    --- ^N\m~[ACeID(PK)
  taxonomy_id             number(28) not null,    --- ^N\m~[ID(FK)
  taxonomy_group_id       number(28) not null,    --- ^N\m~[O[vID(FK)
  item_id                 varchar2(256),          --- id (element tag attrubute)
  item_name               varchar2(256),          --- name (element tag attrubute)
  item_type               varchar2(64),           --- type (element tag attrubute)
  item_substitutiongroup  varchar2(32),           --- substitutiongroup (element tag attrubute)
  item_balance            varchar2(10),           --- ݕ(credit)/ؕ(debit)
  item_nillable           number(1)               --- NULLltO(0:false, 1:true)
                          check(item_nillable = any(0,1)),
  item_period_type        varchar2(10),           --- vԑ(instant/duration/null)
  abstract                number(1)               --- abstract(0:false, 1:true)
                          check(abstract = any(0,1)),
  documentation           long,                   --- hLg(Ql)
  creation_date           date,                   --- 쐬
  constraint pk_xb_taxonomy_item primary key (taxonomy_item_id),
  constraint fk_item_taxonomy foreign key (taxonomy_id)
    references xb_taxonomy (taxonomy_id),
  constraint fk_item_taxonomy_group foreign key (taxonomy_group_id)
    references xb_taxonomy_group (taxonomy_group_id)
)
/

--- <<ACexe[u>>
--- ACẽxi[
create table xb_item_label
(
    taxonomy_group_id              number(28,0) not null,
    taxonomy_id                    number(28,0) not null,
    taxonomy_item_id               number(28,0) not null,
    label_lang                     varchar2(8),
    resource_value                 long
)
/

--- <<ACeI[_[[Ne[u>>
--- ACe̐eq֌Wƕяi[郏[Ne[u
create table xb_item_work
(
    taxonomy_group_id              number(28,0) not null,
    taxonomy_id                    number(28,0) not null,
    taxonomy_item_id               number(28,0) not null,
    item_type                      varchar2(32),
    parent_taxonomy_item_id        number(28,0) not null,
    parent_item_type               varchar2(32),
    context_type                   varchar2(32),
    presentation_order             number(10,4)
)
/

--- <<ACe[ge[u>>
--- ACêi[
create table xb_item_top
(
    taxonomy_group_id              number(28,0) not null,
    taxonomy_item_id               number(28,0) not null,
    item_lang                      varchar2(8),
    item_name                      long
)
/

--- <<ACeI[_[e[u>>
--- ACe̐eq֌Wƕяi[
create table xb_item
(
    item_order                     number(10) not null,
    taxonomy_group_id              number(28,0) not null,
    taxonomy_id                    number(28,0) not null,
    taxonomy_item_id               number(28,0) not null,
    item_type                      varchar2(32),
    parent_taxonomy_item_id        number(28,0) not null,
    parent_item_type               varchar2(32),
    context_type                   varchar2(32),
    presentation_order             number(10,4),
    item_lang                      varchar2(8),
    item_name                      long,
    constraint pk_xb_item primary key (item_order, taxonomy_group_id, taxonomy_item_id, item_lang)
)
/

--- <<[U[ACee[u>>
--- [U[̉Ȗڏi[
create table xb_item_interface
(
    user_item_id                   number(28,0) not null,
    item_value                     varchar2(512),
    entity                         varchar2(128),
    period                         varchar2(10),
    unit                           varchar2(128),
    constraint pk_xb_item_interface primary key (user_item_id, entity, period, unit)
)
/

--- YReLXg̃ACei[
create table xb_interface
(
    item_order                    number(10,0) not null,
    taxonomy_item_id              number(28,0) not null,
    taxonomy_item_seq             number(10,0) not null,
    parent_taxonomy_item_id       number(28,0) not null,
    parent_taxonomy_item_seq      number(10,0) not null,
    item_value                    varchar2(512),
    item_precision                number(10,0) not null,
    item_decimal                  number(10,0) not null,
    context_type                  varchar2(32),
    context_name                  varchar2(128),
    unit_name                     varchar2(128),
    footnote_value                varchar2(128)
)
/
CREATE TABLE XB_CONTEXT
(
    CONTEXT_ID                     NUMBER(28,0) NOT NULL,
    CONTEXT_TYPE                   VARCHAR2(32) NOT NULL,
    CONTEXT_NAME                   VARCHAR2(128) NOT NULL,
    NAME                           VARCHAR2(128) NOT NULL,
    ENTITY_ID                      NUMBER(28,0) NOT NULL,
    FISCAL_YEAR                    NUMBER(4,0),
    PERIOD_START_DATE              VARCHAR2(10),
    PERIOD_END_DATE                VARCHAR2(10),
    ITEM_PRECISION                 NUMBER NOT NULL,
    ITEM_CWA                       NUMBER NOT NULL,
    UNIT_FLAG                      NUMBER(1,0) NOT NULL,
    DESCRIPTION                    VARCHAR2(512),
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_CONTEXT PRIMARY KEY (CONTEXT_ID) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_CONTEXT_SCENARIO
(
    MAIN_ID                        NUMBER(28,0) NOT NULL,
    ETC_TYPE                       NUMBER(1,0) NOT NULL,
    ETC_ID                         NUMBER(28,0) NOT NULL,
    PARENT_ETC_ID                  NUMBER(28,0) NOT NULL,
    PREFIX                         VARCHAR2(128) NOT NULL,
    URI                            VARCHAR2(512),
    PRESENTATION_ORDER             NUMBER(28,0),
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_CONTEXT_SCENARIO PRIMARY KEY (MAIN_ID, ETC_TYPE, ETC_ID, PARENT_ETC_ID, PREFIX) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_CONTEXT_UNIT
(
    CONTEXT_ID                     NUMBER(28,0) NOT NULL,
    UNIT_ID                        NUMBER(28,0) NOT NULL,
    PRESENTATION_ORDER             NUMBER(28,0),
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_CONTEXT_UNIT PRIMARY KEY (CONTEXT_ID, UNIT_ID) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_DIVIDE_MEASURE
(
    DIVIDE_ID                      NUMBER(28,0) NOT NULL,
    DIVIDE_TYPE                    NUMBER(1,0) NOT NULL,
    MEASURE_ID                     NUMBER(28,0) NOT NULL,
    PRESENTATION_ORDER             NUMBER(28,0),
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_DIVIDE_MEASURE PRIMARY KEY (DIVIDE_ID, DIVIDE_TYPE, MEASURE_ID) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
COMMENT ON COLUMN XB_DIVIDE_MEASURE.DIVIDE_TYPE IS '1:Numerator@2:Denominator'
/
CREATE TABLE XB_ENTITY
(
    ENTITY_ID                      NUMBER(28,0) NOT NULL,
    ENTITY_NAME                    VARCHAR2(128) NOT NULL,
    PRESENTATION_ORDER             NUMBER(28,0),
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_ENTITY PRIMARY KEY (ENTITY_ID) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_ENTITY_IDENTIFIER
(
    ENTITY_ID                      NUMBER(28,0) NOT NULL,
    IDENTIFIER_ID                  NUMBER(28,0) NOT NULL,
    PRESENTATION_ORDER             NUMBER(28,0),
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_ENTITY_IDENTIFIER PRIMARY KEY (ENTITY_ID, IDENTIFIER_ID) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_ENTITY_SEGMENT
(
    MAIN_ID                        NUMBER(28,0) NOT NULL,
    ETC_TYPE                       NUMBER(1,0) NOT NULL,
    ETC_ID                         NUMBER(28,0) NOT NULL,
    PARENT_ETC_ID                  NUMBER(28,0) NOT NULL,
    PREFIX                         VARCHAR2(128) NOT NULL,
    URI                            VARCHAR2(512),
    PRESENTATION_ORDER             NUMBER(28,0),
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_ENTITY_SEGMENT PRIMARY KEY (MAIN_ID, ETC_TYPE, ETC_ID, PARENT_ETC_ID, PREFIX) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_ETC
(
    ETC_TYPE                       NUMBER(1,0) NOT NULL,
    ETC_ID                         NUMBER(28,0) NOT NULL,
    ETC_NAME                       VARCHAR2(128) NOT NULL,
    NAME                           VARCHAR2(128),
    VALUE                          LONG,
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_ETC PRIMARY KEY (ETC_TYPE, ETC_ID) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
COMMENT ON COLUMN XB_ETC.ETC_TYPE IS '1:ā@2:ص@3:̯ɰ'
/
CREATE TABLE XB_ETC_ATTRIBUTES
(
    ETC_TYPE                       NUMBER(1,0) NOT NULL,
    ETC_ID                         NUMBER(28,0) NOT NULL,
    NAME                           VARCHAR2(128) NOT NULL,
    VALUE                          VARCHAR2(128) NOT NULL,
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_ETC_ATTRIBUTES PRIMARY KEY (ETC_TYPE, ETC_ID, NAME) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_IDENTIFIER
(
    IDENTIFIER_ID                  NUMBER(28,0) NOT NULL,
    IDENTIFIER_NAME                VARCHAR2(128) NOT NULL,
    SCHEMA                         VARCHAR2(512),
    VALUE                          VARCHAR2(128) NOT NULL,
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_IDENTIFIER PRIMARY KEY (IDENTIFIER_ID) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_ITEM_FOOTNOTE
(
    MAIN_ID                        NUMBER(28,0) NOT NULL,
    ETC_TYPE                       NUMBER(1,0) NOT NULL,
    ETC_ID                         NUMBER(28,0) NOT NULL,
    PARENT_ETC_ID                  NUMBER(28,0) NOT NULL,
    PRESENTATION_ORDER             NUMBER(28,0),
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_ITEM_FOOTNOTE PRIMARY KEY (MAIN_ID, ETC_TYPE, ETC_ID, PARENT_ETC_ID) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_MAPPING
(
    TAXONOMY_GROUP_ID              NUMBER(28,0) NOT NULL,
    TAXONOMY_ITEM_ID               NUMBER(28,0) NOT NULL,
    USER_ITEM_ID                   NUMBER(28,0) NOT NULL,
    ITEM_PRECISION                 NUMBER,
    ITEM_DECIMAL                   NUMBER,
    ETC_TYPE                       NUMBER(1,0),
    ETC_ID                         NUMBER(28,0),
    TUPLE_CHILD_FLAG               NUMBER(1,0) NOT NULL,
    DESCRIPTION                    VARCHAR2(512),
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_MAPPING PRIMARY KEY (TAXONOMY_GROUP_ID, TAXONOMY_ITEM_ID) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_MEASURE
(
    MEASURE_ID                     NUMBER(28,0) NOT NULL,
    MEASURE_NAME                   VARCHAR2(128) NOT NULL,
    MONEY_FLAG                     NUMBER(1,0) NOT NULL,
    VALUE                          VARCHAR2(128) NOT NULL,
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_MEASURE PRIMARY KEY (MEASURE_ID) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_REF
(
    REF_TYPE                       NUMBER(1,0) NOT NULL,
    REF_ID                         NUMBER(28,0) NOT NULL,
    REF_NAME                       VARCHAR2(128) NOT NULL,
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_REF PRIMARY KEY (REF_TYPE, REF_ID) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_REF_ATTRIBUTES
(
    REF_TYPE                       NUMBER(1,0) NOT NULL,
    REF_ID                         NUMBER(28,0) NOT NULL,
    NAME                           VARCHAR2(128) NOT NULL,
    VALUE                          VARCHAR2(512) NOT NULL,
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_REF_ATTRIBUTES PRIMARY KEY (REF_TYPE, REF_ID, NAME) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_TUPLE_DATA
(
    ITEM_ORDER                     NUMBER(10,0) NOT NULL,
    TAXONOMY_GROUP_ID              NUMBER(28,0) NOT NULL,
    TAXONOMY_ITEM_ID               NUMBER(28,0) NOT NULL,
    TAXONOMY_ITEM_SEQ              NUMBER(28,0) NOT NULL,
    PARENT_TAXONOMY_ITEM_ID        NUMBER(28,0) NOT NULL,
    PARENT_TAXONOMY_ITEM_SEQ       NUMBER(28,0) NOT NULL,
    ITEM_VALUE                     VARCHAR2(512),
    CONTEXT_ID                     NUMBER(28,0) NOT NULL
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_UNIT
(
    UNIT_ID                        NUMBER(28,0) NOT NULL,
    UNIT_NAME                      VARCHAR2(128) NOT NULL,
    NAME                           VARCHAR2(128),
    PRESENTATION_ORDER             NUMBER(28,0),
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_UNIT PRIMARY KEY (UNIT_ID) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
CREATE TABLE XB_UNIT_DIVIDE
(
    UNIT_ID                        NUMBER(28,0) NOT NULL,
    DIVIDE_ID                      NUMBER(28,0) NOT NULL,
    OPERATOR_TYPE                  NUMBER(1,0) NOT NULL,
    PRESENTATION_ORDER             NUMBER(28,0),
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_UNIT_DIVIDE PRIMARY KEY (UNIT_ID, DIVIDE_ID) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
COMMENT ON COLUMN XB_UNIT_DIVIDE.OPERATOR_TYPE IS '1:Divide@2:Multiply'
/
CREATE TABLE XB_UNIT_MEASURE
(
    UNIT_ID                        NUMBER(28,0) NOT NULL,
    MEASURE_ID                     NUMBER(28,0) NOT NULL,
    PRESENTATION_ORDER             NUMBER(28,0),
    CREATION_DATE                  DATE NOT NULL,
    CONSTRAINT PK_XB_UNIT_MEASURE PRIMARY KEY (UNIT_ID, MEASURE_ID) USING INDEX
        PCTFREE 10
        INITRANS 2
        MAXTRANS 255
        TABLESPACE USERS
        STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
        LOGGING
)
PCTFREE 10
MAXTRANS 255
TABLESPACE USERS
STORAGE(INITIAL 64K MINEXTENTS 1 MAXEXTENTS 2147483645 BUFFER_POOL DEFAULT)
NOCACHE
LOGGING
/
