unit AbonInfoSet;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, AbonInfo, StdCtrls, ExtCtrls;

type
  TAbonInfoEdit = class(TForm)
    AbonTypeRadio: TRadioGroup;
    CompTypeRadio: TRadioGroup;
    GroupBox1: TGroupBox;
    AllRadio: TRadioButton;
    ThreadRadio: TRadioButton;
    BoardRadio: TRadioButton;
    ThrNameEdit: TEdit;
    ThrInfoEdit: TEdit;
    BrdNameEdit: TEdit;
    BrdInfoEdit: TEdit;
    OkButton: TButton;
    CancelButton: TButton;
    procedure FormShow(Sender: TObject);
    procedure TargetRadioClick(Sender: TObject);
    procedure OkButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private 錾 }
    FInf: TLineInfo;
  public
    { Public 錾 }

    procedure SetInfo(const src: TLineInfo);
    procedure GetInfo(var dst: TLineInfo);
  end;

var
  AbonInfoEdit: TAbonInfoEdit;

implementation

{$R *.dfm}


procedure TAbonInfoEdit.FormCreate(Sender: TObject);
var
    CenterForm: TCustomForm;
begin
    CenterForm := TCustomForm(Owner);
    if Assigned(CenterForm) then begin
        Left := ((CenterForm.Width - Width) div 2) + CenterForm.Left;
        Top := ((CenterForm.Height - Height) div 2) + CenterForm.Top;
    end else begin
        Left := (Screen.Width - Width) div 2;
        Top := (Screen.Height - Height) div 2;
    end;

    FInf := TLineInfo.Create;
end;

procedure TAbonInfoEdit.FormDestroy(Sender: TObject);
begin
    FInf.Free;
end;

procedure TAbonInfoEdit.SetInfo(const src: TLineInfo);
begin
    FInf.Copy(src);
end;

procedure TAbonInfoEdit.GetInfo(var dst: TLineInfo);
begin
    dst.Copy(FInf);
end;

procedure TAbonInfoEdit.FormShow(Sender: TObject);
begin
    case FInf.AbonType of
        atStandard:    AbonTypeRadio.ItemIndex := 0;
        stTransparent: AbonTypeRadio.ItemIndex := 1;
    end;

    case FInf.CompType of
        ctStandard: CompTypeRadio.ItemIndex := 0;
        ctRegexp:   CompTypeRadio.ItemIndex := 1;
    end;

    case FInf.TargetType of
        ttAll:    AllRadio.Checked    := True;
        ttThread: ThreadRadio.Checked := True;
        ttBoard:  BoardRadio.Checked  := True;
    end;

    ThrInfoEdit.Text := FInf.TargetThread;
    BrdInfoEdit.Text := FInf.TargetBoard;

    TargetRadioClick(AllRadio);
end;

procedure TAbonInfoEdit.TargetRadioClick(Sender: TObject);
begin
    if (ThreadRadio.Checked = True) then begin
        ThrNameEdit.Enabled := True;
        ThrInfoEdit.Enabled := True;
        BrdNameEdit.Enabled := False;
        BrdInfoEdit.Enabled := False;
    end else if (BoardRadio.Checked = True) then begin
        ThrNameEdit.Enabled := False;
        ThrInfoEdit.Enabled := False;
        BrdNameEdit.Enabled := True;
        BrdInfoEdit.Enabled := True;
    end else begin
        ThrNameEdit.Enabled := False;
        ThrInfoEdit.Enabled := False;
        BrdNameEdit.Enabled := False;
        BrdInfoEdit.Enabled := False;
    end;
end;

procedure TAbonInfoEdit.OkButtonClick(Sender: TObject);
begin
    if (AbonTypeRadio.ItemIndex = 1) then
        FInf.AbonType := stTransparent
    else
        FInf.AbonType := atStandard;

    if (CompTypeRadio.ItemIndex = 1) then
        FInf.CompType := ctRegexp
    else
        FInf.CompType := ctStandard;

    if (ThreadRadio.Checked = True) then
        FInf.TargetType := ttThread
    else if (BoardRadio.Checked = True) then
        FInf.TargetType := ttBoard
    else
        FInf.TargetType := ttAll;

    FInf.TargetThread := ThrInfoEdit.Text;
    FInf.TargetBoard  := BrdInfoEdit.Text;

    ModalResult := mrOk;
end;

end.
