unit AbonInfo;

interface

type
  TAbonType = (atStandard, stTransparent);
  TCompType = (ctStandard, ctRegexp);
  TTargetType = (ttAll, ttThread, ttBoard);

  TLineInfo = class(TObject)
  public
    AbonType:   TAbonType;
    CompType:   TCompType;
    TargetType: TTargetType;
    TargetBoard: String;
    TargetThread: String;
	constructor Create;
    function ToString: String;
    procedure Clear;
    procedure Copy(const Src: TLineInfo);
  end;

implementation

constructor TLineInfo.Create;
begin
    AbonType := atStandard;
    CompType := ctStandard;
    TargetType := ttAll;
end;

function TLineInfo.ToString: String;
var
    dst: String;
begin
    case AbonType of
        atStandard:    dst := 'ʏ킠ځ[E';
        stTransparent: dst := 'ځ[E';
        else           dst := 'E';
    end;
    case CompType of
        ctStandard:    dst := dst + 'ʏrE';
        ctRegexp:      dst := dst + 'K\E';
        else           dst := dst + 'E';
    end;
    case TargetType of
        ttAll:         dst := dst + 'SXΏ';
        ttThread:      dst := dst + 'Xw';
        ttBoard:       dst := dst + 'w';
    end;
    Result := dst;
end;

procedure TLineInfo.Clear;
begin
    AbonType     := atStandard;
    CompType     := ctStandard;
    TargetType   := ttAll;
    TargetBoard  := '';
    TargetThread := '';
end;

procedure TLineInfo.Copy(const Src: TLineInfo);
begin
    AbonType     := Src.AbonType;
    CompType     := Src.CompType;
    TargetType   := Src.TargetType;
    TargetBoard  := Src.TargetBoard;
    TargetThread := Src.TargetThread;
end;

end.
