unit UpdateCheck;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, IdAntiFreezeBase, IdAntiFreeze, IdBaseComponent, IdComponent,
  IdTCPConnection, IdTCPClient, IdHTTP, StdCtrls, ExtCtrls, Buttons;

type
  TUpdateCheckForm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    ResultMemo: TMemo;
    UpdateButton: TButton;
    IdHTTP: TIdHTTP;
    IdAntiFreeze: TIdAntiFreeze;
    NightBuildCheckButton: TButton;
    CancelBitBtn: TBitBtn;
    procedure UpdateButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure NightBuildCheckButtonClick(Sender: TObject);
    procedure CancelBitBtnClick(Sender: TObject);
  private
    { Private 錾 }
    FExecPath : string;
    FExecArgs : string;
    FAllowshutdown : Boolean;
    FCanceled : Boolean;
    function  GetDesktopDir:string;
    function  GetDownloadFilePath(FileName: String): String;
    function  CreateShortCut(FileName, Argment, SavePath :string):boolean;
    procedure DonwloadUpdate(url: String);
    function CheckUpdate(nightbuild :Boolean): Boolean;
  public
    { Public 錾 }
    property ExecPath :String read FExecPath;
    property ExecArgs :String read FExecArgs;
    property Allowshutdown :Boolean read FAllowshutdown;
  end;

var
  UpdateCheckForm: TUpdateCheckForm;

implementation
uses
    GikoSystem, NewBoard, Giko, IniFiles, MojuUtils, GikoDataModule,
    ActiveX, ComObj, ShlObj, GikoUtil;

{$R *.dfm}
//! K
procedure TUpdateCheckForm.UpdateButtonClick(Sender: TObject);
begin
    if CheckUpdate(false) then begin
        if GikoUtil.MsgBox(Handle, 'XV邽߃MRirċN܂H', 'ImF',
            MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) = ID_YES then begin
            FAllowshutdown := True;
            close;
        end;
    end;
end;
//! l
procedure TUpdateCheckForm.NightBuildCheckButtonClick(Sender: TObject);
begin
    if GikoUtil.MsgBox(Handle, '[Xłł͂܂񂪂낵łH', 'XVmF',
        MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) = ID_YES then begin
        if CheckUpdate(true) then begin
            if GikoUtil.MsgBox(Handle, 'XV邽߃MRirċN܂H', 'ImF',
                MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) = ID_YES then begin
                FAllowshutdown := True;
                close;
            end;
        end;
    end;
end;

//! Abvf[gΏۊmF
function TUpdateCheckForm.CheckUpdate(nightbuild :Boolean): Boolean;
const
{$IFDEF DEBUG}
//	CHECK_URL = 'http://gikonavi.sourceforge.jp/updater/debug.txt';
	CHECK_URL = 'http://gikonavigoeson.sourceforge.jp/updater/debug.txt';
{$ELSE}
//	CHECK_URL = 'http://gikonavi.sourceforge.jp/updater/latest.txt';
	CHECK_URL = 'http://gikonavigoeson.sourceforge.jp/updater/latest.txt';
{$ENDIF}
var
    value, url : string;
   	ResStream: TMemoryStream;
    downResult, current, newest: TStringList;
    newgiko: Boolean;
begin
    Result := false;
    FExecPath := '';
    FExecArgs := '';
    FAllowshutdown := False;
    ResultMemo.Lines.Clear;
    Screen.Cursor := crHourGlass;
    UpdateButton.Enabled := False;
    NightBuildCheckButton.Enabled := False;

    try
        ResStream := TMemoryStream.Create;
        try
            TNewBoardDialog.InitHTTPClient(IdHTTP);
            IdHTTP.Request.Referer := '';
            IdHTTP.Request.AcceptEncoding := 'gzip';

            IdHTTP.Request.CacheControl := 'no-cache';
            IdHTTP.Request.CustomHeaders.Add('Pragma: no-cache');
            IdHTTP.ReadTimeout := 0;
            IdHTTP.HandleRedirects := true;
            downResult := TStringList.Create;
            newest     := TStringList.Create;
            current    := TStringList.Create;
            IdAntiFreeze.Active := true;
            try
                try
                    ResStream.Clear;
                    FCanceled := False;
                    CancelBitBtn.Enabled := True;
                    IdHTTP.Get(CHECK_URL, ResStream);
                    CancelBitBtn.Enabled := False;
                    if (FCanceled) then begin
                        raise Exception.Create('_E[hLZ܂B');
                    end;
                    value := GikoSys.GzipDecompress(ResStream,
                            IdHTTP.Response.ContentEncoding);
                    downResult.Text := value;
                    if (nightbuild) then  begin
                        ResultMemo.Lines.Add('ŐVnight build́A' + downResult.Values[ 'n_version' ]);
                        newest.Text := MojuUtils.CustomStringReplace(downResult.Values[ 'n_version' ],
                                        '.', #10, false);
                    end else begin
                        ResultMemo.Lines.Add('ŐṼMRiŕA' +  downResult.Values[ 'version' ]);
                        newest.Text := MojuUtils.CustomStringReplace(downResult.Values[ 'version' ],
                                        '.', #10, false);
                    end;
                    current.Text := MojuUtils.CustomStringReplace(GikoSys.Version,
                                        '.', #10, false);
                    if newest.Count >= 2 then begin
                        newgiko := false;
                        // night build́ArhԍŔ肷
                        if (nightbuild) then begin
                            url := downResult.Values[ 'n_url' ];
                            newgiko := StrToInt(current[3]) < StrToInt(newest[3]);
                        end else begin
                            url := downResult.Values[ 'url' ];
                            newgiko := ( StrToInt(current[1]) < StrToInt(newest[1]) ) or
                                        ( (StrToInt(current[1]) = StrToInt(newest[1]))) and
                                            ((StrToInt(current[2]) < StrToInt(newest[2])) );
                        end;
                        if (newgiko) then begin
                            if GikoUtil.MsgBox(Handle, 'VMRir܂B_E[h܂H', 'XVmF',
                                MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) = ID_YES then begin
                                ResultMemo.Lines.Add('VMRir܂B_E[hJn܂B' + url);
                                DonwloadUpdate(Trim(url));
                                Result := True;
                            end;
                        end else begin
                            ResultMemo.Lines.Add('̃MRirŐVłB');
                        end;
                    end else begin
                        ResultMemo.Lines.Add('̃MRirŐVłB');
                    end;
                except
                    on E: Exception do begin
                        ResultMemo.Lines.Add(E.Message);
                        {$IFDEF DEBUG}
                        Writeln(IdHTTP.ResponseText);
                        {$ENDIF}
                    end;
                end;
            finally
                current.free;
                newest.free;
                downResult.Free;
                IdAntiFreeze.Active := false;
            end;
        finally
            ResStream.Clear;
            ResStream.Free;
        end;
    finally
        NightBuildCheckButton.Enabled := True;
        UpdateButton.Enabled := True;
        Screen.Cursor := crDefault;
    end;

end;

//! Abvf[g_E[h
procedure TUpdateCheckForm.DonwloadUpdate(url: String);
var
    filename : String;
    fileStrem: TFileStream;
begin
    filename := GetDownloadFilePath(Copy(url, LastDelimiter('/', url) + 1,  Length(url)));
    fileStrem := TFileStream.Create(filename, fmCreate);
    try
        CancelBitBtn.Enabled := True;
        IdHTTP.Get(url, fileStrem);
        CancelBitBtn.Enabled := False;
        if (FCanceled) then begin
            raise Exception.Create('_E[hLZ܂B');
        end;
        ResultMemo.Lines.Add(
            IdHttp.ResponseText + '(' + IntToStr(IdHttp.ResponseCode) + ')');
        FExecPath := filename;
        FExecArgs := '/SP- /silent /noicons "/dir=' + GikoSys.GetAppDir + '"';
        if CreateShortCut(
            execPath, execArgs, GetDesktopDir) then begin
            ResultMemo.Lines.Add('fXNgbv"MRirXV"V[gJbg쐬܂B');
            // ResultMemo.Lines.Add('MRirIāA"MRirXV"V[gJbg_uNbNĂB');
        end else begin
            ResultMemo.Lines.Add('fXNgbvɃV[gJbg쐬ł܂łB');
        end;

    finally
        fileStrem.Free;
    end;
end;
//! _E[ht@C̕ۑpX
function  TUpdateCheckForm.GetDownloadFilePath(FileName: String): String;
var
    TempPath: array[0..MAX_PATH] of Char;
begin
    GetTempPath(MAX_PATH, TempPath);
    Result := IncludeTrailingPathDelimiter(TempPath) + FileName;
end;


//! fXNgbṽpX擾֐
function  TUpdateCheckForm.GetDesktopDir:string;
var
    DeskTopPath: array[0..MAX_PATH] of Char;
    pidl: PItemIDList;
begin
    SHGetSpecialFolderLocation(Application.Handle, CSIDL_DESKTOP, pidl);
    SHGetPathFromIDList(pidl, DesktopPath);
    Result := DesktopPath;
end;

//! V[gJbg쐬֐
function  TUpdateCheckForm.CreateShortCut(FileName, Argment, SavePath :string):boolean;
//FileNamecV[gJbg쐬t@C
//SavePathc.lnkt@C쐬fBNg
var
    SL :IShelllink;
    PF :IPersistFile;
    wFileName :WideString;
begin
    Result :=false;
    //IUnKnownIuWFNg쐬āAIShellLinkɃLXg
    SL :=CreateComObject(CLSID_ShellLink) as IShellLink;
    //IPersistFile ɃLXg
    PF :=SL as IPersistFile;

    if (SL.SetPath(PChar(FileName)) <> NOERROR) then begin
        Exit;
    end;
    if (SL.SetWorkingDirectory(PChar(ExtractFilePath(FileName)))
                                   <> NOERROR ) then begin
        Exit;
    end;
    if (SL.SetArguments(PChar(Argment)) <> NOERROR) then begin
        Exit;
    end;
    if (SL.SetDescription(PChar('MRirXV')) <> NOERROR) then begin
        Exit;
    end;

    //IPersistFileSave\bhɂPWChar^̃p[^Kv
    wFileName :=SavePath +'\MRirXV.lnk';
    //V[gJbg쐬
    if (PF.Save(PWChar(wFileName),True) <> NOERROR) then begin
        Exit;
    end;
    Result :=true;
end;

//! FormRXgN^
procedure TUpdateCheckForm.FormCreate(Sender: TObject);
begin
    ResultMemo.Lines.Clear;
    FExecPath := '';
    FExecArgs := '';
    FAllowshutdown := False;
end;
//! LZ{^
procedure TUpdateCheckForm.CancelBitBtnClick(Sender: TObject);
begin
    CancelBitBtn.Enabled := False;
    FCanceled := True;
    if IdHTTP.Connected then begin
        IdHTTP.Disconnect;
    end;
end;

end.
