unit GikoDataModule;

interface

uses
  SysUtils, Classes, ExtActns, StdActns, ActnList, ImgList, Controls,
{$IF Defined(DELPRO) }
	SHDocVw,
	MSHTML,
{$ELSE}
	SHDocVw_TLB,
	MSHTML_TLB,
{$IFEND}
  ComCtrls, BrowserRecord, Graphics, Messages, Setting, Dialogs,
  ActiveX, GikoSystem, MoveHistoryItem, HistoryList;

const
	CAPTION_NAME: string = 'MRir';
	USER_SETLINKBAR					= WM_USER + 2003;

	ITEM_ICON_SORT1					= 12;		//!< \[gACR
	ITEM_ICON_SORT2					= 13;		//!< \[gACR

	//c[o[ACR
	TOOL_ICON_HEIGHT_MAX 		= 16;		//!< őACR
	TOOL_ICON_HEIGHT_MIN 		= 17;		//!< ŏACR
	TOOL_ICON_HEIGHT_NORMAL = 18;		//!< WACR
	TOOL_ICON_WIDTH_MAX 		= 19;		//!< őACR
	TOOL_ICON_WIDTH_MIN 		= 20;		//!< ŏACR
	TOOL_ICON_WIDTH_NORMAL 	= 21;		//!< WACR

	TOOL_ICON_FAV_FOLDER		= 30;		//!< CɓtH_ACR
	TOOL_ICON_FAV_BOARD			= 31;		//!< CɓACR
	TOOL_ICON_FAV_THREAD		= 32;		//!< CɓXACR

	//! HTTP
	PROTOCOL_HTTP : string = 'http://';
	//! MRirTCgURL
	URL_GIKONAVI: string = 'gikonavi.sourceforge.jp/';
	//! MRir()TCgURL
	URL_GIKONAVIGO: string = 'gikonavigoeson.sourceforge.jp/';
	//! MonazillaTCgURL
	URL_MONAZILLA: string = 'www.monazilla.org/';
	//! 2˂URL
	URL_2ch: string = 'www.2ch.net/';
	//! MRirWikiURL
	URL_Wiki: string = 'sourceforge.jp/projects/gikonavi/wiki/FAQ';
	//! MRir()WikiURL
	URL_GoWiki: string = 'sourceforge.jp/projects/gikonavigoeson/wiki/FAQ';

	SELECTCOMBOBOX_NAME: string = ''; // 'Xbhi';
	SELECTCOMBOBOX_COLOR: TColor = clWindow;


type

  TGikoDM = class(TDataModule)
	GikoFormActionList: TActionList;
	OnlyAHundredResAction: TAction;
	OnlyKokoResAction: TAction;
	LoginAction: TAction;
	NewBoardAction: TAction;
	LogDeleteAction: TAction;
	KidokuAction: TAction;
	StdToolBarVisibleAction: TAction;
	AddressBarVisibleAction: TAction;
	LinkBarVisibleAction: TAction;
	ListToolBarVisibleAction: TAction;
	SearchAction: TAction;
	GikoNaviWebPageAction: TAction;
	MonazillaWebPageAction: TAction;
	BBS2chWebPageAction: TAction;
	GikoFolderOpenAction: TAction;
	AboutAction: TAction;
	SelectTextClearAction: TAction;
	NameTextClearAction: TAction;
	MailTextClearAction: TAction;
	ExitAction: TAction;
	ListNameBarVisibleAction: TAction;
	BrowserToolBarVisibleAction: TAction;
	BrowserNameBarVisibleAction: TAction;
	MsgBarVisibleAction: TAction;
	MsgBarCloseAction: TAction;
	StatusBarVisibleAction: TAction;
	CabinetBBSAction: TAction;
	CabinetHistoryAction: TAction;
	OnlyNewResAction: TAction;
	CabinetFavoriteAction: TAction;
	CabinetVisibleAction: TAction;
	ListNumberVisibleAction: TAction;
	UpFolderAction: TAction;
	CabinetCloseAction: TAction;
	IconStyle: TAction;
	LargeIconAction: TAction;
	SmallIconAction: TAction;
	ListIconAction: TAction;
	DetailIconAction: TAction;
	MidokuAction: TAction;
	AllSelectAction: TAction;
	AllItemAction: TAction;
	LogItemAction: TAction;
	NewItemAction: TAction;
	ThreadRangeAction: TAction;
	SelectItemAction: TAction;
	StopAction: TAction;
	OptionAction: TAction;
	RoundAction: TAction;
	BrowserMaxAction: TAction;
	BrowserMinAction: TAction;
	ScrollTopAction: TAction;
	ScrollLastAction: TAction;
	ScrollNewAction: TAction;
	ScrollKokoAction: TAction;
	EditorAction: TAction;
	IEAction: TAction;
	ShowThreadAction: TAction;
	ShowBoardAction: TAction;
	URLCopyAction: TAction;
	NameCopyAction: TAction;
	NameURLCopyAction: TAction;
	ItemReloadAction: TAction;
	ThreadEditorAction: TAction;
	BoardIEAction: TAction;
	SelectItemURLCopyAction: TAction;
	SelectItemNameCopyAction: TAction;
	SelectItemNameURLCopyAction: TAction;
	SelectListReloadAction: TAction;
	SelectThreadReloadAction: TAction;
	BrowserTabCloseAction: TAction;
	NotSelectTabCloseAction: TAction;
	AllTabCloseAction: TAction;
	KokomadeAction: TAction;
	ZenbuAction: TAction;
	KokoResAction: TAction;
	TreeSelectBoradReload: TAction;
	TreeSelectThreadReload: TAction;
	TreeSelectURLCopy: TAction;
	SelectReservAction: TAction;
	SelectNewRoundName: TAction;
	SelectDeleteRound: TAction;
	KeySettingAction: TAction;
	ArrangeAction: TAction;
	ActiveLogDeleteAction: TAction;
	TreeSelectNameURLCopy: TAction;
	PaneInitAction: TAction;
	LeftmostTabSelectAction: TAction;
	LeftTabSelectAction: TAction;
	RightTabSelectAction: TAction;
	RightmostTabSelectAction: TAction;
	FavoriteAddAction: TAction;
	BoardFavoriteAddAction: TAction;
	ThreadFavoriteAddAction: TAction;
	TreeSelectFavoriteAddAction: TAction;
	FavoriteArrangeAction: TAction;
	MoveToAction: TAction;
	BrowserTabVisibleAction: TAction;
	BrowserTabTopAction: TAction;
	BrowserTabBottomAction: TAction;
	BrowserTabTabStyleAction: TAction;
	BrowserTabButtonStyleAction: TAction;
	BrowserTabFlatStyleAction: TAction;
	GikoHelpAction: TAction;
	KotehanAction: TAction;
	ToolBarSettingAction: TAction;
	SelectResAction: TAction;
	AllResAction: TAction;
	EditNGAction: TAction;
	ReloadAction: TAction;
	GoFowardAction: TAction;
	GoBackAction: TAction;
	TreeSelectSearchBoardName: TAction;
	FavoriteTreeViewRenameAction: TAction;
	FavoriteTreeViewNewFolderAction: TAction;
	FavoriteTreeViewDeleteAction: TAction;
	FavoriteTreeViewBrowseFolderAction: TAction;
	FavoriteTreeViewReloadAction: TAction;
	FavoriteTreeViewURLCopyAction: TAction;
	FavoriteTreeViewNameCopyAction: TAction;
	FavoriteTreeViewNameURLCopyAction: TAction;
	FavoriteTreeViewLogDeleteAction: TAction;
	ResRangeAction: TAction;
	ExportFavoriteFile: TFileSaveAs;
	FavoriteTreeViewBrowseBoardAction: TAction;
	FavoriteTreeViewBrowseThreadAction: TAction;
	UpBoardAction: TAction;
	KoreCopy: TAction;
	TreeSelectNameCopy: TAction;
	SetFocusForBrowserAction: TAction;
	SetFocusForThreadListAction: TAction;
	SetFocusForCabinetAction: TAction;
	FileRun1: TFileRun;
	ThreadlistMaxAndFocusAction: TAction;
	BrowserMaxAndFocusAction: TAction;
	SelectItemSaveForHTML: TAction;
	SelectItemSaveForDat: TAction;
	LogFolderOpenAction: TAction;
	TabsSaveAction: TAction;
	TabsOpenAction: TAction;
	BrowsBoradHeadAction: TAction;
	JumpToNumOfResAction: TAction;
	FavoriteTreeViewCollapseAction: TAction;
	RightTabCloseAction: TAction;
	LeftTabCloseAction: TAction;
	SameIDResAnchorAction: TAction;
	IndividualAbon1Action: TAction;
	IndividualAbon0Action: TAction;
	AntiIndividualAbonAction: TAction;
	AntiIndividualAbonDlgAction: TAction;
	IndividualAbonID1Action: TAction;
	IndividualAbonID0Action: TAction;
	MuteAction: TAction;
	SortActiveColumnAction: TAction;
	SortNextColumnAction: TAction;
	SortPrevColumnAction: TAction;
	BeLogInOutAction: TAction;
	UnSelectedListViewAction: TAction;
	WikiFAQWebPageAction: TAction;
	ToobarImageList: TImageList;
    SaveDialog: TSaveDialog;
    ThreadSizeCalcForFileAction: TAction;
    SetInputAssistAction: TAction;
    OpenFindDialogAction: TAction;
    ArchiveItemAction: TAction;
    LiveItemAction: TAction;
    FavoriteTreeViewItemNameCopyAction: TAction;
    CloseAllEditorAction: TAction;
    PrevMoveHistory: TAction;
    NextMoveHistory: TAction;
    ClickActiveElementAction: TAction;
    VKDownAction: TAction;
    VKUpAction: TAction;
    VKRightAction: TAction;
    VKLeftAction: TAction;
    StoredTaskTrayAction: TAction;
    AllImageLinkToClipbordAction: TAction;
    NewImageLinkToClipBoardAction: TAction;
    SetForcusForAddresBarAction: TAction;
    NewBoardSearchAction: TAction;
    NGWordEditFormAction: TAction;
    ScrollPageDownAction: TAction;
    ScrollPageUpAction: TAction;
    AllLinkToClipboardAction: TAction;
    NewLinkToClipboardAction: TAction;
    AddIDtoNGWord0Action: TAction;
    AddIDtoNGWord1Action: TAction;
    ExtractSameIDAction: TAction;
    ShowTabListAction: TAction;
    DereferenceResAction: TAction;
    UpdateGikonaviAction: TAction;
    konoURLPATHAction: TAction;
    konoURLQueryAction: TAction;
    PopupMenuSettingAction: TAction;
    GikoNaviGoesonWebPageAction: TAction;
    GoWikiFAQWebPageAction: TAction;
	procedure EditNGActionExecute(Sender: TObject);
	procedure ReloadActionExecute(Sender: TObject);
	procedure GoFowardActionExecute(Sender: TObject);
	procedure GoBackActionExecute(Sender: TObject);
	procedure MoveToActionExecute(Sender: TObject);
	procedure FavoriteAddActionExecute(Sender: TObject);
	procedure FavoriteArrangeActionExecute(Sender: TObject);
	procedure FavoriteTreeViewCollapseActionExecute(Sender: TObject);
	procedure FavoriteTreeViewRenameActionExecute(Sender: TObject);
	procedure FavoriteTreeViewNewFolderActionExecute(Sender: TObject);
	procedure FavoriteTreeViewDeleteActionExecute(Sender: TObject);
	procedure FavoriteTreeViewBrowseFolderActionExecute(Sender: TObject);
	procedure FavoriteTreeViewReloadActionExecute(Sender: TObject);
	procedure FavoriteTreeViewURLCopyActionExecute(Sender: TObject);
	procedure FavoriteTreeViewNameCopyActionExecute(Sender: TObject);
	procedure FavoriteTreeViewNameURLCopyActionExecute(Sender: TObject);
	procedure FavoriteTreeViewLogDeleteActionExecute(Sender: TObject);
	procedure FavoriteTreeViewBrowseThreadActionExecute(Sender: TObject);
	procedure OnlyAHundredResActionExecute(Sender: TObject);
	procedure OnlyKokoResActionExecute(Sender: TObject);
	procedure OnlyNewResActionExecute(Sender: TObject);
	procedure BrowserMaxActionExecute(Sender: TObject);
	procedure BrowserMinActionExecute(Sender: TObject);
	procedure ScrollTopActionExecute(Sender: TObject);
	procedure ScrollLastActionExecute(Sender: TObject);
	procedure ScrollNewActionExecute(Sender: TObject);
	procedure ScrollKokoActionExecute(Sender: TObject);
	procedure ScrollKokoActionUpdate(Sender: TObject);
	procedure EditorActionExecute(Sender: TObject);
	procedure IEActionExecute(Sender: TObject);
	procedure ShowThreadActionExecute(Sender: TObject);
	procedure ShowBoardActionExecute(Sender: TObject);
	procedure URLCopyActionExecute(Sender: TObject);
	procedure NameCopyActionExecute(Sender: TObject);
	procedure NameURLCopyActionExecute(Sender: TObject);
	procedure ItemReloadActionExecute(Sender: TObject);
	procedure BrowserTabCloseActionExecute(Sender: TObject);
	procedure BrowserTabCloseActionUpdate(Sender: TObject);
	procedure NotSelectTabCloseActionExecute(Sender: TObject);
	procedure NotSelectTabCloseActionUpdate(Sender: TObject);
	procedure AllTabCloseActionExecute(Sender: TObject);
	procedure ActiveLogDeleteActionExecute(Sender: TObject);
	procedure LeftmostTabSelectActionExecute(Sender: TObject);
	procedure LeftmostTabSelectActionUpdate(Sender: TObject);
	procedure LeftTabSelectActionExecute(Sender: TObject);
	procedure RightTabSelectActionExecute(Sender: TObject);
	procedure RightTabSelectActionUpdate(Sender: TObject);
	procedure RightmostTabSelectActionExecute(Sender: TObject);
	procedure ThreadFavoriteAddActionExecute(Sender: TObject);
	procedure ThreadFavoriteAddActionUpdate(Sender: TObject);
	procedure SelectResActionExecute(Sender: TObject);
	procedure AllResActionExecute(Sender: TObject);
	procedure ResRangeActionExecute(Sender: TObject);
	procedure UpBoardActionExecute(Sender: TObject);
	procedure JumpToNumOfResActionExecute(Sender: TObject);
	procedure RightTabCloseActionExecute(Sender: TObject);
	procedure RightTabCloseActionUpdate(Sender: TObject);
	procedure LeftTabCloseActionExecute(Sender: TObject);
	procedure DataModuleCreate(Sender: TObject);
	procedure SearchActionExecute(Sender: TObject);
	procedure OptionActionExecute(Sender: TObject);
	procedure RoundActionExecute(Sender: TObject);
	procedure KeySettingActionExecute(Sender: TObject);
	procedure KotehanActionExecute(Sender: TObject);
	procedure ToolBarSettingActionExecute(Sender: TObject);
	procedure MuteActionExecute(Sender: TObject);
	procedure TreeSelectBoradReloadExecute(Sender: TObject);
	procedure TreeSelectThreadReloadExecute(Sender: TObject);
	procedure TreeSelectURLCopyExecute(Sender: TObject);
	procedure TreeSelectNameURLCopyExecute(Sender: TObject);
	procedure TreeSelectFavoriteAddActionExecute(Sender: TObject);
	procedure TreeSelectSearchBoardNameExecute(Sender: TObject);
	procedure TreeSelectNameCopyExecute(Sender: TObject);
	procedure LoginActionExecute(Sender: TObject);
	procedure NewBoardActionExecute(Sender: TObject);
	procedure LogDeleteActionExecute(Sender: TObject);
	procedure LogDeleteActionUpdate(Sender: TObject);
	procedure SelectTextClearActionExecute(Sender: TObject);
	procedure NameTextClearActionExecute(Sender: TObject);
	procedure MailTextClearActionExecute(Sender: TObject);
	procedure ExitActionExecute(Sender: TObject);
	procedure ExportFavoriteFileBeforeExecute(Sender: TObject);
	procedure ExportFavoriteFileAccept(Sender: TObject);
	procedure SelectItemSaveForHTMLExecute(Sender: TObject);
	procedure SelectItemSaveForDatExecute(Sender: TObject);
	procedure TabsSaveActionExecute(Sender: TObject);
	procedure TabsOpenActionExecute(Sender: TObject);
	procedure BeLogInOutActionExecute(Sender: TObject);
	procedure KokomadeActionExecute(Sender: TObject);
	procedure ZenbuActionExecute(Sender: TObject);
	procedure KokoResActionExecute(Sender: TObject);
	procedure KoreCopyExecute(Sender: TObject);
	procedure SameIDResAnchorActionExecute(Sender: TObject);
	procedure IndividualAbon1ActionExecute(Sender: TObject);
	procedure IndividualAbon0ActionExecute(Sender: TObject);
	procedure AntiIndividualAbonActionExecute(Sender: TObject);
	procedure AntiIndividualAbonDlgActionExecute(Sender: TObject);
	procedure IndividualAbonID1ActionExecute(Sender: TObject);
	procedure IndividualAbonID0ActionExecute(Sender: TObject);
	procedure GikoNaviWebPageActionExecute(Sender: TObject);
	procedure MonazillaWebPageActionExecute(Sender: TObject);
	procedure BBS2chWebPageActionExecute(Sender: TObject);
	procedure GikoFolderOpenActionExecute(Sender: TObject);
	procedure AboutActionExecute(Sender: TObject);
	procedure GikoHelpActionExecute(Sender: TObject);
	procedure WikiFAQWebPageActionExecute(Sender: TObject);
	procedure ListNumberVisibleActionExecute(Sender: TObject);
	procedure UpFolderActionExecute(Sender: TObject);
	procedure UpFolderActionUpdate(Sender: TObject);
	procedure IconStyleExecute(Sender: TObject);
	procedure AllItemActionExecute(Sender: TObject);
	procedure LogItemActionExecute(Sender: TObject);
	procedure NewItemActionExecute(Sender: TObject);
	procedure ThreadRangeActionExecute(Sender: TObject);
	procedure SelectItemActionExecute(Sender: TObject);
	procedure ThreadEditorActionExecute(Sender: TObject);
	procedure BoardIEActionExecute(Sender: TObject);
	procedure SelectItemURLCopyActionExecute(Sender: TObject);
	procedure SelectItemURLCopyActionUpdate(Sender: TObject);
	procedure SelectItemNameCopyActionExecute(Sender: TObject);
	procedure SelectItemNameCopyActionUpdate(Sender: TObject);
	procedure SelectItemNameURLCopyActionExecute(Sender: TObject);
	procedure SelectListReloadActionExecute(Sender: TObject);
	procedure SelectListReloadActionUpdate(Sender: TObject);
	procedure SelectThreadReloadActionExecute(Sender: TObject);
	procedure SelectThreadReloadActionUpdate(Sender: TObject);
	procedure SelectReservActionExecute(Sender: TObject);
	procedure SelectReservActionUpdate(Sender: TObject);
	procedure SelectNewRoundNameExecute(Sender: TObject);
	procedure SelectDeleteRoundExecute(Sender: TObject);
	procedure BoardFavoriteAddActionExecute(Sender: TObject);
	procedure BoardFavoriteAddActionUpdate(Sender: TObject);
	procedure LogFolderOpenActionExecute(Sender: TObject);
	procedure LogFolderOpenActionUpdate(Sender: TObject);
	procedure BrowsBoradHeadActionExecute(Sender: TObject);
	procedure SortActiveColumnActionExecute(Sender: TObject);
	procedure SortNextColumnActionExecute(Sender: TObject);
	procedure SortPrevColumnActionExecute(Sender: TObject);
	procedure StdToolBarVisibleActionExecute(Sender: TObject);
	procedure AddressBarVisibleActionExecute(Sender: TObject);
	procedure LinkBarVisibleActionExecute(Sender: TObject);
	procedure ListToolBarVisibleActionExecute(Sender: TObject);
	procedure ListNameBarVisibleActionExecute(Sender: TObject);
	procedure BrowserToolBarVisibleActionExecute(Sender: TObject);
	procedure BrowserNameBarVisibleActionExecute(Sender: TObject);
	procedure MsgBarVisibleActionExecute(Sender: TObject);
	procedure MsgBarCloseActionExecute(Sender: TObject);
	procedure StatusBarVisibleActionExecute(Sender: TObject);
	procedure CabinetBBSActionExecute(Sender: TObject);
	procedure CabinetHistoryActionExecute(Sender: TObject);
	procedure CabinetFavoriteActionExecute(Sender: TObject);
	procedure CabinetVisibleActionExecute(Sender: TObject);
	procedure CabinetCloseActionExecute(Sender: TObject);
	procedure LargeIconActionExecute(Sender: TObject);
	procedure SmallIconActionExecute(Sender: TObject);
	procedure ListIconActionExecute(Sender: TObject);
	procedure DetailIconActionExecute(Sender: TObject);
	procedure StopActionExecute(Sender: TObject);
	procedure ArrangeActionExecute(Sender: TObject);
	procedure PaneInitActionExecute(Sender: TObject);
	procedure BrowserTabVisibleActionExecute(Sender: TObject);
	procedure BrowserTabTopActionExecute(Sender: TObject);
	procedure BrowserTabBottomActionExecute(Sender: TObject);
	procedure BrowserTabTabStyleActionExecute(Sender: TObject);
	procedure BrowserTabButtonStyleActionExecute(Sender: TObject);
	procedure BrowserTabFlatStyleActionExecute(Sender: TObject);
	procedure SetFocusForBrowserActionExecute(Sender: TObject);
	procedure SetFocusForBrowserActionUpdate(Sender: TObject);
	procedure SetFocusForThreadListActionExecute(Sender: TObject);
	procedure SetFocusForCabinetActionExecute(Sender: TObject);
	procedure SetFocusForCabinetActionUpdate(Sender: TObject);
	procedure ThreadlistMaxAndFocusActionExecute(Sender: TObject);
	procedure BrowserMaxAndFocusActionExecute(Sender: TObject);
	procedure UnSelectedListViewActionExecute(Sender: TObject);
	procedure KidokuActionExecute(Sender: TObject);
	procedure MidokuActionExecute(Sender: TObject);
	procedure AllSelectActionExecute(Sender: TObject);
	procedure AllSelectActionUpdate(Sender: TObject);
    procedure ThreadSizeCalcForFileActionExecute(Sender: TObject);
    procedure SetInputAssistActionExecute(Sender: TObject);
    procedure OpenFindDialogActionExecute(Sender: TObject);
    procedure ArchiveItemActionExecute(Sender: TObject);
    procedure LiveItemActionExecute(Sender: TObject);
    procedure FavoriteTreeViewItemNameCopyActionExecute(Sender: TObject);
    procedure CloseAllEditorActionExecute(Sender: TObject);
    procedure CloseAllEditorActionUpdate(Sender: TObject);
    procedure PrevMoveHistoryUpdate(Sender: TObject);
    procedure PrevMoveHistoryExecute(Sender: TObject);
    procedure NextMoveHistoryUpdate(Sender: TObject);
    procedure NextMoveHistoryExecute(Sender: TObject);
    procedure ClickActiveElementActionExecute(Sender: TObject);
    procedure VKDownActionExecute(Sender: TObject);
    procedure VKUpActionExecute(Sender: TObject);
    procedure VKRightActionExecute(Sender: TObject);
    procedure VKLeftActionExecute(Sender: TObject);
    procedure StoredTaskTrayActionExecute(Sender: TObject);
    procedure LeftTabSelectActionUpdate(Sender: TObject);
    procedure RightmostTabSelectActionUpdate(Sender: TObject);
    procedure NewImageLinkToClipBoardActionExecute(Sender: TObject);
    procedure AllImageLinkToClipbordActionExecute(Sender: TObject);
    procedure SetForcusForAddresBarActionExecute(Sender: TObject);
    procedure NewBoardSearchActionExecute(Sender: TObject);
    procedure ScrollPageDownActionExecute(Sender: TObject);
    procedure ScrollPageUpActionExecute(Sender: TObject);
    procedure AllLinkToClipboardActionExecute(Sender: TObject);
    procedure NewLinkToClipboardActionExecute(Sender: TObject);
    procedure AddIDtoNGWord0ActionExecute(Sender: TObject);
    procedure AddIDtoNGWord1ActionExecute(Sender: TObject);
    procedure ExtractSameIDActionExecute(Sender: TObject);
    procedure ShowTabListActionExecute(Sender: TObject);
    procedure DereferenceResActionExecute(Sender: TObject);
    procedure UpdateGikonaviActionExecute(Sender: TObject);
    procedure konoURLPATHActionExecute(Sender: TObject);
    procedure konoURLQueryActionExecute(Sender: TObject);
    procedure konoURLQueryActionUpdate(Sender: TObject);
    procedure PopupMenuSettingActionExecute(Sender: TObject);
    procedure GikoNaviGoesonWebPageActionExecute(Sender: TObject);
    procedure GoWikiFAQWebPageActionExecute(Sender: TObject);
  private
	{ Private 錾 }
	procedure ClearResFilter;
	procedure SetResRange(range: Integer);
	procedure SetThreadAreaHorNormal;
	procedure SetThreadAreaHorizontal(gls : TGikoListState);
	procedure SetThreadAreaVerNormal;
	procedure SetThreadAreaVertical(gls : TGikoListState);
	procedure SetThreadReadProperty(read: Boolean);
	procedure SelectThreadSaveToFile(dat: Boolean);
	function GetSortProperties(List: TObject;var vSortOrder: Boolean): Boolean;
	procedure RecalcThreadSize(limit : Integer);
	procedure ClearSelectComboBox;
    procedure ClearMailAllEditor();
    procedure ClearNameTextAllEditor();
    procedure MoveURLWithHistory(URL : String; KeyMask: Boolean = False);
    procedure BackToHistory(item: TMoveHistoryItem);
    function GetActiveThreadLinks : IHTMLElementCollection;
    procedure GetLinkURLs(links : IHTMLElementCollection;
        URLs : TStringList; const Start: Integer; Exts : TStringList);
  public
	{ Public 錾 }
	procedure RepaintStatusBar;
    function EditorFormExists(): boolean;
    procedure GetTabURLs(AStringList: TStringList);
    procedure OpenURLs(AStringList: TStringList);
  published
	{ Published 錾 }
	//! TActionGetActiveContentnilȊOŗLɂȂ
	procedure DependActiveCntentActionUpdate(Sender: TObject);
	//! TActionGetActiveContentnilȊOOĂƗLɂȂ
	procedure DependActiveCntentLogActionUpdate(Sender: TObject);
	//! TActionActiveListTBoard()ŗLɂȂ
	procedure DependActiveListTBoardActionUpdate(Sender: TObject);
	//! TActionActiveListTBoardŗLɂȂ
	procedure DependActiveListTBoardWithSpeciapActionUpdate(Sender: TObject);
  end;

var
  GikoDM: TGikoDM;


implementation

uses
	Windows, Math, Clipbrd,
	Giko, GikoUtil, BoardGroup,
	FavoriteArrange, Favorite, MojuUtils,
	Editor, ListSelect, Search, Option, Round,
	KeySetting, Gesture, Kotehan, ToolBarSetting,
	ToolBarUtil, NewBoard, HTMLCreate, IndividualAbon,
	GikoBayesian, About, ShellAPI,
	RoundName, RoundData, Menus, ListViewUtils,
	ThreadControl, GikoMessage, InputAssist,
    DefaultFileManager, Forms, NewBoardURL, UpdateCheck,
    PopupMenuSetting;

const
	MSG_ERROR : string = 'G[';

{$R *.dfm}
// *************************************************************************
//! TActionGetActiveContentnilȊOŗLɂȂ
// *************************************************************************
procedure TGikoDM.DependActiveCntentActionUpdate(Sender: TObject);
begin
	TAction(Sender).Enabled := (GikoForm.GetActiveContent <> nil);
end;
// *************************************************************************
//! TActionGetActiveContentnilȊOOĂ
// *************************************************************************
procedure TGikoDM.DependActiveCntentLogActionUpdate(Sender: TObject);
begin
	TAction(Sender).Enabled := (GikoForm.GetActiveContent <> nil)
									and (GikoForm.GetActiveContent.IsLogFile);
end;
// *************************************************************************
//! TActionActiveListTBoard()ŗLɂȂ
// *************************************************************************
procedure TGikoDM.DependActiveListTBoardActionUpdate(Sender: TObject);
begin
	TAction(Sender).Enabled := (GikoForm.GetActiveList is TBoard) and
        (GikoForm.GetActiveList <> BoardGroup.SpecialBoard);
end;
// *************************************************************************
//! TActionActiveListTBoardŗLɂȂ
// *************************************************************************
procedure TGikoDM.DependActiveListTBoardWithSpeciapActionUpdate(Sender: TObject);
begin
	TAction(Sender).Enabled := (GikoForm.GetActiveList is TBoard);
end;
// *************************************************************************
//! NG[hҏW
// *************************************************************************
procedure TGikoDM.EditNGActionExecute(Sender: TObject);
begin
	//eLXgɊ֘AtꂽAvNG[ht@CI[v
	GikoSys.FAbon.EditNGwords;
end;
// *************************************************************************
//! NG[hǂݍ݁iēǂݍ݁j
// *************************************************************************
procedure TGikoDM.ReloadActionExecute(Sender: TObject);
begin
	//[hs@s烁bZ[Wo
	if GikoSys.FAbon.ReLoadFromNGwordFile =false then begin
		MsgBox(GikoForm.Handle, 'NG[ht@C̍ēǂݍ݂Ɏs܂',
			MSG_ERROR, MB_OK or MB_ICONEXCLAMATION);
	end else begin
		//SẴ^uɍĕ`ݒ
		GikoForm.RepaintAllTabsBrowser();
	end;
end;
// *************************************************************************
//! NG[hǂݍ݁ij
// *************************************************************************
procedure TGikoDM.GoFowardActionExecute(Sender: TObject);
begin
	//̓ǂݍ݁@s烁bZ[Wo
	if GikoSys.FAbon.GoBack =false then begin
		MsgBox(GikoForm.Handle, 'NG[ht@C̓ǂݍ݂Ɏs܂',
			MSG_ERROR, MB_OK or MB_ICONEXCLAMATION);
	end else begin
		//Xe[^Xɕ\NG[ht@CXV
		RepaintStatusBar;
		//SẴ^uɍĕ`ݒ
		GikoForm.RepaintAllTabsBrowser();
	end;
end;
// *************************************************************************
//! NG[hǂݍ݁iOj
// *************************************************************************
procedure TGikoDM.GoBackActionExecute(Sender: TObject);
begin
	//̓ǂݍ݁@s烁bZ[Wo
	if GikoSys.FAbon.GoForward =false then begin
		MsgBox(GikoForm.Handle, 'ONG[ht@C̓ǂݍ݂Ɏs܂',
			MSG_ERROR, MB_OK or MB_ICONEXCLAMATION);
	end else begin
		//Xe[^Xɕ\NG[ht@CXV
		RepaintStatusBar;
		//SẴ^uɍĕ`ݒ
		GikoForm.RepaintAllTabsBrowser();
	end;
end;
// *************************************************************************
//! NG[hύX̃Xe[^Xo[̍XV
// *************************************************************************
procedure TGikoDM.RepaintStatusBar;
var
	s : String;
begin
	//Xe[^Xɕ\NG[ht@CXV
	s := GikoSys.FAbon.NGwordname;
	GikoForm.StatusBar.Panels.Items[GiKo.NGWORDNAME_PANEL].Text := s;
	//Xe[^X̕\TCỸTCY
	GikoForm.StatusBar.Panels[GiKo.NGWORDNAME_PANEL].Width
		:= Max(GikoForm.StatusBar.Canvas.TextWidth(s), 100);
	GikoForm.StatusBarResize(nil);
end;
// *************************************************************************
//! AhXo[ɕ\ĂAhXֈړ
// *************************************************************************
procedure TGikoDM.MoveToActionExecute(Sender: TObject);
begin
	//AhXR{{bNXURL擾
	//URLɈړ
    MoveURLWithHistory( Trim(GikoForm.AddressComboBox.Text) );
end;
// *************************************************************************
//! Cɓ̒ǉ_CAOJ
// *************************************************************************
procedure TGikoDM.FavoriteAddActionExecute(Sender: TObject);
begin
	GikoForm.ShowFavoriteAddDialog(GikoForm.GetActiveContent);
end;
// *************************************************************************
//! Cɓ̐_CAOJ
// *************************************************************************
procedure TGikoDM.FavoriteArrangeActionExecute(Sender: TObject);
var
	Dlg: TFavoriteArrangeDialog;
begin
	Dlg := TFavoriteArrangeDialog.Create(GikoForm);
	try
		Dlg.ShowModal;
	finally
		Dlg.Release;
	end;
	//No[ɍXV`
	PostMessage( GikoForm.Handle, USER_SETLINKBAR, 0, 0 );
end;
// *************************************************************************
//! c[Sĕ
// *************************************************************************
procedure TGikoDM.FavoriteTreeViewCollapseActionExecute(Sender: TObject);
var
	node	: TTreeNode;
begin
	node := GikoForm.FavoriteTreeView.Items.GetFirstNode;
	try
		//m[h@m[hk
		while node <> nil do begin
			if node.HasChildren then
				node.Expanded := False;
			node := node.GetNext;
		end;
	except
	end;
end;
// *************************************************************************
//! Cɓ̖OҏW
// *************************************************************************
procedure TGikoDM.FavoriteTreeViewRenameActionExecute(Sender: TObject);
var
	node : TTreeNode;
begin

	if GikoForm.ClickNode = nil then
		Exit;
	if GikoForm.ClickNode.IsFirstNode then
		Exit;
	if GikoForm.ClickNode.Text = Favorite.FAVORITE_LINK_NAME then
		Exit;
	GikoForm.FavoriteTreeView.ReadOnly := False;
	if (GikoForm.TreeType = gttFavorite) and (GikoForm.CabinetPanel.Visible) then begin
		node := GikoForm.ClickNode.Parent;
		while node <> nil do begin
			node.Expanded	:= True;
			node					:= node.Parent;
		end;
		GikoForm.ClickNode.EditText;
	end else begin
		GikoForm.ClickNode.Text := InputBox( 'O̕ύX', 'Cɓ̐VO͂Ă', GikoForm.ClickNode.Text );
	end;
	//XVƂ
	FavoriteDM.Modified := true;
	GikoForm.SetLinkBar;
end;
// *************************************************************************
//! VCɓɃtH_쐬
// *************************************************************************
procedure TGikoDM.FavoriteTreeViewNewFolderActionExecute(Sender: TObject);
var
	NewFavFolder: TFavoriteFolder;
	Node: TTreeNode;
begin

	if GikoForm.ClickNode = nil then
		Exit;

	try
		if not (TObject(GikoForm.ClickNode.Data) is TFavoriteFolder) then begin
			GikoForm.FavoriteTreeView.Selected := GikoForm.ClickNode.Parent;
			GikoForm.ClickNode := GikoForm.ClickNode.Parent;
		end;

		NewFavFolder := TFavoriteFolder.Create;
		Node := GikoForm.FavoriteTreeView.Items.AddChildObject(GikoForm.ClickNode, 'VtH_', NewFavFolder);
		Node.ImageIndex := 14;
		Node.SelectedIndex := 14;
	//			FClickNode.Selected.Expanded := True;
		GikoForm.FavoriteTreeView.Selected := Node;
		GikoForm.ClickNode := Node;
		//XVƂ
		FavoriteDM.Modified := true;
		FavoriteTreeViewRenameAction.Execute;
	finally
	end;

end;
// *************************************************************************
//! ̂Cɓ폜
// *************************************************************************
procedure TGikoDM.FavoriteTreeViewDeleteActionExecute(Sender: TObject);
const
	DEL_LINK_MSG = 'gNh̓No[ptH_łB폜Ă낵łH';
	DEL_MSG = 'g^0h폜܂B낵łH';
	DEL_TITLE = '폜mF';
begin

	if GikoForm.ClickNode = nil then
		Exit;
	if GikoForm.ClickNode.IsFirstNode then
		Exit;
	if (GetKeyState( VK_SHIFT ) and $80000000) = 0 then begin
		if GikoForm.ClickNode.Text = Favorite.FAVORITE_LINK_NAME then begin
			if MsgBox(GikoForm.Handle, DEL_LINK_MSG, DEL_TITLE, MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) <> ID_YES then
				Exit;
		end else begin
			if MsgBox(GikoForm.Handle, StringReplace( DEL_MSG, '^0', GikoForm.ClickNode.Text, [rfReplaceAll] ) , DEL_TITLE, MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) <> ID_YES then
				Exit;
		end;
	end;

	GikoForm.ClickNode.Delete;
	//XVƂ
	FavoriteDM.Modified := true;

	GikoForm.SetLinkBar;

end;
// *************************************************************************
//! ̃tH_ɓĂ邨CɓSĊJ
// *************************************************************************
procedure TGikoDM.FavoriteTreeViewBrowseFolderActionExecute(
  Sender: TObject);
begin
	GikoForm.FavoriteBrowseFolder( GikoForm.ClickNode );
end;
// *************************************************************************
//! IĂ邨Cɓ_E[h
// *************************************************************************
procedure TGikoDM.FavoriteTreeViewReloadActionExecute(Sender: TObject);
var
	FavThread: TFavoriteThreadItem;
	FavBoard: TFavoriteBoardItem;
	shiftDown: Boolean;
begin
	if (GikoForm.ClickNode = nil) then Exit;

	shiftDown := GetAsyncKeyState(VK_SHIFT) = Smallint($8001);

	if TObject( GikoForm.ClickNode.Data ) is TFavoriteThreadItem then begin
		FavThread := TFavoriteThreadItem( GikoForm.ClickNode.Data );
		if FavThread.Item <> nil then
			GikoForm.DownloadContent(FavThread.Item, shiftDown);
	end else if TObject( GikoForm.ClickNode.Data ) is TFavoriteBoardItem then begin
		FavBoard := TFavoriteBoardItem( GikoForm.ClickNode.Data );
		GikoForm.DownloadList(FavBoard.Item, shiftDown);
	end;

end;
// *************************************************************************
//! IĂ邨CɓURLRs[
// *************************************************************************
procedure TGikoDM.FavoriteTreeViewURLCopyActionExecute(Sender: TObject);
begin

	if GikoForm.ClickNode = nil then Exit;

	if (TObject(GikoForm.ClickNode.Data) is TFavoriteItem) then begin
		Clipboard.AsText := TFavoriteItem( GikoForm.ClickNode.Data ).URL + #13#10;
	end;
end;
// *************************************************************************
//! IĂ邨Cɓ̖ORs[
// *************************************************************************
procedure TGikoDM.FavoriteTreeViewNameCopyActionExecute(Sender: TObject);
begin

	if GikoForm.ClickNode = nil then Exit;

	if (TObject(GikoForm.ClickNode.Data) is TFavoriteItem) then begin
		Clipboard.AsText :=
			TFavoriteItem(GikoForm.ClickNode.Data).GetItemTitle + #13#10;
	end else begin
		Clipboard.AsText :=
			GikoForm.ClickNode.Text + #13#10;

	end;
end;
// *************************************************************************
//! IĂ邨Cɓ̖OURLRs[
// *************************************************************************
procedure TGikoDM.FavoriteTreeViewNameURLCopyActionExecute(
  Sender: TObject);
var
	favItem : TFavoriteItem;
begin

	if GikoForm.ClickNode = nil then Exit;

	if (TObject(GikoForm.ClickNode.Data) is TFavoriteItem) then begin
		favItem := TFavoriteItem(GikoForm.ClickNode.Data);
		Clipboard.AsText := favItem.GetItemTitle  + #13#10 +
							favItem.URL + #13#10;
	end;

end;
// *************************************************************************
//! IĂ邨CɓXbh폜
// *************************************************************************
procedure TGikoDM.FavoriteTreeViewLogDeleteActionExecute(Sender: TObject);
const
	DEL_MSG = 'g^0h̃O폜܂B낵łH';
	DEL_TITLE = '폜mF';
var
	ThreadItem: TThreadItem;
	FavThread: TFavoriteThreadItem;
begin

	if GikoForm.ClickNode = nil then Exit;
	if not (TObject(GikoForm.ClickNode.Data) is TFavoriteThreadItem) then Exit;

	FavThread := TFavoriteThreadItem( GikoForm.ClickNode.Data );
	ThreadItem := FavThread.Item;

	try
		if GikoSys.Setting.DeleteMsg then begin
			if (GetKeyState( VK_SHIFT ) and $80000000) = 0 then
				if MsgBox(GikoForm.Handle, StringReplace( DEL_MSG, '^0', GikoForm.ClickNode.Text, [rfReplaceAll] ) , DEL_TITLE, MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) <> ID_YES then
					Exit;
		end;

		GikoForm.DeleteHistory(ThreadItem);
		GikoForm.DeleteTab(ThreadItem);
		ThreadItem.DeleteLogFile;

		GikoForm.ListView.Refresh;
	finally
	end;

end;
// *************************************************************************
//! ݕ\ĂXbhuEUŕ\
// *************************************************************************
procedure TGikoDM.FavoriteTreeViewBrowseThreadActionExecute(
  Sender: TObject);
var
	threadItem	: TThreadItem;
begin

	if GikoForm.ClickNode = nil then Exit;

	if (TObject(GikoForm.ClickNode.Data) is TFavoriteThreadItem) then begin

		threadItem := TFavoriteThreadItem( GikoForm.ClickNode.Data ).Item;
		if threadItem = nil then
			Exit;
		GikoSys.OpenBrowser( threadItem.URL, gbtAuto );

	end;
end;
//! X̍i݃tB^[ɂ
procedure TGikoDM.ClearResFilter;
var
	FilterList : TStringList;
begin
	// tB^ɂ
	FilterList := TStringList.Create;
	try
		GikoSys.FSelectResFilter.LoadFromStringList( FilterList );
		GikoSys.FSelectResFilter.Reverse := False;
	finally
		FilterList.Free;
	end;
	GikoForm.SelectResWord := '';
end;
// *************************************************************************
//! X̕\͈͂ݒ肷
// *************************************************************************
procedure TGikoDM.SetResRange(range: Integer);
begin
	if GikoSys.ResRange <> range then begin
		GikoSys.ResRange	:= range;
		// tB^ɂ
		ClearResFilter;
		GikoForm.RepaintAllTabsBrowser();
	end;
end;
// *************************************************************************
//! ŐV100X̂ݕ\
// *************************************************************************
procedure TGikoDM.OnlyAHundredResActionExecute(Sender: TObject);
begin
	if (GikoForm.ActiveContent <> nil) and (GikoForm.ActiveContent.Browser <> nil)
		and (GikoForm.ActiveContent.Browser.Busy) then Exit;

	GikoForm.ResRangeMenuSelect 	:= 100;
	OnlyAHundredResAction.Checked	:= True;
	//@\͈͂ݒ肷BݒlƂĂB
    SetResRange(GikoSys.Setting.ResRangeExCount);
end;
// *************************************************************************
//! ǃX̂ݕ\
// *************************************************************************
procedure TGikoDM.OnlyKokoResActionExecute(Sender: TObject);
begin
	if (GikoForm.ActiveContent <> nil) and (GikoForm.ActiveContent.Browser <> nil)
		and (GikoForm.ActiveContent.Browser.Busy) then Exit;

	GikoForm.ResRangeMenuSelect	:= Ord( grrKoko );
	OnlyKokoResAction.Checked	:= True;

	//@\͈͂ݒ肷
	SetResRange(Ord( grrKoko ));
end;
// *************************************************************************
//! VX̂ݕ\
// *************************************************************************
procedure TGikoDM.OnlyNewResActionExecute(Sender: TObject);
begin
	if (GikoForm.ActiveContent <> nil) and (GikoForm.ActiveContent.Browser <> nil)
		and (GikoForm.ActiveContent.Browser.Busy) then Exit;

	GikoForm.ResRangeMenuSelect	:= Ord( grrNew );
	OnlyNewResAction.Checked	:= True;

	//@\͈͂ݒ肷
	SetResRange(Ord( grrNew ));
end;
// *************************************************************************
//! Xbh\GAʏ\ɂ )ListOrientation = gloHorizontal@
// *************************************************************************
procedure TGikoDM.SetThreadAreaHorNormal;
begin
	//ʏ\ɂ
	GikoForm.ViewPanel.Width := GikoForm.BrowserSizeWidth;
	BrowserMaxAction.ImageIndex := TOOL_ICON_WIDTH_MAX;
	BrowserMinAction.ImageIndex := TOOL_ICON_WIDTH_MIN;
	GikoSys.Setting.ListWidthState := glsNormal;
end;
// *************************************************************************
//! Xbh\GAő/ŏ\ɂ )ListOrientation = gloHorizontal@
// *************************************************************************
procedure TGikoDM.SetThreadAreaHorizontal(gls : TGikoListState);
begin
	if GikoSys.Setting.ListWidthState = glsNormal then
		GikoForm.BrowserSizeWidth := GikoForm.ViewPanel.Width;
	//ő\
	if (gls = glsMax) then begin
		GikoForm.ViewPanel.Width := 1;
		BrowserMaxAction.ImageIndex := TOOL_ICON_WIDTH_NORMAL;
		BrowserMinAction.ImageIndex := TOOL_ICON_WIDTH_MIN;
		GikoSys.Setting.ListWidthState := glsMax;
	end else if (gls = glsMin) then begin
		GikoForm.ViewPanel.Width := GikoForm.ThreadMainPanel.Width - 80;
		BrowserMaxAction.ImageIndex := TOOL_ICON_WIDTH_MAX;
		BrowserMinAction.ImageIndex := TOOL_ICON_WIDTH_NORMAL;
		GikoSys.Setting.ListWidthState := glsMin;
	end;
end;
// *************************************************************************
//! Xbh\GAʏ\ɂ )ListOrientation = gloVertical
// *************************************************************************
procedure TGikoDM.SetThreadAreaVerNormal;
begin
	//ʏ\ɂ
	GikoForm.ViewPanel.Height := GikoForm.BrowserSizeHeight;
	BrowserMaxAction.ImageIndex := TOOL_ICON_HEIGHT_MAX;
	BrowserMinAction.ImageIndex := TOOL_ICON_HEIGHT_MIN;
	GikoSys.Setting.ListHeightState := glsNormal;
end;
// *************************************************************************
//! Xbh\GAő/ŏ\ɂ )ListOrientation = gloVertical
// *************************************************************************
procedure TGikoDM.SetThreadAreaVertical(gls : TGikoListState);
begin
	if GikoSys.Setting.ListHeightState = glsNormal then
		GikoForm.BrowserSizeHeight := GikoForm.ViewPanel.Height;
	if (gls = glsMin) then begin
		GikoForm.ViewPanel.Height := GikoForm.ThreadMainPanel.Height - GikoForm.BrowserCoolBar.Height - 7;
		BrowserMaxAction.ImageIndex := TOOL_ICON_HEIGHT_MAX;
		BrowserMinAction.ImageIndex := TOOL_ICON_HEIGHT_NORMAL;
		GikoSys.Setting.ListHeightState := glsMin;
	end else if (gls = glsMax) then begin
		GikoForm.ViewPanel.Height := 1;
		BrowserMaxAction.ImageIndex := TOOL_ICON_HEIGHT_NORMAL;
		BrowserMinAction.ImageIndex := TOOL_ICON_HEIGHT_MIN;
		GikoSys.Setting.ListHeightState := glsMax;
	end;
end;
// *************************************************************************
//! Xbh\GA傫\
// *************************************************************************
procedure TGikoDM.BrowserMaxActionExecute(Sender: TObject);
begin
	if GikoSys.Setting.ListOrientation = gloHorizontal then begin
		case GikoSys.Setting.ListWidthState of
			glsMax: begin
				//ʏ\ɂ
				SetThreadAreaHorNormal;
			end;
			glsMin, glsNormal: begin
				//ő\ɂ
				SetThreadAreaHorizontal(glsMax);
			end;
		end;
	end else begin
		case GikoSys.Setting.ListHeightState of
			glsMax: begin
				//ʏ\ɂ
				SetThreadAreaVerNormal;
			end;
			glsMin, glsNormal: begin
				//ő\ɂ
				SetThreadAreaVertical(glsMax);
			end;
		end;
	end;
end;
// *************************************************************************
//! Xbh\GA\
// *************************************************************************
procedure TGikoDM.BrowserMinActionExecute(Sender: TObject);
begin
	if GikoSys.Setting.ListOrientation = gloHorizontal then begin
		case GikoSys.Setting.ListWidthState of
			glsMax, glsNormal: begin
				//ŏ\ɂ
				SetThreadAreaHorizontal(glsMin);
			end;
			glsMin: begin
				//ʏ\ɂ
				SetThreadAreaHorNormal;
			end;
		end;
	end else begin
		case GikoSys.Setting.ListHeightState of
			glsMax, glsNormal: begin
				//ŏ\ɂ
				SetThreadAreaVertical(glsMin);
			end;
			glsMin: begin
				//ʏ\ɂ
				SetThreadAreaVerNormal;
			end;
		end;
	end;
end;
// *************************************************************************
//! ݕ\ĂXbh̐擪ֈړ
// *************************************************************************
procedure TGikoDM.ScrollTopActionExecute(Sender: TObject);
begin
	GikoForm.BrowserMovement('top');
end;
// *************************************************************************
//! ݕ\ĂXbh̍Ōֈړ
// *************************************************************************
procedure TGikoDM.ScrollLastActionExecute(Sender: TObject);
begin
	GikoForm.BrowserMovement('bottom');
end;
// *************************************************************************
//! ݕ\ĂXbh̐Vֈړ
// *************************************************************************
procedure TGikoDM.ScrollNewActionExecute(Sender: TObject);
begin
	GikoForm.BrowserMovement('new');
end;
// *************************************************************************
//! ݕ\ĂXbh̃RR܂œǂ񂾂ֈړ
// *************************************************************************
procedure TGikoDM.ScrollKokoActionExecute(Sender: TObject);
begin
	GikoForm.BrowserMovement('koko');
end;
// *************************************************************************
//! ݕ\ĂXbh̃RR܂œǂ񂾂ֈړUpdateCxg
// *************************************************************************
procedure TGikoDM.ScrollKokoActionUpdate(Sender: TObject);
begin
	ScrollKokoAction.Enabled := (GikoForm.GetActiveContent <> nil)
								and (GikoForm.GetActiveContent.IsLogFile)
								and (GikoForm.GetActiveContent.Kokomade <> -1);
end;
// *************************************************************************
//! X݃EBhE\
// *************************************************************************
procedure TGikoDM.EditorActionExecute(Sender: TObject);
var
	Editor: TEditorForm;
	Item: TThreadItem;
begin
	Item := GikoForm.GetActiveContent;
	if Item = nil then Exit;
	Editor := TEditorForm.Create(GikoForm.GetMainForm);
	Editor.SetThreadItem(Item);
	Editor.Show;
	Editor.BodyEdit.SetFocus;
end;
// *************************************************************************
//! XuEUŕ\
// *************************************************************************
procedure TGikoDM.IEActionExecute(Sender: TObject);
begin
	ShowThreadAction.Execute;
end;
// *************************************************************************
//! ݕ\ĂXbhuEUŕ\
// *************************************************************************
procedure TGikoDM.ShowThreadActionExecute(Sender: TObject);
var
	ThreadItem: TThreadItem;
begin
	ThreadItem := GikoForm.GetActiveContent;
	if ThreadItem = nil then Exit;
	GikoSys.OpenBrowser(ThreadItem.URL, gbtAuto);
end;
// *************************************************************************
//! ݕ\ĂXbh̔uEUŕ\
// *************************************************************************
procedure TGikoDM.ShowBoardActionExecute(Sender: TObject);
var
	ThreadItem: TThreadItem;
begin
	ThreadItem := GikoForm.GetActiveContent;
	if ThreadItem = nil then Exit;
	GikoSys.OpenBrowser(ThreadItem.ParentBoard.URL, gbtAuto);
end;
// *************************************************************************
//! ݕ\ĂXbhURLRs[
// *************************************************************************
procedure TGikoDM.URLCopyActionExecute(Sender: TObject);
var
	s: string;
begin
	s := '';
	if TObject(GikoForm.GetActiveContent) is TBoard then
		s := s + TBoard(GikoForm.GetActiveContent).URL + #13#10
	else if TObject(GikoForm.GetActiveContent) is TThreadItem then
		s := s + TThreadItem(GikoForm.GetActiveContent).URL + #13#10;
	if s <> '' then
		Clipboard.AsText := s;
end;
// *************************************************************************
//! ݕ\ĂXbhRs[
// *************************************************************************
procedure TGikoDM.NameCopyActionExecute(Sender: TObject);
var
	s: string;
begin
	s := '';
	if TObject(GikoForm.GetActiveContent) is TBoard then
		s := s + TBoard(GikoForm.GetActiveContent).Title + #13#10
	else if TObject(GikoForm.GetActiveContent) is TThreadItem then
		s := s + TThreadItem(GikoForm.GetActiveContent).Title + #13#10;
	if s <> '' then
		Clipboard.AsText := s;
end;
// *************************************************************************
//! ݕ\ĂXbhURLRs[
// *************************************************************************
procedure TGikoDM.NameURLCopyActionExecute(Sender: TObject);
var
	s: string;
begin
	s := '';
	if TObject(GikoForm.GetActiveContent) is TBoard then
		s := s + TBoard(GikoForm.GetActiveContent).Title + #13#10 + TBoard(GikoForm.GetActiveContent).URL + #13#10
	else if TObject(GikoForm.GetActiveContent) is TThreadItem then
		s := s + TThreadItem(GikoForm.GetActiveContent).Title + #13#10 + TThreadItem(GikoForm.GetActiveContent).URL + #13#10;
	if s <> '' then
		Clipboard.AsText := s;
end;
// *************************************************************************
//! \ĂXbh_E[h
// *************************************************************************
procedure TGikoDM.ItemReloadActionExecute(Sender: TObject);
var
	ThreadItem: TThreadItem;
	shiftDown: Boolean;
begin
	ThreadItem := GikoForm.GetActiveContent;
	shiftDown := GetAsyncKeyState(VK_SHIFT) = Smallint($8001);
	if ThreadItem <> nil then
		GikoForm.DownloadContent(ThreadItem, shiftDown);
end;
// *************************************************************************
//! ݊JĂ^u
// *************************************************************************
procedure TGikoDM.BrowserTabCloseActionExecute(Sender: TObject);
var
	idx: Integer;
begin
	idx := GikoForm.BrowserTab.TabIndex;
	if idx <> -1 then begin
		if GikoForm.BrowserTab.Tabs.Objects[idx] <> nil then begin
			GikoForm.DeleteTab(TBrowserRecord(GikoForm.BrowserTab.Tabs.Objects[idx]));
		end;
	end;
end;
// *************************************************************************
//! ^uPȏ゠ꂪLɂUpdateCxg
// *************************************************************************
procedure TGikoDM.BrowserTabCloseActionUpdate(Sender: TObject);
begin
	TAction(Sender).Enabled := (GikoForm.BrowserTab.Tabs.Count > 0);
end;
// *************************************************************************
//! ݊JĂ^uȊO
// *************************************************************************
procedure TGikoDM.NotSelectTabCloseActionExecute(Sender: TObject);
var
	i: Integer;
	idx: Integer;
begin
	idx := GikoForm.BrowserTab.TabIndex;
	if idx = -1 then Exit;
	GikoForm.BrowserTab.Tabs.BeginUpdate;
	for i := GikoForm.BrowserTab.Tabs.Count - 1 downto GikoForm.BrowserTab.TabIndex + 1 do begin
		TBrowserRecord(GikoForm.BrowserTab.Tabs.Objects[i]).Free;
		GikoForm.BrowserTab.Tabs.Delete(i);
	end;
	if idx > 0 then begin
		for i := GikoForm.BrowserTab.TabIndex - 1 downto 0 do begin
			TBrowserRecord(GikoForm.BrowserTab.Tabs.Objects[i]).Free;
			GikoForm.BrowserTab.Tabs.Delete(i);
		end;
	end;
	GikoForm.BrowserTab.Tabs.EndUpdate;
end;
// *************************************************************************
//! ^uQȏ゠ꂪLɂUpdateCxg
// *************************************************************************
procedure TGikoDM.NotSelectTabCloseActionUpdate(Sender: TObject);
begin
	TAction(Sender).Enabled := (GikoForm.BrowserTab.Tabs.Count > 1);
end;
// *************************************************************************
//! SẴ^u
// *************************************************************************
procedure TGikoDM.AllTabCloseActionExecute(Sender: TObject);
var
	i: Integer;
begin
	if GikoSys.Setting.ShowDialogForAllTabClose then
		if(MessageDlg('SẴ^uĂ낵łH', mtConfirmation,[mbOk, mbCancel], 0) = mrCancel ) then
			Exit;

	GikoForm.ActiveContent := nil;
	GikoForm.BrowserNullTab.Thread := nil;
	GikoForm.BrowserTab.OnChange := nil;
	GikoForm.BrowserTab.Tabs.BeginUpdate;
	for i := GikoForm.BrowserTab.Tabs.Count - 1 downto 0 do begin
		TBrowserRecord(GikoForm.BrowserTab.Tabs.Objects[i]).Free;
	end;
	GikoForm.BrowserTab.Tabs.Clear;
	GikoForm.BrowserTab.Tabs.EndUpdate;
	GikoForm.BrowserTab.OnChange := GikoForm.BrowserTabChange;
	GikoForm.SetContent(GikoForm.BrowserNullTab);
	GikoForm.Caption := CAPTION_NAME ;
end;
// *************************************************************************
//! ݊JĂ^ũXbh폜
// *************************************************************************
procedure TGikoDM.ActiveLogDeleteActionExecute(Sender: TObject);
const
	DEL_MSG = 'g^0h̃O폜܂B낵łH';
	DEL_TITLE = '폜mF';
var
	idx: Integer;
	ThreadItem: TThreadItem;
begin
	idx := GikoForm.BrowserTab.TabIndex;
	if idx <> -1 then begin
		if GikoForm.BrowserTab.Tabs.Objects[idx] <> nil then begin
			ThreadItem := TBrowserRecord(GikoForm.BrowserTab.Tabs.Objects[idx]).Thread;
			if GikoSys.Setting.DeleteMsg then
				if (GetKeyState( VK_SHIFT ) and $80000000) = 0 then
					if MsgBox(GikoForm.Handle, StringReplace( DEL_MSG, '^0', ThreadItem.Title, [rfReplaceAll] ) , DEL_TITLE, MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) <> ID_YES then
						Exit;
			GikoForm.DeleteTab(TBrowserRecord(GikoForm.BrowserTab.Tabs.Objects[idx]));
            GikoForm.DeleteHistory(ThreadItem);
			ThreadItem.DeleteLogFile;
			if ThreadItem.ParentBoard = GikoForm.ActiveList then
				GikoForm.ListView.Refresh;
		end;
	end;
end;
// *************************************************************************
//! ԍ̃^uI
// *************************************************************************
procedure TGikoDM.LeftmostTabSelectActionExecute(Sender: TObject);
begin
	if GikoForm.BrowserTab.Tabs.Count > 0 then begin
		GikoForm.BrowserTab.TabIndex := 0;
		GikoForm.BrowserTab.OnChange(nil);
	end;
end;
// *************************************************************************
//! ̃^uIUpdateCxg
// *************************************************************************
procedure TGikoDM.LeftTabSelectActionUpdate(Sender: TObject);
begin
    if ( not GikoSys.Setting.LoopBrowserTabs ) then begin
        LeftmostTabSelectActionUpdate(Sender);
    end else begin
        TAction(Sender).Enabled := (GikoForm.BrowserTab.Tabs.Count > 1);
    end;
end;

// *************************************************************************
//! ^u̐PȏŁA^ũCfbNXOȊOŗLɂȂUpdateCxg
// *************************************************************************
procedure TGikoDM.LeftmostTabSelectActionUpdate(Sender: TObject);
begin
	TAction(Sender).Enabled := (GikoForm.BrowserTab.Tabs.Count > 0)
								and (GikoForm.BrowserTab.TabIndex <> 0);
end;
// *************************************************************************
//! ̃^uI
// *************************************************************************
procedure TGikoDM.LeftTabSelectActionExecute(Sender: TObject);
begin
	if GikoForm.BrowserTab.Tabs.Count > 0 then begin
		if GikoForm.BrowserTab.TabIndex = -1 then begin
			GikoForm.BrowserTab.TabIndex := 0;
			GikoForm.BrowserTab.OnChange(nil);
		end else if GikoForm.BrowserTab.TabIndex > 0 then begin
			GikoForm.BrowserTab.TabIndex := GikoForm.BrowserTab.TabIndex - 1;
			GikoForm.BrowserTab.OnChange(nil);
		end else begin
            if (GikoSys.Setting.LoopBrowserTabs) and
                (GikoForm.BrowserTab.TabIndex = 0) then begin
    			GikoForm.BrowserTab.TabIndex := GikoForm.BrowserTab.Tabs.Count - 1;
	    		GikoForm.BrowserTab.OnChange(nil);
            end;
        end;
	end;
end;
// *************************************************************************
//! Ẽ^uI
// *************************************************************************
procedure TGikoDM.RightTabSelectActionExecute(Sender: TObject);
begin
	if GikoForm.BrowserTab.Tabs.Count > 0 then begin
		if GikoForm.BrowserTab.TabIndex = -1 then begin
			GikoForm.BrowserTab.TabIndex := GikoForm.BrowserTab.Tabs.Count - 1;
			GikoForm.BrowserTab.OnChange(nil);
		end else if GikoForm.BrowserTab.TabIndex < (GikoForm.BrowserTab.Tabs.Count - 1) then begin
			GikoForm.BrowserTab.TabIndex := GikoForm.BrowserTab.TabIndex + 1;
			GikoForm.BrowserTab.OnChange(nil);
		end else begin
            if (GikoSys.Setting.LoopBrowserTabs) and
                (GikoForm.BrowserTab.TabIndex = (GikoForm.BrowserTab.Tabs.Count - 1)) then begin
    			GikoForm.BrowserTab.TabIndex := 0;
	    		GikoForm.BrowserTab.OnChange(nil);
            end;
        end;
	end;
end;
// *************************************************************************
//! Ẽ^uIUpdateCxg
// *************************************************************************
procedure TGikoDM.RightTabSelectActionUpdate(Sender: TObject);
begin
    if ( not GikoSys.Setting.LoopBrowserTabs ) then begin
        RightmostTabSelectActionUpdate(Sender);
    end else begin
        TAction(Sender).Enabled := (GikoForm.BrowserTab.Tabs.Count > 1);
    end;
end;

// *************************************************************************
//! ԉẼ^uI
// *************************************************************************
procedure TGikoDM.RightmostTabSelectActionExecute(Sender: TObject);
begin
	if GikoForm.BrowserTab.Tabs.Count > 0 then begin
		GikoForm.BrowserTab.TabIndex := GikoForm.BrowserTab.Tabs.Count - 1;
		GikoForm.BrowserTab.OnChange(nil);
	end;
end;
// *************************************************************************
//! ԉẼ^uIUpdateCxg
// *************************************************************************
procedure TGikoDM.RightmostTabSelectActionUpdate(Sender: TObject);
begin
	TAction(Sender).Enabled := (GikoForm.BrowserTab.Tabs.Count > 0)
								and (GikoForm.BrowserTab.TabIndex <> GikoForm.BrowserTab.Tabs.Count - 1);

end;
// *************************************************************************
//! IĂXbhCɓɒǉ
// *************************************************************************
procedure TGikoDM.ThreadFavoriteAddActionExecute(Sender: TObject);
begin
	if TObject(GikoForm.ListView.Selected.Data) is TThreadItem then
		GikoForm.ShowFavoriteAddDialog(TObject(GikoForm.ListView.Selected.Data));
end;
// *************************************************************************
//! XbhꗗŁAXPȏIĂLɂȂUpdateCxg
// *************************************************************************
procedure TGikoDM.ThreadFavoriteAddActionUpdate(Sender: TObject);
begin
	TAction(Sender).Enabled := (GikoForm.GetActiveList is TBoard)
									and (GikoForm.ListView.SelCount > 0);
end;
// *************************************************************************
//! X̓ei荞
// *************************************************************************
procedure TGikoDM.SelectResActionExecute(Sender: TObject);
var
	Dlg: TListSelectDialog;
	FilterList : TStringList;
	idx : Integer;
begin
	Dlg := TListSelectDialog.Create(GikoForm);
	try
		Dlg.SelectComboBox.Items.Assign(GikoSys.Setting.SelectTextList);
		Dlg.SelectComboBox.Text := GikoForm.SelectResWord;
		Dlg.ShowModal;
		if Dlg.ModalResult = mrOK then begin
			SelectResAction.Checked := True;
			if Length( Dlg.SelectComboBox.Text ) = 0 then begin
				// ͂ OK ͍i荞݉ƓӋ`
				ResRangeAction.Execute;
			end else begin
				GikoSys.ResRange := Ord( grrSelect );

				// Ōɐݒ肵̂oĂ
				GikoForm.SelectResWord := Dlg.SelectComboBox.Text;

				// ̍XV
				idx := GikoSys.Setting.SelectTextList.IndexOf(Dlg.SelectComboBox.Text);
				if idx <> -1 then
					GikoSys.Setting.SelectTextList.Delete(idx);
				GikoSys.Setting.SelectTextList.Insert(0, Dlg.SelectComboBox.Text);
				while Dlg.SelectComboBox.Items.Count > 100 do begin
					Dlg.SelectComboBox.Items.Delete(Dlg.SelectComboBox.Items.Count - 1);
				end;

				try
					if GikoForm.SelectComboBoxPanel.Visible then
						GikoForm.SelectComboBox.Items.Assign( GikoSys.Setting.SelectTextList );
				except
				end;

				// tB^̐ݒ
				FilterList := TStringList.Create;
				try
					GikoSys.FSelectResFilter.Reverse := True;
					FilterList.Delimiter := ' '; //؂q𔼊pXy[Xɐݒ
					FilterList.DelimitedText := Dlg.SelectComboBox.Text;

					GikoSys.FSelectResFilter.LoadFromStringList( FilterList );
				finally
					FilterList.Free;
				end;
				GikoForm.RepaintAllTabsBrowser();
			end;
		end else begin
			// LZ
			if GikoSys.ResRange <> Ord( grrSelect ) then
				ResRangeAction.Execute;
		end;
	finally
		Dlg.Release;
	end;

end;
// *************************************************************************
//! SẴX\
// *************************************************************************
procedure TGikoDM.AllResActionExecute(Sender: TObject);
begin
	if(GikoForm.ActiveContent <> nil) and (GikoForm.ActiveContent.Browser <> nil )
		and (GikoForm.ActiveContent.Browser.Busy) then Exit;

	GikoForm.ResRangeMenuSelect	:= Ord( grrAll );
	AllResAction.Checked		:= True;

	//@\͈͂ݒ肷
	SetResRange(Ord( grrAll ));
end;
// *************************************************************************
//! X̕\͈͂ݒ
// *************************************************************************
procedure TGikoDM.ResRangeActionExecute(Sender: TObject);
begin
	case GikoForm.ResRangeMenuSelect of
	Ord( grrAll ):	AllResAction.Execute;
	Ord( grrKoko ):	OnlyKokoResAction.Execute;
	Ord( grrNew ):	OnlyNewResAction.Execute;
	100:			OnlyAHundredResAction.Execute;
	end;

end;
// *************************************************************************
//! ̃Xbh܂ރXbhꗗ\
// *************************************************************************
procedure TGikoDM.UpBoardActionExecute(Sender: TObject);
begin
	GikoForm.SelectTreeNode( GikoForm.GetActiveContent.ParentBoard, True );
end;
// *************************************************************************
//! w肵ԍ̃Xɔ
// *************************************************************************
procedure TGikoDM.JumpToNumOfResActionExecute(Sender: TObject);
var
	str: string;
	res: integer;
begin
	str := '1';
	if( InputQuery('w肵ԍ̃Xɔ', 'ԍ͂Ă', str) ) then begin
		str := ZenToHan(str);
		res := StrToIntDef(str, -1);
		if (res > 0) and (res <= GikoForm.GetActiveContent.Count) then begin
			GikoForm.ActiveContent.Move(IntToStr(res));
			SetFocusForBrowserAction.Execute;
		end else if res > GikoForm.GetActiveContent.Count then begin
			GikoForm.ActiveContent.Move(IntToStr(GikoForm.GetActiveContent.Count));
			SetFocusForBrowserAction.Execute;
		end;
	end;
end;
// *************************************************************************
//! ANeBuȃ^uE
// *************************************************************************
procedure TGikoDM.RightTabCloseActionExecute(Sender: TObject);
var
	i: Integer;
	idx: Integer;
begin
	idx := GikoForm.BrowserTab.TabIndex;
	if idx = -1 then Exit;
	GikoForm.BrowserTab.Tabs.BeginUpdate;
	for i := GikoForm.BrowserTab.Tabs.Count - 1 downto idx + 1 do begin
		TBrowserRecord(GikoForm.BrowserTab.Tabs.Objects[i]).Free;
		GikoForm.BrowserTab.Tabs.Delete(i);
	end;
	GikoForm.BrowserTab.Tabs.EndUpdate;
end;
// *************************************************************************
//! ^u̐QȏŗLUpdateCxg
// *************************************************************************
procedure TGikoDM.RightTabCloseActionUpdate(Sender: TObject);
begin
	TAction(Sender).Enabled := (GikoForm.BrowserTab.Tabs.Count > 1);
end;
// *************************************************************************
//! ANeBuȃ^u荶
// *************************************************************************
procedure TGikoDM.LeftTabCloseActionExecute(Sender: TObject);
var
	i: Integer;
	idx: Integer;
begin
	idx := GikoForm.BrowserTab.TabIndex;
	if idx = -1 then Exit;
	GikoForm.BrowserTab.Tabs.BeginUpdate;
	if idx > 0 then begin
		for i := idx - 1 downto 0 do begin
			TBrowserRecord(GikoForm.BrowserTab.Tabs.Objects[i]).Free;
			GikoForm.BrowserTab.Tabs.Delete(i);
		end;
	end;
	GikoForm.BrowserTab.Tabs.EndUpdate;
end;
////////////////////////////////Xbh܂ł܂/////////////////////
procedure TGikoDM.DataModuleCreate(Sender: TObject);
begin
    // GikoDMKvt@CƂII
    // Ԃɒӂ邱ƁII
    //N̏t@Cݒ
    TDefaultFileManager.CopyDefaultFiles(
        GikoSys.GetAppDir + 'defaultFiles.ini');
end;
// *************************************************************************
//! O_CAO\
// *************************************************************************
procedure TGikoDM.SearchActionExecute(Sender: TObject);
var
	chk: TObject;
begin

	if GikoForm.SearchDialog = nil then begin
		if (GikoForm.GetActiveList is TCategory) or (GikoForm.GetActiveList is TBoard) then
			chk := GikoForm.GetActiveList
		else
			chk := nil;

		GikoForm.SearchDialog := TSearchDialog.Create(GikoForm, chk);
		GikoForm.SearchDialog.SearchComboBox.Items.Assign( GikoSys.Setting.SelectTextList );
	end;

	try
		GikoForm.SearchDialog.Show;
	except
	end;
end;
// *************************************************************************
//! IvV_CAO\
// *************************************************************************
procedure TGikoDM.OptionActionExecute(Sender: TObject);
var
	Dlg: TOptionDialog;
begin
	Dlg := TOptionDialog.Create(GikoForm);
	try
		Dlg.ShowModal;
	finally
		Dlg.Release;
	end;
end;
// *************************************************************************
//! _CAO\
// *************************************************************************
procedure TGikoDM.RoundActionExecute(Sender: TObject);
var
	Dlg: TRoundDialog;
begin
	Dlg := TRoundDialog.Create(GikoForm);
	try
		Dlg.ShowModal;
	finally
		Dlg.Release;
	end;
end;
// *************************************************************************
//! L[ݒ_CAOJ
// *************************************************************************
procedure TGikoDM.KeySettingActionExecute(Sender: TObject);
var
	Dlg: TKeySettingForm;
begin
	Dlg := TKeySettingForm.Create(GikoForm);
	try
		if Dlg.ShowModal = mrOk then begin
			GikoSys.SaveKeySetting(GikoFormActionList, Setting.KEY_SETTING_FILE_NAME);
			GikoSys.SaveKeySetting(Dlg.EditorForm.ActionList, Setting.EKEY_SETTING_FILE_NAME);
			GikoSys.Setting.Gestures.SaveGesture( GikoSys.Setting.GetGestureFileName );
		end;

	finally
		Dlg.Release;
		MouseGesture.UnHook;
		MouseGesture.OnGestureStart := GikoForm.OnGestureStart;
		MouseGesture.OnGestureMove := GikoForm.OnGestureMove;
		MouseGesture.OnGestureEnd := GikoForm.OnGestureEnd;
		if GikoSys.Setting.GestureEnabled then begin
			GikoSys.Setting.Gestures.ClearGesture;
			GikoSys.Setting.Gestures.LoadGesture(
				GikoSys.Setting.GetGestureFileName, GikoFormActionList );
			MouseGesture.SetHook( GikoForm.Handle );
		end;
	end;
end;
// *************************************************************************
//! L[ݒ_CAOJ
// *************************************************************************
procedure TGikoDM.KotehanActionExecute(Sender: TObject);
var
	Dlg: TKotehanDialog;
begin
	Dlg := TKotehanDialog.Create(GikoForm);
	try
		Dlg.ShowModal;
	finally
		Dlg.Release;
	end;
end;
// *************************************************************************
//! c[o[ݒ_CAOJ
// *************************************************************************
procedure TGikoDM.ToolBarSettingActionExecute(Sender: TObject);
var
	Dlg: TToolBarSettingDialog;
	i: Integer;
begin
	Dlg := TToolBarSettingDialog.Create(GikoForm, GikoFormActionList);
	try
		Dlg.AddToolBar(GikoForm.StdToolBar, gttStandard);
		Dlg.AddToolBar(GikoForm.ListToolBar, gttList);
		Dlg.AddToolBar(GikoForm.BrowserToolBar, gttBrowser);
		case GikoForm.ToolBarSettingSender of
		tssMain:		Dlg.ToolBarIndex := 0;
		tssList:		Dlg.ToolBarIndex := 1;
		tssBrowser: Dlg.ToolBarIndex := 2;
		end;
		if Dlg.ShowModal = mrOK then begin
			GikoForm.SetToolBarPopup;

			//œKĐݒ肷邽߂ɓKȃvpeB
			for i := 0 to GikoForm.MainCoolBar.Bands.Count - 1 do begin
				GikoForm.MainCoolBar.Bands[i].MinWidth :=
					GikoForm.MainCoolBar.Bands[i].MinWidth + 1;
				GikoForm.MainCoolBar.Bands[i].MinWidth :=
					GikoForm.MainCoolBar.Bands[i].MinWidth - 1;
			end;
			for i := 0 to GikoForm.ListCoolBar.Bands.Count - 1 do begin
				GikoForm.ListCoolBar.Bands[i].MinWidth :=
					GikoForm.ListCoolBar.Bands[i].MinWidth + 1;
				GikoForm.ListCoolBar.Bands[i].MinWidth :=
					GikoForm.ListCoolBar.Bands[i].MinWidth - 1;
			end;
			for i := 0 to GikoForm.BrowserCoolBar.Bands.Count - 1 do begin
				GikoForm.BrowserCoolBar.Bands[i].MinWidth :=
					GikoForm.BrowserCoolBar.Bands[i].MinWidth + 1;
				GikoForm.BrowserCoolBar.Bands[i].MinWidth :=
					GikoForm.BrowserCoolBar.Bands[i].MinWidth - 1;
			end;

			SaveToolBarSetting(GikoForm.StdToolBar);
			SaveToolBarSetting(GikoForm.ListToolBar);
			//ListToolBarɂ邩ȂiComboBoxzu
			GikoForm.SetSelectComboBox;
			GikoForm.ResetBandInfo( GikoForm.ListCoolBar, GikoForm.ListToolBar );
			SaveToolBarSetting(GikoForm.BrowserToolBar);
		end;
	finally
		Dlg.Release;
		GikoForm.ToolBarSettingSender := tssNone;
	end;
end;
// *************************************************************************
//! ~[g
// *************************************************************************
procedure TGikoDM.MuteActionExecute(Sender: TObject);
begin
	GikoSys.Setting.Mute := not GikoSys.Setting.Mute;
end;
////////////////////////////////c[܂ł܂/////////////////////
// *************************************************************************
//! Xbhꗗ_E[h
// *************************************************************************
procedure TGikoDM.TreeSelectBoradReloadExecute(Sender: TObject);
var
	Board: TBoard;
	TmpTreeNode: TTreeNode;
begin
	TmpTreeNode := GikoForm.ClickNode;
	GikoForm.TreeView.Selected := GikoForm.ClickNode;
	Board := nil;

	if TObject(TmpTreeNode.Data) is TBoard then
		Board := TBoard(TmpTreeNode.Data)
	else if TObject(TmpTreeNode.Data) is TFavoriteBoardItem then
		Board := TFavoriteBoardItem(TmpTreeNode.Data).Item;

	if Board <> nil then
		GikoForm.DownloadList(Board);
end;
// *************************************************************************
//! IꂽXbh_E[h
// *************************************************************************
procedure TGikoDM.TreeSelectThreadReloadExecute(Sender: TObject);
var
	ThreadItem: TThreadItem;
	TmpTreeNode: TTreeNode;
begin
	TmpTreeNode := GikoForm.ClickNode;
	GikoForm.TreeView.Selected := GikoForm.ClickNode;
	ThreadItem := nil;

	if TObject(TmpTreeNode.Data) is TThreadItem then
		ThreadItem := TThreadItem(TmpTreeNode.Data)
	else if TObject(TmpTreeNode.Data) is TFavoriteThreadItem then
		ThreadItem := TFavoriteThreadItem(TmpTreeNode.Data).Item;

	if ThreadItem <> nil then
		GikoForm.DownloadContent(ThreadItem);
end;
// *************************************************************************
//! IꂽURLRs[
// *************************************************************************
procedure TGikoDM.TreeSelectURLCopyExecute(Sender: TObject);
var
	TmpTreeNode: TTreeNode;
	s: string;
begin
	TmpTreeNode := GikoForm.ClickNode;
	GikoForm.TreeView.Selected := GikoForm.ClickNode;
	if TObject(TmpTreeNode.Data) is TBoard then begin
		s := TBoard(TmpTreeNode.Data).URL + #13#10;
	end else if TObject(TmpTreeNode.Data) is TFavoriteBoardItem then begin
		s := TFavoriteBoardItem(TmpTreeNode.Data).URL + #13#10;
	end else if (TObject(TmpTreeNode.Data) is TThreadItem) then begin
		s := TThreadItem(TmpTreeNode.Data).URL + #13#10;
	end else if TObject(TmpTreeNode.Data) is TFavoriteThreadItem then begin
		s := TFavoriteThreadItem(TmpTreeNode.Data).URL + #13#10;
	end;
	Clipboard.AsText := s;
end;
// *************************************************************************
//! Iꂽ̖OURLRs[
// *************************************************************************
procedure TGikoDM.TreeSelectNameURLCopyExecute(Sender: TObject);
var
	TmpTreeNode: TTreeNode;
	s: string;
begin
	TmpTreeNode := GikoForm.ClickNode;
	GikoForm.TreeView.Selected := GikoForm.ClickNode;
	if TObject(TmpTreeNode.Data) is TBoard then begin
		s := TBoard(TmpTreeNode.Data).Title + #13#10 + TBoard(TmpTreeNode.Data).URL + #13#10;
	end else if TObject(TmpTreeNode.Data) is TFavoriteBoardItem then begin
		s := TFavoriteBoardItem(TmpTreeNode.Data).Item.Title + #13#10 + TFavoriteBoardItem(TmpTreeNode.Data).URL + #13#10;
	end else if (TObject(TmpTreeNode.Data) is TThreadItem) then begin
		s := TThreadItem(TmpTreeNode.Data).Title + #13#10 + TThreadItem(TmpTreeNode.Data).URL + #13#10;
	end else if TObject(TmpTreeNode.Data) is TFavoriteThreadItem then begin
		s := TFavoriteThreadItem(TmpTreeNode.Data).Item.Title + #13#10 + TFavoriteThreadItem(TmpTreeNode.Data).URL + #13#10;
	end;
	Clipboard.AsText := s;
end;
// *************************************************************************
//! Cɓɒǉ
// *************************************************************************
procedure TGikoDM.TreeSelectFavoriteAddActionExecute(Sender: TObject);
begin
	GikoForm.ShowFavoriteAddDialog(TObject(GikoForm.ClickNode.Data));
end;
// *************************************************************************
//! 
// *************************************************************************
procedure TGikoDM.TreeSelectSearchBoardNameExecute(Sender: TObject);
var
	s : String;
	msg : String;
	CurItem : TTreeNode;
	next : boolean;
begin
	if InputQuery('','̓',s) then begin
		next := true;
		while next do begin
			if GikoForm.TreeView.Selected = nil then
				CurItem := GikoForm.TreeView.Items.GetFirstNode
			else begin
				CurItem := GikoForm.TreeView.Selected.GetNext;
				if CurItem = nil then
					CurItem := GikoForm.TreeView.Items.GetFirstNode;
			end;
			while CurItem <> nil do begin
				if (CurItem.ImageIndex <> 2) and (VaguePos(s,CurItem.Text) <> 0) then begin
					break;
				end;
				CurItem := CurItem.GetNext;
			end;
			try
				if CurItem = nil then begin
					msg := '擪ɖ߂܂H';
					if MsgBox(GikoForm.Handle, msg, '', MB_YESNO or MB_ICONEXCLAMATION) = mrYes	then begin
						CurItem := GikoForm.TreeView.Items.GetFirstNode;
					end else begin
						Exit;
					end;
					GikoForm.TreeView.Select(CurItem);
					GikoForm.TreeView.SetFocus;
				end else begin
					GikoForm.TreeView.Select(CurItem);
					GikoForm.TreeView.SetFocus;
					msg := 'ɍs܂H';
					if MsgBox(GikoForm.Handle, msg, '', MB_YESNO or MB_ICONEXCLAMATION) = mrYes	then begin
						next := true;
					end else begin
						next := false;
					end;
				end;

			except
				Exit;
			end;
		end;
	end;
end;
// *************************************************************************
//! Iꂽ̖ORs[
// *************************************************************************
procedure TGikoDM.TreeSelectNameCopyExecute(Sender: TObject);
var
	s: string;
begin
	GikoForm.TreeView.Selected := GikoForm.ClickNode;
	s := GikoForm.ClickNode.Text;
	Clipboard.AsText := s;
end;
////////////////////////////////c[|bvAbv܂ł܂/////////////////////
// *************************************************************************
//! OC^OAEg
// *************************************************************************
procedure TGikoDM.LoginActionExecute(Sender: TObject);
var
	TmpCursor: TCursor;
	msg : String;
begin
	if GikoSys.Dolib.Connected then begin
		//OAEg
		GikoSys.Dolib.Disconnect;
		LoginAction.Checked := False;
		GikoForm.AddMessageList(GikoSys.GetGikoMessage(gmLogout), nil, gmiOK);
		LoginAction.Caption := 'OC(&L)';
	end else begin
		TmpCursor := GikoForm.ScreenCursor;
		GikoForm.ScreenCursor := crHourGlass;
		try
			//ʏ탍OC
			if not GikoSys.Setting.ForcedLogin then begin
				GikoSys.Dolib.ClientUA := 'gikoNavi/1.00';
				GikoSys.Dolib.UserName := GikoSys.Setting.UserID;
				GikoSys.Dolib.Password := GikoSys.Setting.Password;
				if GikoSys.Setting.ReadProxy then begin
					GikoSys.Dolib.ProxyAddress := GikoSys.Setting.ReadProxyAddress;
					GikoSys.Dolib.ProxyPort := GikoSys.Setting.ReadProxyPort;
				end else begin
					GikoSys.Dolib.ProxyAddress := '';
					GikoSys.Dolib.ProxyPort := 0;
				end;
				if GikoSys.Dolib.Connect then begin
					LoginAction.Checked := True;
					GikoForm.AddMessageList(GikoSys.GetGikoMessage(gmLogin) + GikoSys.Setting.UserID, nil, gmiOK);
					LoginAction.Caption := 'OAEg(&L)';
					//LoginToolButton.Style := tbsCheck;
				end else begin
		//			MsgBox(Handle, 'OCo܂ł', 'G[', MB_OK or MB_ICONSTOP);
					GikoForm.AddMessageList(GikoSys.Dolib.ErrorMsg, nil, gmiNG);
					GikoForm.PlaySound('Error');
					LoginAction.Checked := False;
					//LoginToolButton.Down := False;
					///LoginToolButton.Style := tbsButton;
				end;
			end else begin
				msg := 'OC[hł́CT[ȍ̗ؖL`FbN܂B' + #13#10
						+ 'UT[ȍꍇAȂ̃pX[h܂\܂B' + #13#10
						+ '̃[hŃOC݂܂H' + #13#10;
				if MsgBox(GikoForm.Handle, msg, 'x', MB_YESNO or MB_ICONEXCLAMATION) = IDYES	 then begin
					GikoSys.Dolib.ClientUA := 'gikoNavi/1.00';
					GikoSys.Dolib.UserName := GikoSys.Setting.UserID;
					GikoSys.Dolib.Password := GikoSys.Setting.Password;
					if GikoSys.Setting.ReadProxy then begin
						GikoSys.Dolib.ProxyAddress := GikoSys.Setting.ReadProxyAddress;
						GikoSys.Dolib.ProxyPort := GikoSys.Setting.ReadProxyPort;
					end else begin
						GikoSys.Dolib.ProxyAddress := '';
						GikoSys.Dolib.ProxyPort := 0;
					end;
					//SSLQpOC
					GikoSys.Dolib.ForcedConnect;
					if GikoSys.Dolib.Connect then begin
						LoginAction.Checked := True;
						GikoForm.AddMessageList(GikoSys.GetGikoMessage(gmForceLogin) + GikoSys.Setting.UserID, nil, gmiOK);
						LoginAction.Caption := 'OAEg(&L)';
						//LoginToolButton.Style := tbsCheck;
						end else begin
			//			MsgBox(Handle, 'OCo܂ł', 'G[', MB_OK or MB_ICONSTOP);
						GikoForm.AddMessageList(GikoSys.Dolib.ErrorMsg, nil, gmiNG);
						GikoForm.PlaySound('Error');
						LoginAction.Checked := False;
						//LoginToolButton.Down := False;
						//LoginToolButton.Style := tbsButton;
					end;
				end else begin
					LoginAction.Checked := False;
					//LoginToolButton.Down := False;
					//LoginToolButton.Style := tbsButton;
				end;
			end;
		finally
			GikoForm.ScreenCursor := TmpCursor;
		end;
	end;
end;
// *************************************************************************
//! {[hXV_CAO\
// *************************************************************************
procedure TGikoDM.NewBoardActionExecute(Sender: TObject);
var
	Dlg: TNewBoardDialog;
	Msg: string;
begin
	if (EditorFormExists) then begin
		Msg := 'XGfB^SĕĂ';
		MsgBox(GikoForm.Handle, Msg, MSG_ERROR, MB_OK or MB_ICONSTOP);
		Exit;
	end;
	Dlg := TNewBoardDialog.Create(GikoForm);
	try
		Dlg.ShowModal;
	finally
		Dlg.Release;
	end;
end;
// *************************************************************************
//! IĂXbh폜
// *************************************************************************
procedure TGikoDM.LogDeleteActionExecute(Sender: TObject);
const
	DEL_MSG = 'g^0h̃O폜܂B낵łH';
	DEL_SAME_MSG = ' ^0 ̃Xbh̃O폜܂B낵łH';
	DEL_TITLE = '폜mF';
var
	ThreadItem: TThreadItem;
	TmpListItem: TListItem;
	List: TList;
	i: Integer;
begin
	List := TList.Create;
	try
		TmpListItem := GikoForm.ListView.Selected;
		while TmpListItem <> nil do begin
			if TObject(TmpListItem.Data) is TThreadItem then begin
				ThreadItem := TThreadItem(TmpListItem.Data);
				if ThreadItem.IsLogFile then
					List.Add(ThreadItem);
			end;
			TmpListItem := GikoForm.ListView.GetNextItem(TmpListItem, sdAll, [isSelected]);
		end;

		if GikoSys.Setting.DeleteMsg and (List.Count > 0) then begin
			if (GetKeyState( VK_SHIFT ) and $80000000) = 0 then begin
				if List.Count = 1 then begin
					if MsgBox(GikoForm.Handle, StringReplace( DEL_MSG, '^0', TThreadItem( List[ 0 ] ).Title, [rfReplaceAll] ) , DEL_TITLE, MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) <> ID_YES then
						Exit;
				end else begin
					if MsgBox(GikoForm.Handle, StringReplace( DEL_SAME_MSG, '^0', IntToStr( List.Count ), [rfReplaceAll] ), DEL_TITLE, MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) <> IDYES then
						Exit;
				end;
			end;
		end;

		for i := 0 to List.Count - 1 do begin
			ThreadItem := TThreadItem(List[i]);
			GikoForm.DeleteHistory(ThreadItem);
			GikoForm.DeleteTab(ThreadItem);
			ThreadItem.DeleteLogFile;
		end;
        GikoForm.TreeView.Refresh;	// UnRead ̕\XV
		GikoForm.ListView.Refresh;
	finally
		List.Free;
	end;
end;
// *************************************************************************
//! ActiveListTBoardŃXꗗłPȏIĂƗLɂȂActionŋ
// *************************************************************************
procedure TGikoDM.LogDeleteActionUpdate(Sender: TObject);
begin
	TAction(Sender).Enabled := (GikoForm.GetActiveList is TBoard)
								and (GikoForm.ListView.SelCount > 0);
end;
// *************************************************************************
//! iݗ
// *************************************************************************
procedure TGikoDM.SelectTextClearActionExecute(Sender: TObject);
const
	DEL_MSG = 'iݑS폜܂B낵łH';
	DEL_TITLE = '폜mF';
begin
	if (GetKeyState( VK_SHIFT ) and $80000000) = 0 then
		if MsgBox(GikoForm.Handle, DEL_MSG, DEL_TITLE, MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) <> ID_YES then
			Exit;
	GikoSys.Setting.SelectTextList.Clear;
	GikoForm.SelectComboBox.Items.Clear;
	GikoForm.SelectComboBox.Text := '';
	GikoForm.SetListViewType( gvtAll );
end;
// *************************************************************************
//! XGfB^̖O
// *************************************************************************
procedure TGikoDM.NameTextClearActionExecute(Sender: TObject);
const
	DEL_MSG = 'XGfB^OS폜܂B낵łH';
	DEL_TITLE = '폜mF';
begin
	if (GetKeyState( VK_SHIFT ) and $80000000) = 0 then
		if MsgBox(GikoForm.Handle, DEL_MSG, DEL_TITLE, MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) <> ID_YES then
			Exit;
	GikoSys.Setting.NameList.Clear;
	ClearNameTextAllEditor
end;
// *************************************************************************
//! XGfB^̃[
// *************************************************************************
procedure TGikoDM.MailTextClearActionExecute(Sender: TObject);
const
	DEL_MSG = 'XGfB^[S폜܂B낵łH';
	DEL_TITLE = '폜mF';
begin
	if (GetKeyState( VK_SHIFT ) and $80000000) = 0 then
		if MsgBox(GikoForm.Handle, DEL_MSG, DEL_TITLE, MB_YESNO or MB_ICONWARNING or MB_DEFBUTTON2) <> ID_YES then
			Exit;
	GikoSys.Setting.MailList.Clear;
	ClearMailAllEditor;
end;
// *************************************************************************
//! MRirI
// *************************************************************************
procedure TGikoDM.ExitActionExecute(Sender: TObject);
begin
	GikoForm.Close;
end;
// *************************************************************************
//! Cɓ̃GNX|[g@sO
// *************************************************************************
procedure TGikoDM.ExportFavoriteFileBeforeExecute(Sender: TObject);
begin
	ExportFavoriteFile.Dialog.FileName := FavoriteDM.GetFavoriteFilePath;
end;
// *************************************************************************
//! Cɓ̃GNX|[g@s
// *************************************************************************
procedure TGikoDM.ExportFavoriteFileAccept(Sender: TObject);
begin
	if FavoriteDM.SaveFavoriteFile( ExportFavoriteFile.Dialog.FileName ) Then begin
		ShowMessage('t@Co͂܂');
	end else begin
		ShowMessage('t@C̏o͂Ɏs܂');
	end;
end;
// *************************************************************************
//! IXbht@Cɕۑ
// *************************************************************************
procedure TGikoDM.SelectThreadSaveToFile(dat: Boolean);
var
	List: TList;
	i: Integer;
	html: TStringList;
	title: string;
begin
	List := TList.Create;
	try
		GikoForm.ScreenCursor := crHourGlass;
		GikoForm.SelectListItem(List);
		if ((GikoSys.Setting.ListOrientation = gloVertical) and
			(GikoSys.Setting.ListHeightState = glsMax)) or
			((GikoSys.Setting.ListOrientation = gloHorizontal) and
			(GikoSys.Setting.ListWidthState = glsMax))	then
			ShowMessage('Xbhꗗ\Ă')
		else if(List.Count = 0) then
			ShowMessage('XbhIĂ')
		else begin
			if dat then begin
				SaveDialog.Title := 'IXbhdat̂܂ܕۑ';
				SaveDialog.Filter := 'DATt@C(*.dat)|*.dat';
			end else begin
				SaveDialog.Title := 'IXbhHTMLĕۑ';
				SaveDialog.Filter := 'HTMLt@C(*.html)|*.html';
			end;
			for i := 0 to List.Count - 1 do begin
				if (TObject(List[i]) is TThreadItem) and (TThreadItem(List[i]).IsLogFile) then begin
					if dat then begin
						SaveDialog.FileName := TThreadItem(List[i]).FileName;
					end else begin
						SaveDialog.FileName := ReplaseNoValidateChar(TThreadItem(List[i]).Title) + '.html';
					end;
					if SaveDialog.Execute then begin
						if dat then begin
							CopyFile(PChar(TThreadItem(List[i]).FilePath),
									PChar(SaveDialog.FileName), true);
						end else begin
							html := TStringList.Create;
							title := TThreadItem(List[i]).Title;
							try
								HTMLCreater.CreateHTML3(html, TThreadItem(List[i]), title);
								html.SaveToFile(SaveDialog.FileName);
								THTMLCreate.SkinorCSSFilesCopy(ExtractFilePath(SaveDialog.FileName));
							finally
								html.Free;
							end;
						end;
					end;
				end;
			end;
		end;
	finally
		GikoForm.ScreenCursor := crDefault;
		List.Free;
	end;
end;
// *************************************************************************
//! IXbhHTMLĕۑ
// *************************************************************************
procedure TGikoDM.SelectItemSaveForHTMLExecute(Sender: TObject);
begin
	SelectThreadSaveToFile(false);
end;
// *************************************************************************
//! IXbhDAT`̂܂ܕۑ
// *************************************************************************
procedure TGikoDM.SelectItemSaveForDatExecute(Sender: TObject);
begin
	SelectThreadSaveToFile(true);
end;
// *************************************************************************
//! ^ȕԂۑ
// *************************************************************************
procedure TGikoDM.TabsSaveActionExecute(Sender: TObject);
const
	Filename = 'tab.sav';
	bFilename = '~tab.sav';
var
	SaveStringList: TStringList;
begin
	SaveStringList := TStringList.Create;
	try
		GetTabURLs(SaveStringList);
        try
            if FileExists( GikoSys.GetAppDir + Filename) then begin
                CopyFile(PChar(GikoSys.GetAppDir + Filename),
                    PChar(GikoSys.GetAppDir + bFilename), False);
            end;
        except
        end;
        SaveStringList.SaveToFile(GikoSys.GetAppDir + Filename);
	finally
		SaveStringList.Free;
	end;
end;
// *************************************************************************
//! uEU^uɐݒ肳ĂXbhURL擾
// *************************************************************************
procedure TGikoDM.GetTabURLs(AStringList: TStringList);
var
  rec : TBrowserRecord;
  i : Integer;
begin
    for i := 0 to GikoForm.BrowserTab.Tabs.Count -1 do begin
        try
            rec := TBrowserRecord( GikoForm.BrowserTab.Tabs.Objects[ i ] );
            if( rec <> nil) and (rec.Thread <> nil) then
                AStringList.Add( rec.Thread.URL );
        except
        end;
    end;
end;
// *************************************************************************
//! w肳ꂽURLJC擪̃^uɃtH[JX
// *************************************************************************
procedure TGikoDM.OpenURLs(AStringList: TStringList);
var
    GikoTab			: TGikoTabAppend;
    i, bound : Integer;
   	item        : TThreadItem;
begin
    if (AStringList <> nil) then begin
        GikoTab := GikoSys.Setting.BrowserTabAppend;
        try
            bound    := AStringList.Count - 1;
            if bound > -1 then begin
                GikoSys.Setting.BrowserTabAppend := gtaLast;
                for i := 0 to bound do begin
                    item := BBSsFindThreadFromURL( AStringList[ i ] );
                    if item <> nil then
                        GikoForm.InsertBrowserTab( item, false );
                end;
                //ŏ̂Pɐݒ
                if (GikoSys.Setting.URLDisplay) and
                    (GikoForm.BrowserTab.Tabs.Count > 0) then begin
					GikoForm.AddressComboBox.Text :=
                        TBrowserRecord(GikoForm.BrowserTab.Tabs.Objects[0]).Thread.URL;
                end;
            end;
        finally
            GikoSys.Setting.BrowserTabAppend := GikoTab;
        end;
    end;
end;
// *************************************************************************
//! ^ȕԂ𕜌
// *************************************************************************
procedure TGikoDM.TabsOpenActionExecute(Sender: TObject);
const
	TABFILE = 'tab.sav';
var
	URLs				: TStringList;
	fileName		: string;
begin
    URLs := TStringList.Create();
	try
       	fileName := GikoSys.GetAppDir + TABFILE;
		if FileExists(fileName) then begin
		    try
				URLs.LoadFromFile(fileName);
                if (URLs.Count = 0) then begin
                    // ̃t@C̏ꍇCobNAbv폜Ȃ߂ɍ폜
                    SysUtils.DeleteFile(fileName);
                end else begin
                    OpenURLs(URLs);
                end;
    		except
	    		on EFOpenError do ShowMessage('^ut@CJ܂');
            end;
        end;
	finally
        URLs.Free;
	end;

    if (GikoForm.BrowserTab.Tabs.Count = 0) and
        (TabsOpenAction.Tag <> 1) then  begin
        ShowMessage('\^u܂B');
    end;
end;
// *************************************************************************
//! Be2chɃOC/OAEg
// *************************************************************************
procedure TGikoDM.BeLogInOutActionExecute(Sender: TObject);
var
	TmpCursor: TCursor;
	msg : String;
begin
	if GikoSys.Belib.Connected then begin
		//OAEg
		GikoSys.Belib.Disconnect;
		BeLogInOutAction.Checked := False;
		GikoForm.AddMessageList(GikoSys.GetGikoMessage(gmBeLogout), nil, gmiOK);
	end else begin
		TmpCursor := GikoForm.ScreenCursor;
		GikoForm.ScreenCursor := crHourGlass;
		try
			GikoSys.Belib.ClientUA := 'gikoNavi/1.00';
			GikoSys.Belib.UserName := GikoSys.Setting.BeUserID;
			GikoSys.Belib.Password := GikoSys.Setting.BePassword;
            if GikoSys.Setting.ReadProxy then begin
				GikoSys.Belib.ProxyAddress := GikoSys.Setting.ReadProxyAddress;
				GikoSys.Belib.ProxyPort := GikoSys.Setting.ReadProxyPort;
			end else begin
                GikoSys.Belib.ProxyAddress := '';
				GikoSys.Belib.ProxyPort := 0;
            end;
            if GikoSys.Belib.Connect then begin
                GikoForm.AddMessageList(GikoSys.GetGikoMessage(gmBeLogin) + GikoSys.Setting.BeUserID, nil, gmiOK);
                BeLogInOutAction.Checked := True;
            end else begin
                GikoForm.AddMessageList(GikoSys.Belib.ErrorMsg, nil, gmiNG);
                GikoForm.PlaySound('Error');
                BeLogInOutAction.Checked := False;
			end;
		finally
			GikoForm.ScreenCursor := TmpCursor;
		end;
	end;
end;
////////////////////////////////t@C܂ł܂/////////////////////
// *************************************************************************
//! RR܂œǂ
// *************************************************************************
procedure TGikoDM.KokomadeActionExecute(Sender: TObject);
var
	No: Integer;
	ThreadItem: TThreadItem;
begin
	No := GikoForm.KokoPopupMenu.Tag;
	if No = 0
        then Exit;
	ThreadItem := GikoForm.KokoPopupThreadItem;
	if not Assigned(ThreadItem) then
        Exit;
	ThreadItem.Kokomade := No;
	GikoForm.ActiveContent.Thread.ScrollTop := GikoForm.ActiveContent.Browser.OleObject.Document.Body.ScrollTop;
	GikoForm.ActiveContent.Repaint := true;
	GikoForm.InsertBrowserTab(GikoForm.ActiveContent.Thread, true);
	//INFO 2005/11/19 UBAKvȂGikoForm̕Ƀ\bhǉ
	//Application.ProcessMessages;
end;
// *************************************************************************
//! Sǂ
// *************************************************************************
procedure TGikoDM.ZenbuActionExecute(Sender: TObject);
var
	ThreadItem: TThreadItem;
begin
	ThreadItem := GikoForm.GetActiveContent(True);
	if ThreadItem = nil then Exit;
	ThreadItem.Kokomade := -1;
	GikoForm.ActiveContent.Thread.ScrollTop := GikoForm.ActiveContent.Browser.OleObject.Document.Body.ScrollTop;
	GikoForm.ActiveContent.Repaint := true;
	GikoForm.InsertBrowserTab(GikoForm.ActiveContent.Thread, true);
	//INFO 2005/11/19 UBAKvȂGikoForm̕Ƀ\bhǉ
	//Application.ProcessMessages;
end;
// *************************************************************************
//! RRɃX
// *************************************************************************
procedure TGikoDM.KokoResActionExecute(Sender: TObject);
var
	Editor: TEditorForm;
	Item: TThreadItem;
	Number: Integer;
begin
	Number := GikoForm.KokoPopupMenu.Tag;
	if Number = 0 then Exit;
	Item := GikoForm.KokoPopupThreadItem;
	if Item = nil then Exit;

	Editor := TEditorForm.Create(GikoForm);
	Editor.SetThreadItem(Item);
	Editor.BodyEdit.Text := '>>' + IntToStr(Number) + #13#10;
	Editor.Show;
	Editor.BodyEdit.SetFocus;
end;
// *************************************************************************
//! IXRs[
// *************************************************************************
procedure TGikoDM.KoreCopyExecute(Sender: TObject);
begin
	GikoForm.KonoresCopy(GikoForm.KokoPopupMenu.Tag, true);
end;
// *************************************************************************
//! IXRs[
// *************************************************************************
procedure TGikoDM.SameIDResAnchorActionExecute(Sender: TObject);
const
    LIMIT = 20;
var
	ThreadItem : TThreadItem;
	No : Integer;
	AID: string;
begin
	No := GikoForm.KokoPopupMenu.Tag;
	if No = 0 then Exit;
	ThreadItem := GikoForm.KokoPopupThreadItem;
	if ThreadItem = nil then Exit;

    AID := GikoSys.GetResID(No, ThreadItem);
    if not IsNoValidID(AID) then begin
        GikoForm.ShowSameIDAncher(AID);
    end;
end;
// *************************************************************************
//! ̃Xځ`@iʏj
// *************************************************************************
procedure TGikoDM.IndividualAbon1ActionExecute(Sender: TObject);
begin
	GikoForm.IndividualAbon(GikoForm.KokoPopupMenu.Tag, 1);
end;
// *************************************************************************
//! ̃Xځ`@ij
// *************************************************************************
procedure TGikoDM.IndividualAbon0ActionExecute(Sender: TObject);
begin
	GikoForm.IndividualAbon(GikoForm.KokoPopupMenu.Tag, 0);
end;
// *************************************************************************
//! ̃Xځ`
// *************************************************************************
procedure TGikoDM.AntiIndividualAbonActionExecute(Sender: TObject);
var
	IndividualForm :TIndividualAbonForm;
	ThreadItem : TThreadItem;
	msg : String;
	ReadList		: TStringList;
	wordCount		: TWordCount;
begin
	IndividualForm := TIndividualAbonForm.Create(GikoForm);
	try
		ThreadItem := GikoForm.GetActiveContent(True);
		ThreadItem.ScrollTop := GikoForm.ActiveContent.Browser.OleObject.Document.Body.ScrollTop;
		if (ThreadItem <> nil) and (ThreadItem.IsLogFile) then begin
			if IndividualForm.SetThreadLogFileName(ThreadItem.GetThreadFileName) then begin
				ReadList		:= TStringList.Create;
				wordCount		:= TWordCount.Create;
				try
{$IFDEF SPAM_FILTER_ENABLED}
					// Xp
					ReadList.LoadFromFile( ThreadItem.GetThreadFileName );
					GikoSys.SpamCountWord( ReadList[ KokoPopupMenu.Tag - 1 ], wordCount );
					GikoSys.SpamForget( wordCount, True );	// Xp
					GikoSys.SpamLearn( wordCount, False );	// nɐݒ
{$ENDIF}
					if IndividualForm.DeleteNG(GikoForm.KokoPopupMenu.Tag) then begin
						GikoForm.ActiveContent.Repaint := true;
						GikoForm.InsertBrowserTab( ThreadItem, True );
					end;
				finally
					wordCount.Free;
					ReadList.Free;
				end;
			end else begin
				msg := '̃Xbhł͌ʂځ`sĂ܂';
				MsgBox(GikoForm.Handle, msg, 'bZ[W', MB_OK);
			end;
		end;
	finally
		IndividualForm.Release;
	end;
end;
// *************************************************************************
//! ̃Xځ`Xԍwi_CAO\j
// *************************************************************************
procedure TGikoDM.AntiIndividualAbonDlgActionExecute(Sender: TObject);
var
	IndividualForm :TIndividualAbonForm;
	ThreadItem : TThreadItem;
	msg : String;
	ReadList		: TStringList;
	wordCount		: TWordCount;
{$IFDEF SPAM_FILTER_ENABLED}
	i : Integer;
{$ENDIF}
begin
	IndividualForm := TIndividualAbonForm.Create(GikoForm);
	try
		ThreadItem := GikoForm.GetActiveContent(True);
		ThreadItem.ScrollTop := GikoForm.ActiveContent.Browser.OleObject.Document.Body.ScrollTop;
		if (ThreadItem <> nil) and (ThreadItem.IsLogFile) then begin
			if IndividualForm.SetThreadLogFileName(ThreadItem.GetThreadFileName) then begin
				if (IndividualForm.ShowModal = mrOK) then begin
					ReadList		:= TStringList.Create;
					wordCount		:= TWordCount.Create;
					try
{$IFDEF SPAM_FILTER_ENABLED}
						// Xp
						ReadList.LoadFromFile( ThreadItem.GetThreadFileName );
						for i := 0 to IndividualForm.DeleteList.Count - 1 do begin
							GikoSys.SpamCountWord( ReadList[ StrToInt(IndividualForm.DeleteList[i]) - 1 ], wordCount );
							GikoSys.SpamForget( wordCount, True );	// Xp
							GikoSys.SpamLearn( wordCount, False );	// nɐݒ
						end;
{$ENDIF}
						if IndividualForm.FRepaint then begin
							GikoForm.ActiveContent.Repaint := true;
							GikoForm.InsertBrowserTab( ThreadItem, True );
						end;
					finally
						wordCount.Free;
						ReadList.Free;
					end;
				end;
			end else begin
				msg := '̃Xbhł͌ʂځ`sĂ܂';
				MsgBox(GikoForm.Handle, msg, 'bZ[W', MB_OK);
			end;
		end;
	finally
		IndividualForm.Release;
	end;
end;
// *************************************************************************
//! IDځ`@ʏ
// *************************************************************************
procedure TGikoDM.IndividualAbonID1ActionExecute(Sender: TObject);
begin
	GikoForm.IndividualAbonID(1);
end;
// *************************************************************************
//! IDځ`@
// *************************************************************************
procedure TGikoDM.IndividualAbonID0ActionExecute(Sender: TObject);
begin
	GikoForm.IndividualAbonID(0);
end;
////////////////////////////////uEU|bvAbv܂ł܂/////////////////////
// *************************************************************************
//! MRir̃EFuTCg\
// *************************************************************************
procedure TGikoDM.GikoNaviWebPageActionExecute(Sender: TObject);
begin
	GikoSys.OpenBrowser(PROTOCOL_HTTP + URL_GIKONAVI, gbtAuto);
end;
// *************************************************************************
//! MRir()̃EFuTCg\
// *************************************************************************
procedure TGikoDM.GikoNaviGoesonWebPageActionExecute(Sender: TObject);
begin
	GikoSys.OpenBrowser(PROTOCOL_HTTP + URL_GIKONAVIGO, gbtAuto);
end;
// *************************************************************************
//! iW̃EFuTCg\
// *************************************************************************
procedure TGikoDM.MonazillaWebPageActionExecute(Sender: TObject);
begin
	GikoSys.OpenBrowser(PROTOCOL_HTTP + URL_MONAZILLA, gbtAuto);
end;
// *************************************************************************
//! Q˂gbvy[W\
// *************************************************************************
procedure TGikoDM.BBS2chWebPageActionExecute(Sender: TObject);
begin
	GikoSys.OpenBrowser(PROTOCOL_HTTP + URL_2ch, gbtAuto);
end;
// *************************************************************************
//! MRir̃tH_J
// *************************************************************************
procedure TGikoDM.GikoFolderOpenActionExecute(Sender: TObject);
begin
	GikoSys.CreateProcess('explorer.exe', '/e,"' + GikoSys.GetAppDir + '"');
end;
// *************************************************************************
//! o[W\
// *************************************************************************
procedure TGikoDM.AboutActionExecute(Sender: TObject);
var
	Dlg: TAboutDialog;
begin
	Dlg := TAboutDialog.Create(GikoForm);
	try
		Dlg.ShowModal;
	finally
		Dlg.Release;
	end;
end;
// *************************************************************************
//! MRir̃wv\
// *************************************************************************
procedure TGikoDM.GikoHelpActionExecute(Sender: TObject);
var
	FileName: string;
begin
	FileName := GikoSys.GetAppDir + 'batahlp.chm';
	if not FileExists(FileName) then begin
		MsgBox(
			GikoForm.Handle,
			'wv܂ł' + #13#10 +
			'wvt@CMRir̃tH_ɒuĂ' + #13#10 +
			'wv̓MRir̃TCgɒuĂ܂',
			MSG_ERROR,
			MB_ICONSTOP);
		Exit;
	end;
	ShellExecute(GikoForm.Handle, 'open', PChar(FileName), '', PChar(GikoSys.GetAppDir), SW_SHOW);
end;
// *************************************************************************
//! MRirWikĩEFuTCg\
// *************************************************************************
procedure TGikoDM.WikiFAQWebPageActionExecute(Sender: TObject);
begin
	GikoSys.OpenBrowser(PROTOCOL_HTTP + URL_Wiki, gbtAuto);
end;
// *************************************************************************
//! MRir()WikĩEFuTCg\
// *************************************************************************
procedure TGikoDM.GoWikiFAQWebPageActionExecute(Sender: TObject);
begin
	GikoSys.OpenBrowser(PROTOCOL_HTTP + URL_GoWiki, gbtAuto);
end;
////////////////////////////////wv܂ł܂/////////////////////
// *************************************************************************
//! Xgԍ\ύX
// *************************************************************************
procedure TGikoDM.ListNumberVisibleActionExecute(Sender: TObject);
begin
	GikoSys.Setting.ListViewNo := ListNumberVisibleAction.Checked;
	GikoForm.ListView.Refresh;
end;
// *************************************************************************
//! ʃtH_Ɉړ
// *************************************************************************
procedure TGikoDM.UpFolderActionExecute(Sender: TObject);
begin
	if GikoForm.GetActiveList is TBoard then begin
		if TBoard(GikoForm.GetActiveList).ParentCategory <> nil then
			GikoForm.SelectTreeNode(TBoard(GikoForm.GetActiveList).ParentCategory, True);
	end else if GikoForm.GetActiveList is TCategory then begin
		GikoForm.SelectTreeNode(TCategory(GikoForm.GetActiveList).ParenTBBS, True);
	end;
end;
// *************************************************************************
//! ʃtH_ɈړUpDateCxg
// *************************************************************************
procedure TGikoDM.UpFolderActionUpdate(Sender: TObject);
begin
	UpFolderAction.Enabled := not (GikoForm.GetActiveList is TBBS) and
        (GikoForm.GetActiveList <> BoardGroup.SpecialBoard);
end;
// *************************************************************************
//! \@\Xg̃[hύX
// *************************************************************************
procedure TGikoDM.IconStyleExecute(Sender: TObject);
begin
	case GikoForm.ListView.ViewStyle of
		vsIcon: SmallIconAction.Execute;
		vsSmallIcon: ListIconAction.Execute;
		vsList: DetailIconAction.Execute;
		vsReport: LargeIconAction.Execute;
	end;
end;
// *************************************************************************
//! SelectComboBox̒lNA
// *************************************************************************
procedure TGikoDM.ClearSelectComboBox;
begin
	if GikoForm.SelectComboBoxPanel.Visible then begin
		GikoForm.SelectComboBox.Text := SELECTCOMBOBOX_NAME;
		GikoForm.SelectComboBox.Color := SELECTCOMBOBOX_COLOR;
		GikoForm.ListView.SetFocus;
	end;
end;
// *************************************************************************
//! Xbhׂĕ\
// *************************************************************************
procedure TGikoDM.AllItemActionExecute(Sender: TObject);
begin
	try
		if GikoForm.ViewType <> gvtAll then
			GikoForm.SetListViewType(gvtAll);
		GikoSys.Setting.ThreadRange := gtrAll;
		AllItemAction.Checked		:= True;
		// SelectComboBox ̗XVĂ
		GikoForm.ModifySelectList;
		// SelectComboBox ̒lNA
		ClearSelectComboBox;
	except
	end;
end;
// *************************************************************************
//! OLXbĥ݂\
// *************************************************************************
procedure TGikoDM.LogItemActionExecute(Sender: TObject);
begin
	try
		if GikoForm.ViewType <> gvtLog then
			GikoForm.SetListViewType(gvtLog);
		GikoSys.Setting.ThreadRange	:= gtrLog;
		LogItemAction.Checked := True;
		// SelectComboBox ̗XVĂ
		GikoForm.ModifySelectList;
		// SelectComboBox ̒lNA
		ClearSelectComboBox;
	except
	end;
end;
// *************************************************************************
//! VXbĥݕ\
// *************************************************************************
procedure TGikoDM.NewItemActionExecute(Sender: TObject);
begin
	try

		if GikoForm.ViewType <> gvtNew then
			GikoForm.SetListViewType(gvtNew);
		GikoSys.Setting.ThreadRange	:= gtrNew;
		NewItemAction.Checked := True;
		// SelectComboBox ̗XVĂ
		GikoForm.ModifySelectList;
		// SelectComboBox ̒lNA
		ClearSelectComboBox;
	except
	end;
end;
// *************************************************************************
//! DATXbĥݕ\
// *************************************************************************
procedure TGikoDM.ArchiveItemActionExecute(Sender: TObject);
begin
	try
		if GikoForm.ViewType <> gvtArch then
			GikoForm.SetListViewType(gvtArch);
		GikoSys.Setting.ThreadRange	:= gtrArch;
		ArchiveItemAction.Checked := True;
		// SelectComboBox ̗XVĂ
		GikoForm.ModifySelectList;
		// SelectComboBox ̒lNA
		ClearSelectComboBox;
	except
	end;
end;
// *************************************************************************
//! Xbĥݕ\
// *************************************************************************
procedure TGikoDM.LiveItemActionExecute(Sender: TObject);
begin
	try
		if GikoForm.ViewType <> gvtLive then
			GikoForm.SetListViewType(gvtLive);
		GikoSys.Setting.ThreadRange	:= gtrLive;
		LiveItemAction.Checked := True;
		// SelectComboBox ̗XVĂ
		GikoForm.ModifySelectList;
		// SelectComboBox ̒lNA
		ClearSelectComboBox;
	except
	end;
end;

// *************************************************************************
//! Xbh̕\͈͂ݒ
// *************************************************************************
procedure TGikoDM.ThreadRangeActionExecute(Sender: TObject);
begin
	case GikoSys.Setting.ThreadRange of
	gtrAll:	AllItemAction.Execute;
	gtrLog:	LogItemAction.Execute;
	gtrNew:	NewItemAction.Execute;
	gtrArch: ArchiveItemAction.Execute;
	gtrLive: LiveItemAction.Execute;
	end;
end;
// *************************************************************************
//! Xbhi݃_CAO\
// *************************************************************************
procedure TGikoDM.SelectItemActionExecute(Sender: TObject);
var
	idx: Integer;
	Dlg: TListSelectDialog;
begin
	try
		if GikoForm.SelectComboBoxPanel.Visible then begin
			if GikoForm.SelectComboBoxPanel.Left + GikoForm.SelectComboBoxPanel.Width < GikoForm.ListToolBar.Width then begin
				// SelectComboBox ꍇ̓tH[JXڂ
				if GikoSys.Setting.ListOrientation = gloHorizontal then begin
					if GikoSys.Setting.ListWidthState = glsMax then
						BrowserMinAction.Execute;
				end else begin
					if GikoSys.Setting.ListHeightState = glsMax then
						BrowserMinAction.Execute;
				end;
				GikoForm.SelectComboBox.SetFocus;
				exit;
			end;
		end;
	except
	end;

	if GikoForm.SelectComboBox.Text = SELECTCOMBOBOX_NAME then begin
		GikoForm.SelectComboBox.Text := '';
		GikoForm.SelectComboBox.Color := clWindow;
	end;

	AllItemAction.Checked := False;
	LogItemAction.Checked := False;
	NewItemAction.Checked := False;
	//SelectItemAction.Checked := True;
	GikoForm.ModifySelectList;
	Dlg := TListSelectDialog.Create(GikoForm);
	try
		Dlg.SelectComboBox.Items.Assign(GikoSys.Setting.SelectTextList);
		Dlg.SelectComboBox.Text := GikoForm.SelectComboBox.Text;
		Dlg.ShowModal;
		if Dlg.ModalResult = mrCancel then begin
			if Length( GikoForm.SelectComboBox.Text ) = 0 then begin
				AllItemAction.Checked := True;
				GikoForm.SelectComboBox.Text := SELECTCOMBOBOX_NAME;
				GikoForm.SelectComboBox.Color := SELECTCOMBOBOX_COLOR;
			end;

			if GikoForm.GetActiveList is TBoard then
				GikoForm.SetListViewType(gvtUser, TBoard(GikoForm.GetActiveList).ParentCategory.ParenTBBS.SelectText , Dlg.KubetsuCheckBox.Checked);
		end else begin
			idx := GikoSys.Setting.SelectTextList.IndexOf(Dlg.SelectComboBox.Text);
			if idx <> -1 then
				GikoSys.Setting.SelectTextList.Delete(idx);
			GikoSys.Setting.SelectTextList.Insert(0, Dlg.SelectComboBox.Text);
			while Dlg.SelectComboBox.Items.Count > 100 do begin
				Dlg.SelectComboBox.Items.Delete(Dlg.SelectComboBox.Items.Count - 1);
			end;

			if Length( Dlg.SelectComboBox.Text ) = 0 then begin
				GikoForm.SelectComboBox.Text := SELECTCOMBOBOX_NAME;
				GikoForm.SelectComboBox.Color := SELECTCOMBOBOX_COLOR;
			end else begin
				GikoForm.SelectComboBox.Text := Dlg.SelectComboBox.Text;
				GikoForm.SelectComboBox.Color := clWindow;
			end;
			GikoForm.SetListViewType(gvtUser, Dlg.SelectComboBox.Text, Dlg.KubetsuCheckBox.Checked);
		end;
	finally
		Dlg.Release;
	end;
end;
// *************************************************************************
//! VX݃EBhE\
// *************************************************************************
procedure TGikoDM.ThreadEditorActionExecute(Sender: TObject);
var
	Editor: TEditorForm;
begin
	if not (GikoForm.GetActiveList is TBoard) then
		Exit;
	Editor := TEditorForm.Create(GikoForm);
	Editor.SetBoard(TBoard(GikoForm.GetActiveList));
	Editor.Show;
	Editor.BodyEdit.SetFocus;
end;
// *************************************************************************
//! ݕ\ĂuEUŕ\
// *************************************************************************
procedure TGikoDM.BoardIEActionExecute(Sender: TObject);
var
	URL: string;
begin
	if GikoForm.GetActiveList is TBoard then begin
		URL := TBoard(GikoForm.GetActiveList).URL;
		GikoSys.OpenBrowser(URL, gbtAuto);
	end;
end;
// *************************************************************************
//! IĂXbhURLRs[
// *************************************************************************
procedure TGikoDM.SelectItemURLCopyActionExecute(Sender: TObject);
var
	List: TList;
	i: Integer;
	s: string;
begin
	s := '';
	List := TList.Create;
	try
		GikoForm.SelectListItem(List);
		for i := 0 to List.Count - 1 do begin
			if TObject(List[i]) is TBoard then
				s := s + TBoard(List[i]).URL + #13#10
			else if TObject(List[i]) is TThreadItem then
				s := s + TThreadItem(List[i]).URL + #13#10;
		end;
		if s <> '' then
			Clipboard.AsText := s;
	finally
		List.Free;
	end;
end;
// *************************************************************************
//! IĂXbhURLRs[UpdateCxg
// *************************************************************************
procedure TGikoDM.SelectItemURLCopyActionUpdate(Sender: TObject);
begin
	if ((GikoForm.GetActiveList is TBoard) or
		(GikoForm.GetActiveList is TCategory))and (GikoForm.ListView.SelCount > 0) then
		TAction(Sender).Enabled := True
	else
		TAction(Sender).Enabled := False;
end;
// *************************************************************************
//! IĂ̖ORs[
// *************************************************************************
procedure TGikoDM.SelectItemNameCopyActionExecute(Sender: TObject);
var
	List: TList;
	i: Integer;
	s: string;
begin
	s := '';
	List := TList.Create;
	try
		GikoForm.SelectListItem(List);
		for i := 0 to List.Count - 1 do begin
            if TObject(List[i]) is TCategory then
                s := s + TCategory(List[i]).Title + #13#10
			else if TObject(List[i]) is TBoard then
				s := s + TBoard(List[i]).Title + #13#10
			else if TObject(List[i]) is TThreadItem then
				s := s + TThreadItem(List[i]).Title + #13#10;
		end;
		if s <> '' then
			Clipboard.AsText := s;
	finally
		List.Free;
	end;
end;
// *************************************************************************
//! IĂ̖ORs[UpdateCxg
// *************************************************************************
procedure TGikoDM.SelectItemNameCopyActionUpdate(Sender: TObject);
begin
	if ((GikoForm.GetActiveList is TBBS) or
        (GikoForm.GetActiveList is TBoard) or
		(GikoForm.GetActiveList is TCategory))and (GikoForm.ListView.SelCount > 0) then
		TAction(Sender).Enabled := True
	else
		TAction(Sender).Enabled := False;
end;
// *************************************************************************
//! IĂXbh̖OURLRs[
// *************************************************************************
procedure TGikoDM.SelectItemNameURLCopyActionExecute(Sender: TObject);
var
	List: TList;
	i: Integer;
	s: string;
begin
	s := '';
	List := TList.Create;
	try
		GikoForm.SelectListItem(List);
		for i := 0 to List.Count - 1 do begin
			if TObject(List[i]) is TBoard then
				s := s + TBoard(List[i]).Title + #13#10 + TBoard(List[i]).URL + #13#10
			else if TObject(List[i]) is TThreadItem then
				s := s + TThreadItem(List[i]).Title + #13#10 + TThreadItem(List[i]).URL + #13#10;
		end;
		if s <> '' then
			Clipboard.AsText := s;
	finally
		List.Free;
	end;
end;
// *************************************************************************
//! IĂXbhꗗ_E[h
// *************************************************************************
procedure TGikoDM.SelectListReloadActionExecute(Sender: TObject);
var
	i: Integer;
	List: TList;
	msg: string;
	shiftDown: Boolean;
begin
	shiftDown := GetAsyncKeyState(VK_SHIFT) = Smallint($8001);
    GikoForm.ActiveListColumnSave;
	if GikoForm.GetActiveList is TCategory then begin
		List := TList.Create;
		try
			GikoForm.SelectListItem(List);
			if List.Count > 5 then begin
				msg := '5ȏ͎wł܂' + #13#10
						 + 'Q˂镉׌yɂ͂';
				MsgBox(GikoForm.Handle, msg, 'x', MB_ICONEXCLAMATION);
				Exit;
			end;
			for i := 0 to List.Count - 1 do begin
				if TObject(List[i]) is TBoard then
					GikoForm.DownloadList(TBoard(List[i]), shiftDown);
			end;
		finally
			List.Free;
		end;
	end else if GikoForm.GetActiveList is TBoard then begin
		GikoForm.DownloadList(TBoard(GikoForm.GetActiveList), shiftDown);
	end;
end;
// *************************************************************************
//! IĂXbhꗗ_E[hUpdateCxg
// *************************************************************************
procedure TGikoDM.SelectListReloadActionUpdate(Sender: TObject);
begin
	if (GikoForm.GetActiveList is TCategory) and (GikoForm.ListView.SelCount > 0) then
		TAction(Sender).Enabled := True
	else if GikoForm.GetActiveList is TBoard then begin
		TAction(Sender).Enabled :=
            (GikoForm.GetActiveList <> BoardGroup.SpecialBoard);
	end else
		TAction(Sender).Enabled := False;
end;
// *************************************************************************
//! IĂXbh_E[h
// *************************************************************************
procedure TGikoDM.SelectThreadReloadActionExecute(Sender: TObject);
var
	List: TList;
	i: Integer;
	msg: string;
	shiftDown: Boolean;
begin
	shiftDown := GetAsyncKeyState(VK_SHIFT) = Smallint($8001);
	List := TList.Create;
	try
		GikoForm.SelectListItem(List);
		if List.Count > 10 then begin
			msg := '10ȏ͎wł܂' + #13#10
					 + 'Q˂镉׌yɂ͂';
			MsgBox(GikoForm.Handle, msg, 'x', MB_ICONEXCLAMATION);
			Exit;
		end;
		for i := 0 to List.Count - 1 do begin
			if TObject(List[i]) is TThreadItem then
				GikoForm.DownloadContent(TThreadItem(List[i]), shiftDown);
		end;
	finally
		List.Free;
	end;
end;
// *************************************************************************
//! IĂXbh_E[hUpdateCxg
// *************************************************************************
procedure TGikoDM.SelectThreadReloadActionUpdate(Sender: TObject);
begin
	TAction(Sender).Enabled :=
		(GikoForm.GetActiveList is TBoard) and (GikoForm.ListView.SelCount > 0);
end;
// *************************************************************************
//! Xbh\
// *************************************************************************
procedure TGikoDM.SelectReservActionExecute(Sender: TObject);
begin
	//INFO 2005/11/19 _~[H@by 
	// ̃Rg폜Ă͑ʖ
end;
// *************************************************************************
//! Xbh\UpdateCxg
// *************************************************************************
procedure TGikoDM.SelectReservActionUpdate(Sender: TObject);
var
	i: Integer;
	List: TList;
begin
	if (GikoForm.GetActiveList is TBoard) and (GikoForm.ListView.SelCount > 0) then begin
		List := TList.Create;
		try
			GikoForm.SelectListItem(List);
			for i := 0 to List.Count - 1 do begin
				if TObject(List[i]) is TThreadItem then begin
					if TThreadItem(List[i]).IsLogFile then begin
						SelectReservAction.Enabled := True;
						Exit;
					end;
				end;
			end;
			SelectReservAction.Enabled := False;
		finally
			List.Free;
		end;
	end else if (GikoForm.GetActiveList is TCategory) and (GikoForm.ListView.SelCount > 0) then
		SelectReservAction.Enabled := True
	else
		SelectReservAction.Enabled := False;
end;
// *************************************************************************
//! IĂXbhɐVOŏ\
// *************************************************************************
procedure TGikoDM.SelectNewRoundNameExecute(Sender: TObject);
var
	s: string;
	Dlg: TRoundNameDialog;
		cnt: Integer;

begin
	//ĂяoATActionListViewɑIȂ΁AEXIT
	if (Sender is TAction) and (GikoForm.ListView.Selected = nil) then
		Exit;

	//o^`FbN
	cnt := RoundList.Count[grtBoard];
	cnt := cnt + RoundList.Count[grtItem];
	if cnt > 500 then begin
			MsgBox(GikoForm.Handle, '500ȏo^ł܂', MSG_ERROR, MB_OK or MB_ICONSTOP);
			Exit;
	end;

	Dlg := TRoundNameDialog.Create(GikoForm);
	try
		Dlg.ShowModal;
		if Dlg.ModalResult <> mrCancel then begin
			s := Trim(Dlg.RoundNameEdit.Text);
			if (Sender is TMenuItem) then begin
				GikoForm.SetSelectItemRound(True, s, TMenuItem(Sender).Parent.Name);
			end else if (Sender is TAction) then begin
				if (GikoForm.ListView.Selected <> nil) then begin
					if (TObject(GikoForm.ListView.Selected.Data) is TThreadItem) then begin
						GikoForm.SetSelectItemRound(True, s,
							TThreadItem(GikoForm.ListView.Selected.Data).Title);
					end else if (TObject(GikoForm.ListView.Selected.Data) is TBoard) then begin
						GikoForm.SetSelectItemRound(True, s,
							TBoard(GikoForm.ListView.Selected.Data).Title);
					end;
				end;
			end;
			GikoForm.ListView.Refresh;
		end;
	finally
		Dlg.Free;
	end;
end;
// *************************************************************************
//! IĂXbh̏폜
// *************************************************************************
procedure TGikoDM.SelectDeleteRoundExecute(Sender: TObject);
var
	s : String;
begin
	if (Sender is TMenuItem) then begin
		try
			GikoForm.SetSelectItemRound(False, '', TMenuItem(Sender).Parent.Name);
		except
		end;
	end else if (Sender is TAction) then begin
		try
			if GikoForm.ListView.Selected <> nil then begin
				if (TObject(GikoForm.ListView.Selected.Data) is TThreadItem) then begin
					s := TThreadItem(GikoForm.ListView.Selected.Data).Title;
				end else if (TObject(GikoForm.ListView.Selected.Data) is TBoard) then begin
					s := TBoard(GikoForm.ListView.Selected.Data).Title;
				end;
				GikoForm.SetSelectItemRound(False, '', s);

			end;
		except
		end;
	end;
	GikoForm.ListView.Refresh;
end;
// *************************************************************************
//! IĂCɓɒǉ
// *************************************************************************
procedure TGikoDM.BoardFavoriteAddActionExecute(Sender: TObject);
begin
	if TObject(GikoForm.ListView.Selected.Data) is TBoard then
		GikoForm.ShowFavoriteAddDialog(TObject(GikoForm.ListView.Selected.Data));
end;
// *************************************************************************
//! IĂCɓɒǉUpdateCxg
// *************************************************************************
procedure TGikoDM.BoardFavoriteAddActionUpdate(Sender: TObject);
begin
	BoardFavoriteAddAction.Enabled :=
		(GikoForm.GetActiveList is TCategory) and (GikoForm.ListView.SelCount > 0);
end;
// *************************************************************************
//! ExplorerLogtH_J
// *************************************************************************
procedure TGikoDM.LogFolderOpenActionExecute(Sender: TObject);
var
	List: TList;
begin
	if ((GikoSys.Setting.ListOrientation = gloVertical) and
		(GikoSys.Setting.ListHeightState = glsMax)) or
		((GikoSys.Setting.ListOrientation = gloHorizontal) and
		(GikoSys.Setting.ListWidthState = glsMax))	then begin
		if(GikoForm.GetActiveContent <> nil) then begin
			GikoSys.CreateProcess('explorer.exe', '/e,"' + ExtractFilePath(GikoForm.GetActiveContent.FilePath) + '"');
		end;
	end else if GikoForm.GetActiveList is TCategory then begin
		List := TList.Create;
		try
			GikoForm.SelectListItem(List);
			GikoSys.CreateProcess('explorer.exe', '/e,"' + ExtractFilePath(TBoard(List[0]).FilePath) + '"');
		finally
			List.Free;
		end;
	end else if GikoForm.GetActiveList is TBoard then begin
		GikoSys.CreateProcess('explorer.exe', '/e,"' + ExtractFilePath(TBoard(GikoForm.GetActiveList).FilePath) + '"');
	end;

end;
// *************************************************************************
//! ActiveListTBoardTCategoryŃXꗗłPȏIĂƗLɂȂActionde
// *************************************************************************
procedure TGikoDM.LogFolderOpenActionUpdate(Sender: TObject);
begin
	if (((GikoForm.GetActiveList is TBoard) and
        (GikoForm.GetActiveList <> BoardGroup.SpecialBoard))
        or (GikoForm.GetActiveList is TCategory))
	    	and (GikoForm.ListView.SelCount > 0) then
		TAction(Sender).Enabled := True
	else
		TAction(Sender).Enabled := False;
end;
// *************************************************************************
//! Header.txtuEUŕ\
// *************************************************************************
procedure TGikoDM.BrowsBoradHeadActionExecute(Sender: TObject);
var
	RefURL, URL : string;
	List : TList;
begin
	RefURL := '';
	if GikoForm.GetActiveList is TCategory then begin
		List := TList.Create;
		try
			GikoForm.SelectListItem(List);
			RefURL := TBoard(List[0]).URL;
		finally
			List.Free;
		end;
	end else if GikoForm.GetActiveList is TBoard then begin
		RefURL := TBoard(GikoForm.GetActiveList).URL
	end;
	if RefURL <> '' then begin
		if RefURL[Length(RefURL)] <> '/' then
			URL	:= RefURL + '/' + 'head.txt'
		else
			URL	:= RefURL + 'head.txt';

		GikoForm.MoveToURL(URL);
	end else begin
		ShowMessage('ł܂łB');
	end;

end;
// *************************************************************************
//! Xꗗ̕\ĂeɂāA\[gJ̈ʒuƕ擾
// *************************************************************************
function TGikoDM.GetSortProperties(List: TObject;
 var vSortOrder: Boolean): Boolean;
begin
	Result := True;
	if (List <> nil) then begin
		if (List is TBBS) then begin
			vSortOrder := GikoSys.Setting.BBSSortOrder;
		end else if (List is TCategory) then begin
			vSortOrder := GikoSys.Setting.CategorySortOrder;
		end else if (List is TBoard) then begin
			vSortOrder := GikoSys.Setting.BoardSortOrder;
		end else begin
			Result := False;
		end;
	end else begin
		Result := False;
	end;
end;
// *************************************************************************
//! ݂̃J\[g
// *************************************************************************
procedure TGikoDM.SortActiveColumnActionExecute(Sender: TObject);
var
	i	: Integer;
	so : boolean;
begin
	if GetSortProperties(GikoForm.GetActiveList, so) then begin
		for i := 0 to GikoForm.ListView.Columns.Count - 1 do begin
			if (GikoForm.ListView.Column[ i ].ImageIndex = ITEM_ICON_SORT1) or
				(GikoForm.ListView.Column[ i ].ImageIndex = ITEM_ICON_SORT2) then begin
				so := not so;
				TListViewUtils.ListViewSort(nil, GikoForm.ListView,
					 GikoForm.ListView.Column[ i ], ListNumberVisibleAction.Checked,
					 so);
				break;
			end;
		end;
	end;
end;
// *************************************************************************
//! ẼׂJ\[g
// *************************************************************************
procedure TGikoDM.SortNextColumnActionExecute(Sender: TObject);
var
	i, id	: Integer;
begin
	for i := 0 to GikoForm.ListView.Columns.Count - 1 do begin
		if (GikoForm.ListView.Column[ i ].ImageIndex = ITEM_ICON_SORT1) or
			(GikoForm.ListView.Column[ i ].ImageIndex = ITEM_ICON_SORT2) then begin
			id := i + 1;
			if id > GikoForm.ListView.Columns.Count - 1 then
				id := 0;
			TListViewUtils.ListViewSort( nil, GikoForm.ListView,
				GikoForm.ListView.Column[ id ], ListNumberVisibleAction.Checked,
				id = 0);
			break;
		end;
	end;
end;
// *************************************************************************
//! ׂ̃J\[g
// *************************************************************************
procedure TGikoDM.SortPrevColumnActionExecute(Sender: TObject);
var
	i, id	: Integer;
begin
	for i := 0 to GikoForm.ListView.Columns.Count - 1 do begin
		if (GikoForm.ListView.Column[ i ].ImageIndex = ITEM_ICON_SORT1) or
			(GikoForm.ListView.Column[ i ].ImageIndex = ITEM_ICON_SORT2) then begin
			id := i - 1;
			if id < 0 then
				id := GikoForm.ListView.Columns.Count - 1;
			TListViewUtils.ListViewSort( nil, GikoForm.ListView,
				GikoForm.ListView.Column[ id ], ListNumberVisibleAction.Checked,
				id = 0);
			break;
		end;
	end;
end;
////////////////////////////////܂ł܂/////////////////////
// *************************************************************************
//! Wc[o[̕\ԂύX
// *************************************************************************
procedure TGikoDM.StdToolBarVisibleActionExecute(Sender: TObject);
var
	CoolBand: TCoolBand;
begin
	CoolBand := GikoForm.GetCoolBand(GikoForm.MainCoolBar, GikoForm.StdToolBar);
	if CoolBand = nil then
		Exit;
	GikoSys.Setting.StdToolBarVisible := StdToolBarVisibleAction.Checked;
	CoolBand.Visible := GikoSys.Setting.StdToolBarVisible;
	GikoForm.StdToolBarVisiblePMenu.Checked := GikoSys.Setting.StdToolBarVisible;
end;
// *************************************************************************
//! AhXo[̕\ԂύX
// *************************************************************************
procedure TGikoDM.AddressBarVisibleActionExecute(Sender: TObject);
var
	CoolBand: TCoolBand;
begin
	CoolBand := GikoForm.GetCoolBand(GikoForm.MainCoolBar, GikoForm.AddressToolBar);
	if CoolBand = nil then
		Exit;
	GikoSys.Setting.AddressBarVisible := AddressBarVisibleAction.Checked;
	CoolBand.Visible := GikoSys.Setting.AddressBarVisible;
	GikoForm.AddressToolBarVisiblePMenu.Checked := GikoSys.Setting.AddressBarVisible;
end;
// *************************************************************************
//! No[̕\ԂύX
// *************************************************************************
procedure TGikoDM.LinkBarVisibleActionExecute(Sender: TObject);
var
	CoolBand: TCoolBand;
begin
	CoolBand := GikoForm.GetCoolBand(GikoForm.MainCoolBar, GikoForm.LinkToolBar);
	if CoolBand = nil then
		Exit;
	GikoSys.Setting.LinkBarVisible := LinkBarVisibleAction.Checked;
	CoolBand.Visible := GikoSys.Setting.LinkBarVisible;
	GikoForm.LinkToolBarVisiblePMenu.Checked := GikoSys.Setting.LinkBarVisible;
end;
// *************************************************************************
//! Xgc[o[̕\ԂύX
// *************************************************************************
procedure TGikoDM.ListToolBarVisibleActionExecute(Sender: TObject);
var
	CoolBand: TCoolBand;
begin
	CoolBand := GikoForm.GetCoolBand(GikoForm.ListCoolBar, GikoForm.ListToolBar);
	if CoolBand = nil then
		Exit;
	CoolBand.Visible := ListToolBarVisibleAction.Checked;
	GikoSys.Setting.ListToolBarVisible := ListToolBarVisibleAction.Checked;
end;
// *************************************************************************
//! Xĝ̕\ԂύX
// *************************************************************************
procedure TGikoDM.ListNameBarVisibleActionExecute(Sender: TObject);
var
	CoolBand: TCoolBand;
begin
	CoolBand := GikoForm.GetCoolBand(GikoForm.ListCoolBar, GikoForm.ListNameToolBar);
	if CoolBand = nil then
		Exit;
	CoolBand.Visible := ListNameBarVisibleAction.Checked;
	GikoSys.Setting.ListNameBarVisible := ListNameBarVisibleAction.Checked;
end;
// *************************************************************************
//! uEUc[o[̕\ԂύX
// *************************************************************************
procedure TGikoDM.BrowserToolBarVisibleActionExecute(Sender: TObject);
var
	CoolBand: TCoolBand;
begin
	CoolBand := GikoForm.GetCoolBand(GikoForm.BrowserCoolBar, GikoForm.BrowserToolBar);
	if CoolBand = nil then
		Exit;
	CoolBand.Visible := BrowserToolBarVisibleAction.Checked;
	GikoSys.Setting.BrowserToolBarVisible := BrowserToolBarVisibleAction.Checked;
end;
// *************************************************************************
//! uEÛ̕\ԂύX
// *************************************************************************
procedure TGikoDM.BrowserNameBarVisibleActionExecute(Sender: TObject);
var
	CoolBand: TCoolBand;
begin
	CoolBand := GikoForm.GetCoolBand(GikoForm.BrowserCoolBar, GikoForm.BrowserNameToolBar);
	if CoolBand = nil then
		Exit;
	CoolBand.Visible := BrowserNameBarVisibleAction.Checked;
	GikoSys.Setting.BrowserNameBarVisible := BrowserNameBarVisibleAction.Checked;
end;
// *************************************************************************
//! bZ[Wo[̕\ԂύX
// *************************************************************************
procedure TGikoDM.MsgBarVisibleActionExecute(Sender: TObject);
begin
	GikoForm.MessageSplitter.Visible := MsgBarVisibleAction.Checked;
	GikoForm.MessagePanel.Top :=
		GikoForm.MessageSplitter.Top + GikoForm.MessageSplitter.Height;
	GikoForm.MessageSplitter.Top := GikoForm.MessagePanel.Top + 1;
	GikoForm.MessagePanel.Visible := MsgBarVisibleAction.Checked;
	GikoSys.Setting.MessageBarVisible := MsgBarVisibleAction.Checked;
end;
// *************************************************************************
//! bZ[Wo[
// *************************************************************************
procedure TGikoDM.MsgBarCloseActionExecute(Sender: TObject);
begin
	MsgBarVisibleAction.Execute;
end;
// *************************************************************************
//! Xe[^Xo[̕\ԂύX
// *************************************************************************
procedure TGikoDM.StatusBarVisibleActionExecute(Sender: TObject);
begin
	GikoForm.StatusBar.Visible := StatusBarVisibleAction.Checked;
	GikoSys.Setting.StatusBarVisible := StatusBarVisibleAction.Checked;
end;
// *************************************************************************
//! Lrlbg̕\fɂ
// *************************************************************************
procedure TGikoDM.CabinetBBSActionExecute(Sender: TObject);
begin

	if GikoForm.CabinetPanel.Visible then begin
		if GikoForm.TreeType = gtt2ch then begin
			GikoForm.CabinetVisible( False );

			CabinetBBSAction.Checked := False;
		end else begin
			CabinetBBSAction.Checked := True;
		end;
	end else begin
		GikoForm.CabinetVisible( True );
		CabinetBBSAction.Checked := True;
	end;

	if GikoForm.ActiveBBS = nil then
		GikoForm.ShowBBSTree( BBSs[ 0 ] )
	else
		GikoForm.ShowBBSTree( GikoForm.ActiveBBS );

end;
// *************************************************************************
//! Lrlbg̕\𗚗Xgɂ
// *************************************************************************
procedure TGikoDM.CabinetHistoryActionExecute(Sender: TObject);
begin
	GikoForm.ShowHistoryTree;
end;
// *************************************************************************
//! Lrlbg̕\Cɓ胊Xgɂ
// *************************************************************************
procedure TGikoDM.CabinetFavoriteActionExecute(Sender: TObject);
var
	i, b : Integer;
	item : TMenuItem;
begin

	if GikoForm.CabinetPanel.Visible then begin
		if GikoForm.TreeType = gttFavorite then begin
			GikoForm.CabinetVisible( False );
			CabinetFavoriteAction.Checked := False;
		end else begin
			CabinetFavoriteAction.Checked := True;
		end;
	end else begin
		GikoForm.CabinetVisible( True );
		CabinetFavoriteAction.Checked := True;
	end;

	// BBS...BBS, History, Favorite
	GikoSys.Setting.CabinetIndex := GikoForm.CabinetSelectPopupMenu.Items.Count - 1;

	b := GikoForm.CabinetSelectPopupMenu.Items.Count - 1;
	for i := 0 to b do begin
		item := GikoForm.CabinetSelectPopupMenu.Items[ i ];
		if item is TBBSMenuItem then begin
			item.Checked := False;
			// CabinetMenu  CabinetSelectPopupMenu Ɠƌ߂Ⴄ
			GikoForm.CabinetMenu.Items[ i ].Checked := False;
		end;
	end;

	// Lrlbgc[o[yуLrlbg̕\ؑ
	GikoForm.HistoryToolBar.Hide;
	GikoForm.FavoriteToolBar.Show;
	GikoForm.TreeView.Visible := False;
	GikoForm.FavoriteTreeView.Visible := True;

	GikoForm.CabinetSelectToolButton.Caption := 'Cɓ';
	GikoForm.TreeType := gttFavorite;

	// j[yу{^̃`FbNݒ
	CabinetBBSAction.Checked := False;
	CabinetHistoryAction.Checked := False;

	// Cɓ̃c[WJ
	GikoForm.FavoriteTreeView.Items.GetFirstNode.Expanded := True;

end;
// *************************************************************************
//! Lrlbg̕\ԂύX
// *************************************************************************
procedure TGikoDM.CabinetVisibleActionExecute(Sender: TObject);
begin
	case GikoForm.TreeType of
	gttHistory:		CabinetHistoryAction.Execute;
	gttFavorite:	CabinetFavoriteAction.Execute;
	else
		CabinetBBSAction.Execute;
	end;
end;
// *************************************************************************
//! Lrlbg
// *************************************************************************
procedure TGikoDM.CabinetCloseActionExecute(Sender: TObject);
begin
	//INFO 2005/11/19 ̃ANVɂ͉ݒ肳ĂȂ@
end;
// *************************************************************************
//! Xg傫ACR\ɂ
// *************************************************************************
procedure TGikoDM.LargeIconActionExecute(Sender: TObject);
begin
	GikoForm.ListView.ViewStyle := vsIcon;
	LargeIconAction.Checked := True;
end;
// *************************************************************************
//! XgACR\ɂ
// *************************************************************************
procedure TGikoDM.SmallIconActionExecute(Sender: TObject);
begin
	GikoForm.ListView.ViewStyle := vsSmallIcon;
	SmallIconAction.Checked := True;
end;
// *************************************************************************
//! Xgꗗ\ɂ
// *************************************************************************
procedure TGikoDM.ListIconActionExecute(Sender: TObject);
begin
	GikoForm.ListView.ViewStyle := vsList;
	ListIconAction.Checked := True;
end;
// *************************************************************************
//! Xgڍו\ɂ
// *************************************************************************
procedure TGikoDM.DetailIconActionExecute(Sender: TObject);
begin
	GikoForm.ListView.ViewStyle := vsReport;
	DetailIconAction.Checked := True;
end;
// *************************************************************************
//! _E[h𒆎~
// *************************************************************************
procedure TGikoDM.StopActionExecute(Sender: TObject);
begin
	GikoForm.FControlThread.DownloadAbort;
	if GikoForm.WorkCount <> 0 then GikoForm.WorkCount := 0;
	try
		GikoForm.Animate.Active := False;
	except
	end;
	GikoForm.ScreenCursor := crDefault;
end;
// *************************************************************************
//! XgƃuEȔczuύX
// *************************************************************************
procedure TGikoDM.ArrangeActionExecute(Sender: TObject);
begin
	if ArrangeAction.Checked then begin
		//c
		GikoForm.ViewPanel.Align := alNone;
		GikoForm.ListSplitter.Align := alNone;
		GikoForm.ThreadPanel.Align := alNone;

		GikoForm.ViewPanel.Width := GikoForm.BrowserSizeWidth;
		GikoForm.ViewPanel.Align := alLeft;

		GikoForm.ListSplitter.Width := 5;
		GikoForm.ListSplitter.Align := alLeft;

		GikoForm.ViewPanel.Left := -10;

		GikoForm.ThreadPanel.Align := alClient;

		GikoSys.Setting.ListOrientation := gloHorizontal;
		case GikoSys.Setting.ListWidthState of
			glsMax: begin
				BrowserMaxAction.ImageIndex := TOOL_ICON_WIDTH_NORMAL;
				BrowserMinAction.ImageIndex := TOOL_ICON_WIDTH_MIN;
				GikoForm.ViewPanel.Width := 1;
			end;
			glsNormal: begin
				BrowserMaxAction.ImageIndex := TOOL_ICON_WIDTH_MAX;
				BrowserMinAction.ImageIndex := TOOL_ICON_WIDTH_MIN;
			end;
			glsMin: begin
				BrowserMaxAction.ImageIndex := TOOL_ICON_WIDTH_MAX;
				BrowserMinAction.ImageIndex := TOOL_ICON_WIDTH_NORMAL;
				GikoForm.ViewPanel.Width := GikoForm.ThreadMainPanel.Width - 80;
			end;
		end;
	end else begin
		//
		GikoForm.ViewPanel.Align := alNone;
		GikoForm.ListSplitter.Align := alNone;
		GikoForm.ThreadPanel.Align := alNone;

		GikoForm.ViewPanel.Height := GikoForm.BrowserSizeHeight;
		GikoForm.ViewPanel.Align := alTop;

		GikoForm.ListSplitter.Height := 5;
		GikoForm.ListSplitter.Align := alTop;

		GikoForm.ViewPanel.Top := -10;

		GikoForm.ThreadPanel.Align := alClient;
		GikoSys.Setting.ListOrientation := gloVertical;
		case GikoSys.Setting.ListHeightState of
			glsMax: begin
				BrowserMaxAction.ImageIndex := TOOL_ICON_HEIGHT_NORMAL;
				BrowserMinAction.ImageIndex := TOOL_ICON_HEIGHT_MIN;
				GikoForm.ViewPanel.Height := 1;
			end;
			glsNormal: begin
				BrowserMaxAction.ImageIndex := TOOL_ICON_HEIGHT_MAX;
				BrowserMinAction.ImageIndex := TOOL_ICON_HEIGHT_MIN;
			end;
			glsMin: begin
				BrowserMaxAction.ImageIndex := TOOL_ICON_HEIGHT_MAX;
				BrowserMinAction.ImageIndex := TOOL_ICON_HEIGHT_NORMAL;
				GikoForm.ViewPanel.Height :=
					GikoForm.ThreadMainPanel.Height - GikoForm.BrowserCoolBar.Height - 7;
			end;
		end;
	end;
end;
// *************************************************************************
//! yC̃TCY
// *************************************************************************
procedure TGikoDM.PaneInitActionExecute(Sender: TObject);
begin
	GikoForm.CabinetPanel.Width := 150;
	GikoForm.MessagePanel.Height := 40;

	GikoForm.BrowserSizeWidth := 200;
	GikoForm.BrowserSizeHeight := 200;
	if ArrangeAction.Checked then begin
		GikoForm.ViewPanel.Width := GikoForm.BrowserSizeWidth;
	end else begin
		GikoForm.ViewPanel.Height := GikoForm.BrowserSizeHeight;
	end;
	if GikoSys.Setting.ListOrientation = gloHorizontal then begin
		if GikoSys.Setting.ListHeightState = glsMax then begin
			BrowserMaxAction.ImageIndex := TOOL_ICON_HEIGHT_MAX;
			GikoSys.Setting.ListHeightState := glsNormal;
		end;
	end else begin
		if GikoSys.Setting.ListWidthState = glsMax then begin
			BrowserMaxAction.ImageIndex := TOOL_ICON_WIDTH_MAX;
			GikoSys.Setting.ListWidthState := glsNormal;
		end;
	end;
end;
// *************************************************************************
//! uEU^u̕\ԂύX
// *************************************************************************
procedure TGikoDM.BrowserTabVisibleActionExecute(Sender: TObject);
begin
	GikoSys.Setting.BrowserTabVisible := BrowserTabVisibleAction.Checked;
	GikoForm.SetBrowserTabState;
end;
// *************************************************************************
//! uEU^uɕ\
// *************************************************************************
procedure TGikoDM.BrowserTabTopActionExecute(Sender: TObject);
begin
	BrowserTabBottomAction.Checked := False;
	BrowserTabTopAction.Checked := True;
	GikoSys.Setting.BrowserTabPosition := gtpTop;
	GikoForm.SetBrowserTabState;
end;
// *************************************************************************
//! uEU^uɕ\
// *************************************************************************
procedure TGikoDM.BrowserTabBottomActionExecute(Sender: TObject);
begin
	BrowserTabTopAction.Checked := False;
	BrowserTabBottomAction.Checked := True;
	GikoSys.Setting.BrowserTabPosition := gtpBottom;
	GikoForm.SetBrowserTabState;
end;
// *************************************************************************
//! uEU^ũX^C^uX^Cɂ
// *************************************************************************
procedure TGikoDM.BrowserTabTabStyleActionExecute(Sender: TObject);
begin
	BrowserTabButtonStyleAction.Checked := False;
	BrowserTabFlatStyleAction.Checked := False;
	BrowserTabTabStyleAction.Checked := True;
	GikoSys.Setting.BrowserTabStyle := gtsTab;
	GikoForm.SetBrowserTabState;
end;
// *************************************************************************
//! uEU^ũX^C{^X^Cɂ
// *************************************************************************
procedure TGikoDM.BrowserTabButtonStyleActionExecute(Sender: TObject);
begin
	BrowserTabTabStyleAction.Checked := False;
	BrowserTabFlatStyleAction.Checked := False;
	BrowserTabButtonStyleAction.Checked := True;
	GikoSys.Setting.BrowserTabStyle := gtsButton;
	GikoForm.SetBrowserTabState;
end;
// *************************************************************************
//! uEU^ũX^Ctbg{^X^Cɂ
// *************************************************************************
procedure TGikoDM.BrowserTabFlatStyleActionExecute(Sender: TObject);
begin
	BrowserTabFlatStyleAction.Checked := True;
	BrowserTabTabStyleAction.Checked := False;
	BrowserTabButtonStyleAction.Checked := False;
	GikoSys.Setting.BrowserTabStyle := gtsFlat;
	GikoForm.SetBrowserTabState;
end;
// *************************************************************************
//! uEUɃtH[JX𓖂Ă
// *************************************************************************
procedure TGikoDM.SetFocusForBrowserActionExecute(Sender: TObject);
begin
    GikoForm.ActiveContent.Browser.SetFocus;
end;
// *************************************************************************
//! uEUɃtH[JX𓖂ĂUpdateCxg
// *************************************************************************
procedure TGikoDM.SetFocusForBrowserActionUpdate(Sender: TObject);
begin
	if( GikoForm.ActiveContent <> nil) and (GikoForm.ActiveContent.Browser <> nil) and
		(GikoForm.ActiveContent.Browser <> GikoForm.BrowserNullTab.Browser) then
		TAction(Sender).Enabled := true
	else
		TAction(Sender).Enabled := false;
end;
// *************************************************************************
//! XbhꗗɃtH[JX𓖂Ă
// *************************************************************************
procedure TGikoDM.SetFocusForThreadListActionExecute(Sender: TObject);
begin
	if GikoForm.ActiveContent <> nil then
		GikoForm.WebBrowserClick(GikoForm.ActiveContent.Browser); //BrowserɓĂȂƓȂƂ
	GikoForm.ListView.SetFocus;

	if( GikoForm.ListView.Items.Count > 0 ) and (GikoForm.ListView.ItemFocused = nil) then
		GikoForm.ListView.Items.Item[0].Selected := true; //IACeƂ͐擪̂I

	//XN[
	if (GikoForm.ListView.ItemFocused <> nil) then begin
		GikoForm.ListView.ItemFocused.MakeVisible(False);
	end;
end;
// *************************************************************************
//! LrlbgɃtH[JX𓖂Ă
// *************************************************************************
procedure TGikoDM.SetFocusForCabinetActionExecute(Sender: TObject);
begin
	if GikoForm.ActiveContent <> nil then
		GikoForm.WebBrowserClick(GikoForm.ActiveContent.Browser); //BrowserɓĂȂƓȂƂ
	if GikoForm.TreeView.Visible then begin
		GikoForm.TreeView.SetFocus;
		if(GikoForm.TreeView.Items.Count > 0) and ( GikoForm.TreeView.Selected = nil ) then
			GikoForm.TreeView.Items.Item[0].Selected := true;
	end else if GikoForm.FavoriteTreeView.Visible then begin
		GikoForm.FavoriteTreeView.SetFocus;
		if(GikoForm.FavoriteTreeView.Items.Count > 0) and (GikoForm.FavoriteTreeView.Selected = nil) then
			GikoForm.FavoriteTreeView.Items.Item[0].Selected := true;
	end;
end;
// *************************************************************************
//! LrlbgɃtH[JX𓖂ĂUpdateCxg
// *************************************************************************
procedure TGikoDM.SetFocusForCabinetActionUpdate(Sender: TObject);
begin
	SetFocusForCabinetAction.Enabled := GikoForm.CabinetPanel.Visible;
end;
// *************************************************************************
//! Xbhꗗő剻ătH[JX𓖂Ă
// *************************************************************************
procedure TGikoDM.ThreadlistMaxAndFocusActionExecute(Sender: TObject);
begin
	BrowserMinAction.Execute;
	SetFocusForThreadListAction.Execute;
end;
// *************************************************************************
//! X\ő剻ătH[JX𓖂Ă
// *************************************************************************
procedure TGikoDM.BrowserMaxAndFocusActionExecute(Sender: TObject);
begin
	BrowserMaxAction.Execute;
	SetFocusForBrowserAction.Execute;
end;
// *************************************************************************
//! Xbhꗗ̑I폜
// *************************************************************************
procedure TGikoDM.UnSelectedListViewActionExecute(Sender: TObject);
begin
	if GikoForm.ListView.Selected <> nil then begin
		GikoForm.ListView.Selected.Focused := True;
		GikoForm.ListView.Selected := nil;
	end;
end;
////////////////////////////////\܂ł܂/////////////////////
// *************************************************************************
//! IĂXbhǂɂ
// *************************************************************************
procedure TGikoDM.KidokuActionExecute(Sender: TObject);
begin
	SetThreadReadProperty(true);
end;
// *************************************************************************
//! IĂXbh𖢓ǂɂ
// *************************************************************************
procedure TGikoDM.MidokuActionExecute(Sender: TObject);
begin
	SetThreadReadProperty(false);
end;
// *************************************************************************
//! IĂXbh̖ǁEǂݒ肷   true :  false : 
// *************************************************************************
procedure TGikoDM.SetThreadReadProperty(read: Boolean);
var
	List: TList;
	i: Integer;
begin
	List := TList.Create;
	try
		GikoForm.SelectListItem(List);
		for i := 0 to List.Count - 1 do begin
			if TObject(List[i]) is TThreadItem then begin
				if (TThreadItem(List[i]).IsLogFile) then begin
					TThreadItem(List[i]).UnRead := not read;
				end;
			end;
		end;
		if GikoForm.TreeView.Visible then
			GikoForm.TreeView.Refresh;
		if GikoForm.ListView.Visible then
			GikoForm.ListView.Refresh;
	finally
		List.Free;
	end;
end;
// *************************************************************************
//! XgSđI
// *************************************************************************
procedure TGikoDM.AllSelectActionExecute(Sender: TObject);
begin
	GikoForm.ListViewAllSelect;
end;
// *************************************************************************
//! XgSđIUpdateCxg
// *************************************************************************
procedure TGikoDM.AllSelectActionUpdate(Sender: TObject);
begin
	AllSelectAction.Enabled := GikoForm.ListView.SelCount > 0;
end;
////////////////////////////////ҏW܂ł܂/////////////////////
//! Xbh̃TCYČvZ
procedure TGikoDM.ThreadSizeCalcForFileActionExecute(Sender: TObject);
const
	RECALC_MES : String = 'Xbh̗eʂt@CČvZ܂B'#13#10 +
							'̑쒆AMRiȓ̑ƃf[^j󂳂鋰ꂪ܂B' +
							'܂̑́AɎԂꍇ܂A낵łH';
	RECALC_TITLE : String = 'Xbh̗eʂt@CČvZ';
	LIMIT_SIZE = 1024;
var
	limitSize : Integer;
	limitStr  : String;
begin
{ ܂AԂ邱Ƃx郁bZ[Wo
  ČvZXbh̃TCY臒liftHg1024B)mF
  vOC𗘗pȂƂőSẴOLXbh
  臒lȉ̃TCY̏ꍇADAT̃t@CTCYƔrAĂ΁A
  DAT̃t@CTCYōXV
}
	if MsgBox(GikoForm.Handle, RECALC_MES,
		RECALC_TITLE, MB_YESNO or MB_ICONWARNING) = ID_YES then begin
		//臒l̊mF
		limitSize := LIMIT_SIZE;
		limitStr  := IntToStr(limitSize);
		if InputQuery('臒l', 'w肵l Bȉ̗eʂ̃XbĥݍČvZ܂', limitStr) then begin
			limitSize := StrToInt(MojuUtils.ZenToHan(limitStr));
			if (limitSize < 0) then begin
				ShowMessage('臒lɕ͎wł܂I');
				ThreadSizeCalcForFileActionExecute(nil);
			end else begin
				RecalcThreadSize(limitSize);
			end;
		end;
	end;
end;
//! limitTCY̏Xbh̗eʂDATt@CvZ
procedure TGikoDM.RecalcThreadSize(limit : Integer);
var
	i, j, tmpSize : Integer;
	Obj   : TObject;
	Board : TBoard;
	Thread: TThreadItem;
	dat   : TStringList;
begin
	// ČvZX^[g@vOC𗘗pȂƂSI
	GikoForm.ScreenCursor := crHourGlass;
	try
		GikoForm.ProgressBar.Max := BoardGroups[0].Count;
		for i := 0 to BoardGroups[0].Count - 1 do begin
			Obj := BoardGroups[0].Objects[i];
			if (Obj <> nil) then begin
				Board := TBoard(Obj);
				if not Board.IsThreadDatRead then begin
					GikoSys.ReadSubjectFile(Board);
				end;
				for j := 0 to Board.Count - 1 do begin
					Thread := Board.Items[j];
					if (Thread <> nil) and (Thread.IsLogFile)
						and (Thread.Size <= limit) then begin
						dat := TStringList.Create;
						try
							tmpSize := Thread.Size;
							try
								dat.LoadFromFile(Thread.GetThreadFileName);
								tmpSize := Length(dat.Text);
								tmpSize := tmpSize - dat.Count;
							except
							end;
							Thread.Size := tmpSize;
						finally
							dat.Free;
						end;
					end;
				end;
			end;
			GikoForm.ProgressBar.StepBy(1);
		end;
	finally
		GikoForm.ScreenCursor := crDefault;
	end;
	GikoForm.ProgressBar.Position := 0;
	ShowMessage('vZI܂B');
end;
// *************************************************************************
//! ̓AVXg̐ݒtH[Ăяo
// *************************************************************************
procedure TGikoDM.SetInputAssistActionExecute(Sender: TObject);
var
	form : TInputAssistForm;
begin
	form := TInputAssistForm.Create(GikoForm);
	try
		form.SetUpFromMain;
		form.ShowModal;
	finally
		form.Release;
	end;
end;
// *************************************************************************
//! ݕ\ĂXbȟ_CAO\
// *************************************************************************
procedure TGikoDM.OpenFindDialogActionExecute(Sender: TObject);
begin
	if( GikoForm.ActiveContent <> nil) and (GikoForm.ActiveContent.Browser <> nil) then begin
        GikoForm.ActiveContent.OpenFindDialog;
	end;
end;

// *************************************************************************
//! IĂ邨Cɓ̕\Rs[
// *************************************************************************
procedure TGikoDM.FavoriteTreeViewItemNameCopyActionExecute(
  Sender: TObject);
begin
	if GikoForm.ClickNode = nil then Exit;

	Clipboard.AsText :=
			GikoForm.ClickNode.Text + #13#10;
end;

// *************************************************************************
//! \Ă邷ׂẴXGfB^
// *************************************************************************
procedure TGikoDM.CloseAllEditorActionExecute(Sender: TObject);
var
    i : Integer;
begin
    if ( EditorFormExists ) then begin
    	//XN[̑SẴtH[AEditorForm
	    for i := Screen.CustomFormCount - 1 downto 0 do begin
    		if TObject(Screen.CustomForms[i]) is TEditorForm then begin
                TEditorForm(Screen.CustomForms[i]).Close;
    		end;
	    end;
    end;
end;
// *************************************************************************
//! XN[ɃXGfB^ꍇCLɂȂ
// *************************************************************************
procedure TGikoDM.CloseAllEditorActionUpdate(Sender: TObject);
begin
    if (Sender is TAction) then begin
        TAction(Sender).Enabled := EditorFormExists;
    end;
end;
// *************************************************************************
//! XN[EditorForm邩
// *************************************************************************
function TGikoDM.EditorFormExists(): boolean;
var
	i : Integer;
begin
	Result := false;
	//XN[̑SẴtH[AEditorFormT
	for i := Screen.CustomFormCount - 1 downto 0 do begin
		if (Screen.CustomForms[i] is TEditorForm) then begin
			Result := true;
			Break;
		end;
	end;
end;

// *************************************************************************
//! XN[ɂ邷ׂĂEditorForm疼O̗폜
// *************************************************************************
procedure TGikoDM.ClearNameTextAllEditor();
var
	i : Integer;
begin
	for i := 0 to Screen.CustomFormCount - 1 do begin
		if (Screen.CustomForms[i] is TEditorForm) then begin
			TEditorForm(Screen.CustomForms[i]).NameComboBox.Items.Clear;
        end;
	end;
end;
// *************************************************************************
//! XN[ɂ邷ׂĂEditorForm烁[폜
// *************************************************************************
procedure TGikoDM.ClearMailAllEditor();
var
	i : Integer;
begin
	for i := 0 to Screen.CustomFormCount - 1 do begin
		if TObject(Screen.CustomForms[i]) is TEditorForm then
			TEditorForm(Screen.CustomForms[i]).MailComboBox.Items.Clear;
	end;
end;

// *************************************************************************
//! N߂̍XV
// *************************************************************************
procedure TGikoDM.PrevMoveHistoryUpdate(Sender: TObject);
begin
      PrevMoveHistory.Enabled :=
          (MoveHisotryManager.HisotryIndex > 0)
end;
// *************************************************************************
//! N߂
// *************************************************************************
procedure TGikoDM.PrevMoveHistoryExecute(Sender: TObject);
begin
    if ( GikoForm.BrowserTab.TabIndex >= 0 ) then begin
        BackToHistory(MoveHisotryManager.getPrevItem
            (TBrowserRecord(GikoForm.BrowserTab.Tabs
                    .Objects[GikoForm.BrowserTab.TabIndex])));
    end else begin
        BackToHistory(MoveHisotryManager.getPrevItem( nil ) );
    end;
end;
//! N
procedure TGikoDM.BackToHistory(item: TMoveHistoryItem);
var
    browser : TWebBrowser;
    doc : IHTMLDocument2;
begin
    if ( item <> nil ) then begin
        if ( GikoForm.GetActiveContent = item.ThreadItem ) then begin
            browser := TBrowserRecord(GikoForm.BrowserTab.Tabs
                .Objects[GikoForm.BrowserTab.TabIndex]).Browser;
            if (browser <> nil) then begin
                try
                    doc := browser.ControlInterface.Document as IHTMLDocument2;
                    (doc.body as IHTMLElement2).ScrollTop := item.ScrollTop;
                except
                end;
            end;
        end else begin
            //URLɈړ
            MoveURLWithHistory(item.ThreadItem.URL, True);
        end;
    end;
end;
//! URLړ
procedure TGikoDM.MoveURLWithHistory(URL : String; KeyMask: Boolean = False);
var
    idx : Integer;
begin
    //URLɈړ
    GikoForm.MoveToURL(URL, KeyMask);
    //ȉȀ
    idx := GikoForm.AddressComboBox.Items.IndexOf(URL);
    if idx = -1 then begin
        GikoForm.AddressComboBox.Items.Insert(0, URL);
        if GikoForm.AddressComboBox.Items.Count > GikoSys.Setting.AddressHistoryCount then
            GikoForm.AddressComboBox.Items.Delete(GikoForm.AddressComboBox.Items.Count - 1);
    end else begin
        GikoForm.AddressComboBox.Items.Delete(idx);
        GikoForm.AddressComboBox.Items.Insert(0, URL);
    end;
end;
// *************************************************************************
//! Niނ̍XV
// *************************************************************************
procedure TGikoDM.NextMoveHistoryUpdate(Sender: TObject);
begin
    NextMoveHistory.Enabled :=
          (MoveHisotryManager.HisotryIndex < MoveHisotryManager.Count - 1);
end;
// *************************************************************************
//! Ni
// *************************************************************************
procedure TGikoDM.NextMoveHistoryExecute(Sender: TObject);
begin
    BackToHistory(MoveHisotryManager.getNextItem);
end;
// *************************************************************************
//! ANeBuvf̃NbN
// *************************************************************************
procedure TGikoDM.ClickActiveElementActionExecute(Sender: TObject);
var
    browser : TWebBrowser;
    elem : IHTMLElement;
    doc : IHTMLDocument2;
begin
    if (GikoForm.GetActiveContent <> nil) then begin
        if (GikoForm.BrowserTab.Tabs.Count > 0) and
            (GikoForm.BrowserTab.TabIndex >= 0) then begin
            browser := TBrowserRecord(GikoForm.BrowserTab.Tabs
                .Objects[GikoForm.BrowserTab.TabIndex]).Browser;
            if (browser <> nil) then begin
                try
                    doc := browser.ControlInterface.Document as IHTMLDocument2;
                    if Assigned(doc) then begin
                        elem := doc.activeElement;
                        if Assigned(elem) then begin
                            elem.click;
                        end;
                    end;
                except
                end;
            end;

        end;
    end;
end;
//! L[̃G~[gANV
procedure TGikoDM.VKDownActionExecute(Sender: TObject);
begin
    keybd_event(VK_DOWN, 0, KEYEVENTF_EXTENDEDKEY, 0);
    keybd_event(VK_DOWN, 0, KEYEVENTF_EXTENDEDKEY or KEYEVENTF_KEYUP, 0);
end;
//! L[̃G~[gANV
procedure TGikoDM.VKUpActionExecute(Sender: TObject);
begin
    keybd_event(VK_UP, 0, KEYEVENTF_EXTENDEDKEY, 0);
    keybd_event(VK_UP, 0, KEYEVENTF_EXTENDEDKEY or KEYEVENTF_KEYUP, 0);
end;
//! L[̃G~[gANV
procedure TGikoDM.VKRightActionExecute(Sender: TObject);
begin
    keybd_event(VK_RIGHT, 0, KEYEVENTF_EXTENDEDKEY, 0);
    keybd_event(VK_RIGHT, 0, KEYEVENTF_EXTENDEDKEY or KEYEVENTF_KEYUP, 0);
end;
//! L[̃G~[gANV
procedure TGikoDM.VKLeftActionExecute(Sender: TObject);
begin
    keybd_event(VK_LEFT, 0, KEYEVENTF_EXTENDEDKEY, 0);
    keybd_event(VK_LEFT, 0, KEYEVENTF_EXTENDEDKEY or KEYEVENTF_KEYUP, 0);
end;
//! ^XNgCɊi[
procedure TGikoDM.StoredTaskTrayActionExecute(Sender: TObject);
begin
    GikoForm.StoredTaskTray;
    StoredTaskTrayAction.Tag := -1;
end;

{
\breif  NC[W擾
C[ẂC*.jpg, *.jpeg, *.gif, *.png
}
procedure TGikoDM.AllImageLinkToClipbordActionExecute(Sender: TObject);
var
    links : IHTMLElementCollection;
    urls, exts : TStringList;
begin
    links := GetActiveThreadLinks;
    if (links <> nil) then begin
        urls := TStringList.Create;
        exts := TStringList.Create;
        try
            exts.CaseSensitive := False;
            exts.Sorted := True;
            exts.Delimiter := ';';
            exts.DelimitedText := '.gif;.jpg;.jpeg;.png';
            GetLinkURLs(links, urls, 0, exts);
            Clipboard.SetTextBuf(urls.GetText);
        finally
            exts.Free;
            urls.Free;
        end;
    end;
end;

{
\breif  VX̃NC[W擾
C[ẂC*.jpg, *.jpeg, *.gif, *.png
}
procedure TGikoDM.NewImageLinkToClipBoardActionExecute(Sender: TObject);
var
    links : IHTMLElementCollection;
    urls, exts : TStringList;
    ThreadItem : TThreadItem;
begin
    ThreadItem := GikoForm.GetActiveContent;
    links := GetActiveThreadLinks;
    if (ThreadItem <> nil) and (links <> nil) then begin
        urls := TStringList.Create;
        exts := TStringList.Create;
        try
            exts.CaseSensitive := False;
            exts.Sorted := True;
            exts.Delimiter := ';';
            exts.DelimitedText := '.gif;.jpg;.jpeg;.png';

            GetLinkURLs(links, urls,
                (ThreadItem.Count - ThreadItem.NewResCount + 1), exts );
            Clipboard.SetTextBuf(urls.GetText);
        finally
            exts.Free;
            urls.Free;
        end;
    end;
end;
{
\breif  NURL擾
Ώۊgq́AڍאݒŐݒ肳Ă
}
procedure TGikoDM.AllLinkToClipboardActionExecute(Sender: TObject);
var
    links : IHTMLElementCollection;
    urls, exts : TStringList;
begin
    links := GetActiveThreadLinks;
    if (links <> nil) then begin
        urls := TStringList.Create;
        exts := TStringList.Create;
        try
            exts.CaseSensitive := False;
            exts.Sorted := True;
            exts.Delimiter := ';';
            exts.DelimitedText :=
                MojuUtils.CustomStringReplace(GikoSys.Setting.ExtList, '*', '');
            GetLinkURLs(links, urls, 0, exts);
            Clipboard.SetTextBuf(urls.GetText);
        finally
            exts.Free;
            urls.Free;
        end;
    end;
end;
{
\breif  VXNURL擾
Ώۊgq́AڍאݒŐݒ肳Ă
}
procedure TGikoDM.NewLinkToClipboardActionExecute(Sender: TObject);
var
    links : IHTMLElementCollection;
    urls, exts : TStringList;
    ThreadItem : TThreadItem;
begin
    ThreadItem := GikoForm.GetActiveContent;
    links := GetActiveThreadLinks;
    if (ThreadItem <> nil) and (links <> nil) then begin
        urls := TStringList.Create;
        exts := TStringList.Create;
        try
            exts.CaseSensitive := False;
            exts.Sorted := True;
            exts.Delimiter := ';';
            exts.DelimitedText :=
                MojuUtils.CustomStringReplace(GikoSys.Setting.ExtList, '*', '');
            GetLinkURLs(links, urls,
                (ThreadItem.Count - ThreadItem.NewResCount + 1), exts );
            Clipboard.SetTextBuf(urls.GetText);
        finally
            exts.Free;
            urls.Free;
        end;
    end;
end;

{
\brief  ݕ\ĂXbĥׂẴN擾B
\return IHTMLElementCollection  ÑRNV
}
function TGikoDM.GetActiveThreadLinks : IHTMLElementCollection;
var
    browser : TWebBrowser;
    doc : IHTMLDocument2;
begin
    Result := nil;
    if (GikoForm.GetActiveContent <> nil) then begin
        if (GikoForm.BrowserTab.Tabs.Count > 0) and
            (GikoForm.BrowserTab.TabIndex >= 0) then begin
            browser := TBrowserRecord(GikoForm.BrowserTab.Tabs
                .Objects[GikoForm.BrowserTab.TabIndex]).Browser;
            if (browser <> nil) then begin
                try
                    doc := browser.ControlInterface.Document as IHTMLDocument2;
                    if Assigned(doc) then begin
                        Result := doc.links;
                    end;
                except
                    Result := nil;
                end;
            end;

        end;
    end;
end;
{
\brief  NURL擾
\param  links   擾郊N̑Ŝ̃RNV
\param  URLs    擾URL̕ۑ
\param  Start   ݒ肵Xԍȍ~擾( > 0)
\param  Exts    擾郊N̊gq
}
procedure TGikoDM.GetLinkURLs(links : IHTMLElementCollection;
        URLs : TStringList; const Start: Integer; Exts : TStringList);
var
    index ,i, j : Integer;
    item : IHTMLElement;
    url, ext : string;
begin
    if (links <> nil) then begin
        index := 0;
        for i := 0 to links.length - 1 do begin
            item := links.item(i, 0) as IHTMLElement;
            if (item <> nil) then begin
                url := item.getAttribute('href', 0);
                // X̔ԍXV
                if (Pos('menu:', url) > 0) then begin
                    index := StrToInt64Def(
                        Copy(url, 6, Length(url)), index + 1
                    );
                end else begin
                    // JnXԍȍ~`FbN
                    if (index >= Start) then begin
                        ext := ExtractFileExt( AnsiLowerCase(url) );
                        // gq`FbN
                        if Exts.Find(ext, j) then begin
                            urls.Add(url)
                        end;
                    end;
                end;
            end;
        end;
    end;
end;
{
\brief  AhXo[ɃtH[JX𓖂Ă
\param  Sender   Cxg̔
}
procedure TGikoDM.SetForcusForAddresBarActionExecute(Sender: TObject);
begin
    if ( GikoForm.AddressToolBar.Visible ) then begin
        GikoForm.AddressComboBox.SetFocus;
    end
end;
{
\brief  ړ]URL擾_CAO\
}
procedure TGikoDM.NewBoardSearchActionExecute(Sender: TObject);
var
    form : TNewBoardURLForm;
	Msg: string;
begin
	if (EditorFormExists) then begin
		Msg := 'XGfB^SĕĂ';
		MsgBox(GikoForm.Handle, Msg, MSG_ERROR, MB_OK or MB_ICONSTOP);
		Exit;
	end;
    form := TNewBoardURLForm.Create(Self);
    try
        form.ShowModal;
    finally
        form.Release;
    end;
end;
//! uEU1y[WXN[
procedure TGikoDM.ScrollPageDownActionExecute(Sender: TObject);
begin
    GikoForm.BrowserMovement(GikoForm.BrowserPanel.Height);
end;
//! uEU1y[WXN[
procedure TGikoDM.ScrollPageUpActionExecute(Sender: TObject);
begin
    GikoForm.BrowserMovement(-GikoForm.BrowserPanel.Height);
end;


//! ̃XIDNG[hɒǉi)
procedure TGikoDM.AddIDtoNGWord0ActionExecute(Sender: TObject);
begin
    GikoForm.AddIDtoNGWord(true);
end;
//! ̃XIDNG[hɒǉ
procedure TGikoDM.AddIDtoNGWord1ActionExecute(Sender: TObject);
begin
    GikoForm.AddIDtoNGWord(false);
end;
//! Nbv{[h̕IDƂēIDXAJ[\
procedure TGikoDM.ExtractSameIDActionExecute(Sender: TObject);
var
    ID: String;
begin
    ID := Trim(Clipboard.AsText);
    if (Length(ID) > 0) then begin
        if not IsNoValidID(ID) then begin
            GikoForm.ShowSameIDAncher(ID);
        end;
    end;
end;
//! ^ũXbhꗗ\
procedure TGikoDM.ShowTabListActionExecute(Sender: TObject);
var
    i : Integer;
begin
    GikoForm.ListView.Items.BeginUpdate;
    GikoForm.ListView.Items.Clear;
    BoardGroup.SpecialBoard.Clear;
	for i := GikoForm.BrowserTab.Tabs.Count - 1 downto 0 do begin
        BoardGroup.SpecialBoard.Add(
    		TBrowserRecord(GikoForm.BrowserTab.Tabs.Objects[i]).Thread);
	end;
    GikoForm.ListView.Items.EndUpdate;
    GikoForm.SetActiveList(BoardGroup.SpecialBoard);
end;
//! tQƂĂ郌Xǉ
procedure TGikoDM.DereferenceResActionExecute(Sender: TObject);
var
	i, currentNo, No : Integer;
    links : IHTMLElementCollection;
    threadItem : TThreadItem;
    item : IHTMLElement;
    url, url2 : string;
    resNo : TStringList;
    alreadyExist : Boolean;
  	PathRec: TPathRec;
begin
	No := GikoForm.KokoPopupMenu.Tag;
	if No = 0 then Exit;

    ThreadItem := GikoForm.KokoPopupThreadItem;
    // ANeBu^uSẴN擾
    links := GetActiveThreadLinks;
    if (ThreadItem <> nil) and (links <> nil) then begin
        resNo := TStringList.Create;
        try
            currentNo := 0;
            alreadyExist := False;
            // NSđ
            for i := 0 to links.length - 1 do begin
                item := links.item(i, 0) as IHTMLElement;
                if (item <> nil) then begin
                    url := item.getAttribute('href', 0);
                    // X̔ԍXV
                    if (Pos('menu:', url) > 0) then begin
                        currentNo := StrToInt64Def(
                            Copy(url, 6, Length(url)), currentNo + 1
                        );
                        alreadyExist := False;
                    end else if (currentNo <> -1) and (not alreadyExist) then begin
                        // IE7Ή
                        if Pos('about:..', url) = 1 then begin
                            url := 'about:blank..' + Copy( url, Length('about:..')+1, Length(url) )
                        end;
                        // ւ̃N烌X|bvp̔ԍ擾
                        if Pos('about:blank..', url) = 1 then begin
                            // No Ԃւ̃NΎQƂ
                            url2 := THTMLCreate.GetRespopupURL(url, ThreadItem.URL);
                			PathRec := Gikosys.Parse2chURL2(url2);
                            if (not PathRec.FNoParam) then begin
                                Gikosys.GetPopupResNumber(url2,PathRec.FSt,PathRec.FTo);
			                end;
                            // ΏۃX͂܂ނȂQƂƂ
                            if (PathRec.FSt = No) or
                                ((PathRec.FSt <= No) and (PathRec.FTo >= No))  then begin
                                alreadyExist := True;
                                resNo.Add(IntToStr(currentNo));
                            end;
                        end;
                    end;
                end;
            end;
            // Ȃ̂-1Œ
            GikoForm.ActiveContent.IDAnchorPopup(
                GikoSys.CreateResAnchor(resNo, ThreadItem, -1));
        finally
            resNo.Clear;
            resNo.Free;
        end;
    end;
end;

procedure TGikoDM.UpdateGikonaviActionExecute(Sender: TObject);
var
    form : TUpdateCheckForm;
	Msg: string;
    shutdown: boolean;
begin
	if (EditorFormExists) then begin
		Msg := 'XGfB^SĕĂ';
		MsgBox(GikoForm.Handle, Msg, MSG_ERROR, MB_OK or MB_ICONSTOP);
		Exit;
	end;
    GikoForm.UpdateExePath := '';
    GikoForm.UpdateExeArgs := '';
    form := TUpdateCheckForm.Create(GikoForm);
    try
        form.ShowModal;
        shutdown := form.Allowshutdown;
        if shutdown then begin
            GikoForm.UpdateExePath := form.ExecPath;
            GikoForm.UpdateExeArgs := form.ExecArgs;
        end;
    finally
        form.Release;
    end;
    if shutdown then begin
        // MRirI
        GikoForm.Close;
    end;

end;
//! ̃XURLRs[iPATH_INFO)
procedure TGikoDM.konoURLPATHActionExecute(Sender: TObject);
var
    No : Integer;
    ThreadItem : TThreadItem;
    URL, Protocol, Host, Path, Document, Port, Bookmark : String;
begin
	No := GikoForm.KokoPopupMenu.Tag;
	if No = 0 then Exit;

    ThreadItem := GikoForm.KokoPopupThreadItem;
    if (ThreadItem.ParentBoard.Is2ch) or not (Pos('?', ThreadItem.URL) > 0) then begin
        GikoSys.ParseURI(ThreadItem.URL,Protocol, Host, Path, Document, Port, Bookmark);
        URL := Protocol + '://' + Host + Path + IntToStr(No);
    end else begin
        if Pos('?', ThreadItem.URL) > 0 then begin
            URL := Copy(ThreadItem.URL, 1, Pos('?', ThreadItem.URL)-1);
            // ܂BBSpu
            URL := MojuUtils.CustomStringReplace(URL, 'read.pl', 'read.cgi');
            URL := URL + '/' + ThreadItem.ParentBoard.BBSID + '/' + ChangeFileExt(ThreadItem.FileName, '')  + '/' + IntToStr(No);
        end;
    end;
    Clipboard.SetTextBuf( PChar(URL) );
end;
//! ̃XURLRs[iQuery_STRING)
procedure TGikoDM.konoURLQueryActionExecute(Sender: TObject);
var
    No : Integer;
    ThreadItem : TThreadItem;
    URL, Protocol, Host, Path, Document, Port, Bookmark : String;
begin
	No := GikoForm.KokoPopupMenu.Tag;
	if No = 0 then Exit;

    ThreadItem := GikoForm.KokoPopupThreadItem;
    // 2chƂ΂́AXԍ܂ĂȂ̂ŗps
    if ThreadItem.ParentBoard.Is2ch or not (Pos('?', ThreadItem.URL) > 0) then begin
        GikoSys.ParseURI(ThreadItem.URL, Protocol, Host, Path, Document, Port, Bookmark);
        URL := Protocol + '://' + Host + '/test/read.cgi?bbs=' + ThreadItem.ParentBoard.BBSID
            + '&key=' + ChangeFileExt(ThreadItem.FileName, '') + '&st=' + IntToStr(No) + '&to=' + IntToStr(No);
    end else begin
        URL := ThreadItem.URL;
        // ܂BBS
        if Pos('&LAST=', URL) > 0 then begin
            URL := Copy(URL, 1, Pos('&LAST=', URL) - 1);
            URL := URL + '&START=' + IntToStr(No) + '&END=' + IntToStr(No);
        end;
        // ̑O
        if Pos('&ls=', URL) > 0 then begin
            URL := Copy(URL, 1, Pos('&ls=', URL) - 1);
            URL := URL + '&st=' + IntToStr(No) + '&to=' + IntToStr(No);
        end;

    end;
    Clipboard.SetTextBuf( PChar(URL) );
end;
//! ̃XURLRs[iQuery_STRINGj̗p`FbN
procedure TGikoDM.konoURLQueryActionUpdate(Sender: TObject);
const
	LIVEDOOR_URL = 'http://jbbs.shitaraba.net/';
begin
    // 2chƂ΂͗płȂ悤ɂi܂XwłȂ̂Łj
    konoURLQueryAction.Enabled := false;
    if (GikoForm.KokoPopupThreadItem <> nil) then begin
        konoURLQueryAction.Enabled := not GikoForm.KokoPopupThreadItem.ParentBoard.Is2ch;
        if konoURLQueryAction.Enabled then begin
            konoURLQueryAction.Enabled := not (Pos(LIVEDOOR_URL, GikoForm.KokoPopupThreadItem.URL) = 1);
        end;
    end;
end;
//! |bvAbvj[ݒ_CAOJ
procedure TGikoDM.PopupMenuSettingActionExecute(Sender: TObject);
var
	Dlg: TPopupMenuSettingDialog;
begin
	Dlg := TPopupMenuSettingDialog.Create(GikoForm, GikoFormActionList);
	try
		Dlg.ShowModal;
	finally
		Dlg.Release;
	end;
end;

end.

