/*******************************************************************************
Copyright (C) 2008 HIMACS,ltd.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
   See the License for the specific language governing permissions and limitations under the License.

This Software (including binary module, source code, other additional module)(gSoftwareh)
is provided and licensed by HIMACS, Ltd. (gHIMACSh) on an as is basis and free of charge.
HIMACS disclaims any express or implied warranties, including, but not limited to,
the bug-free and defect-free programming, this Softwarefs perfect running under the recommended
environment for its usage, the implied warranties of merchantability and fitness
for a particular purpose with regard to this Software. HIMACS shall not be responsible for 
all liability for any loss, liability, damages (whether direct or indirect,
incidental or consequential, and including loss of data or profits,
or damages caused by business interruption),
personal injury or expense of any nature whatsoever which may be suffered
by the user of this Software as a result of or which may be attributable, directly or indirectly,
to the use of this Software.
*******************************************************************************/
/**
 * Created on 9 sept. 2008
 * Created by Takaki Tsue, Masato Kawahashi
 * Copyright (C) 2008 HIMACS,ltd. 
 * Licensed under the Apache License, Version 2.0
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <unistd.h>
#include <malloc.h>
#include <execinfo.h>
#include <string.h>
#include "gerons_core.h"
#ifdef _THREAD_SAFE
#include <pthread.h>
#endif // _THREAD_SAFE

/* function prototype declare */

/*
 * malloc Hook initializer.
 */
static void my_init_hook(void);

/* Debug purposed hook pointer */
static void *my_malloc_hook(size_t, const void *);
static void my_free_hook(void *, const void *);

/* Original hook pointer */
static void *(*old_malloc_hook)(size_t, const void *);
static void (*old_free_hook)(void *, const void *);
	
GERONS_SHM *logArea; //Shared memopry pointer for logging

#ifdef _THREAD_SAFE
/* MT lock resource */
static pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
#endif // _THREAD_SAFE

/* Lock to synchronize multi thread operations */
static void lock()
{
#ifdef __THREAD_SAFE
	pthread_mutex_lock(&mutex);
#endif // __THREAD_SAFE
}

/* Unlock to synchronize multi thread operations */
static void unlock()
{
#ifdef __THREAD_SAFE
	pthread_mutex_unlock(&mutex);
#endif // __THREAD_SAFE
}

/* Initialiaze hook */
static void my_init_hook(void)
{
	old_malloc_hook = __malloc_hook;	
	old_free_hook = __free_hook;	
	__malloc_hook = my_malloc_hook;
	__free_hook = my_free_hook;
}

/*
 * initializer.
 * please do ld command with option -init _init_debug
 */
void _init_debug()
{
	 __malloc_initialize_hook = my_init_hook;
	

	_init_common();
}


/*
 * logging.
 */
void logging(SHM_LOG *data)
{
	if (logArea == NULL) {
		// Zannen
		return;
	}
	memcpy(&(logArea->log[logArea->curPos++%logArea->nEntry]), data, sizeof(SHM_LOG));
}

/*
 * set backtrace information.
 */
inline void setBackTrace(void **stack, char address[][MAX_STRLEN+1])
{
	int nptrs = backtrace(stack, STACK_DEPTH);
	char **strings = backtrace_symbols(stack, STACK_DEPTH);;
	int i;

	for(i = 0; i < nptrs ; i++) {
		strncpy(address[i], strings[i], MAX_STRLEN);
	}
	free(strings);
}

/*
 * malloc for debug.
 */
static void *
my_malloc_hook(size_t length, const void *caller)
{
    void *result;
	SHM_LOG log;

	lock();
	__malloc_hook = old_malloc_hook;
	__free_hook = old_free_hook;
	result = malloc(length);


	memset(&log, 0, sizeof(SHM_LOG));
	log.pid = getpid();
	log.type = TYPE_MALLOC;
	log.size = length;
	log.ptr = result;
	setBackTrace(log.stack, log.address);
	logging(&log);

	__malloc_hook = my_malloc_hook;
	__free_hook = my_free_hook;

	unlock();
	return result;
}

/*
 * free for debug.
 */
void my_free_hook(void *ptr, const void *caller)
{
	SHM_LOG log;

	lock();
	__free_hook = old_free_hook;
	__malloc_hook = old_malloc_hook;
	free(ptr);
	memset(&log, 0, sizeof(SHM_LOG));
	log.pid = getpid();
	log.type = TYPE_FREE;
	log.ptr = ptr;
	setBackTrace(log.stack, log.address);
	logging(&log);
	__malloc_hook = my_malloc_hook;
	__free_hook = my_free_hook;
	unlock();
}
