/*******************************************************************************
Copyright (C) 2008 HIMACS,ltd.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
   See the License for the specific language governing permissions and limitations under the License.

This Software (including binary module, source code, other additional module)(gSoftwareh)
is provided and licensed by HIMACS, Ltd. (gHIMACSh) on an as is basis and free of charge.
HIMACS disclaims any express or implied warranties, including, but not limited to,
the bug-free and defect-free programming, this Softwarefs perfect running under the recommended
environment for its usage, the implied warranties of merchantability and fitness
for a particular purpose with regard to this Software. HIMACS shall not be responsible for 
all liability for any loss, liability, damages (whether direct or indirect,
incidental or consequential, and including loss of data or profits,
or damages caused by business interruption),
personal injury or expense of any nature whatsoever which may be suffered
by the user of this Software as a result of or which may be attributable, directly or indirectly,
to the use of this Software.
*******************************************************************************/
/**
 * Created on 9 sept. 2008
 * Created by Takaki Tsue, Masato Kawahashi
 * Copyright (C) 2008 HIMACS,ltd. 
 * Licensed under the Apache License, Version 2.0
 *
 */

/*
 * Dump logging.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include "gerons_core.h"

GERONS_SHM *logArea; // information of malloc/free

/*
 * dump logging data.
 */
int main(int argc, char *argv[])
{
	int i = 0;

	_init_common();
	if (logArea==NULL) {
		return 1;
	}

	for(i = 0; i < logArea->nEntry; i++) {
		int j = 0;
		SHM_LOG log;

		memcpy(&log, &(logArea->log[i]), sizeof(log));
		if (log.type == 0) {
			break;
		}
		printf("%d,%p,%d,%x", log.pid, log.ptr, log.size, log.type);
		for(j = 0; j < STACK_DEPTH; j++) {
			printf(",%p", log.stack[j]);
		}
		for(j = 0; j < STACK_DEPTH; j++) {
			printf(",%s", log.address[j]);
		}
		printf("\n");
	}
	return 0;
}
