/*******************************************************************************
Copyright (C) 2008 HIMACS,ltd.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
   See the License for the specific language governing permissions and limitations under the License.

This Software (including binary module, source code, other additional module)(gSoftwareh)
is provided and licensed by HIMACS, Ltd. (gHIMACSh) on an as is basis and free of charge.
HIMACS disclaims any express or implied warranties, including, but not limited to,
the bug-free and defect-free programming, this Softwarefs perfect running under the recommended
environment for its usage, the implied warranties of merchantability and fitness
for a particular purpose with regard to this Software. HIMACS shall not be responsible for 
all liability for any loss, liability, damages (whether direct or indirect,
incidental or consequential, and including loss of data or profits,
or damages caused by business interruption),
personal injury or expense of any nature whatsoever which may be suffered
by the user of this Software as a result of or which may be attributable, directly or indirectly,
to the use of this Software.
*******************************************************************************/
/**
 * Created on 1 apri. 2009
 * Created by Takaki Tsue
 * Copyright (C) 2009 HIMACS,ltd. 
 * Licensed under the Apache License, Version 2.0
 *
 */

package com.tsuetools.gerons;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Set;

// Referenced classes of package com.tsuetools.gerons:
//            CSVAnalyzer, CSVReader

public class Main
{

    public Main()
    {
        leakMap = new HashMap();
        bytesMap = new HashMap();
        stackMap = new HashMap();
        resultMap = new HashMap();
    }

    private void saveLeak(String line)
    {
        CSVAnalyzer ana = new CSVAnalyzer(line, ",");
        int count = 0;
        long totalBytes = 0L;
        String key = ana.getCol(1, 2, ",");
        String stackKey = ana.getCol(15, 24, DELIM_LF);
        if(leakMap.containsKey(key))
            count = ((Integer)leakMap.get(key)).intValue();
        if(bytesMap.containsKey(stackKey))
            totalBytes = ((Long)bytesMap.get(stackKey)).longValue();
        String ope = ana.getCol(4, 4, ",");
        if(ope.equals("1"))
        {
            count++;
            totalBytes += Long.parseLong(ana.getCol(3, 3, ","));
        } else
        if(ope.equals("2"))
            count--;
        leakMap.put(key, new Integer(count));
        bytesMap.put(stackKey, new Long(totalBytes));
        stackMap.put(key, stackKey);
    }

    private void report()
    {
        String keyarr[] = (String[])resultMap.keySet().toArray(new String[0]);
        for(int i = 0; i < keyarr.length; i++)
        {
            System.out.println(resultMap.get(keyarr[i]));
            System.out.println("\t" + keyarr[i]);
            System.out.println();
        }

    }

    private void analyze()
    {
        String keyarr[] = (String[])leakMap.keySet().toArray(new String[0]);
        for(int i = 0; i < keyarr.length; i++)
        {
            int count = ((Integer)leakMap.get(keyarr[i])).intValue();
            String stackKey = (String)stackMap.get(keyarr[i]);
            if(count > 0)
                resultMap.put(stackKey, "in doubt of memory leak ( " + bytesMap.get(stackKey) + " bytes )");
            else
            if(count < 0)
                resultMap.put(stackKey, "in doubt of invalid free(ex. double free)");
        }

    }

    public static void main(String args[])
        throws IOException
    {
        Main main = new Main();
        String line = null;
        CSVReader reader = new CSVReader(System.in);
        while((line = reader.next()) != null) 
            main.saveLeak(line);
        main.analyze();
        main.report();
    }

    private HashMap leakMap;
    private HashMap bytesMap;
    private HashMap stackMap;
    private HashMap resultMap;
    private static final String DELIM_COMMA = ",";
    private static final String DELIM_LF = System.getProperty("line.separator") + "\t";
    private static final String OPE_MALLOC = "1";
    private static final String OPE_FREE = "2";
    private static final String ERR_MALLOC = "in doubt of memory leak";
    private static final String ERR_FREE = "in doubt of invalid free(ex. double free)";

}
