﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nft.framework.drawing;
using Microsoft.Xna.Framework.Graphics;
using DefaultEffect = StockEffects.AlphaTestEffect;

namespace nft.xna
{
    interface IDrawable
    {
        void RenderSelf(XnaSurface surface, DefaultEffect ef);
    }

    public class X3DObject : I3DObject, IDrawable
    {

        protected object _tag;
        protected EffectFilter filter;
        private XnaTexture texture;

        public X3DObject(XnaTexture texture, object tag)
        {
            this._tag = tag;
            this.texture = texture;
            texture.ImageSrc.AddRef();
        }

        public X3DObject(XnaTexture texture) : this( texture, null)
        {
        }

        public Texture2D Texture
        {
            get
            {
                return texture.ImageSrc.Texture2D;
            }
        }

        public object Tag
        {
            get
            {
                return _tag;
            }
            set
            {
                _tag = value;
            }
        }

        public IEffectFilter Effect
        {
            get
            {
                return filter;
            }
            set
            {
                filter = (EffectFilter)value;
            }
        }

        public virtual void RenderSelf(XnaSurface surface, DefaultEffect ef)
        {
        }

        #region IDisposable 定型
        public virtual void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        protected virtual void Dispose(Boolean disposing)
        {
            if (disposing && texture!=null)
            {
                texture.ImageSrc.ReleaseRef();
                texture = null;
            }
        }

        public bool IsDisposed
        { get { return texture == null; } }

        ~X3DObject()
        {
            Dispose(false);
        }
        #endregion
    }

    public class BillBoard : X3DObject, IBillboard
    {
        public BillBoard(XnaTexture texture, object tag)
            : base(texture, tag)
        {
        }
        
        Structure _anchor;
        PointF3D _offset;
        public ICubicStructure Anchor
        {
            get
            {
                return _anchor;
            }
            set
            {
                _anchor = (Structure)value;
            }
        }

        public PointF3D Offset
        {
            get
            {
                return _offset;
            }
            set
            {
                _offset = value;
            }
        }
    }

    public class EffectFilter : IEffectFilter
    {
    }
}
