﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.framework.drawing;
using System.IO;
using System.Drawing;
using System.Runtime.Serialization;

namespace nft.framework.util {
    public abstract class FileImageRef : ImageRef {

        public abstract string FullPath { get; }

        protected override Image CreateImage() {
            return Image.FromFile(FullPath);
        }

        public override bool Equals(object obj) {
            FileImageRef iref = obj as FileImageRef;
            return FullPath.Equals(iref.FullPath);
        }

        public override int GetHashCode() {
            return FullPath.GetHashCode();
        }
    }
}
