using System;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.Reflection;
using System.Xml;
using nft.framework;
using nft.framework.plugin;
using nft.util;
using nft.core;
using nft.core.structure;
using System.Windows.Forms;

namespace nft.core.game
{
    public interface IMapGenerator
	{
		// returns false if Setup is not available.
		bool IsSetupEnable { get; }
		// returns setup panel (if needed)
		IMapGeneSetupPanel GetSetupPanel();
		// ProgressMonitor that monitor generation process.
        ProgressMonitor Monitor { get; }
        // abort generating if possible (returns true)
        bool Abort();
	}

	/// <summary>
	/// generate terrain map
	/// </summary>
	public interface ITerrainGenerator
	{
        ITerrainMap Generate(ParamSet param);
	}

	/// <summary>
	/// divide world into districts (<code>IDistrict</code>).
	/// </summary>
	public interface IWorldDivider : IMapGenerator
	{
        ITerrainMap Divide(ITerrainMap map);
	}

	/// <summary>
	/// Generate cities, industries, and plants.
	/// </summary>
	public interface ILandGenerator : IMapGenerator
	{
		Lot[] Generate(ITerrainMap terrain);
	}

    public abstract class CtbMapGenerator : Contribution, IMapGenerator {
        protected Type typeSetupUI = null;
        protected IMapGeneSetupPanel pnlSetupUI;

        public CtbMapGenerator(Plugin p, XmlElement contrib)
            : base(p, contrib) {
            XmlNode node = contrib.SelectSingleNode("setup");
            if (node != null) {
                Type t = PluginUtil.loadTypeFromManifest(node as XmlElement);
                if (typeof(IMapGeneSetupPanel).IsAssignableFrom(t)) {
                    typeSetupUI = t;
                } else {
                    throw new InvalidCastException("setup UI class must be an instance of IMapGeneSetupPanel.");
                }
            }
        }

        public virtual IMapGenerator GetGenerator() { return this; }
		public override bool IsDetachable { get	{ return true; } }

        #region IMapGenerator o

        public virtual bool IsSetupEnable {
            get { return typeSetupUI != null; }
        }

        public virtual IMapGeneSetupPanel GetSetupPanel() {
            if (!IsSetupEnable) {
                throw new NotImplementedException();
            } else {
                if (pnlSetupUI == null || pnlSetupUI.IsDisposed) {
                    pnlSetupUI = CreateSetupUI();
                }
                return pnlSetupUI;
            }
        }

        public virtual bool Abort() {
            return false;
        }

        protected ProgressMonitor monitor = new ProgressMonitor(2);
        public virtual ProgressMonitor Monitor { get { return monitor; } }

        #endregion

        protected virtual IMapGeneSetupPanel CreateSetupUI() {
            return Activator.CreateInstance(typeSetupUI) as IMapGeneSetupPanel;
        }
    }
}
