/*
 * Copyright 2009-2012 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.exentity.FailureUrl;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.dbmeta.name.TableSqlName;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of FAILURE_URL. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class FailureUrlDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final FailureUrlDbm _instance = new FailureUrlDbm();

    private FailureUrlDbm() {
    }

    public static FailureUrlDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    @Override
    public DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    protected final String _tableDbName = "FAILURE_URL";

    protected final String _tablePropertyName = "failureUrl";

    protected final TableSqlName _tableSqlName = new TableSqlName(
            "FAILURE_URL", _tableDbName);
    {
        _tableSqlName.xacceptFilter(DBFluteConfig.getInstance()
                .getTableSqlNameFilter());
    }

    @Override
    public String getTableDbName() {
        return _tableDbName;
    }

    @Override
    public String getTablePropertyName() {
        return _tablePropertyName;
    }

    @Override
    public TableSqlName getTableSqlName() {
        return _tableSqlName;
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected final ColumnInfo _columnId = cci("ID", "ID", null, null, true,
            "id", Long.class, true, true, "BIGINT", 19, 0, false, null, null,
            null, null, null);

    protected final ColumnInfo _columnUrl = cci("URL", "URL", null, null, true,
            "url", String.class, false, false, "VARCHAR", 4000, 0, false, null,
            null, null, null, null);

    protected final ColumnInfo _columnThreadName = cci("THREAD_NAME",
            "THREAD_NAME", null, null, true, "threadName", String.class, false,
            false, "VARCHAR", 30, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnErrorName = cci("ERROR_NAME",
            "ERROR_NAME", null, null, false, "errorName", String.class, false,
            false, "VARCHAR", 255, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnErrorLog = cci("ERROR_LOG", "ERROR_LOG",
            null, null, false, "errorLog", String.class, false, false,
            "VARCHAR", 4000, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnErrorCount = cci("ERROR_COUNT",
            "ERROR_COUNT", null, null, true, "errorCount", Integer.class,
            false, false, "INTEGER", 10, 0, false, null, null, null, null, null);

    protected final ColumnInfo _columnLastAccessTime = cci("LAST_ACCESS_TIME",
            "LAST_ACCESS_TIME", null, null, true, "lastAccessTime",
            java.sql.Timestamp.class, false, false, "TIMESTAMP", 23, 10, false,
            null, null, null, null, null);

    protected final ColumnInfo _columnWebConfigId = cci("WEB_CONFIG_ID",
            "WEB_CONFIG_ID", null, null, false, "webConfigId", Long.class,
            false, false, "BIGINT", 19, 0, false, null, null,
            "webCrawlingConfig", null, null);

    protected final ColumnInfo _columnFileConfigId = cci("FILE_CONFIG_ID",
            "FILE_CONFIG_ID", null, null, false, "fileConfigId", Long.class,
            false, false, "BIGINT", 19, 0, false, null, null,
            "fileCrawlingConfig", null, null);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnUrl() {
        return _columnUrl;
    }

    public ColumnInfo columnThreadName() {
        return _columnThreadName;
    }

    public ColumnInfo columnErrorName() {
        return _columnErrorName;
    }

    public ColumnInfo columnErrorLog() {
        return _columnErrorLog;
    }

    public ColumnInfo columnErrorCount() {
        return _columnErrorCount;
    }

    public ColumnInfo columnLastAccessTime() {
        return _columnLastAccessTime;
    }

    public ColumnInfo columnWebConfigId() {
        return _columnWebConfigId;
    }

    public ColumnInfo columnFileConfigId() {
        return _columnFileConfigId;
    }

    @Override
    protected List<ColumnInfo> ccil() {
        final List<ColumnInfo> ls = newArrayList();
        ls.add(columnId());
        ls.add(columnUrl());
        ls.add(columnThreadName());
        ls.add(columnErrorName());
        ls.add(columnErrorLog());
        ls.add(columnErrorCount());
        ls.add(columnLastAccessTime());
        ls.add(columnWebConfigId());
        ls.add(columnFileConfigId());
        return ls;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    @Override
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    @Override
    public boolean hasPrimaryKey() {
        return true;
    }

    @Override
    public boolean hasCompoundPrimaryKey() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------
    public ForeignInfo foreignFileCrawlingConfig() {
        final Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(
                columnFileConfigId(), FileCrawlingConfigDbm.getInstance()
                        .columnId());
        return cfi("fileCrawlingConfig", this,
                FileCrawlingConfigDbm.getInstance(), map, 0, false, false);
    }

    public ForeignInfo foreignWebCrawlingConfig() {
        final Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(
                columnWebConfigId(), WebCrawlingConfigDbm.getInstance()
                        .columnId());
        return cfi("webCrawlingConfig", this,
                WebCrawlingConfigDbm.getInstance(), map, 1, false, false);
    }

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    @Override
    public boolean hasIdentity() {
        return true;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    @Override
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.FailureUrl";
    }

    @Override
    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.FailureUrlCB";
    }

    @Override
    public String getDaoTypeName() {
        return "${glPackageExtendedDao}.FailureUrlDao";
    }

    @Override
    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.FailureUrlBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    @Override
    public Class<FailureUrl> getEntityType() {
        return FailureUrl.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    @Override
    public Entity newEntity() {
        return newMyEntity();
    }

    public FailureUrl newMyEntity() {
        return new FailureUrl();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    @Override
    public void acceptPrimaryKeyMap(final Entity e,
            final Map<String, ? extends Object> m) {
        doAcceptPrimaryKeyMap((FailureUrl) e, m, _epsMap);
    }

    @Override
    public Map<String, Object> extractPrimaryKeyMap(final Entity e) {
        return doExtractPrimaryKeyMap(e);
    }

    @Override
    public Map<String, Object> extractAllColumnMap(final Entity e) {
        return doExtractAllColumnMap(e);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<FailureUrl>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsUrl(), columnUrl());
        setupEps(_epsMap, new EpsThreadName(), columnThreadName());
        setupEps(_epsMap, new EpsErrorName(), columnErrorName());
        setupEps(_epsMap, new EpsErrorLog(), columnErrorLog());
        setupEps(_epsMap, new EpsErrorCount(), columnErrorCount());
        setupEps(_epsMap, new EpsLastAccessTime(), columnLastAccessTime());
        setupEps(_epsMap, new EpsWebConfigId(), columnWebConfigId());
        setupEps(_epsMap, new EpsFileConfigId(), columnFileConfigId());
    }

    @Override
    public boolean hasEntityPropertySetupper(final String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    @Override
    public void setupEntityProperty(final String propertyName,
            final Object entity, final Object value) {
        findEps(_epsMap, propertyName).setup((FailureUrl) entity, value);
    }

    public class EpsId implements Eps<FailureUrl> {
        @Override
        public void setup(final FailureUrl e, final Object v) {
            e.setId(ctl(v));
        }
    }

    public static class EpsUrl implements Eps<FailureUrl> {
        @Override
        public void setup(final FailureUrl e, final Object v) {
            e.setUrl((String) v);
        }
    }

    public static class EpsThreadName implements Eps<FailureUrl> {
        @Override
        public void setup(final FailureUrl e, final Object v) {
            e.setThreadName((String) v);
        }
    }

    public static class EpsErrorName implements Eps<FailureUrl> {
        @Override
        public void setup(final FailureUrl e, final Object v) {
            e.setErrorName((String) v);
        }
    }

    public static class EpsErrorLog implements Eps<FailureUrl> {
        @Override
        public void setup(final FailureUrl e, final Object v) {
            e.setErrorLog((String) v);
        }
    }

    public class EpsErrorCount implements Eps<FailureUrl> {
        @Override
        public void setup(final FailureUrl e, final Object v) {
            e.setErrorCount(cti(v));
        }
    }

    public static class EpsLastAccessTime implements Eps<FailureUrl> {
        @Override
        public void setup(final FailureUrl e, final Object v) {
            e.setLastAccessTime((java.sql.Timestamp) v);
        }
    }

    public class EpsWebConfigId implements Eps<FailureUrl> {
        @Override
        public void setup(final FailureUrl e, final Object v) {
            e.setWebConfigId(ctl(v));
        }
    }

    public class EpsFileConfigId implements Eps<FailureUrl> {
        @Override
        public void setup(final FailureUrl e, final Object v) {
            e.setFileConfigId(ctl(v));
        }
    }
}
