<tiles:insert template="/WEB-INF/view/common/admin/layout.jsp" flush="true">
	<tiles:put name="title"><bean:message key="labels.failure_url_configuration" /></tiles:put>
	<tiles:put name="header" value="/WEB-INF/view/common/admin/header.jsp" />
	<tiles:put name="footer" value="/WEB-INF/view/common/admin/footer.jsp" />
	<tiles:put name="menu" value="/WEB-INF/view/common/admin/menu.jsp" />
	<tiles:put name="menuType" value="failureUrl" />
	<tiles:put name="headerScript" type="string"></tiles:put>
	<tiles:put name="body" type="string">

      <div id="main">
<!-- Message: BEGIN -->
<div><html:messages id="msg" message="true"><bean:write name="msg" ignore="true"/></html:messages><html:errors/></div>
<!-- Message: END -->

<!-- Search: BEGIN -->
<div class="form-table">
<s:form>
<table>
	<tbody>
		<tr>
			<td>
				<table><tbody>
								<tr>
						<th><bean:message key="labels.failure_url_search_url"/></th>
						<td><html:text property="searchParams.url"></html:text></td>
					</tr>
								<tr>
						<th><bean:message key="labels.failure_url_search_error_count"/></th>
						<td>
						<html:text property="searchParams.errorCountMin" size="2"></html:text>
						-
						<html:text property="searchParams.errorCountMax" size="2"></html:text>
						</td>
					<tr>
						<th><bean:message key="labels.failure_url_search_error_name"/></th>
						<td><html:text property="searchParams.errorName"></html:text></td>
					</tr>
					</tr>
				</tbody></table>
			</td>
			<td>
				<input type="submit" name="search" value="<bean:message key="labels.crud_button_search"/>"/>
				<input type="submit" name="reset" value="<bean:message key="labels.crud_button_reset"/>"/>
			</td>
		</tr>
	</tbody>
</table>
</s:form>
</div>
<!-- Search: END -->

<div style="margin-top:5px;">
<script><!-- 
function confirmToDeleteAll() {
	if(confirm('<bean:message key="labels.failure_url_delete_all_confirmation"/>')){
		return true;
	} else {
		return false;
	}
}
// -->
</script>
<s:link href="deleteall" onclick="return confirmToDeleteAll();"><bean:message key="labels.search_log_delete_all_link"/></s:link>
</div>


<!-- List: BEGIN -->
<div class="list-table">
<table border="1" style="margin-top:5px;">
	<thead>
		<tr>
				<th style="text-align: center;width:300px;"><bean:message key="labels.failure_url_url"/></th>
				<th style="text-align: center;"><bean:message key="labels.failure_url_last_access_time"/></th>
			<th style="text-align: center;">&nbsp;</th>
		</tr>
	</thead>
	<tbody>
		<c:forEach var="data" varStatus="s" items="${failureUrlItems}">
		<tr class="${s.index % 2 == 0 ? 'row1' : 'row2'}">
								<td><div style="width:300px;overflow-x:auto;">${f:h(data.url)}</div></td>
								<td>${f:h(data.lastAccessTimeForList)}</td>
			<td align="center">
				<s:link href="confirmpage/4/${f:u(data.id)}"><bean:message key="labels.failure_url_link_confirm"/></s:link>
				<s:link href="deletepage/3/${f:u(data.id)}"><bean:message key="labels.crud_link_delete"/></s:link>
			</td>
		</tr>
		</c:forEach>
	</tbody>
</table>
<!-- Page Navigation: BEGIN -->
<div>
	<span>
		<c:if test="${failureUrlPager.existPrePage}">
		<s:link href="list/${failureUrlPager.currentPageNumber - 1}"><bean:message key="labels.crud_link_prev_page"/></s:link>
		</c:if>
	</span>
	<span>
		<c:forEach var="p" varStatus="s" items="${failureUrlPager.pageNumberList}">
		<span>
			<c:if test="${p == failureUrlPager.currentPageNumber}">
			${p}
			</c:if>
			<c:if test="${p != failureUrlPager.currentPageNumber}">
			<s:link href="list/${p}">${p}</s:link>
			</c:if>
		</span>
		</c:forEach>
	</span>
	<span>
		<c:if test="${failureUrlPager.existNextPage}">
		<s:link href="list/${failureUrlPager.currentPageNumber + 1}"><bean:message key="labels.crud_link_next_page"/></s:link>
		</c:if>
	</span>
</div>
<div>
	<span>
		${failureUrlPager.currentPageNumber}/${failureUrlPager.allPageCount} (${failureUrlPager.allRecordCount})
	</span>
</div>
<!-- Page Navigation: END -->
</div>
<!-- List: END -->

</div>

	</tiles:put>
</tiles:insert>
