package jp.sf.fess.helper;

import java.io.Serializable;

import jp.sf.fess.Constants;
import jp.sf.fess.FessSystemException;

import org.mobylet.mail.MobyletMailer;
import org.mobylet.mail.message.MessageBody;
import org.mobylet.mail.message.MobyletMessage;

public class MailHelper implements Serializable {

    private static final long serialVersionUID = 1L;

    public String from = Constants.DEFAULT_FROM_EMAIL;

    public void send(final String[] toAddresses, final String subject,
            final String text) {
        if (toAddresses == null || toAddresses.length == 0) {
            throw new FessSystemException("TO address is empty.");
        }
        final MobyletMessage message = MobyletMailer
                .createMessage(toAddresses[0].trim());
        if (toAddresses.length > 1) {
            for (int i = 1; i < toAddresses.length; i++) {
                message.to(toAddresses[i].trim());
            }
        }
        final MessageBody body = new MessageBody();
        body.setText(text);
        message.from(from).subject(subject).setBody(body);
        MobyletMailer.send(message);
    }

}
