/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsentity.dbmeta;

import java.util.List;
import java.util.Map;

import jp.sf.fess.db.allcommon.DBCurrent;
import jp.sf.fess.db.allcommon.DBFluteConfig;
import jp.sf.fess.db.exentity.WebConfigToRoleTypeMapping;

import org.seasar.dbflute.DBDef;
import org.seasar.dbflute.Entity;
import org.seasar.dbflute.dbmeta.AbstractDBMeta;
import org.seasar.dbflute.dbmeta.info.ColumnInfo;
import org.seasar.dbflute.dbmeta.info.ForeignInfo;
import org.seasar.dbflute.dbmeta.info.UniqueInfo;
import org.seasar.dbflute.dbmeta.name.TableSqlName;
import org.seasar.dbflute.helper.StringKeyMap;

/**
 * The DB meta of WEB_CONFIG_TO_ROLE_TYPE_MAPPING. (Singleton)
 * @author DBFlute(AutoGenerator)
 */
public class WebConfigToRoleTypeMappingDbm extends AbstractDBMeta {

    // ===================================================================================
    //                                                                           Singleton
    //                                                                           =========
    private static final WebConfigToRoleTypeMappingDbm _instance = new WebConfigToRoleTypeMappingDbm();

    private WebConfigToRoleTypeMappingDbm() {
    }

    public static WebConfigToRoleTypeMappingDbm getInstance() {
        return _instance;
    }

    // ===================================================================================
    //                                                                       Current DBDef
    //                                                                       =============
    public DBDef getCurrentDBDef() {
        return DBCurrent.getInstance().currentDBDef();
    }

    // ===================================================================================
    //                                                                          Table Info
    //                                                                          ==========
    protected final String _tableDbName = "WEB_CONFIG_TO_ROLE_TYPE_MAPPING";

    protected final String _tablePropertyName = "webConfigToRoleTypeMapping";

    protected final TableSqlName _tableSqlName = new TableSqlName(
            "WEB_CONFIG_TO_ROLE_TYPE_MAPPING", _tableDbName);
    {
        _tableSqlName.xacceptFilter(DBFluteConfig.getInstance()
                .getTableSqlNameFilter());
    }

    public String getTableDbName() {
        return _tableDbName;
    }

    public String getTablePropertyName() {
        return _tablePropertyName;
    }

    public TableSqlName getTableSqlName() {
        return _tableSqlName;
    }

    // ===================================================================================
    //                                                                         Column Info
    //                                                                         ===========
    protected final ColumnInfo _columnId = cci("ID", "ID", null, null, true,
            "id", Long.class, true, true, "BIGINT", 19, 0, false, null, null,
            null, null, null);

    protected final ColumnInfo _columnWebConfigId = cci("WEB_CONFIG_ID",
            "WEB_CONFIG_ID", null, null, true, "webConfigId", Long.class,
            false, false, "BIGINT", 19, 0, false, null, null,
            "webCrawlingConfig", null, null);

    protected final ColumnInfo _columnRoleTypeId = cci("ROLE_TYPE_ID",
            "ROLE_TYPE_ID", null, null, true, "roleTypeId", Long.class, false,
            false, "BIGINT", 19, 0, false, null, null, "roleType", null, null);

    public ColumnInfo columnId() {
        return _columnId;
    }

    public ColumnInfo columnWebConfigId() {
        return _columnWebConfigId;
    }

    public ColumnInfo columnRoleTypeId() {
        return _columnRoleTypeId;
    }

    protected List<ColumnInfo> ccil() {
        List<ColumnInfo> ls = newArrayList();
        ls.add(columnId());
        ls.add(columnWebConfigId());
        ls.add(columnRoleTypeId());
        return ls;
    }

    {
        initializeInformationResource();
    }

    // ===================================================================================
    //                                                                         Unique Info
    //                                                                         ===========
    // -----------------------------------------------------
    //                                       Primary Element
    //                                       ---------------
    public UniqueInfo getPrimaryUniqueInfo() {
        return cpui(columnId());
    }

    public boolean hasPrimaryKey() {
        return true;
    }

    public boolean hasCompoundPrimaryKey() {
        return false;
    }

    // ===================================================================================
    //                                                                       Relation Info
    //                                                                       =============
    // -----------------------------------------------------
    //                                      Foreign Property
    //                                      ----------------
    public ForeignInfo foreignRoleType() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnRoleTypeId(),
                RoleTypeDbm.getInstance().columnId());
        return cfi("roleType", this, RoleTypeDbm.getInstance(), map, 0, false,
                false);
    }

    public ForeignInfo foreignWebCrawlingConfig() {
        Map<ColumnInfo, ColumnInfo> map = newLinkedHashMap(columnWebConfigId(),
                WebCrawlingConfigDbm.getInstance().columnId());
        return cfi("webCrawlingConfig", this,
                WebCrawlingConfigDbm.getInstance(), map, 1, false, false);
    }

    // -----------------------------------------------------
    //                                     Referrer Property
    //                                     -----------------

    // ===================================================================================
    //                                                                        Various Info
    //                                                                        ============
    public boolean hasIdentity() {
        return true;
    }

    // ===================================================================================
    //                                                                           Type Name
    //                                                                           =========
    public String getEntityTypeName() {
        return "jp.sf.fess.db.exentity.WebConfigToRoleTypeMapping";
    }

    public String getConditionBeanTypeName() {
        return "jp.sf.fess.db.cbean.bs.WebConfigToRoleTypeMappingCB";
    }

    public String getDaoTypeName() {
        return "${glPackageExtendedDao}.WebConfigToRoleTypeMappingDao";
    }

    public String getBehaviorTypeName() {
        return "jp.sf.fess.db.exbhv.WebConfigToRoleTypeMappingBhv";
    }

    // ===================================================================================
    //                                                                         Object Type
    //                                                                         ===========
    public Class<WebConfigToRoleTypeMapping> getEntityType() {
        return WebConfigToRoleTypeMapping.class;
    }

    // ===================================================================================
    //                                                                     Object Instance
    //                                                                     ===============
    public Entity newEntity() {
        return newMyEntity();
    }

    public WebConfigToRoleTypeMapping newMyEntity() {
        return new WebConfigToRoleTypeMapping();
    }

    // ===================================================================================
    //                                                                     Entity Handling
    //                                                                     ===============  
    public void acceptPrimaryKeyMap(Entity e, Map<String, ? extends Object> m) {
        doAcceptPrimaryKeyMap((WebConfigToRoleTypeMapping) e, m, _epsMap);
    }

    public Map<String, Object> extractPrimaryKeyMap(Entity e) {
        return doExtractPrimaryKeyMap(e);
    }

    public Map<String, Object> extractAllColumnMap(Entity e) {
        return doExtractAllColumnMap(e);
    }

    // ===================================================================================
    //                                                               Entity Property Setup
    //                                                               =====================
    // It's very INTERNAL!
    protected final Map<String, Eps<WebConfigToRoleTypeMapping>> _epsMap = StringKeyMap
            .createAsFlexibleConcurrent();
    {
        setupEps(_epsMap, new EpsId(), columnId());
        setupEps(_epsMap, new EpsWebConfigId(), columnWebConfigId());
        setupEps(_epsMap, new EpsRoleTypeId(), columnRoleTypeId());
    }

    public boolean hasEntityPropertySetupper(String propertyName) {
        return _epsMap.containsKey(propertyName);
    }

    public void setupEntityProperty(String propertyName, Object entity,
            Object value) {
        findEps(_epsMap, propertyName).setup(
                (WebConfigToRoleTypeMapping) entity, value);
    }

    public class EpsId implements Eps<WebConfigToRoleTypeMapping> {
        public void setup(WebConfigToRoleTypeMapping e, Object v) {
            e.setId(ctl(v));
        }
    }

    public class EpsWebConfigId implements Eps<WebConfigToRoleTypeMapping> {
        public void setup(WebConfigToRoleTypeMapping e, Object v) {
            e.setWebConfigId(ctl(v));
        }
    }

    public class EpsRoleTypeId implements Eps<WebConfigToRoleTypeMapping> {
        public void setup(WebConfigToRoleTypeMapping e, Object v) {
            e.setRoleTypeId(ctl(v));
        }
    }
}
