/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.RequestHeaderDbm;
import jp.sf.fess.db.cbean.RequestHeaderCB;
import jp.sf.fess.db.exentity.RequestHeader;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of REQUEST_HEADER as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, NAME, VALUE, WEB_CRAWLING_CONFIG_ID, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     WEB_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     webCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsRequestHeaderBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "REQUEST_HEADER";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return RequestHeaderDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public RequestHeaderDbm getMyDBMeta() {
        return RequestHeaderDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public RequestHeader newMyEntity() {
        return new RequestHeader();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public RequestHeaderCB newMyConditionBean() {
        return new RequestHeaderCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * RequestHeaderCB cb = new RequestHeaderCB();
     * cb.query().setFoo...(value);
     * int count = requestHeaderBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of RequestHeader. (NotNull)
     * @return The selected count.
     */
    public int selectCount(RequestHeaderCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(RequestHeaderCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * RequestHeaderCB cb = new RequestHeaderCB();
     * cb.query().setFoo...(value);
     * requestHeaderBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;RequestHeader&gt;() {
     *     public void handle(RequestHeader entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of RequestHeader. (NotNull)
     * @param entityRowHandler The handler of entity row of RequestHeader. (NotNull)
     */
    public void selectCursor(RequestHeaderCB cb,
            EntityRowHandler<RequestHeader> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, RequestHeader.class);
    }

    protected <ENTITY extends RequestHeader> void doSelectCursor(
            RequestHeaderCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<RequestHeader>", entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * RequestHeaderCB cb = new RequestHeaderCB();
     * cb.query().setFoo...(value);
     * RequestHeader requestHeader = requestHeaderBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (requestHeader != null) {
     *     ... = requestHeader.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of RequestHeader. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public RequestHeader selectEntity(RequestHeaderCB cb) {
        return doSelectEntity(cb, RequestHeader.class);
    }

    protected <ENTITY extends RequestHeader> ENTITY doSelectEntity(
            final RequestHeaderCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, RequestHeaderCB>() {
                    public List<ENTITY> callbackSelectList(RequestHeaderCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * RequestHeaderCB cb = new RequestHeaderCB();
     * cb.query().setFoo...(value);
     * RequestHeader requestHeader = requestHeaderBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = requestHeader.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of RequestHeader. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public RequestHeader selectEntityWithDeletedCheck(RequestHeaderCB cb) {
        return doSelectEntityWithDeletedCheck(cb, RequestHeader.class);
    }

    protected <ENTITY extends RequestHeader> ENTITY doSelectEntityWithDeletedCheck(
            final RequestHeaderCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, RequestHeaderCB>() {
                    public List<ENTITY> callbackSelectList(RequestHeaderCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public RequestHeader selectByPKValue(Long id) {
        return doSelectByPKValue(id, RequestHeader.class);
    }

    protected <ENTITY extends RequestHeader> ENTITY doSelectByPKValue(Long id,
            Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public RequestHeader selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, RequestHeader.class);
    }

    protected <ENTITY extends RequestHeader> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private RequestHeaderCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        RequestHeaderCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * RequestHeaderCB cb = new RequestHeaderCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;RequestHeader&gt; requestHeaderList = requestHeaderBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (RequestHeader requestHeader : requestHeaderList) {
     *     ... = requestHeader.get...();
     * }
     * </pre>
     * @param cb The condition-bean of RequestHeader. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<RequestHeader> selectList(RequestHeaderCB cb) {
        return doSelectList(cb, RequestHeader.class);
    }

    protected <ENTITY extends RequestHeader> ListResultBean<ENTITY> doSelectList(
            RequestHeaderCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, RequestHeaderCB>() {
                    public List<ENTITY> callbackSelectList(RequestHeaderCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * RequestHeaderCB cb = new RequestHeaderCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;RequestHeader&gt; page = requestHeaderBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (RequestHeader requestHeader : page) {
     *     ... = requestHeader.get...();
     * }
     * </pre>
     * @param cb The condition-bean of RequestHeader. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<RequestHeader> selectPage(RequestHeaderCB cb) {
        return doSelectPage(cb, RequestHeader.class);
    }

    protected <ENTITY extends RequestHeader> PagingResultBean<ENTITY> doSelectPage(
            RequestHeaderCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, RequestHeaderCB>() {
                    public int callbackSelectCount(RequestHeaderCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(RequestHeaderCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * requestHeaderBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(RequestHeaderCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<RequestHeaderCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends RequestHeaderCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'WebCrawlingConfig'.
     * @param requestHeaderList The list of requestHeader. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<WebCrawlingConfig> pulloutWebCrawlingConfig(
            List<RequestHeader> requestHeaderList) {
        return helpPulloutInternally(
                requestHeaderList,
                new InternalPulloutCallback<RequestHeader, WebCrawlingConfig>() {
                    public WebCrawlingConfig getFr(RequestHeader e) {
                        return e.getWebCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<RequestHeader> ls) {
                        e.setRequestHeaderList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * RequestHeader requestHeader = new RequestHeader();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * requestHeader.setFoo...(value);
     * requestHeader.setBar...(value);
     * requestHeaderBhv.<span style="color: #FD4747">insert</span>(requestHeader);
     * ... = requestHeader.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param requestHeader The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(RequestHeader requestHeader) {
        assertEntityNotNull(requestHeader);
        delegateInsert(requestHeader);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * RequestHeader requestHeader = new RequestHeader();
     * requestHeader.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * requestHeader.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * requestHeader.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     requestHeaderBhv.<span style="color: #FD4747">update</span>(requestHeader);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param requestHeader The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final RequestHeader requestHeader) {
        helpUpdateInternally(requestHeader,
                new InternalUpdateCallback<RequestHeader>() {
                    public int callbackDelegateUpdate(RequestHeader entity) {
                        return delegateUpdate(entity);
                    }
                });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * RequestHeader requestHeader = new RequestHeader();
     * requestHeader.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * requestHeader.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//requestHeader.setVersionNo(value);</span>
     * requestHeaderBhv.<span style="color: #FD4747">updateNonstrict</span>(requestHeader);
     * </pre>
     * @param requestHeader The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final RequestHeader requestHeader) {
        helpUpdateNonstrictInternally(requestHeader,
                new InternalUpdateNonstrictCallback<RequestHeader>() {
                    public int callbackDelegateUpdateNonstrict(
                            RequestHeader entity) {
                        return delegateUpdateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        updateNonstrict(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param requestHeader The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final RequestHeader requestHeader) {
        helpInsertOrUpdateInternally(
                requestHeader,
                new InternalInsertOrUpdateCallback<RequestHeader, RequestHeaderCB>() {
                    public void callbackInsert(RequestHeader entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(RequestHeader entity) {
                        update(entity);
                    }

                    public RequestHeaderCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(RequestHeaderCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param requestHeader The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(RequestHeader requestHeader) {
        helpInsertOrUpdateInternally(requestHeader,
                new InternalInsertOrUpdateNonstrictCallback<RequestHeader>() {
                    public void callbackInsert(RequestHeader entity) {
                        insert(entity);
                    }

                    public void callbackUpdateNonstrict(RequestHeader entity) {
                        updateNonstrict(entity);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdateNonstrict(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * RequestHeader requestHeader = new RequestHeader();
     * requestHeader.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * requestHeader.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     requestHeaderBhv.<span style="color: #FD4747">delete</span>(requestHeader);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param requestHeader The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(RequestHeader requestHeader) {
        helpDeleteInternally(requestHeader,
                new InternalDeleteCallback<RequestHeader>() {
                    public int callbackDelegateDelete(RequestHeader entity) {
                        return delegateDelete(entity);
                    }
                });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * RequestHeader requestHeader = new RequestHeader();
     * requestHeader.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//requestHeader.setVersionNo(value);</span>
     * requestHeaderBhv.<span style="color: #FD4747">deleteNonstrict</span>(requestHeader);
     * </pre>
     * @param requestHeader Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(RequestHeader requestHeader) {
        helpDeleteNonstrictInternally(requestHeader,
                new InternalDeleteNonstrictCallback<RequestHeader>() {
                    public int callbackDelegateDeleteNonstrict(
                            RequestHeader entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * RequestHeader requestHeader = new RequestHeader();
     * requestHeader.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//requestHeader.setVersionNo(value);</span>
     * requestHeaderBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(requestHeader);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param requestHeader Entity. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(RequestHeader requestHeader) {
        helpDeleteNonstrictIgnoreDeletedInternally(
                requestHeader,
                new InternalDeleteNonstrictIgnoreDeletedCallback<RequestHeader>() {
                    public int callbackDelegateDeleteNonstrict(
                            RequestHeader entity) {
                        return delegateDeleteNonstrict(entity);
                    }
                });
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param requestHeaderList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<RequestHeader> requestHeaderList) {
        assertObjectNotNull("requestHeaderList", requestHeaderList);
        return delegateInsertList(requestHeaderList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param requestHeaderList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<RequestHeader> requestHeaderList) {
        assertObjectNotNull("requestHeaderList", requestHeaderList);
        return delegateUpdateList(requestHeaderList);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param requestHeaderList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(List<RequestHeader> requestHeaderList) {
        assertObjectNotNull("requestHeaderList", requestHeaderList);
        return delegateUpdateListNonstrict(requestHeaderList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param requestHeaderList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<RequestHeader> requestHeaderList) {
        assertObjectNotNull("requestHeaderList", requestHeaderList);
        return delegateDeleteList(requestHeaderList);
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param requestHeaderList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(List<RequestHeader> requestHeaderList) {
        assertObjectNotNull("requestHeaderList", requestHeaderList);
        return delegateDeleteListNonstrict(requestHeaderList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * RequestHeader requestHeader = new RequestHeader();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//requestHeader.setPK...(value);</span>
     * requestHeader.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//requestHeader.setVersionNo(value);</span>
     * RequestHeaderCB cb = new RequestHeaderCB();
     * cb.query().setFoo...(value);
     * requestHeaderBhv.<span style="color: #FD4747">queryUpdate</span>(requestHeader, cb);
     * </pre>
     * @param requestHeader The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of RequestHeader. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(RequestHeader requestHeader, RequestHeaderCB cb) {
        return delegateQueryUpdate(requestHeader, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * RequestHeaderCB cb = new RequestHeaderCB();
     * cb.query().setFoo...(value);
     * requestHeaderBhv.<span style="color: #FD4747">queryDelete</span>(requestHeader, cb);
     * </pre>
     * @param cb The condition-bean of RequestHeader. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(RequestHeaderCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * RequestHeader requestHeader = new RequestHeader();
     * requestHeader.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * requestHeader.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * requestHeader.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;RequestHeaderCB&gt; option = new UpdateOption&lt;RequestHeaderCB&gt;();
     *     option.self(new SpecifyQuery&lt;RequestHeaderCB&gt;() {
     *         public void specify(RequestHeaderCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     requestHeaderBhv.<span style="color: #FD4747">varyingUpdate</span>(requestHeader, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param requestHeader The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(RequestHeader requestHeader,
            final UpdateOption<RequestHeaderCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(requestHeader,
                new InternalUpdateCallback<RequestHeader>() {
                    public int callbackDelegateUpdate(RequestHeader entity) {
                        return delegateVaryingUpdate(entity, option);
                    }
                });
    }

    /**
     * Varying-update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * RequestHeader requestHeader = new RequestHeader();
     * requestHeader.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * requestHeader.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//requestHeader.setVersionNo(value);</span>
     * UpdateOption&lt;RequestHeaderCB&gt; option = new UpdateOption&lt;RequestHeaderCB&gt;();
     * option.self(new SpecifyQuery&lt;RequestHeaderCB&gt;() {
     *     public void specify(RequestHeaderCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * requestHeaderBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(requestHeader, option);
     * </pre>
     * @param requestHeader The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(RequestHeader requestHeader,
            final UpdateOption<RequestHeaderCB> option) {
        processVaryingUpdate(option);
        helpUpdateNonstrictInternally(requestHeader,
                new InternalUpdateNonstrictCallback<RequestHeader>() {
                    public int callbackDelegateUpdateNonstrict(
                            RequestHeader entity) {
                        return delegateVaryingUpdateNonstrict(entity, option);
                    }
                });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * RequestHeader requestHeader = new RequestHeader();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//requestHeader.setPK...(value);</span>
     * requestHeader.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//requestHeader.setVersionNo(value);</span>
     * RequestHeaderCB cb = new RequestHeaderCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;RequestHeaderCB&gt; option = new UpdateOption&lt;RequestHeaderCB&gt;();
     * option.self(new SpecifyQuery&lt;RequestHeaderCB&gt;() {
     *     public void specify(RequestHeaderCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * requestHeaderBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(requestHeader, cb, option);
     * </pre>
     * @param requestHeader The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of RequestHeader. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(RequestHeader requestHeader,
            RequestHeaderCB cb, final UpdateOption<RequestHeaderCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(requestHeader, cb, option);
    }

    protected void processVaryingUpdate(UpdateOption<RequestHeaderCB> option) {
        assertUpdateOptionNotNull(option);
        RequestHeaderCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(RequestHeaderCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends RequestHeader> void delegateSelectCursor(
            RequestHeaderCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends RequestHeader> List<ENTITY> delegateSelectList(
            RequestHeaderCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(RequestHeader e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(RequestHeader e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateEntityCommand(e));
    }

    protected int delegateUpdateNonstrict(RequestHeader e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(RequestHeader e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteEntityCommand(e));
    }

    protected int delegateDeleteNonstrict(RequestHeader e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<RequestHeader> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<RequestHeader> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateUpdateListNonstrict(List<RequestHeader> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    protected int[] delegateDeleteList(List<RequestHeader> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int[] delegateDeleteListNonstrict(List<RequestHeader> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    protected int delegateQueryUpdate(RequestHeader e, RequestHeaderCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(RequestHeaderCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(RequestHeader e,
            UpdateOption<RequestHeaderCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateEntityCommand(e, op));
    }

    protected int delegateVaryingUpdateNonstrict(RequestHeader e,
            UpdateOption<RequestHeaderCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(RequestHeader e,
            RequestHeaderCB cb, UpdateOption<RequestHeaderCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected RequestHeader downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, RequestHeader.class);
    }

    protected RequestHeaderCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, RequestHeaderCB.class);
    }
}
