/*
 * Copyright 2009-2010 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.ClickLogDbm;
import jp.sf.fess.db.cbean.ClickLogCB;
import jp.sf.fess.db.exentity.ClickLog;
import jp.sf.fess.db.exentity.SearchLog;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.dbmeta.DBMeta;

/**
 * The behavior of CLICK_LOG as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, SEARCH_ID, URL, REQUESTED_TIME
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     
 * 
 * [foreign-table]
 *     SEARCH_LOG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     searchLog
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsClickLogBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:BehaviorQueryPathBegin*/
    public static final String PATH_selectClickUrlRanking = "selectClickUrlRanking";

    /*df:BehaviorQueryPathEnd*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "CLICK_LOG";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return ClickLogDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public ClickLogDbm getMyDBMeta() {
        return ClickLogDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public ClickLog newMyEntity() {
        return new ClickLog();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public ClickLogCB newMyConditionBean() {
        return new ClickLogCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count by the condition-bean. {IgnorePagingCondition}
     * <pre>
     * ClickLogCB cb = new ClickLogCB();
     * cb.query().setFoo...(value);
     * int count = clickLogBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of ClickLog. (NotNull)
     * @return The selected count.
     */
    public int selectCount(ClickLogCB cb) {
        return doSelectCount(cb);
    }

    protected int doSelectCount(ClickLogCB cb) {
        assertCBNotNull(cb);
        return delegateSelectCount(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * ClickLogCB cb = new ClickLogCB();
     * cb.query().setFoo...(value);
     * clickLogBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;ClickLog&gt;() {
     *     public void handle(ClickLog entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of ClickLog. (NotNull)
     * @param entityRowHandler The handler of entity row of ClickLog. (NotNull)
     */
    public void selectCursor(ClickLogCB cb,
            EntityRowHandler<ClickLog> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, ClickLog.class);
    }

    protected <ENTITY extends ClickLog> void doSelectCursor(ClickLogCB cb,
            EntityRowHandler<ENTITY> entityRowHandler, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<ClickLog>", entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * ClickLogCB cb = new ClickLogCB();
     * cb.query().setFoo...(value);
     * ClickLog clickLog = clickLogBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (clickLog != null) {
     *     ... = clickLog.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of ClickLog. (NotNull)
     * @return The selected entity. (Nullable: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public ClickLog selectEntity(ClickLogCB cb) {
        return doSelectEntity(cb, ClickLog.class);
    }

    protected <ENTITY extends ClickLog> ENTITY doSelectEntity(
            final ClickLogCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(cb,
                new InternalSelectEntityCallback<ENTITY, ClickLogCB>() {
                    public List<ENTITY> callbackSelectList(ClickLogCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * ClickLogCB cb = new ClickLogCB();
     * cb.query().setFoo...(value);
     * ClickLog clickLog = clickLogBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = clickLog.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of ClickLog. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public ClickLog selectEntityWithDeletedCheck(ClickLogCB cb) {
        return doSelectEntityWithDeletedCheck(cb, ClickLog.class);
    }

    protected <ENTITY extends ClickLog> ENTITY doSelectEntityWithDeletedCheck(
            final ClickLogCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, ClickLogCB>() {
                    public List<ENTITY> callbackSelectList(ClickLogCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (Nullable: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public ClickLog selectByPKValue(Long id) {
        return doSelectByPKValue(id, ClickLog.class);
    }

    protected <ENTITY extends ClickLog> ENTITY doSelectByPKValue(Long id,
            Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public ClickLog selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, ClickLog.class);
    }

    protected <ENTITY extends ClickLog> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private ClickLogCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        ClickLogCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * ClickLogCB cb = new ClickLogCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;ClickLog&gt; clickLogList = clickLogBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (ClickLog clickLog : clickLogList) {
     *     ... = clickLog.get...();
     * }
     * </pre>
     * @param cb The condition-bean of ClickLog. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<ClickLog> selectList(ClickLogCB cb) {
        return doSelectList(cb, ClickLog.class);
    }

    protected <ENTITY extends ClickLog> ListResultBean<ENTITY> doSelectList(
            ClickLogCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, ClickLogCB>() {
                    public List<ENTITY> callbackSelectList(ClickLogCB cb,
                            Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * ClickLogCB cb = new ClickLogCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;ClickLog&gt; page = clickLogBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (ClickLog clickLog : page) {
     *     ... = clickLog.get...();
     * }
     * </pre>
     * @param cb The condition-bean of ClickLog. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<ClickLog> selectPage(ClickLogCB cb) {
        return doSelectPage(cb, ClickLog.class);
    }

    protected <ENTITY extends ClickLog> PagingResultBean<ENTITY> doSelectPage(
            ClickLogCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, ClickLogCB>() {
                    public int callbackSelectCount(ClickLogCB cb) {
                        return doSelectCount(cb);
                    }

                    public List<ENTITY> callbackSelectList(ClickLogCB cb,
                            Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * clickLogBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(ClickLogCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (Nullable)
     */
    public <RESULT> SLFunction<ClickLogCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends ClickLogCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'SearchLog'.
     * @param clickLogList The list of clickLog. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<SearchLog> pulloutSearchLog(List<ClickLog> clickLogList) {
        return helpPulloutInternally(clickLogList,
                new InternalPulloutCallback<ClickLog, SearchLog>() {
                    public SearchLog getFr(ClickLog e) {
                        return e.getSearchLog();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(SearchLog e, List<ClickLog> ls) {
                        e.setClickLogList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * ClickLog clickLog = new ClickLog();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * clickLog.setFoo...(value);
     * clickLog.setBar...(value);
     * clickLogBhv.<span style="color: #FD4747">insert</span>(clickLog);
     * ... = clickLog.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param clickLog The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(ClickLog clickLog) {
        assertEntityNotNull(clickLog);
        delegateInsert(clickLog);
    }

    @Override
    protected void doCreate(Entity entity) {
        insert(downcast(entity));
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * ClickLog clickLog = new ClickLog();
     * clickLog.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * clickLog.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * clickLog.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     clickLogBhv.<span style="color: #FD4747">update</span>(clickLog);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param clickLog The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final ClickLog clickLog) {
        helpUpdateInternally(clickLog, new InternalUpdateCallback<ClickLog>() {
            public int callbackDelegateUpdate(ClickLog entity) {
                return delegateUpdate(entity);
            }
        });
    }

    @Override
    protected void doModify(Entity entity) {
        update(downcast(entity));
    }

    @Override
    protected void doModifyNonstrict(Entity entity) {
        update(downcast(entity));
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param clickLog The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(final ClickLog clickLog) {
        helpInsertOrUpdateInternally(clickLog,
                new InternalInsertOrUpdateCallback<ClickLog, ClickLogCB>() {
                    public void callbackInsert(ClickLog entity) {
                        insert(entity);
                    }

                    public void callbackUpdate(ClickLog entity) {
                        update(entity);
                    }

                    public ClickLogCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(ClickLogCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    protected void doCreateOrUpdate(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    @Override
    protected void doCreateOrUpdateNonstrict(Entity entity) {
        insertOrUpdate(downcast(entity));
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * ClickLog clickLog = new ClickLog();
     * clickLog.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * clickLog.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     clickLogBhv.<span style="color: #FD4747">delete</span>(clickLog);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param clickLog The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(ClickLog clickLog) {
        helpDeleteInternally(clickLog, new InternalDeleteCallback<ClickLog>() {
            public int callbackDelegateDelete(ClickLog entity) {
                return delegateDelete(entity);
            }
        });
    }

    @Override
    protected void doRemove(Entity entity) {
        delete(downcast(entity));
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param clickLogList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<ClickLog> clickLogList) {
        assertObjectNotNull("clickLogList", clickLogList);
        return delegateInsertList(clickLogList);
    }

    /**
     * Batch-update the list. <br />
     * All columns are update target. {NOT modified only} <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param clickLogList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdate(List<ClickLog> clickLogList) {
        assertObjectNotNull("clickLogList", clickLogList);
        return delegateUpdateList(clickLogList);
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param clickLogList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDelete(List<ClickLog> clickLogList) {
        assertObjectNotNull("clickLogList", clickLogList);
        return delegateDeleteList(clickLogList);
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * ClickLog clickLog = new ClickLog();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//clickLog.setPK...(value);</span>
     * clickLog.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//clickLog.setVersionNo(value);</span>
     * ClickLogCB cb = new ClickLogCB();
     * cb.query().setFoo...(value);
     * clickLogBhv.<span style="color: #FD4747">queryUpdate</span>(clickLog, cb);
     * </pre>
     * @param clickLog The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of ClickLog. (NotNull)
     * @return The updated count.
     */
    public int queryUpdate(ClickLog clickLog, ClickLogCB cb) {
        return delegateQueryUpdate(clickLog, cb);
    }

    /**
     * Query-delete the several entities. {NonExclusiveControl}
     * <pre>
     * ClickLogCB cb = new ClickLogCB();
     * cb.query().setFoo...(value);
     * clickLogBhv.<span style="color: #FD4747">queryDelete</span>(clickLog, cb);
     * </pre>
     * @param cb The condition-bean of ClickLog. (NotNull)
     * @return The deleted count.
     */
    public int queryDelete(ClickLogCB cb) {
        return delegateQueryDelete(cb);
    }

    /**
     * Varying-update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * ClickLog clickLog = new ClickLog();
     * clickLog.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * clickLog.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * clickLog.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     UpdateOption&lt;ClickLogCB&gt; option = new UpdateOption&lt;ClickLogCB&gt;();
     *     option.self(new SpecifyQuery&lt;ClickLogCB&gt;() {
     *         public void specify(ClickLogCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     clickLogBhv.<span style="color: #FD4747">varyingUpdate</span>(clickLog, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param clickLog The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying values. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(ClickLog clickLog,
            final UpdateOption<ClickLogCB> option) {
        processVaryingUpdate(option);
        helpUpdateInternally(clickLog, new InternalUpdateCallback<ClickLog>() {
            public int callbackDelegateUpdate(ClickLog entity) {
                return delegateVaryingUpdate(entity, option);
            }
        });
    }

    /**
     * Varying-query-update the several entities non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * ClickLog clickLog = new ClickLog();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//clickLog.setPK...(value);</span>
     * clickLog.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set the value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//clickLog.setVersionNo(value);</span>
     * ClickLogCB cb = new ClickLogCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;ClickLogCB&gt; option = new UpdateOption&lt;ClickLogCB&gt;();
     * option.self(new SpecifyQuery&lt;ClickLogCB&gt;() {
     *     public void specify(ClickLogCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * clickLogBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(clickLog, cb, option);
     * </pre>
     * @param clickLog The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of ClickLog. (NotNull)
     * @param option The option of update for varying values. (NotNull)
     * @return The updated count.
     */
    public int varyingQueryUpdate(ClickLog clickLog, ClickLogCB cb,
            final UpdateOption<ClickLogCB> option) {
        processVaryingUpdate(option);
        return delegateVaryingQueryUpdate(clickLog, cb, option);
    }

    protected void processVaryingUpdate(UpdateOption<ClickLogCB> option) {
        assertUpdateOptionNotNull(option);
        ClickLogCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        option.resolveSpecification(cb);
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCount(ClickLogCB cb) {
        return invoke(createSelectCountCBCommand(cb));
    }

    protected <ENTITY extends ClickLog> void delegateSelectCursor(
            ClickLogCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        invoke(createSelectCursorCBCommand(cb, entityRowHandler, entityType));
    }

    protected <ENTITY extends ClickLog> List<ENTITY> delegateSelectList(
            ClickLogCB cb, Class<ENTITY> entityType) {
        return invoke(createSelectListCBCommand(cb, entityType));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(ClickLog e) {
        if (!processBeforeInsert(e)) {
            return 1;
        }
        return invoke(createInsertEntityCommand(e));
    }

    protected int delegateUpdate(ClickLog e) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createUpdateNonstrictEntityCommand(e));
    }

    protected int delegateDelete(ClickLog e) {
        if (!processBeforeDelete(e)) {
            return 1;
        }
        return invoke(createDeleteNonstrictEntityCommand(e));
    }

    protected int[] delegateInsertList(List<ClickLog> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertEntityCommand(helpFilterBeforeInsertInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doCreateList(List<Entity> ls) {
        return delegateInsertList((List) ls);
    }

    protected int[] delegateUpdateList(List<ClickLog> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictEntityCommand(helpFilterBeforeUpdateInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doModifyList(List<Entity> ls) {
        return delegateUpdateList((List) ls);
    }

    protected int[] delegateDeleteList(List<ClickLog> ls) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictEntityCommand(helpFilterBeforeDeleteInternally(ls)));
    }

    @SuppressWarnings("unchecked")
    protected int[] doRemoveList(List<Entity> ls) {
        return delegateDeleteList((List) ls);
    }

    protected int delegateQueryUpdate(ClickLog e, ClickLogCB cb) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createQueryUpdateEntityCBCommand(e, cb));
    }

    protected int delegateQueryDelete(ClickLogCB cb) {
        if (!processBeforeQueryDelete(cb)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb));
    }

    protected int delegateVaryingUpdate(ClickLog e, UpdateOption<ClickLogCB> op) {
        if (!processBeforeUpdate(e)) {
            return 1;
        }
        return invoke(createVaryingUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateVaryingQueryUpdate(ClickLog e, ClickLogCB cb,
            UpdateOption<ClickLogCB> op) {
        if (!processBeforeQueryUpdate(e, cb)) {
            return 0;
        }
        return invoke(createVaryingQueryUpdateEntityCBCommand(e, cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected ClickLog downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, ClickLog.class);
    }

    protected ClickLogCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb, ClickLogCB.class);
    }
}
