<tiles:insert template="/WEB-INF/view/common/admin/layout.jsp" flush="true">
	<tiles:put name="title"><bean:message key="labels.crawler_configuration" /></tiles:put>
	<tiles:put name="header" value="/WEB-INF/view/common/admin/header.jsp" />
	<tiles:put name="footer" value="/WEB-INF/view/common/admin/footer.jsp" />
	<tiles:put name="menu" value="/WEB-INF/view/common/admin/menu.jsp" />
	<tiles:put name="menuType" value="crawl" />
	<tiles:put name="body" type="string">

<div id="main">

	<div>
		<html:messages id="msg" message="true"><bean:write name="msg" ignore="true"/></html:messages>
		<html:errors/>
	</div>

	<s:form>
	<div class="form-table">
		<table style="width:500px;">
            <caption><bean:message key="labels.crawler_title_edit"/></caption>
			<tbody>
				<tr>
					<th style="width:200px;">
						<bean:message key="labels.schedule"/>
					</th>
					<td>
						<html:text property="cronExpression"/>
					</td>
				</tr>
				<tr>
					<th>
						<bean:message key="labels.optimize"/>
					</th>
					<td>
						<html:checkbox property="optimize"/><bean:message key="labels.enabled"/>
					</td>
				</tr>
				<tr>
					<th>
						<bean:message key="labels.commit"/>
					</th>
					<td>
						<html:checkbox property="commit"/><bean:message key="labels.enabled"/>
					</td>
				</tr>
				<tr>
					<th>
						<bean:message key="labels.server_rotation"/>
					</th>
					<td>
						<html:checkbox property="serverRotation"/><bean:message key="labels.enabled"/>
					</td>
				</tr>
				<tr>
					<th>
						<bean:message key="labels.day_for_cleanup"/>
					</th>
					<td>
						<html:select property="dayForCleanup">
							<html:option value="-1"><bean:message key="labels.none"/></html:option>
							<c:forEach var="d" items="${dayItems}">
								<html:option value="${f:h(d)}">${f:h(d)}</html:option>
							</c:forEach>
						</html:select>
						<bean:message key="labels.day"/>
					</td>
				</tr>
				<tr>
					<th>
						<bean:message key="labels.mobile_transcoder"/>
					</th>
					<td>
						<html:select property="mobileTranscoder">
							<c:forEach var="item" items="${mobileTranscoderItems}">
								<html:option value="${f:u(item.value)}">${f:h(item.label)}</html:option>
							</c:forEach>
						</html:select>
					</td>
				</tr>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="2">
						<input type="submit" name="update" value="<bean:message key="labels.crawl_button_update"/>"/>
					</td>
				</tr>
			</tfoot>
		</table>
	</div>
	</s:form>

</div>

	</tiles:put>
</tiles:insert>
