//
// Copyright 2009-2010 Facebook
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

/*! \mainpage Three20 API Documentation
 *
 * \section intro_sec Introduction
 *
 * All of the API documentation you see here has been generated from the Three20 source.
 *
 * Get the source: http://github.com/facebook/three20
 *
 * Three20 is a rather large iPhone development library. It is composed of a stack of four
 * components:
 *
 * <center>
 *   <a href="#UI" style="display:block;width:200px;font-size:1.5em">UI</a>
 *   <a href="#Style" style="display:block;width:200px;font-size:1.5em">Style</a>
 *   <a href="#Network" style="display:block;width:200px;font-size:1.5em">Network</a>
 *   <a href="#Core" style="display:block;width:200px;font-size:1.5em">Core</a>
 * </center>
 *
 * \section Core
 *
 * Three20's foundation includes debugging utilities and a plethora of useful additions to common
 * objects.
 *
 * \section Network
 *
 * A full network+cache implementation has been built around NSURLRequests with support for
 * disc and memory caching.
 *
 * \section Style
 *
 * A robust style framework that makes it easy to create gradients, shadows, and rounded borders.
 *
 * \section UI
 *
 * Three20 includes a growing set of common controls. Photo browsers, table view cells, and
 * springboard implementations are just a few. The UI component includes the TTNavigator object
 * that makes building persistent applications easy.
 *
 */

// Core
#import "Three20Core/Three20Core.h"

// Network
#import "Three20Network/Three20Network.h"

// Style
#import "Three20Style/Three20Style.h"

// UICommon
#import "Three20UICommon/Three20UICommon.h"

// UINavigator
#import "Three20UINavigator/Three20UINavigator.h"

// UI
#import "Three20UI/Three20UI.h"
