package org.seasar.chronos.core.task.state.impl;

import java.util.concurrent.TimeUnit;

import org.seasar.chronos.core.task.state.TaskExecuteContext;
import org.seasar.chronos.core.task.strategy.TaskExecuteStrategy;

public class TaskExecuteStateFinished extends AbstractTaskExecuteState {

    public TaskExecuteStateFinished(
            final TaskExecuteStrategy taskExecuteStrategy) {
        super(taskExecuteStrategy);
    }

    @Override
    public boolean await(final TaskExecuteContext context, final long time,
            final TimeUnit timeUnit) throws InterruptedException {
        return false;
    }

    @Override
    public boolean cancel(final TaskExecuteContext context) {
        return false;
    }

    @Override
    public void destroy(final AbstractTaskExecuteContext context)
            throws InterruptedException {
        getTaskExecuteStrategy().destroy();
        changeState(context, context.getTaskExecuteStateInitialized());
    }

    @Override
    public void execute(final TaskExecuteContext context,
            final String startTaskName) throws InterruptedException {

    }

    @Override
    public String finish(final AbstractTaskExecuteContext context)
            throws InterruptedException {
        return null;
    }

    @Override
    public void initialize(final AbstractTaskExecuteContext context) {

    }

    @Override
    public String start(final AbstractTaskExecuteContext context)
            throws InterruptedException {
        final String result = getTaskExecuteStrategy().start();
        changeState(context, context.getTaskExecuteStateStarted());
        return result;
    }

    @Override
    public void waitOne() throws InterruptedException {

    }

}
