/*
 * Copyright 2007-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.chronos.core.task.impl;

import org.seasar.chronos.core.TaskThreadPool;
import org.seasar.chronos.core.TaskTrigger;
import org.seasar.chronos.core.ThreadPoolType;
import org.seasar.chronos.core.task.TaskConstant;
import org.seasar.chronos.core.task.TaskPropertyReader;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

public class TaskPropertyReaderImpl implements TaskPropertyReader {

    private BeanDesc beanDesc;

    private Object task;

    public BeanDesc getBeanDesc() {
        return beanDesc;
    }

    public String getDescription(final String defaultValue) {
        if (hasDescription()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_DESCRIPTION);
            return (String) pd.getValue(task);
        }
        return defaultValue;
    }

    public Exception getException(final Exception defaultValue) {
        Exception result = defaultValue;
        if (hasException()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_SHUTDOWN_TASK);
            result = (Exception) pd.getValue(task);
        }
        return result;
    }

    public Object getTask() {
        return task;
    }

    public Class<?> getTaskClass() {
        return beanDesc.getBeanClass();
    }

    public Long getTaskId(final Long defaultValue) {
        if (hasTaskId()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_TASKID);
            return (Long) pd.getValue(task);
        }
        return defaultValue;
    }

    public String getTaskName(final String defaultValue) {
        if (hasTaskName()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_TASKNAME);
            return (String) pd.getValue(task);
        }
        return defaultValue;
    }

    public TaskThreadPool getThreadPool(final TaskThreadPool defaultValue) {
        if (hasThreadPool()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_THREADPOOL);
            final TaskThreadPool result = (TaskThreadPool) pd.getValue(task);
            if (result != null) {
                return result;
            }
        }
        return defaultValue;
    }

    public int getThreadPoolSize(final int defaultValue) {
        if (hasThreadPoolSize()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_THREAD_POOL_SIZE);
            final Integer result = (Integer) pd.getValue(task);
            if (result != null) {
                return result;
            }
        }
        return defaultValue;
    }

    public ThreadPoolType getThreadPoolType(final ThreadPoolType defaultType) {
        ThreadPoolType result = defaultType;
        if (hasThreadPoolType()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_THREAD_POOL_TYPE);
            result = (ThreadPoolType) pd.getValue(task);
        }
        return result;
    }

    public TaskTrigger getTrigger(final TaskTrigger defaultValue) {
        TaskTrigger result = defaultValue;
        if (hasTrigger()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_TRIGGER);
            result = (TaskTrigger) pd.getValue(task);
        }
        return result;
    }

    public boolean hasDescription() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_DESCRIPTION);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_DESCRIPTION);
            result = pd.hasReadMethod();
            return result;
        }
        return result;
    }

    public boolean hasEndTask() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_END_TASK);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_END_TASK);
            result = pd.isReadable();
            return result;
        }
        return result;
    }

    public boolean hasException() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_EXCEPTION);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_EXCEPTION);
            result = pd.isReadable();
            return result;
        }
        return false;
    }

    public boolean hasExecuted() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_EXECUTED);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_EXECUTED);
            result = pd.isReadable();
            return result;
        }
        return result;
    }

    public boolean hasReScheduleTask() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_RESCHEDULE_TASK);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_RESCHEDULE_TASK);
            result = pd.isReadable();
            return result;
        }
        return result;
    }

    public boolean hasShutdownTask() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_SHUTDOWN_TASK);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_SHUTDOWN_TASK);
            result = pd.isReadable();
            return result;
        }
        return result;
    }

    public boolean hasStartTask() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_START_TASK);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_START_TASK);
            result = pd.isReadable();
            return result;
        }
        return result;
    }

    public boolean hasTaskId() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_TASKID);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_TASKID);
            result = pd.isReadable();
            return result;
        }
        return result;
    }

    public boolean hasTaskName() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_TASKNAME);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_TASKNAME);
            result = pd.isReadable();
            return result;
        }
        return result;
    }

    public boolean hasThreadPool() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_THREADPOOL);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_THREADPOOL);
            result = pd.isReadable();
            return result;
        }
        return result;
    }

    public boolean hasThreadPoolSize() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_THREAD_POOL_SIZE);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_THREAD_POOL_SIZE);
            result = pd.isReadable();
            return result;
        }
        return result;
    }

    public boolean hasThreadPoolType() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_TASKNAME);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_TASKNAME);
            result = pd.isReadable();
            return result;
        }
        return result;
    }

    public boolean hasTrigger() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_TRIGGER);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_TRIGGER);
            result = pd.isReadable();
            return result;
        }
        return result;
    }

    public boolean isEndTask(final boolean defaultValue) {
        boolean result = defaultValue;
        if (hasEndTask()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_END_TASK);
            result = Boolean.TRUE.equals(pd.getValue(task));
        }
        return result;
    }

    public boolean isExecuted(final boolean defaultValue) {
        boolean result = defaultValue;
        if (hasExecuted()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_EXECUTED);
            result = Boolean.TRUE.equals(pd.getValue(task));
        }
        return result;
    }

    public boolean isReScheduleTask(final boolean defaultValue) {
        boolean result = defaultValue;
        if (hasReScheduleTask()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_RESCHEDULE_TASK);
            result = Boolean.TRUE.equals(pd.getValue(task));
        }
        return result;
    }

    public boolean isShutdownTask(final boolean defaultValue) {
        boolean result = defaultValue;
        if (hasShutdownTask()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_SHUTDOWN_TASK);
            result = Boolean.TRUE.equals(pd.getValue(task));
        }
        return result;
    }

    public boolean isStartTask(final boolean defaultValue) {
        boolean result = defaultValue;
        if (hasStartTask()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_START_TASK);
            result = Boolean.TRUE.equals(pd.getValue(task));
        }
        return result;
    }

    public void setup(final Object task, final BeanDesc beanDesc) {
        this.task = task;
        this.beanDesc = beanDesc;
    }

    public void setup(final Object task, final Class<?> taskClass) {
        this.task = task;
        beanDesc = BeanDescFactory.getBeanDesc(taskClass);
    }

}
