/* 
 * Copyright 2008 the Seasar Foundation and the Others.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not 
 * use this file except in compliance with the License. You may obtain a copy 
 * of the License at 
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0 
 *   
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations 
 * under the License.
 * 
 */

package org.seasar.chronos.core.trigger;

import org.seasar.chronos.core.TaskTrigger;
import org.seasar.chronos.core.util.ObjectUtil;

public abstract class AbstractTrigger implements TaskTrigger {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    private Long triggerId;

    private String name;

    private Object task;

    private String description;

    private boolean execute;

    private boolean reScheduleTask;

    private boolean shutdownTask;

    public AbstractTrigger() {

    }

    public AbstractTrigger(final String name) {
        setName(name);
    }

    @Override
    public boolean equals(final Object obj) {
        if (obj instanceof AbstractTrigger) {
            boolean result = true;
            final AbstractTrigger src = (AbstractTrigger) obj;
            if (triggerId != null) {
                result = result & triggerId.equals(src.triggerId);
            }
            if (name != null) {
                result = result & name.equals(src.name);
            }
            if (task != null) {
                result = result & task.equals(src.task);
            }
            if (description != null) {
                result = result & description.equals(src.description);
            }
            result = result & execute == src.execute;
            return result;
        } else {
            return super.equals(obj);
        }
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String getDescription() {
        return description;
    }

    public String getName() {
        return name;
    }

    public Object getTask() {
        return task;
    }

    public Long getTriggerId() {
        if (triggerId == null) {
            triggerId = ObjectUtil.generateObjectId();
        }
        return triggerId;
    }

    public boolean isExecute() {
        return execute;
    }

    public void load() {

    }

    public void save() {

    }

    public void setDescription(final String description) {
        this.description = description;
    }

    public void setExecute(final boolean executed) {
        execute = executed;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public void setTask(final Object task) {
        this.task = task;
    }

    public void setTriggerId(final Long id) {
        triggerId = id;
    }

    public boolean isReScheduleTask() {
        return reScheduleTask;
    }

    public void setReScheduleTask(final boolean reScheduleTask) {
        this.reScheduleTask = reScheduleTask;
    }

    public boolean isShutdownTask() {
        return shutdownTask;
    }

    public void setShutdownTask(final boolean shutdownTask) {
        this.shutdownTask = shutdownTask;
    }

}
