/*
 * Copyright 2007-2008 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.chronos.core.task.impl;

import org.seasar.chronos.core.TaskThreadPool;
import org.seasar.chronos.core.TaskTrigger;
import org.seasar.chronos.core.ThreadPoolType;
import org.seasar.chronos.core.task.TaskConstant;
import org.seasar.chronos.core.task.TaskPropertyWriter;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;

public class TaskPropertyWriterImpl implements TaskPropertyWriter {

    public Object getTask() {
        return task;
    }

    public Class<?> getTaskClass() {
        return beanDesc.getBeanClass();
    }

    public BeanDesc getBeanDesc() {
        return beanDesc;
    }

    private BeanDesc beanDesc;

    private Object task;

    public void setup(final Object task, final Class<?> taskClass) {
        this.task = task;
        beanDesc = BeanDescFactory.getBeanDesc(taskClass);
    }

    public void setup(final Object task, final BeanDesc beanDesc) {
        this.task = task;
        this.beanDesc = beanDesc;
    }

    public void setThreadPoolType(final ThreadPoolType value) {
        if (hasThreadPoolType()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_THREAD_POOL_TYPE);
            pd.setValue(task, value);
        }
    }

    public void setDescription(final String value) {
        if (hasDescription()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_DESCRIPTION);
            pd.setValue(task, value);
        }
    }

    public void setEndTask(final boolean value) {
        if (hasEndTask()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_END_TASK);
            pd.setValue(task, value);
        }
    }

    public void setExecuted(final boolean value) {
        if (hasExecuted()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_EXECUTED);
            pd.setValue(task, value);
        }
    }

    public void setReSchedule(final boolean value) {
        if (hasReSchedule()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_RESCHEDULE_TASK);
            pd.setValue(task, value);
        }
    }

    public void setShutdownTask(final boolean value) {
        if (hasShutdownTask()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_SHUTDOWN_TASK);
            pd.setValue(task, value);
        }
    }

    public void setStartTask(final boolean value) {
        if (hasStartTask()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_START_TASK);
            pd.setValue(task, value);
        }
    }

    public void setTaskId(final Long value) {
        if (hasTaskId()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_TASKID);
            pd.setValue(task, value);
        }
    }

    public void setTaskName(final String value) {
        if (hasTaskName()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_TASKNAME);
            pd.setValue(task, value);
        }
    }

    @Binding(bindingType = BindingType.NONE)
    public void setThreadPool(final TaskThreadPool value) {
        if (hasThreadPool()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_THREADPOOL);
            pd.setValue(task, value);
        }
    }

    public void setThreadPoolSize(final int value) {
        if (hasThreadPoolSize()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_THREAD_POOL_SIZE);
            pd.setValue(task, value);
        }
    }

    @Binding(bindingType = BindingType.NONE)
    public void setTrigger(final TaskTrigger value) {
        if (beanDesc.hasPropertyDesc(TaskConstant.PROPERTY_NAME_TRIGGER)) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_TRIGGER);
            pd.setValue(task, value);
        }
    }

    public boolean hasDescription() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_DESCRIPTION);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_DESCRIPTION);
            result = pd.isWritable();
            return result;
        }
        return result;
    }

    public boolean hasEndTask() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_END_TASK);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_END_TASK);
            result = pd.isWritable();
            return result;
        }
        return result;
    }

    public boolean hasExecuted() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_EXECUTED);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_EXECUTED);
            result = pd.isWritable();
            return result;
        }
        return result;
    }

    public boolean hasReSchedule() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_RESCHEDULE_TASK);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_RESCHEDULE_TASK);
            result = pd.isWritable();
            return result;
        }
        return result;
    }

    public boolean hasShutdownTask() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_SHUTDOWN_TASK);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_SHUTDOWN_TASK);
            result = pd.isWritable();
            return result;
        }
        return result;
    }

    public boolean hasStartTask() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_START_TASK);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_START_TASK);
            result = pd.isWritable();
            return result;
        }
        return result;
    }

    public boolean hasTaskId() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_TASKID);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_TASKID);
            result = pd.isWritable();
            return result;
        }
        return result;
    }

    public boolean hasTaskName() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_TASKNAME);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_TASKNAME);
            result = pd.isWritable();
            return result;
        }
        return result;
    }

    public boolean hasThreadPool() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_THREADPOOL);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_THREADPOOL);
            result = pd.isWritable();
            return result;
        }
        return result;
    }

    public boolean hasThreadPoolSize() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_THREAD_POOL_SIZE);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_THREAD_POOL_SIZE);
            result = pd.isWritable();
            return result;
        }
        return result;
    }

    public boolean hasThreadPoolType() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_THREAD_POOL_TYPE);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_THREAD_POOL_TYPE);
            result = pd.isWritable();
            return result;
        }
        return result;
    }

    public boolean hasTrigger() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_TRIGGER);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_TRIGGER);
            result = pd.isWritable();
            return result;
        }
        return result;
    }

    public boolean hasException() {
        boolean result = beanDesc
                .hasPropertyDesc(TaskConstant.PROPERTY_NAME_EXCEPTION);
        if (result) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_EXCEPTION);
            result = pd.isWritable();
            return result;
        }
        return result;
    }

    public void setException(final Exception value) {
        if (hasException()) {
            final PropertyDesc pd = beanDesc
                    .getPropertyDesc(TaskConstant.PROPERTY_NAME_EXCEPTION);
            pd.setValue(task, value);
        }
    }
}
