<tiles:insert template="/WEB-INF/view/common/admin/layout.jsp" flush="true">
	<tiles:put name="title"><bean:message key="labels.file_authentication_configuration" /></tiles:put>
	<tiles:put name="header" value="/WEB-INF/view/common/admin/header.jsp" />
	<tiles:put name="footer" value="/WEB-INF/view/common/admin/footer.jsp" />
	<tiles:put name="menu" value="/WEB-INF/view/common/admin/menu.jsp" />
	<tiles:put name="menuType" value="fileAuthentication" />
	<tiles:put name="headerScript" type="string"></tiles:put>
	<tiles:put name="body" type="string">

<div id="main">

<!-- Message: BEGIN -->
<div><html:messages id="msg" message="true"><bean:write name="msg" ignore="true"/></html:messages><html:errors/></div>
<!-- Message: END -->

<!-- List: BEGIN -->
<div class="list-table">
<div>
<c:if test="${displayCreateLink}">
<s:link href="createpage"><bean:message key="labels.file_authentication_link_create_new"/></s:link>
</c:if>
<c:if test="${!displayCreateLink}">
<s:link href="../fileCrawlingConfig/index"><bean:message key="labels.file_authentication_create_file_config"/></s:link>
</c:if>
</div>
<table style="width:500px;margin-top:5px;">
	<thead>
		<tr>
				<th style="text-align: center;width:200px;"><bean:message key="labels.file_authentication_list_hostname"/></th>
				<th style="text-align: center;"><bean:message key="labels.file_authentication_list_file_crawling_config"/></th>
			<th style="text-align: center;width:150px;">&nbsp;</th>
		</tr>
	</thead>
	<tbody>
		<c:forEach var="data" varStatus="s" items="${fileAuthenticationItems}">
		<tr class="${s.index % 2 == 0 ? 'row1' : 'row2'}">
								<td><c:if test="${data.hostname==null||data.hostname==''}"><bean:message key="labels.file_authentication_any"/></c:if>${f:h(data.hostname)}:<c:if test="${data.port==-1}"><bean:message key="labels.file_authentication_any"/></c:if><c:if test="${data.port!=-1}">${f:h(data.port)}</c:if></td>
								<td>${f:h(data.fileCrawlingConfig.name)}</td>
			<td align="center">
<s:link href="confirmpage/4/${f:u(data.id)}"><bean:message key="labels.file_authentication_link_details"/></s:link>
				<s:link href="editpage/2/${f:u(data.id)}"><bean:message key="labels.file_authentication_link_edit"/></s:link>
				<s:link href="deletepage/3/${f:u(data.id)}"><bean:message key="labels.file_authentication_link_delete"/></s:link>
			</td>
		</tr>
		</c:forEach>
	</tbody>
</table>
<!-- Page Navigation: BEGIN -->
<div>
	<span>
		<c:if test="${fileAuthenticationPager.existPrePage}">
		<s:link href="list/${fileAuthenticationPager.currentPageNumber - 1}"><bean:message key="labels.file_authentication_link_prev_page"/></s:link>
		</c:if>
	</span>
	<span>
		<c:forEach var="p" varStatus="s" items="${fileAuthenticationPager.pageNumberList}">
		<span>
			<c:if test="${p == fileAuthenticationPager.currentPageNumber}">
			${p}
			</c:if>
			<c:if test="${p != fileAuthenticationPager.currentPageNumber}">
			<s:link href="list/${p}">${p}</s:link>
			</c:if>
		</span>
		</c:forEach>
	</span>
	<span>
		<c:if test="${fileAuthenticationPager.existNextPage}">
		<s:link href="list/${fileAuthenticationPager.currentPageNumber + 1}"><bean:message key="labels.file_authentication_link_next_page"/></s:link>
		</c:if>
	</span>
</div>
<div>
	<span>
		${fileAuthenticationPager.currentPageNumber}/${fileAuthenticationPager.allPageCount} (${fileAuthenticationPager.allRecordCount})
	</span>
</div>
<!-- Page Navigation: END -->
</div>
<!-- List: END -->

</div>

	</tiles:put>
</tiles:insert>
