/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.WebAuthenticationDbm;
import jp.sf.fess.db.cbean.WebAuthenticationCB;
import jp.sf.fess.db.exbhv.WebAuthenticationBhv;
import jp.sf.fess.db.exentity.WebAuthentication;
import jp.sf.fess.db.exentity.WebCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of WEB_AUTHENTICATION as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, HOSTNAME, PORT, AUTH_REALM, PROTOCOL_SCHEME, USERNAME, PASSWORD, PARAMETERS, WEB_CRAWLING_CONFIG_ID, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     WEB_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     webCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsWebAuthenticationBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "WEB_AUTHENTICATION";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return WebAuthenticationDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public WebAuthenticationDbm getMyDBMeta() {
        return WebAuthenticationDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public WebAuthentication newMyEntity() {
        return new WebAuthentication();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public WebAuthenticationCB newMyConditionBean() {
        return new WebAuthenticationCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * WebAuthenticationCB cb = new WebAuthenticationCB();
     * cb.query().setFoo...(value);
     * int count = webAuthenticationBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of WebAuthentication. (NotNull)
     * @return The selected count.
     */
    public int selectCount(WebAuthenticationCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(WebAuthenticationCB cb) { // called by selectCount(cb) 
        assertCBNotNull(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(WebAuthenticationCB cb) { // called by selectPage(cb)
        assertCBNotNull(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * WebAuthenticationCB cb = new WebAuthenticationCB();
     * cb.query().setFoo...(value);
     * webAuthenticationBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;WebAuthentication&gt;() {
     *     public void handle(WebAuthentication entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of WebAuthentication. (NotNull)
     * @param entityRowHandler The handler of entity row of WebAuthentication. (NotNull)
     */
    public void selectCursor(WebAuthenticationCB cb,
            EntityRowHandler<WebAuthentication> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, WebAuthentication.class);
    }

    protected <ENTITY extends WebAuthentication> void doSelectCursor(
            WebAuthenticationCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<WebAuthentication>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * WebAuthenticationCB cb = new WebAuthenticationCB();
     * cb.query().setFoo...(value);
     * WebAuthentication webAuthentication = webAuthenticationBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (webAuthentication != null) {
     *     ... = webAuthentication.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of WebAuthentication. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebAuthentication selectEntity(WebAuthenticationCB cb) {
        return doSelectEntity(cb, WebAuthentication.class);
    }

    protected <ENTITY extends WebAuthentication> ENTITY doSelectEntity(
            final WebAuthenticationCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, WebAuthenticationCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebAuthenticationCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * WebAuthenticationCB cb = new WebAuthenticationCB();
     * cb.query().setFoo...(value);
     * WebAuthentication webAuthentication = webAuthenticationBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = webAuthentication.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of WebAuthentication. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebAuthentication selectEntityWithDeletedCheck(WebAuthenticationCB cb) {
        return doSelectEntityWithDeletedCheck(cb, WebAuthentication.class);
    }

    protected <ENTITY extends WebAuthentication> ENTITY doSelectEntityWithDeletedCheck(
            final WebAuthenticationCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, WebAuthenticationCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebAuthenticationCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebAuthentication selectByPKValue(Long id) {
        return doSelectByPKValue(id, WebAuthentication.class);
    }

    protected <ENTITY extends WebAuthentication> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public WebAuthentication selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, WebAuthentication.class);
    }

    protected <ENTITY extends WebAuthentication> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private WebAuthenticationCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        WebAuthenticationCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * WebAuthenticationCB cb = new WebAuthenticationCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;WebAuthentication&gt; webAuthenticationList = webAuthenticationBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (WebAuthentication webAuthentication : webAuthenticationList) {
     *     ... = webAuthentication.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebAuthentication. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<WebAuthentication> selectList(WebAuthenticationCB cb) {
        return doSelectList(cb, WebAuthentication.class);
    }

    protected <ENTITY extends WebAuthentication> ListResultBean<ENTITY> doSelectList(
            WebAuthenticationCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, WebAuthenticationCB>() {
                    public List<ENTITY> callbackSelectList(
                            WebAuthenticationCB cb, Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * WebAuthenticationCB cb = new WebAuthenticationCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;WebAuthentication&gt; page = webAuthenticationBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (WebAuthentication webAuthentication : page) {
     *     ... = webAuthentication.get...();
     * }
     * </pre>
     * @param cb The condition-bean of WebAuthentication. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<WebAuthentication> selectPage(WebAuthenticationCB cb) {
        return doSelectPage(cb, WebAuthentication.class);
    }

    protected <ENTITY extends WebAuthentication> PagingResultBean<ENTITY> doSelectPage(
            WebAuthenticationCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, WebAuthenticationCB>() {
                    public int callbackSelectCount(WebAuthenticationCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            WebAuthenticationCB cb, Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * webAuthenticationBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(WebAuthenticationCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<WebAuthenticationCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends WebAuthenticationCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'WebCrawlingConfig'.
     * @param webAuthenticationList The list of webAuthentication. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<WebCrawlingConfig> pulloutWebCrawlingConfig(
            List<WebAuthentication> webAuthenticationList) {
        return helpPulloutInternally(
                webAuthenticationList,
                new InternalPulloutCallback<WebAuthentication, WebCrawlingConfig>() {
                    public WebCrawlingConfig getFr(WebAuthentication e) {
                        return e.getWebCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(WebCrawlingConfig e,
                            List<WebAuthentication> ls) {
                        e.setWebAuthenticationList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * WebAuthentication webAuthentication = new WebAuthentication();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * webAuthentication.setFoo...(value);
     * webAuthentication.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//webAuthentication.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//webAuthentication.set...;</span>
     * webAuthenticationBhv.<span style="color: #FD4747">insert</span>(webAuthentication);
     * ... = webAuthentication.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param webAuthentication The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(WebAuthentication webAuthentication) {
        doInsert(webAuthentication, null);
    }

    protected void doInsert(WebAuthentication webAuthentication,
            InsertOption<WebAuthenticationCB> option) {
        assertObjectNotNull("webAuthentication", webAuthentication);
        prepareInsertOption(option);
        delegateInsert(webAuthentication, option);
    }

    protected void prepareInsertOption(InsertOption<WebAuthenticationCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreate(Entity entity,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), (InsertOption) option);
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebAuthentication webAuthentication = new WebAuthentication();
     * webAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webAuthentication.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//webAuthentication.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//webAuthentication.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webAuthentication.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webAuthenticationBhv.<span style="color: #FD4747">update</span>(webAuthentication);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webAuthentication The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final WebAuthentication webAuthentication) {
        doUpdate(webAuthentication, null);
    }

    protected void doUpdate(WebAuthentication webAuthentication,
            final UpdateOption<WebAuthenticationCB> option) {
        assertObjectNotNull("webAuthentication", webAuthentication);
        prepareUpdateOption(option);
        helpUpdateInternally(webAuthentication,
                new InternalUpdateCallback<WebAuthentication>() {
                    public int callbackDelegateUpdate(WebAuthentication entity) {
                        return delegateUpdate(entity, option);
                    }
                });
    }

    protected void prepareUpdateOption(UpdateOption<WebAuthenticationCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected WebAuthenticationCB createCBForVaryingUpdate() {
        WebAuthenticationCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected WebAuthenticationCB createCBForSpecifiedUpdate() {
        WebAuthenticationCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModify(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * WebAuthentication webAuthentication = new WebAuthentication();
     * webAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webAuthentication.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//webAuthentication.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//webAuthentication.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webAuthentication.setVersionNo(value);</span>
     * webAuthenticationBhv.<span style="color: #FD4747">updateNonstrict</span>(webAuthentication);
     * </pre>
     * @param webAuthentication The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final WebAuthentication webAuthentication) {
        doUpdateNonstrict(webAuthentication, null);
    }

    protected void doUpdateNonstrict(WebAuthentication webAuthentication,
            final UpdateOption<WebAuthenticationCB> option) {
        assertObjectNotNull("webAuthentication", webAuthentication);
        prepareUpdateOption(option);
        helpUpdateNonstrictInternally(webAuthentication,
                new InternalUpdateNonstrictCallback<WebAuthentication>() {
                    public int callbackDelegateUpdateNonstrict(
                            WebAuthentication entity) {
                        return delegateUpdateNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModifyNonstrict(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            updateNonstrict(downcast(entity));
        } else {
            varyingUpdateNonstrict(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param webAuthentication The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(WebAuthentication webAuthentication) {
        doInesrtOrUpdate(webAuthentication, null, null);
    }

    protected void doInesrtOrUpdate(WebAuthentication webAuthentication,
            final InsertOption<WebAuthenticationCB> insertOption,
            final UpdateOption<WebAuthenticationCB> updateOption) {
        helpInsertOrUpdateInternally(
                webAuthentication,
                new InternalInsertOrUpdateCallback<WebAuthentication, WebAuthenticationCB>() {
                    public void callbackInsert(WebAuthentication entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdate(WebAuthentication entity) {
                        doUpdate(entity, updateOption);
                    }

                    public WebAuthenticationCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(WebAuthenticationCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModify(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param webAuthentication The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(WebAuthentication webAuthentication) {
        doInesrtOrUpdateNonstrict(webAuthentication, null, null);
    }

    protected void doInesrtOrUpdateNonstrict(
            WebAuthentication webAuthentication,
            final InsertOption<WebAuthenticationCB> insertOption,
            final UpdateOption<WebAuthenticationCB> updateOption) {
        helpInsertOrUpdateInternally(
                webAuthentication,
                new InternalInsertOrUpdateNonstrictCallback<WebAuthentication>() {
                    public void callbackInsert(WebAuthentication entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdateNonstrict(WebAuthentication entity) {
                        doUpdateNonstrict(entity, updateOption);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModifyNonstrict(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdateNonstrict(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdateNonstrict(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * WebAuthentication webAuthentication = new WebAuthentication();
     * webAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webAuthentication.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     webAuthenticationBhv.<span style="color: #FD4747">delete</span>(webAuthentication);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param webAuthentication The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(WebAuthentication webAuthentication) {
        doDelete(webAuthentication, null);
    }

    protected void doDelete(WebAuthentication webAuthentication,
            final DeleteOption<WebAuthenticationCB> option) {
        assertObjectNotNull("webAuthentication", webAuthentication);
        prepareDeleteOption(option);
        helpDeleteInternally(webAuthentication,
                new InternalDeleteCallback<WebAuthentication>() {
                    public int callbackDelegateDelete(WebAuthentication entity) {
                        return delegateDelete(entity, option);
                    }
                });
    }

    protected void prepareDeleteOption(DeleteOption<WebAuthenticationCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemove(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), (DeleteOption) option);
        }
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * WebAuthentication webAuthentication = new WebAuthentication();
     * webAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webAuthentication.setVersionNo(value);</span>
     * webAuthenticationBhv.<span style="color: #FD4747">deleteNonstrict</span>(webAuthentication);
     * </pre>
     * @param webAuthentication The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(WebAuthentication webAuthentication) {
        doDeleteNonstrict(webAuthentication, null);
    }

    protected void doDeleteNonstrict(WebAuthentication webAuthentication,
            final DeleteOption<WebAuthenticationCB> option) {
        assertObjectNotNull("webAuthentication", webAuthentication);
        prepareDeleteOption(option);
        helpDeleteNonstrictInternally(webAuthentication,
                new InternalDeleteNonstrictCallback<WebAuthentication>() {
                    public int callbackDelegateDeleteNonstrict(
                            WebAuthentication entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * WebAuthentication webAuthentication = new WebAuthentication();
     * webAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webAuthentication.setVersionNo(value);</span>
     * webAuthenticationBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(webAuthentication);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param webAuthentication The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(WebAuthentication webAuthentication) {
        doDeleteNonstrictIgnoreDeleted(webAuthentication, null);
    }

    protected void doDeleteNonstrictIgnoreDeleted(
            WebAuthentication webAuthentication,
            final DeleteOption<WebAuthenticationCB> option) {
        assertObjectNotNull("webAuthentication", webAuthentication);
        prepareDeleteOption(option);
        helpDeleteNonstrictIgnoreDeletedInternally(
                webAuthentication,
                new InternalDeleteNonstrictIgnoreDeletedCallback<WebAuthentication>() {
                    public int callbackDelegateDeleteNonstrict(
                            WebAuthentication entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemoveNonstrict(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            deleteNonstrict(downcast(entity));
        } else {
            varyingDeleteNonstrict(downcast(entity), (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param webAuthenticationList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<WebAuthentication> webAuthenticationList) {
        return doBatchInsert(webAuthenticationList, null);
    }

    protected int[] doBatchInsert(
            List<WebAuthentication> webAuthenticationList,
            InsertOption<WebAuthenticationCB> option) {
        assertObjectNotNull("webAuthenticationList", webAuthenticationList);
        prepareInsertOption(option);
        return delegateBatchInsert(webAuthenticationList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpCreate(List<Entity> ls,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert((List) ls);
        } else {
            return varyingBatchInsert((List) ls, (InsertOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param webAuthenticationList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<WebAuthentication> webAuthenticationList) {
        return doBatchUpdate(webAuthenticationList, null);
    }

    protected int[] doBatchUpdate(
            List<WebAuthentication> webAuthenticationList,
            UpdateOption<WebAuthenticationCB> option) {
        assertObjectNotNull("webAuthenticationList", webAuthenticationList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(webAuthenticationList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModify(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate((List) ls);
        } else {
            return varyingBatchUpdate((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param webAuthenticationList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<WebAuthentication> webAuthenticationList,
            SpecifyQuery<WebAuthenticationCB> updateColumnSpec) {
        return doBatchUpdate(webAuthenticationList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param webAuthenticationList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<WebAuthentication> webAuthenticationList) {
        return doBatchUpdateNonstrict(webAuthenticationList, null);
    }

    protected int[] doBatchUpdateNonstrict(
            List<WebAuthentication> webAuthenticationList,
            UpdateOption<WebAuthenticationCB> option) {
        assertObjectNotNull("webAuthenticationList", webAuthenticationList);
        prepareUpdateOption(option);
        return delegateBatchUpdateNonstrict(webAuthenticationList, option);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param webAuthenticationList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<WebAuthentication> webAuthenticationList,
            SpecifyQuery<WebAuthenticationCB> updateColumnSpec) {
        return doBatchUpdateNonstrict(webAuthenticationList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModifyNonstrict(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdateNonstrict((List) ls);
        } else {
            return varyingBatchUpdateNonstrict((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webAuthenticationList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<WebAuthentication> webAuthenticationList) {
        return doBatchDelete(webAuthenticationList, null);
    }

    protected int[] doBatchDelete(
            List<WebAuthentication> webAuthenticationList,
            DeleteOption<WebAuthenticationCB> option) {
        assertObjectNotNull("webAuthenticationList", webAuthenticationList);
        prepareDeleteOption(option);
        return delegateBatchDelete(webAuthenticationList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemove(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete((List) ls);
        } else {
            return varyingBatchDelete((List) ls, (DeleteOption) option);
        }
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param webAuthenticationList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(
            List<WebAuthentication> webAuthenticationList) {
        return doBatchDeleteNonstrict(webAuthenticationList, null);
    }

    protected int[] doBatchDeleteNonstrict(
            List<WebAuthentication> webAuthenticationList,
            DeleteOption<WebAuthenticationCB> option) {
        assertObjectNotNull("webAuthenticationList", webAuthenticationList);
        prepareDeleteOption(option);
        return delegateBatchDeleteNonstrict(webAuthenticationList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemoveNonstrict(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDeleteNonstrict((List) ls);
        } else {
            return varyingBatchDeleteNonstrict((List) ls, (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * webAuthenticationBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;webAuthentication, WebAuthenticationCB&gt;() {
     *     public ConditionBean setup(webAuthentication entity, WebAuthenticationCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(
            QueryInsertSetupper<WebAuthentication, WebAuthenticationCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            QueryInsertSetupper<WebAuthentication, WebAuthenticationCB> setupper,
            InsertOption<WebAuthenticationCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        WebAuthentication entity = new WebAuthentication();
        WebAuthenticationCB intoCB = createCBForQueryInsert();
        ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected WebAuthenticationCB createCBForQueryInsert() {
        WebAuthenticationCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeCreate(
            QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert((QueryInsertSetupper) setupper);
        } else {
            return varyingQueryInsert((QueryInsertSetupper) setupper,
                    (InsertOption) option);
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * WebAuthentication webAuthentication = new WebAuthentication();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webAuthentication.setPK...(value);</span>
     * webAuthentication.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//webAuthentication.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//webAuthentication.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webAuthentication.setVersionNo(value);</span>
     * WebAuthenticationCB cb = new WebAuthenticationCB();
     * cb.query().setFoo...(value);
     * webAuthenticationBhv.<span style="color: #FD4747">queryUpdate</span>(webAuthentication, cb);
     * </pre>
     * @param webAuthentication The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of WebAuthentication. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(WebAuthentication webAuthentication,
            WebAuthenticationCB cb) {
        return doQueryUpdate(webAuthentication, cb, null);
    }

    protected int doQueryUpdate(WebAuthentication webAuthentication,
            WebAuthenticationCB cb, UpdateOption<WebAuthenticationCB> option) {
        assertObjectNotNull("webAuthentication", webAuthentication);
        assertCBNotNull(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(webAuthentication, cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeModify(Entity entity, ConditionBean cb,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity), (WebAuthenticationCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity),
                    (WebAuthenticationCB) cb, (UpdateOption) option);
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * WebAuthenticationCB cb = new WebAuthenticationCB();
     * cb.query().setFoo...(value);
     * webAuthenticationBhv.<span style="color: #FD4747">queryDelete</span>(webAuthentication, cb);
     * </pre>
     * @param cb The condition-bean of WebAuthentication. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(WebAuthenticationCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(WebAuthenticationCB cb,
            DeleteOption<WebAuthenticationCB> option) {
        assertCBNotNull(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeRemove(ConditionBean cb,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((WebAuthenticationCB) cb);
        } else {
            return varyingQueryDelete((WebAuthenticationCB) cb,
                    (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * WebAuthentication webAuthentication = new WebAuthentication();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * webAuthentication.setFoo...(value);
     * webAuthentication.setBar...(value);
     * InsertOption<WebAuthenticationCB> option = new InsertOption<WebAuthenticationCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * webAuthenticationBhv.<span style="color: #FD4747">varyingInsert</span>(webAuthentication, option);
     * ... = webAuthentication.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param webAuthentication The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(WebAuthentication webAuthentication,
            InsertOption<WebAuthenticationCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(webAuthentication, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * WebAuthentication webAuthentication = new WebAuthentication();
     * webAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webAuthentication.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * webAuthentication.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;WebAuthenticationCB&gt; option = new UpdateOption&lt;WebAuthenticationCB&gt;();
     *     option.self(new SpecifyQuery&lt;WebAuthenticationCB&gt;() {
     *         public void specify(WebAuthenticationCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     webAuthenticationBhv.<span style="color: #FD4747">varyingUpdate</span>(webAuthentication, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param webAuthentication The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(WebAuthentication webAuthentication,
            UpdateOption<WebAuthenticationCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(webAuthentication, option);
    }

    /**
     * Update the entity with varying requests non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as updateNonstrict(entity).
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * WebAuthentication webAuthentication = new WebAuthentication();
     * webAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * webAuthentication.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webAuthentication.setVersionNo(value);</span>
     * UpdateOption&lt;WebAuthenticationCB&gt; option = new UpdateOption&lt;WebAuthenticationCB&gt;();
     * option.self(new SpecifyQuery&lt;WebAuthenticationCB&gt;() {
     *     public void specify(WebAuthenticationCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * webAuthenticationBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(webAuthentication, option);
     * </pre>
     * @param webAuthentication The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(WebAuthentication webAuthentication,
            UpdateOption<WebAuthenticationCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdateNonstrict(webAuthentication, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param webAuthentication The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(WebAuthentication webAuthentication,
            InsertOption<WebAuthenticationCB> insertOption,
            UpdateOption<WebAuthenticationCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(webAuthentication, insertOption, updateOption);
    }

    /**
     * Insert or update the entity with varying requests non-strictly. {NonExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdateNonstrict(entity).
     * @param webAuthentication The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdateNonstrict(
            WebAuthentication webAuthentication,
            InsertOption<WebAuthenticationCB> insertOption,
            UpdateOption<WebAuthenticationCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdateNonstrict(webAuthentication, insertOption, updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param webAuthentication The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(WebAuthentication webAuthentication,
            DeleteOption<WebAuthenticationCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(webAuthentication, option);
    }

    /**
     * Delete the entity with varying requests non-strictly. {UpdateCountZeroException, NonExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as deleteNonstrict(entity).
     * @param webAuthentication The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDeleteNonstrict(WebAuthentication webAuthentication,
            DeleteOption<WebAuthenticationCB> option) {
        assertDeleteOptionNotNull(option);
        doDeleteNonstrict(webAuthentication, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param webAuthenticationList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(
            List<WebAuthentication> webAuthenticationList,
            InsertOption<WebAuthenticationCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(webAuthenticationList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param webAuthenticationList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(
            List<WebAuthentication> webAuthenticationList,
            UpdateOption<WebAuthenticationCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(webAuthenticationList, option);
    }

    /**
     * Batch-update the list with varying requests non-strictly. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param webAuthenticationList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdateNonstrict(
            List<WebAuthentication> webAuthenticationList,
            UpdateOption<WebAuthenticationCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdateNonstrict(webAuthenticationList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param webAuthenticationList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(
            List<WebAuthentication> webAuthenticationList,
            DeleteOption<WebAuthenticationCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(webAuthenticationList, option);
    }

    /**
     * Batch-delete the list with varying requests non-strictly. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDeleteNonstrict(entityList).
     * @param webAuthenticationList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDeleteNonstrict(
            List<WebAuthentication> webAuthenticationList,
            DeleteOption<WebAuthenticationCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDeleteNonstrict(webAuthenticationList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            QueryInsertSetupper<WebAuthentication, WebAuthenticationCB> setupper,
            InsertOption<WebAuthenticationCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * WebAuthentication webAuthentication = new WebAuthentication();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//webAuthentication.setPK...(value);</span>
     * webAuthentication.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//webAuthentication.setVersionNo(value);</span>
     * WebAuthenticationCB cb = new WebAuthenticationCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;WebAuthenticationCB&gt; option = new UpdateOption&lt;WebAuthenticationCB&gt;();
     * option.self(new SpecifyQuery&lt;WebAuthenticationCB&gt;() {
     *     public void specify(WebAuthenticationCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * webAuthenticationBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(webAuthentication, cb, option);
     * </pre>
     * @param webAuthentication The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of WebAuthentication. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(WebAuthentication webAuthentication,
            WebAuthenticationCB cb, UpdateOption<WebAuthenticationCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(webAuthentication, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of WebAuthentication. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(WebAuthenticationCB cb,
            DeleteOption<WebAuthenticationCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<WebAuthenticationBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(WebAuthenticationCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(WebAuthenticationCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends WebAuthentication> void delegateSelectCursor(
            WebAuthenticationCB cb, EntityRowHandler<ENTITY> erh,
            Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends WebAuthentication> List<ENTITY> delegateSelectList(
            WebAuthenticationCB cb, Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(WebAuthentication e,
            InsertOption<WebAuthenticationCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(WebAuthentication e,
            UpdateOption<WebAuthenticationCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateEntityCommand(e, op));
    }

    protected int delegateUpdateNonstrict(WebAuthentication e,
            UpdateOption<WebAuthenticationCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(WebAuthentication e,
            DeleteOption<WebAuthenticationCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteEntityCommand(e, op));
    }

    protected int delegateDeleteNonstrict(WebAuthentication e,
            DeleteOption<WebAuthenticationCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(List<WebAuthentication> ls,
            InsertOption<WebAuthenticationCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(List<WebAuthentication> ls,
            UpdateOption<WebAuthenticationCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchUpdateNonstrict(List<WebAuthentication> ls,
            UpdateOption<WebAuthenticationCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(List<WebAuthentication> ls,
            DeleteOption<WebAuthenticationCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchDeleteNonstrict(List<WebAuthentication> ls,
            DeleteOption<WebAuthenticationCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(WebAuthentication e,
            WebAuthenticationCB inCB, ConditionBean resCB,
            InsertOption<WebAuthenticationCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(WebAuthentication e,
            WebAuthenticationCB cb, UpdateOption<WebAuthenticationCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(WebAuthenticationCB cb,
            DeleteOption<WebAuthenticationCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected WebAuthentication downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, WebAuthentication.class);
    }

    protected WebAuthenticationCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                WebAuthenticationCB.class);
    }
}
