/*
 * Copyright 2009-2011 the Fess Project and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package jp.sf.fess.db.bsbhv;

import java.util.List;

import jp.sf.fess.db.bsentity.dbmeta.FileAuthenticationDbm;
import jp.sf.fess.db.cbean.FileAuthenticationCB;
import jp.sf.fess.db.exbhv.FileAuthenticationBhv;
import jp.sf.fess.db.exentity.FileAuthentication;
import jp.sf.fess.db.exentity.FileCrawlingConfig;

import org.seasar.dbflute.Entity;
import org.seasar.dbflute.bhv.AbstractBehaviorWritable;
import org.seasar.dbflute.bhv.DeleteOption;
import org.seasar.dbflute.bhv.InsertOption;
import org.seasar.dbflute.bhv.QueryInsertSetupper;
import org.seasar.dbflute.bhv.UpdateOption;
import org.seasar.dbflute.cbean.ConditionBean;
import org.seasar.dbflute.cbean.EntityRowHandler;
import org.seasar.dbflute.cbean.ListResultBean;
import org.seasar.dbflute.cbean.PagingResultBean;
import org.seasar.dbflute.cbean.SpecifyQuery;
import org.seasar.dbflute.dbmeta.DBMeta;
import org.seasar.dbflute.outsidesql.executor.OutsideSqlBasicExecutor;

/**
 * The behavior of FILE_AUTHENTICATION as TABLE. <br />
 * <pre>
 * [primary-key]
 *     ID
 * 
 * [column]
 *     ID, HOSTNAME, PORT, PROTOCOL_SCHEME, USERNAME, PASSWORD, PARAMETERS, FILE_CRAWLING_CONFIG_ID, CREATED_BY, CREATED_TIME, UPDATED_BY, UPDATED_TIME, DELETED_BY, DELETED_TIME, VERSION_NO
 * 
 * [sequence]
 *     
 * 
 * [identity]
 *     ID
 * 
 * [version-no]
 *     VERSION_NO
 * 
 * [foreign-table]
 *     FILE_CRAWLING_CONFIG
 * 
 * [referrer-table]
 *     
 * 
 * [foreign-property]
 *     fileCrawlingConfig
 * 
 * [referrer-property]
 *     
 * </pre>
 * @author DBFlute(AutoGenerator)
 */
public abstract class BsFileAuthenticationBhv extends AbstractBehaviorWritable {

    // ===================================================================================
    //                                                                          Definition
    //                                                                          ==========
    /*df:beginQueryPath*/
    /*df:endQueryPath*/

    // ===================================================================================
    //                                                                          Table name
    //                                                                          ==========
    /** @return The name on database of table. (NotNull) */
    public String getTableDbName() {
        return "FILE_AUTHENTICATION";
    }

    // ===================================================================================
    //                                                                              DBMeta
    //                                                                              ======
    /** @return The instance of DBMeta. (NotNull) */
    public DBMeta getDBMeta() {
        return FileAuthenticationDbm.getInstance();
    }

    /** @return The instance of DBMeta as my table type. (NotNull) */
    public FileAuthenticationDbm getMyDBMeta() {
        return FileAuthenticationDbm.getInstance();
    }

    // ===================================================================================
    //                                                                        New Instance
    //                                                                        ============
    /** {@inheritDoc} */
    public Entity newEntity() {
        return newMyEntity();
    }

    /** {@inheritDoc} */
    public ConditionBean newConditionBean() {
        return newMyConditionBean();
    }

    /** @return The instance of new entity as my table type. (NotNull) */
    public FileAuthentication newMyEntity() {
        return new FileAuthentication();
    }

    /** @return The instance of new condition-bean as my table type. (NotNull) */
    public FileAuthenticationCB newMyConditionBean() {
        return new FileAuthenticationCB();
    }

    // ===================================================================================
    //                                                                        Count Select
    //                                                                        ============
    /**
     * Select the count of uniquely-selected records by the condition-bean. {IgnorePagingCondition, IgnoreSpecifyColumn}<br />
     * SpecifyColumn is ignored but you can use it only to remove text type column for union's distinct.
     * <pre>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * int count = fileAuthenticationBhv.<span style="color: #FD4747">selectCount</span>(cb);
     * </pre>
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @return The selected count.
     */
    public int selectCount(FileAuthenticationCB cb) {
        return doSelectCountUniquely(cb);
    }

    protected int doSelectCountUniquely(FileAuthenticationCB cb) { // called by selectCount(cb) 
        assertCBNotNull(cb);
        return delegateSelectCountUniquely(cb);
    }

    protected int doSelectCountPlainly(FileAuthenticationCB cb) { // called by selectPage(cb)
        assertCBNotNull(cb);
        return delegateSelectCountPlainly(cb);
    }

    @Override
    protected int doReadCount(ConditionBean cb) {
        return selectCount(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Cursor Select
    //                                                                       =============
    /**
     * Select the cursor by the condition-bean.
     * <pre>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * fileAuthenticationBhv.<span style="color: #FD4747">selectCursor</span>(cb, new EntityRowHandler&lt;FileAuthentication&gt;() {
     *     public void handle(FileAuthentication entity) {
     *         ... = entity.getFoo...();
     *     }
     * });
     * </pre>
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @param entityRowHandler The handler of entity row of FileAuthentication. (NotNull)
     */
    public void selectCursor(FileAuthenticationCB cb,
            EntityRowHandler<FileAuthentication> entityRowHandler) {
        doSelectCursor(cb, entityRowHandler, FileAuthentication.class);
    }

    protected <ENTITY extends FileAuthentication> void doSelectCursor(
            FileAuthenticationCB cb, EntityRowHandler<ENTITY> entityRowHandler,
            Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityRowHandler<FileAuthentication>",
                entityRowHandler);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        delegateSelectCursor(cb, entityRowHandler, entityType);
    }

    // ===================================================================================
    //                                                                       Entity Select
    //                                                                       =============
    /**
     * Select the entity by the condition-bean.
     * <pre>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * FileAuthentication fileAuthentication = fileAuthenticationBhv.<span style="color: #FD4747">selectEntity</span>(cb);
     * if (fileAuthentication != null) {
     *     ... = fileAuthentication.get...();
     * } else {
     *     ...
     * }
     * </pre>
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @return The selected entity. (NullAllowed: If the condition has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileAuthentication selectEntity(FileAuthenticationCB cb) {
        return doSelectEntity(cb, FileAuthentication.class);
    }

    protected <ENTITY extends FileAuthentication> ENTITY doSelectEntity(
            final FileAuthenticationCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityInternally(
                cb,
                new InternalSelectEntityCallback<ENTITY, FileAuthenticationCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileAuthenticationCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntity(ConditionBean cb) {
        return selectEntity(downcast(cb));
    }

    /**
     * Select the entity by the condition-bean with deleted check.
     * <pre>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * FileAuthentication fileAuthentication = fileAuthenticationBhv.<span style="color: #FD4747">selectEntityWithDeletedCheck</span>(cb);
     * ... = fileAuthentication.get...(); <span style="color: #3F7E5E">// the entity always be not null</span>
     * </pre>
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileAuthentication selectEntityWithDeletedCheck(
            FileAuthenticationCB cb) {
        return doSelectEntityWithDeletedCheck(cb, FileAuthentication.class);
    }

    protected <ENTITY extends FileAuthentication> ENTITY doSelectEntityWithDeletedCheck(
            final FileAuthenticationCB cb, final Class<ENTITY> entityType) {
        return helpSelectEntityWithDeletedCheckInternally(
                cb,
                new InternalSelectEntityWithDeletedCheckCallback<ENTITY, FileAuthenticationCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileAuthenticationCB cb) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected Entity doReadEntityWithDeletedCheck(ConditionBean cb) {
        return selectEntityWithDeletedCheck(downcast(cb));
    }

    /**
     * Select the entity by the primary-key value.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NullAllowed: If the primary-key value has no data, it returns null)
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileAuthentication selectByPKValue(Long id) {
        return doSelectByPKValue(id, FileAuthentication.class);
    }

    protected <ENTITY extends FileAuthentication> ENTITY doSelectByPKValue(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntity(buildPKCB(id), entityType);
    }

    /**
     * Select the entity by the primary-key value with deleted check.
     * @param id The one of primary key. (NotNull)
     * @return The selected entity. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.SelectEntityConditionNotFoundException When the condition for selecting an entity is not found.
     */
    public FileAuthentication selectByPKValueWithDeletedCheck(Long id) {
        return doSelectByPKValueWithDeletedCheck(id, FileAuthentication.class);
    }

    protected <ENTITY extends FileAuthentication> ENTITY doSelectByPKValueWithDeletedCheck(
            Long id, Class<ENTITY> entityType) {
        return doSelectEntityWithDeletedCheck(buildPKCB(id), entityType);
    }

    private FileAuthenticationCB buildPKCB(Long id) {
        assertObjectNotNull("id", id);
        FileAuthenticationCB cb = newMyConditionBean();
        cb.query().setId_Equal(id);
        return cb;
    }

    // ===================================================================================
    //                                                                         List Select
    //                                                                         ===========
    /**
     * Select the list as result bean.
     * <pre>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * ListResultBean&lt;FileAuthentication&gt; fileAuthenticationList = fileAuthenticationBhv.<span style="color: #FD4747">selectList</span>(cb);
     * for (FileAuthentication fileAuthentication : fileAuthenticationList) {
     *     ... = fileAuthentication.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @return The result bean of selected list. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public ListResultBean<FileAuthentication> selectList(FileAuthenticationCB cb) {
        return doSelectList(cb, FileAuthentication.class);
    }

    protected <ENTITY extends FileAuthentication> ListResultBean<ENTITY> doSelectList(
            FileAuthenticationCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        assertSpecifyDerivedReferrerEntityProperty(cb, entityType);
        return helpSelectListInternally(cb, entityType,
                new InternalSelectListCallback<ENTITY, FileAuthenticationCB>() {
                    public List<ENTITY> callbackSelectList(
                            FileAuthenticationCB cb, Class<ENTITY> entityType) {
                        return delegateSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected ListResultBean<? extends Entity> doReadList(ConditionBean cb) {
        return selectList(downcast(cb));
    }

    // ===================================================================================
    //                                                                         Page Select
    //                                                                         ===========
    /**
     * Select the page as result bean. <br />
     * (both count-select and paging-select are executed)
     * <pre>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * cb.query().addOrderBy_Bar...();
     * cb.<span style="color: #FD4747">paging</span>(20, 3); <span style="color: #3F7E5E">// 20 records per a page and current page number is 3</span>
     * PagingResultBean&lt;FileAuthentication&gt; page = fileAuthenticationBhv.<span style="color: #FD4747">selectPage</span>(cb);
     * int allRecordCount = page.getAllRecordCount();
     * int allPageCount = page.getAllPageCount();
     * boolean isExistPrePage = page.isExistPrePage();
     * boolean isExistNextPage = page.isExistNextPage();
     * ...
     * for (FileAuthentication fileAuthentication : page) {
     *     ... = fileAuthentication.get...();
     * }
     * </pre>
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @return The result bean of selected page. (NotNull)
     * @exception org.seasar.dbflute.exception.DangerousResultSizeException When the result size is over the specified safety size.
     */
    public PagingResultBean<FileAuthentication> selectPage(
            FileAuthenticationCB cb) {
        return doSelectPage(cb, FileAuthentication.class);
    }

    protected <ENTITY extends FileAuthentication> PagingResultBean<ENTITY> doSelectPage(
            FileAuthenticationCB cb, Class<ENTITY> entityType) {
        assertCBNotNull(cb);
        assertObjectNotNull("entityType", entityType);
        return helpSelectPageInternally(cb, entityType,
                new InternalSelectPageCallback<ENTITY, FileAuthenticationCB>() {
                    public int callbackSelectCount(FileAuthenticationCB cb) {
                        return doSelectCountPlainly(cb);
                    }

                    public List<ENTITY> callbackSelectList(
                            FileAuthenticationCB cb, Class<ENTITY> entityType) {
                        return doSelectList(cb, entityType);
                    }
                });
    }

    @Override
    protected PagingResultBean<? extends Entity> doReadPage(ConditionBean cb) {
        return selectPage(downcast(cb));
    }

    // ===================================================================================
    //                                                                       Scalar Select
    //                                                                       =============
    /**
     * Select the scalar value derived by a function from uniquely-selected records. <br />
     * You should call a function method after this method called like as follows:
     * <pre>
     * fileAuthenticationBhv.<span style="color: #FD4747">scalarSelect</span>(Date.class).max(new ScalarQuery() {
     *     public void query(FileAuthenticationCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooDatetime()</span>; <span style="color: #3F7E5E">// required for a function</span>
     *         cb.query().setBarName_PrefixSearch("S");
     *     }
     * });
     * </pre>
     * @param <RESULT> The type of result.
     * @param resultType The type of result. (NotNull)
     * @return The scalar value derived by a function. (NullAllowed)
     */
    public <RESULT> SLFunction<FileAuthenticationCB, RESULT> scalarSelect(
            Class<RESULT> resultType) {
        return doScalarSelect(resultType, newMyConditionBean());
    }

    protected <RESULT, CB extends FileAuthenticationCB> SLFunction<CB, RESULT> doScalarSelect(
            Class<RESULT> resultType, CB cb) {
        assertObjectNotNull("resultType", resultType);
        assertCBNotNull(cb);
        cb.xsetupForScalarSelect();
        cb.getSqlClause().disableSelectIndex(); // for when you use union
        return new SLFunction<CB, RESULT>(cb, resultType);
    }

    // ===================================================================================
    //                                                                            Sequence
    //                                                                            ========
    @Override
    protected Number doReadNextVal() {
        String msg = "This table is NOT related to sequence: "
                + getTableDbName();
        throw new UnsupportedOperationException(msg);
    }

    // ===================================================================================
    //                                                                    Pull out Foreign
    //                                                                    ================
    /**
     * Pull out the list of foreign table 'FileCrawlingConfig'.
     * @param fileAuthenticationList The list of fileAuthentication. (NotNull)
     * @return The list of foreign table. (NotNull)
     */
    public List<FileCrawlingConfig> pulloutFileCrawlingConfig(
            List<FileAuthentication> fileAuthenticationList) {
        return helpPulloutInternally(
                fileAuthenticationList,
                new InternalPulloutCallback<FileAuthentication, FileCrawlingConfig>() {
                    public FileCrawlingConfig getFr(FileAuthentication e) {
                        return e.getFileCrawlingConfig();
                    }

                    public boolean hasRf() {
                        return true;
                    }

                    public void setRfLs(FileCrawlingConfig e,
                            List<FileAuthentication> ls) {
                        e.setFileAuthenticationList(ls);
                    }
                });
    }

    // ===================================================================================
    //                                                                       Entity Update
    //                                                                       =============
    /**
     * Insert the entity.
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * fileAuthentication.setFoo...(value);
     * fileAuthentication.setBar...(value);
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//fileAuthentication.set...;</span>
     * fileAuthenticationBhv.<span style="color: #FD4747">insert</span>(fileAuthentication);
     * ... = fileAuthentication.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param fileAuthentication The entity of insert target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insert(FileAuthentication fileAuthentication) {
        doInsert(fileAuthentication, null);
    }

    protected void doInsert(FileAuthentication fileAuthentication,
            InsertOption<FileAuthenticationCB> option) {
        assertObjectNotNull("fileAuthentication", fileAuthentication);
        prepareInsertOption(option);
        delegateInsert(fileAuthentication, option);
    }

    protected void prepareInsertOption(InsertOption<FileAuthenticationCB> option) {
        if (option == null) {
            return;
        }
        assertInsertOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreate(Entity entity,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            insert(downcast(entity));
        } else {
            varyingInsert(downcast(entity), (InsertOption) option);
        }
    }

    /**
     * Update the entity modified-only. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * fileAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileAuthentication.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//fileAuthentication.set...;</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileAuthentication.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     fileAuthenticationBhv.<span style="color: #FD4747">update</span>(fileAuthentication);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param fileAuthentication The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void update(final FileAuthentication fileAuthentication) {
        doUpdate(fileAuthentication, null);
    }

    protected void doUpdate(FileAuthentication fileAuthentication,
            final UpdateOption<FileAuthenticationCB> option) {
        assertObjectNotNull("fileAuthentication", fileAuthentication);
        prepareUpdateOption(option);
        helpUpdateInternally(fileAuthentication,
                new InternalUpdateCallback<FileAuthentication>() {
                    public int callbackDelegateUpdate(FileAuthentication entity) {
                        return delegateUpdate(entity, option);
                    }
                });
    }

    protected void prepareUpdateOption(UpdateOption<FileAuthenticationCB> option) {
        if (option == null) {
            return;
        }
        assertUpdateOptionStatus(option);
        if (option.hasSelfSpecification()) {
            option.resolveSelfSpecification(createCBForVaryingUpdate());
        }
        if (option.hasSpecifiedUpdateColumn()) {
            option.resolveUpdateColumnSpecification(createCBForSpecifiedUpdate());
        }
    }

    protected FileAuthenticationCB createCBForVaryingUpdate() {
        FileAuthenticationCB cb = newMyConditionBean();
        cb.xsetupForVaryingUpdate();
        return cb;
    }

    protected FileAuthenticationCB createCBForSpecifiedUpdate() {
        FileAuthenticationCB cb = newMyConditionBean();
        cb.xsetupForSpecifiedUpdate();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModify(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            update(downcast(entity));
        } else {
            varyingUpdate(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Update the entity non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * fileAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileAuthentication.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//fileAuthentication.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setVersionNo(value);</span>
     * fileAuthenticationBhv.<span style="color: #FD4747">updateNonstrict</span>(fileAuthentication);
     * </pre>
     * @param fileAuthentication The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void updateNonstrict(final FileAuthentication fileAuthentication) {
        doUpdateNonstrict(fileAuthentication, null);
    }

    protected void doUpdateNonstrict(FileAuthentication fileAuthentication,
            final UpdateOption<FileAuthenticationCB> option) {
        assertObjectNotNull("fileAuthentication", fileAuthentication);
        prepareUpdateOption(option);
        helpUpdateNonstrictInternally(fileAuthentication,
                new InternalUpdateNonstrictCallback<FileAuthentication>() {
                    public int callbackDelegateUpdateNonstrict(
                            FileAuthentication entity) {
                        return delegateUpdateNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doModifyNonstrict(Entity entity,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            updateNonstrict(downcast(entity));
        } else {
            varyingUpdateNonstrict(downcast(entity), (UpdateOption) option);
        }
    }

    /**
     * Insert or update the entity modified-only. {ExclusiveControl(when update)}
     * @param fileAuthentication The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdate(FileAuthentication fileAuthentication) {
        doInesrtOrUpdate(fileAuthentication, null, null);
    }

    protected void doInesrtOrUpdate(FileAuthentication fileAuthentication,
            final InsertOption<FileAuthenticationCB> insertOption,
            final UpdateOption<FileAuthenticationCB> updateOption) {
        helpInsertOrUpdateInternally(
                fileAuthentication,
                new InternalInsertOrUpdateCallback<FileAuthentication, FileAuthenticationCB>() {
                    public void callbackInsert(FileAuthentication entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdate(FileAuthentication entity) {
                        doUpdate(entity, updateOption);
                    }

                    public FileAuthenticationCB callbackNewMyConditionBean() {
                        return newMyConditionBean();
                    }

                    public int callbackSelectCount(FileAuthenticationCB cb) {
                        return selectCount(cb);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModify(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdate(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdate(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Insert or update the entity non-strictly modified-only. {NonExclusiveControl(when update)}
     * @param fileAuthentication The entity of insert or update target. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void insertOrUpdateNonstrict(FileAuthentication fileAuthentication) {
        doInesrtOrUpdateNonstrict(fileAuthentication, null, null);
    }

    protected void doInesrtOrUpdateNonstrict(
            FileAuthentication fileAuthentication,
            final InsertOption<FileAuthenticationCB> insertOption,
            final UpdateOption<FileAuthenticationCB> updateOption) {
        helpInsertOrUpdateInternally(
                fileAuthentication,
                new InternalInsertOrUpdateNonstrictCallback<FileAuthentication>() {
                    public void callbackInsert(FileAuthentication entity) {
                        doInsert(entity, insertOption);
                    }

                    public void callbackUpdateNonstrict(
                            FileAuthentication entity) {
                        doUpdateNonstrict(entity, updateOption);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doCreateOrModifyNonstrict(Entity entity,
            InsertOption<? extends ConditionBean> insertOption,
            UpdateOption<? extends ConditionBean> updateOption) {
        if (insertOption == null && updateOption == null) {
            insertOrUpdateNonstrict(downcast(entity));
        } else {
            insertOption = insertOption == null ? new InsertOption()
                    : insertOption;
            updateOption = updateOption == null ? new UpdateOption()
                    : updateOption;
            varyingInsertOrUpdateNonstrict(downcast(entity),
                    (InsertOption) insertOption, (UpdateOption) updateOption);
        }
    }

    /**
     * Delete the entity. {UpdateCountZeroException, ExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * fileAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileAuthentication.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     fileAuthenticationBhv.<span style="color: #FD4747">delete</span>(fileAuthentication);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * } 
     * </pre>
     * @param fileAuthentication The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void delete(FileAuthentication fileAuthentication) {
        doDelete(fileAuthentication, null);
    }

    protected void doDelete(FileAuthentication fileAuthentication,
            final DeleteOption<FileAuthenticationCB> option) {
        assertObjectNotNull("fileAuthentication", fileAuthentication);
        prepareDeleteOption(option);
        helpDeleteInternally(fileAuthentication,
                new InternalDeleteCallback<FileAuthentication>() {
                    public int callbackDelegateDelete(FileAuthentication entity) {
                        return delegateDelete(entity, option);
                    }
                });
    }

    protected void prepareDeleteOption(DeleteOption<FileAuthenticationCB> option) {
        if (option == null) {
            return;
        }
        assertDeleteOptionStatus(option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemove(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            delete(downcast(entity));
        } else {
            varyingDelete(downcast(entity), (DeleteOption) option);
        }
    }

    /**
     * Delete the entity non-strictly. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * fileAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setVersionNo(value);</span>
     * fileAuthenticationBhv.<span style="color: #FD4747">deleteNonstrict</span>(fileAuthentication);
     * </pre>
     * @param fileAuthentication The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrict(FileAuthentication fileAuthentication) {
        doDeleteNonstrict(fileAuthentication, null);
    }

    protected void doDeleteNonstrict(FileAuthentication fileAuthentication,
            final DeleteOption<FileAuthenticationCB> option) {
        assertObjectNotNull("fileAuthentication", fileAuthentication);
        prepareDeleteOption(option);
        helpDeleteNonstrictInternally(fileAuthentication,
                new InternalDeleteNonstrictCallback<FileAuthentication>() {
                    public int callbackDelegateDeleteNonstrict(
                            FileAuthentication entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    /**
     * Delete the entity non-strictly ignoring deleted. {UpdateCountZeroException, NonExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * fileAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setVersionNo(value);</span>
     * fileAuthenticationBhv.<span style="color: #FD4747">deleteNonstrictIgnoreDeleted</span>(fileAuthentication);
     * <span style="color: #3F7E5E">// if the target entity doesn't exist, no exception</span>
     * </pre>
     * @param fileAuthentication The entity of delete target. (NotNull) {PrimaryKeyRequired}
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void deleteNonstrictIgnoreDeleted(
            FileAuthentication fileAuthentication) {
        doDeleteNonstrictIgnoreDeleted(fileAuthentication, null);
    }

    protected void doDeleteNonstrictIgnoreDeleted(
            FileAuthentication fileAuthentication,
            final DeleteOption<FileAuthenticationCB> option) {
        assertObjectNotNull("fileAuthentication", fileAuthentication);
        prepareDeleteOption(option);
        helpDeleteNonstrictIgnoreDeletedInternally(
                fileAuthentication,
                new InternalDeleteNonstrictIgnoreDeletedCallback<FileAuthentication>() {
                    public int callbackDelegateDeleteNonstrict(
                            FileAuthentication entity) {
                        return delegateDeleteNonstrict(entity, option);
                    }
                });
    }

    @Override
    @SuppressWarnings("unchecked")
    protected void doRemoveNonstrict(Entity entity,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            deleteNonstrict(downcast(entity));
        } else {
            varyingDeleteNonstrict(downcast(entity), (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Batch Update
    //                                                                        ============
    /**
     * Batch-insert the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are insert target. (so default constraints are not available) <br />
     * And if the table has an identity, entities after the process do not have incremented values.
     * (When you use the (normal) insert(), an entity after the process has an incremented value)
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @return The array of inserted count.
     */
    public int[] batchInsert(List<FileAuthentication> fileAuthenticationList) {
        return doBatchInsert(fileAuthenticationList, null);
    }

    protected int[] doBatchInsert(
            List<FileAuthentication> fileAuthenticationList,
            InsertOption<FileAuthenticationCB> option) {
        assertObjectNotNull("fileAuthenticationList", fileAuthenticationList);
        prepareInsertOption(option);
        return delegateBatchInsert(fileAuthenticationList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpCreate(List<Entity> ls,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchInsert((List) ls);
        } else {
            return varyingBatchInsert((List) ls, (InsertOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<FileAuthentication> fileAuthenticationList) {
        return doBatchUpdate(fileAuthenticationList, null);
    }

    protected int[] doBatchUpdate(
            List<FileAuthentication> fileAuthenticationList,
            UpdateOption<FileAuthenticationCB> option) {
        assertObjectNotNull("fileAuthenticationList", fileAuthenticationList);
        prepareUpdateOption(option);
        return delegateBatchUpdate(fileAuthenticationList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModify(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdate((List) ls);
        } else {
            return varyingBatchUpdate((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-update the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchUpdate(List<FileAuthentication> fileAuthenticationList,
            SpecifyQuery<FileAuthenticationCB> updateColumnSpec) {
        return doBatchUpdate(fileAuthenticationList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * All columns are update target. {NOT modified only}
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<FileAuthentication> fileAuthenticationList) {
        return doBatchUpdateNonstrict(fileAuthenticationList, null);
    }

    protected int[] doBatchUpdateNonstrict(
            List<FileAuthentication> fileAuthenticationList,
            UpdateOption<FileAuthenticationCB> option) {
        assertObjectNotNull("fileAuthenticationList", fileAuthenticationList);
        prepareUpdateOption(option);
        return delegateBatchUpdateNonstrict(fileAuthenticationList, option);
    }

    /**
     * Batch-update the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement. <br />
     * You can specify update columns used on set clause of update statement.
     * However you do not need to specify common columns for update
     * and an optimistick lock column because they are specified implicitly.
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @param updateColumnSpec The specification of update columns. (NotNull)
     * @return The array of updated count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchUpdateNonstrict(
            List<FileAuthentication> fileAuthenticationList,
            SpecifyQuery<FileAuthenticationCB> updateColumnSpec) {
        return doBatchUpdateNonstrict(fileAuthenticationList,
                createSpecifiedUpdateOption(updateColumnSpec));
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpModifyNonstrict(List<Entity> ls,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchUpdateNonstrict((List) ls);
        } else {
            return varyingBatchUpdateNonstrict((List) ls, (UpdateOption) option);
        }
    }

    /**
     * Batch-delete the list. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.BatchEntityAlreadyUpdatedException When the entity has already been updated. This exception extends EntityAlreadyUpdatedException.
     */
    public int[] batchDelete(List<FileAuthentication> fileAuthenticationList) {
        return doBatchDelete(fileAuthenticationList, null);
    }

    protected int[] doBatchDelete(
            List<FileAuthentication> fileAuthenticationList,
            DeleteOption<FileAuthenticationCB> option) {
        assertObjectNotNull("fileAuthenticationList", fileAuthenticationList);
        prepareDeleteOption(option);
        return delegateBatchDelete(fileAuthenticationList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemove(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDelete((List) ls);
        } else {
            return varyingBatchDelete((List) ls, (DeleteOption) option);
        }
    }

    /**
     * Batch-delete the list non-strictly. <br />
     * This method uses 'Batch Update' of java.sql.PreparedStatement.
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @return The array of deleted count.
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     */
    public int[] batchDeleteNonstrict(
            List<FileAuthentication> fileAuthenticationList) {
        return doBatchDeleteNonstrict(fileAuthenticationList, null);
    }

    protected int[] doBatchDeleteNonstrict(
            List<FileAuthentication> fileAuthenticationList,
            DeleteOption<FileAuthenticationCB> option) {
        assertObjectNotNull("fileAuthenticationList", fileAuthenticationList);
        prepareDeleteOption(option);
        return delegateBatchDeleteNonstrict(fileAuthenticationList, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int[] doLumpRemoveNonstrict(List<Entity> ls,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return batchDeleteNonstrict((List) ls);
        } else {
            return varyingBatchDeleteNonstrict((List) ls, (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                        Query Update
    //                                                                        ============
    /**
     * Insert the several entities by query (modified-only for fixed value).
     * <pre>
     * fileAuthenticationBhv.<span style="color: #FD4747">queryInsert</span>(new QueryInsertSetupper&lt;fileAuthentication, FileAuthenticationCB&gt;() {
     *     public ConditionBean setup(fileAuthentication entity, FileAuthenticationCB intoCB) {
     *         FooCB cb = FooCB();
     *         cb.setupSelect_Bar();
     * 
     *         <span style="color: #3F7E5E">// mapping</span>
     *         intoCB.specify().columnMyName().mappedFrom(cb.specify().columnFooName());
     *         intoCB.specify().columnMyCount().mappedFrom(cb.specify().columnFooCount());
     *         intoCB.specify().columnMyDate().mappedFrom(cb.specify().specifyBar().columnBarDate());
     *         entity.setMyFixedValue("foo"); <span style="color: #3F7E5E">// fixed value</span>
     *         <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     *         <span style="color: #3F7E5E">//entity.setRegisterUser(value);</span>
     *         <span style="color: #3F7E5E">//entity.set...;</span>
     *         <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     *         <span style="color: #3F7E5E">//entity.setVersionNo(value);</span>
     * 
     *         return cb;
     *     }
     * });
     * </pre>
     * @param setupper The setup-per of query-insert. (NotNull)
     * @return The inserted count.
     */
    public int queryInsert(
            QueryInsertSetupper<FileAuthentication, FileAuthenticationCB> setupper) {
        return doQueryInsert(setupper, null);
    }

    protected int doQueryInsert(
            QueryInsertSetupper<FileAuthentication, FileAuthenticationCB> setupper,
            InsertOption<FileAuthenticationCB> option) {
        assertObjectNotNull("setupper", setupper);
        prepareInsertOption(option);
        FileAuthentication entity = new FileAuthentication();
        FileAuthenticationCB intoCB = createCBForQueryInsert();
        ConditionBean resourceCB = setupper.setup(entity, intoCB);
        return delegateQueryInsert(entity, intoCB, resourceCB, option);
    }

    protected FileAuthenticationCB createCBForQueryInsert() {
        FileAuthenticationCB cb = newMyConditionBean();
        cb.xsetupForQueryInsert();
        return cb;
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeCreate(
            QueryInsertSetupper<? extends Entity, ? extends ConditionBean> setupper,
            InsertOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryInsert((QueryInsertSetupper) setupper);
        } else {
            return varyingQueryInsert((QueryInsertSetupper) setupper,
                    (InsertOption) option);
        }
    }

    /**
     * Update the several entities by query non-strictly modified-only. {NonExclusiveControl}
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setPK...(value);</span>
     * fileAuthentication.setFoo...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set values of common columns</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setRegisterUser(value);</span>
     * <span style="color: #3F7E5E">//fileAuthentication.set...;</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setVersionNo(value);</span>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * fileAuthenticationBhv.<span style="color: #FD4747">queryUpdate</span>(fileAuthentication, cb);
     * </pre>
     * @param fileAuthentication The entity that contains update values. (NotNull, PrimaryKeyNullAllowed)
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition.
     */
    public int queryUpdate(FileAuthentication fileAuthentication,
            FileAuthenticationCB cb) {
        return doQueryUpdate(fileAuthentication, cb, null);
    }

    protected int doQueryUpdate(FileAuthentication fileAuthentication,
            FileAuthenticationCB cb, UpdateOption<FileAuthenticationCB> option) {
        assertObjectNotNull("fileAuthentication", fileAuthentication);
        assertCBNotNull(cb);
        prepareUpdateOption(option);
        return delegateQueryUpdate(fileAuthentication, cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeModify(Entity entity, ConditionBean cb,
            UpdateOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryUpdate(downcast(entity), (FileAuthenticationCB) cb);
        } else {
            return varyingQueryUpdate(downcast(entity),
                    (FileAuthenticationCB) cb, (UpdateOption) option);
        }
    }

    /**
     * Delete the several entities by query. {NonExclusiveControl}
     * <pre>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * fileAuthenticationBhv.<span style="color: #FD4747">queryDelete</span>(fileAuthentication, cb);
     * </pre>
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition.
     */
    public int queryDelete(FileAuthenticationCB cb) {
        return doQueryDelete(cb, null);
    }

    protected int doQueryDelete(FileAuthenticationCB cb,
            DeleteOption<FileAuthenticationCB> option) {
        assertCBNotNull(cb);
        prepareDeleteOption(option);
        return delegateQueryDelete(cb, option);
    }

    @Override
    @SuppressWarnings("unchecked")
    protected int doRangeRemove(ConditionBean cb,
            DeleteOption<? extends ConditionBean> option) {
        if (option == null) {
            return queryDelete((FileAuthenticationCB) cb);
        } else {
            return varyingQueryDelete((FileAuthenticationCB) cb,
                    (DeleteOption) option);
        }
    }

    // ===================================================================================
    //                                                                      Varying Update
    //                                                                      ==============
    // -----------------------------------------------------
    //                                         Entity Update
    //                                         -------------
    /**
     * Insert the entity with varying requests. <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as insert(entity).
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * <span style="color: #3F7E5E">// if auto-increment, you don't need to set the PK value</span>
     * fileAuthentication.setFoo...(value);
     * fileAuthentication.setBar...(value);
     * InsertOption<FileAuthenticationCB> option = new InsertOption<FileAuthenticationCB>();
     * <span style="color: #3F7E5E">// you can insert by your values for common columns</span>
     * option.disableCommonColumnAutoSetup();
     * fileAuthenticationBhv.<span style="color: #FD4747">varyingInsert</span>(fileAuthentication, option);
     * ... = fileAuthentication.getPK...(); <span style="color: #3F7E5E">// if auto-increment, you can get the value after</span>
     * </pre>
     * @param fileAuthentication The entity of insert target. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsert(FileAuthentication fileAuthentication,
            InsertOption<FileAuthenticationCB> option) {
        assertInsertOptionNotNull(option);
        doInsert(fileAuthentication, option);
    }

    /**
     * Update the entity with varying requests modified-only. {UpdateCountZeroException, ExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as update(entity).
     * <pre>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * fileAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileAuthentication.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// if exclusive control, the value of exclusive control column is required</span>
     * fileAuthentication.<span style="color: #FD4747">setVersionNo</span>(value);
     * try {
     *     <span style="color: #3F7E5E">// you can update by self calculation values</span>
     *     UpdateOption&lt;FileAuthenticationCB&gt; option = new UpdateOption&lt;FileAuthenticationCB&gt;();
     *     option.self(new SpecifyQuery&lt;FileAuthenticationCB&gt;() {
     *         public void specify(FileAuthenticationCB cb) {
     *             cb.specify().<span style="color: #FD4747">columnXxxCount()</span>;
     *         }
     *     }).plus(1); <span style="color: #3F7E5E">// XXX_COUNT = XXX_COUNT + 1</span>
     *     fileAuthenticationBhv.<span style="color: #FD4747">varyingUpdate</span>(fileAuthentication, option);
     * } catch (EntityAlreadyUpdatedException e) { <span style="color: #3F7E5E">// if concurrent update</span>
     *     ...
     * }
     * </pre>
     * @param fileAuthentication The entity of update target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdate(FileAuthentication fileAuthentication,
            UpdateOption<FileAuthenticationCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdate(fileAuthentication, option);
    }

    /**
     * Update the entity with varying requests non-strictly modified-only. {UpdateCountZeroException, NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification), disableCommonColumnAutoSetup(). <br />
     * Other specifications are same as updateNonstrict(entity).
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * fileAuthentication.setPK...(value); <span style="color: #3F7E5E">// required</span>
     * fileAuthentication.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setVersionNo(value);</span>
     * UpdateOption&lt;FileAuthenticationCB&gt; option = new UpdateOption&lt;FileAuthenticationCB&gt;();
     * option.self(new SpecifyQuery&lt;FileAuthenticationCB&gt;() {
     *     public void specify(FileAuthenticationCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * fileAuthenticationBhv.<span style="color: #FD4747">varyingUpdateNonstrict</span>(fileAuthentication, option);
     * </pre>
     * @param fileAuthentication The entity of update target. (NotNull) {PrimaryKeyRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingUpdateNonstrict(FileAuthentication fileAuthentication,
            UpdateOption<FileAuthenticationCB> option) {
        assertUpdateOptionNotNull(option);
        doUpdateNonstrict(fileAuthentication, option);
    }

    /**
     * Insert or update the entity with varying requests. {ExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdate(entity).
     * @param fileAuthentication The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdate(FileAuthentication fileAuthentication,
            InsertOption<FileAuthenticationCB> insertOption,
            UpdateOption<FileAuthenticationCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdate(fileAuthentication, insertOption, updateOption);
    }

    /**
     * Insert or update the entity with varying requests non-strictly. {NonExclusiveControl(when update)}<br />
     * Other specifications are same as insertOrUpdateNonstrict(entity).
     * @param fileAuthentication The entity of insert or update target. (NotNull)
     * @param insertOption The option of insert for varying requests. (NotNull)
     * @param updateOption The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     * @exception org.seasar.dbflute.exception.EntityAlreadyExistsException When the entity already exists. (Unique Constraint Violation)
     */
    public void varyingInsertOrUpdateNonstrict(
            FileAuthentication fileAuthentication,
            InsertOption<FileAuthenticationCB> insertOption,
            UpdateOption<FileAuthenticationCB> updateOption) {
        assertInsertOptionNotNull(insertOption);
        assertUpdateOptionNotNull(updateOption);
        doInesrtOrUpdateNonstrict(fileAuthentication, insertOption,
                updateOption);
    }

    /**
     * Delete the entity with varying requests. {UpdateCountZeroException, ExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as delete(entity).
     * @param fileAuthentication The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyUpdatedException When the entity has already been updated.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDelete(FileAuthentication fileAuthentication,
            DeleteOption<FileAuthenticationCB> option) {
        assertDeleteOptionNotNull(option);
        doDelete(fileAuthentication, option);
    }

    /**
     * Delete the entity with varying requests non-strictly. {UpdateCountZeroException, NonExclusiveControl} <br />
     * Now a valid option does not exist. <br />
     * Other specifications are same as deleteNonstrict(entity).
     * @param fileAuthentication The entity of delete target. (NotNull) {PrimaryKeyRequired, ConcurrencyColumnRequired}
     * @param option The option of update for varying requests. (NotNull)
     * @exception org.seasar.dbflute.exception.EntityAlreadyDeletedException When the entity has already been deleted.
     * @exception org.seasar.dbflute.exception.EntityDuplicatedException When the entity has been duplicated.
     */
    public void varyingDeleteNonstrict(FileAuthentication fileAuthentication,
            DeleteOption<FileAuthenticationCB> option) {
        assertDeleteOptionNotNull(option);
        doDeleteNonstrict(fileAuthentication, option);
    }

    // -----------------------------------------------------
    //                                          Batch Update
    //                                          ------------
    /**
     * Batch-insert the list with varying requests. <br />
     * For example, disableCommonColumnAutoSetup()
     * , disablePrimaryKeyIdentity(), limitBatchInsertLogging(). <br />
     * Other specifications are same as batchInsert(entityList).
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The array of inserted count.
     */
    public int[] varyingBatchInsert(
            List<FileAuthentication> fileAuthenticationList,
            InsertOption<FileAuthenticationCB> option) {
        assertInsertOptionNotNull(option);
        return doBatchInsert(fileAuthenticationList, option);
    }

    /**
     * Batch-update the list with varying requests. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdate(entityList).
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdate(
            List<FileAuthentication> fileAuthenticationList,
            UpdateOption<FileAuthenticationCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdate(fileAuthenticationList, option);
    }

    /**
     * Batch-update the list with varying requests non-strictly. <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), limitBatchUpdateLogging(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The array of updated count.
     */
    public int[] varyingBatchUpdateNonstrict(
            List<FileAuthentication> fileAuthenticationList,
            UpdateOption<FileAuthenticationCB> option) {
        assertUpdateOptionNotNull(option);
        return doBatchUpdateNonstrict(fileAuthenticationList, option);
    }

    /**
     * Batch-delete the list with varying requests. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDelete(entityList).
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDelete(
            List<FileAuthentication> fileAuthenticationList,
            DeleteOption<FileAuthenticationCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDelete(fileAuthenticationList, option);
    }

    /**
     * Batch-delete the list with varying requests non-strictly. <br />
     * For example, limitBatchDeleteLogging(). <br />
     * Other specifications are same as batchDeleteNonstrict(entityList).
     * @param fileAuthenticationList The list of the entity. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The array of deleted count.
     */
    public int[] varyingBatchDeleteNonstrict(
            List<FileAuthentication> fileAuthenticationList,
            DeleteOption<FileAuthenticationCB> option) {
        assertDeleteOptionNotNull(option);
        return doBatchDeleteNonstrict(fileAuthenticationList, option);
    }

    // -----------------------------------------------------
    //                                          Query Update
    //                                          ------------
    /**
     * Insert the several entities by query with varying requests (modified-only for fixed value). <br />
     * For example, disableCommonColumnAutoSetup(), disablePrimaryKeyIdentity(). <br />
     * Other specifications are same as queryInsert(entity, setupper). 
     * @param setupper The setup-per of query-insert. (NotNull)
     * @param option The option of insert for varying requests. (NotNull)
     * @return The inserted count.
     */
    public int varyingQueryInsert(
            QueryInsertSetupper<FileAuthentication, FileAuthenticationCB> setupper,
            InsertOption<FileAuthenticationCB> option) {
        assertInsertOptionNotNull(option);
        return doQueryInsert(setupper, option);
    }

    /**
     * Update the several entities by query with varying requests non-strictly modified-only. {NonExclusiveControl} <br />
     * For example, self(selfCalculationSpecification), specify(updateColumnSpecification)
     * , disableCommonColumnAutoSetup(), allowNonQueryUpdate(). <br />
     * Other specifications are same as queryUpdate(entity, cb). 
     * <pre>
     * <span style="color: #3F7E5E">// ex) you can update by self calculation values</span>
     * FileAuthentication fileAuthentication = new FileAuthentication();
     * <span style="color: #3F7E5E">// you don't need to set PK value</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setPK...(value);</span>
     * fileAuthentication.setOther...(value); <span style="color: #3F7E5E">// you should set only modified columns</span>
     * <span style="color: #3F7E5E">// you don't need to set a value of exclusive control column</span>
     * <span style="color: #3F7E5E">// (auto-increment for version number is valid though non-exclusive control)</span>
     * <span style="color: #3F7E5E">//fileAuthentication.setVersionNo(value);</span>
     * FileAuthenticationCB cb = new FileAuthenticationCB();
     * cb.query().setFoo...(value);
     * UpdateOption&lt;FileAuthenticationCB&gt; option = new UpdateOption&lt;FileAuthenticationCB&gt;();
     * option.self(new SpecifyQuery&lt;FileAuthenticationCB&gt;() {
     *     public void specify(FileAuthenticationCB cb) {
     *         cb.specify().<span style="color: #FD4747">columnFooCount()</span>;
     *     }
     * }).plus(1); <span style="color: #3F7E5E">// FOO_COUNT = FOO_COUNT + 1</span>
     * fileAuthenticationBhv.<span style="color: #FD4747">varyingQueryUpdate</span>(fileAuthentication, cb, option);
     * </pre>
     * @param fileAuthentication The entity that contains update values. (NotNull) {PrimaryKeyNotRequired}
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @param option The option of update for varying requests. (NotNull)
     * @return The updated count.
     * @exception org.seasar.dbflute.exception.NonQueryUpdateNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryUpdate(FileAuthentication fileAuthentication,
            FileAuthenticationCB cb, UpdateOption<FileAuthenticationCB> option) {
        assertUpdateOptionNotNull(option);
        return doQueryUpdate(fileAuthentication, cb, option);
    }

    /**
     * Delete the several entities by query with varying requests non-strictly. <br />
     * For example, allowNonQueryDelete(). <br />
     * Other specifications are same as batchUpdateNonstrict(entityList).
     * @param cb The condition-bean of FileAuthentication. (NotNull)
     * @param option The option of delete for varying requests. (NotNull)
     * @return The deleted count.
     * @exception org.seasar.dbflute.exception.NonQueryDeleteNotAllowedException When the query has no condition (if not allowed).
     */
    public int varyingQueryDelete(FileAuthenticationCB cb,
            DeleteOption<FileAuthenticationCB> option) {
        assertDeleteOptionNotNull(option);
        return doQueryDelete(cb, option);
    }

    // ===================================================================================
    //                                                                          OutsideSql
    //                                                                          ==========
    /**
     * Prepare the basic executor of outside-SQL to execute it. <br />
     * The invoker of behavior command should be not null when you call this method.
     * <pre>
     * You can use the methods for outside-SQL are as follows:
     * {Basic}
     *   o selectList()
     *   o execute()
     *   o call()
     * 
     * {Entity}
     *   o entityHandling().selectEntity()
     *   o entityHandling().selectEntityWithDeletedCheck()
     * 
     * {Paging}
     *   o autoPaging().selectList()
     *   o autoPaging().selectPage()
     *   o manualPaging().selectList()
     *   o manualPaging().selectPage()
     * 
     * {Cursor}
     *   o cursorHandling().selectCursor()
     * 
     * {Option}
     *   o dynamicBinding().selectList()
     *   o removeBlockComment().selectList()
     *   o removeLineComment().selectList()
     *   o formatSql().selectList()
     * </pre>
     * @return The basic executor of outside-SQL. (NotNull) 
     */
    public OutsideSqlBasicExecutor<FileAuthenticationBhv> outsideSql() {
        return doOutsideSql();
    }

    // ===================================================================================
    //                                                                     Delegate Method
    //                                                                     ===============
    // [Behavior Command]
    // -----------------------------------------------------
    //                                                Select
    //                                                ------
    protected int delegateSelectCountUniquely(FileAuthenticationCB cb) {
        return invoke(createSelectCountCBCommand(cb, true));
    }

    protected int delegateSelectCountPlainly(FileAuthenticationCB cb) {
        return invoke(createSelectCountCBCommand(cb, false));
    }

    protected <ENTITY extends FileAuthentication> void delegateSelectCursor(
            FileAuthenticationCB cb, EntityRowHandler<ENTITY> erh,
            Class<ENTITY> et) {
        invoke(createSelectCursorCBCommand(cb, erh, et));
    }

    protected <ENTITY extends FileAuthentication> List<ENTITY> delegateSelectList(
            FileAuthenticationCB cb, Class<ENTITY> et) {
        return invoke(createSelectListCBCommand(cb, et));
    }

    // -----------------------------------------------------
    //                                                Update
    //                                                ------
    protected int delegateInsert(FileAuthentication e,
            InsertOption<FileAuthenticationCB> op) {
        if (!processBeforeInsert(e, op)) {
            return 0;
        }
        return invoke(createInsertEntityCommand(e, op));
    }

    protected int delegateUpdate(FileAuthentication e,
            UpdateOption<FileAuthenticationCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateEntityCommand(e, op));
    }

    protected int delegateUpdateNonstrict(FileAuthentication e,
            UpdateOption<FileAuthenticationCB> op) {
        if (!processBeforeUpdate(e, op)) {
            return 0;
        }
        return invoke(createUpdateNonstrictEntityCommand(e, op));
    }

    protected int delegateDelete(FileAuthentication e,
            DeleteOption<FileAuthenticationCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteEntityCommand(e, op));
    }

    protected int delegateDeleteNonstrict(FileAuthentication e,
            DeleteOption<FileAuthenticationCB> op) {
        if (!processBeforeDelete(e, op)) {
            return 0;
        }
        return invoke(createDeleteNonstrictEntityCommand(e, op));
    }

    protected int[] delegateBatchInsert(List<FileAuthentication> ls,
            InsertOption<FileAuthenticationCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchInsertCommand(processBatchInternally(ls, op),
                op));
    }

    protected int[] delegateBatchUpdate(List<FileAuthentication> ls,
            UpdateOption<FileAuthenticationCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchUpdateNonstrict(List<FileAuthentication> ls,
            UpdateOption<FileAuthenticationCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchUpdateNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int[] delegateBatchDelete(List<FileAuthentication> ls,
            DeleteOption<FileAuthenticationCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteCommand(
                processBatchInternally(ls, op, false), op));
    }

    protected int[] delegateBatchDeleteNonstrict(List<FileAuthentication> ls,
            DeleteOption<FileAuthenticationCB> op) {
        if (ls.isEmpty()) {
            return new int[] {};
        }
        return invoke(createBatchDeleteNonstrictCommand(
                processBatchInternally(ls, op, true), op));
    }

    protected int delegateQueryInsert(FileAuthentication e,
            FileAuthenticationCB inCB, ConditionBean resCB,
            InsertOption<FileAuthenticationCB> op) {
        if (!processBeforeQueryInsert(e, inCB, resCB, op)) {
            return 0;
        }
        return invoke(createQueryInsertCBCommand(e, inCB, resCB, op));
    }

    protected int delegateQueryUpdate(FileAuthentication e,
            FileAuthenticationCB cb, UpdateOption<FileAuthenticationCB> op) {
        if (!processBeforeQueryUpdate(e, cb, op)) {
            return 0;
        }
        return invoke(createQueryUpdateCBCommand(e, cb, op));
    }

    protected int delegateQueryDelete(FileAuthenticationCB cb,
            DeleteOption<FileAuthenticationCB> op) {
        if (!processBeforeQueryDelete(cb, op)) {
            return 0;
        }
        return invoke(createQueryDeleteCBCommand(cb, op));
    }

    // ===================================================================================
    //                                                                Optimistic Lock Info
    //                                                                ====================
    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasVersionNoValue(Entity entity) {
        return !(downcast(entity).getVersionNo() + "").equals("null");// For primitive type
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected boolean hasUpdateDateValue(Entity entity) {
        return false;
    }

    // ===================================================================================
    //                                                                     Downcast Helper
    //                                                                     ===============
    protected FileAuthentication downcast(Entity entity) {
        return helpEntityDowncastInternally(entity, FileAuthentication.class);
    }

    protected FileAuthenticationCB downcast(ConditionBean cb) {
        return helpConditionBeanDowncastInternally(cb,
                FileAuthenticationCB.class);
    }
}
